<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : FrontendUser Mailer (c) 2008-2010 by Georg Busch (georg.busch@gmx.net)
#          An addon module for CMS Made Simple to provide backend users ability 
#          to easily send an email to all frontend users or just specific front-
#          end usergroups within a CMS Made Simple powered website.
# Version: 0.9.3
# File   : action.viewLogs.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if(!isset($gCms))
	exit;

if(!$this->CheckPermission('Use FEUMailer')) {
	return $this->DisplayErrorPage($id,$returnid,
												$this->Lang('error_permissions'));
}

$feusers =& $this->GetModuleInstance('FrontEndUsers');
if(!$feusers)
	return $this->DisplayErrorPage($id,$returnid,$this->Lang('error_feusers'));

if(!$this->GetModuleInstance('CMSMailer')) {
	return $this->DisplayErrorPage($id,$returnid,
												$this->Lang('error_cmsmailer'));
}

$active_tab = 'archive';
if(isset($params['active_tab'])) {
	$active_tab = trim($params['active_tab']);
}

if(isset($params['cancel']))
	$this->Redirect($id, 'defaultadmin', $returnid,array("active_tab"=>$active_tab));

if(isset($params['resend_all']))
	$task = 'all';
if(isset($params['resend_new']))
	$task = 'continue';
if(isset($params['resend_errors']))
	$task = 'error';
if(isset($params['resend_selected']))
	$task = 'selected';
	
if(isset($task)) {
	$params['task']=$task;
	$this->Redirect($id, 'prepareSendMail', $returnid,$params);
}

if(isset($params['archive_id']) && $params['archive_id']>0) {
	$archive_id = intval(trim($params['archive_id']));
}

if(isset($params['tmp_id']) && $params['tmp_id']>0) {
	$tmp_id = intval(trim($params['tmp_id']));
}
$mail_type = '';
if(isset($params['mail_type']) && $params['mail_type']!='') {
	$mail_type = trim($params['mail_type']);
}

#$delete = $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->lang('delete'),'','','systemicon');
#$errorlogs = $gCms->variables['admintheme']->DisplayImage('icons/extra/yellow.gif', $this->lang('view_log'),'','','systemicon');
#$logs = $gCms->variables['admintheme']->DisplayImage('icons/system/info.gif', $this->lang('view_log'),'','','systemicon');
$ok = $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif',
															'','','','systemicon');
$error = $gCms->variables['admintheme']->DisplayImage('icons/system/false.gif',
															'','','','systemicon');
$resend = '<img src="'.$gCms->config['root_url'].'/modules/FEUMailer/images/resend_all.gif" alt="'.$this->lang('resend_user').'" title="'.$this->lang('resend_user').'" class="systemicon" />';

if(isset($params['savefilter'])) {
	$this->SetPreference("sortby",$params['sort_by']);
	$this->SetPreference("sortorder",$params['sort_order']);
	$this->SetPreference("limit",$params['limit']);
	$this->SetPreference("errorsonly",(isset($params['errors_only'])?true:false));
	$this->prefs = '';
}

$clear_log = false;
if(isset($params['clear_log']) && $params['clear_log']==true) {
	$clear_log = true;
}

if(isset($params['limit'])) {
	$limit = (trim($params['limit']));
} else {
	$limit = $this->GetPref("limit",100);
}

$old_limit = $limit;
if(isset($params['old_limit'])) {
	$old_limit = intval(trim($params['old_limit']));
}

if(isset($params['sort_by'])) {
	$sort_by = trim($params['sort_by']);
} else {
	$sort_by = $this->GetPref("sortby","L.id");
}

if(isset($params['sort_order'])) {
	$sort_order = trim($params['sort_order']);
} else {
	$sort_order = $this->GetPref("sortorder","ASC");
}

if(isset($params['errors_only']) && $params['errors_only']) {
	$errors_only = true;
} else {
	$errors_only = $this->GetPref("errorsonly",false);
}

$page = 0;
if(isset($params['page'])) {
	$page = intval(trim($params['page']));
}

if($limit>$old_limit && $limit>0 && $old_limit>0 && isset($params['submit'])) {
	$factor = $limit / $old_limit;
	$page = floor($page / $factor);
}
else if($limit<$old_limit && $limit>0 && isset($params['submit'])) {
	$factor = $old_limit / $limit;
	$page = floor($page * $factor);
}

if(isset($params['submit']) && $errors_only==true) {
	$page=0;
}

$subject 	= '';
$sentby 	= '';
$logs 		= array();
$max_id		= 0;
$min_id		= 0;
$logs_count = 0;
$mail_stored = false;
// get number of log entrys
$query = "SELECT COUNT(id) AS logs_count, MAX(id) AS maximum, MIN(id) AS minimum 
			FROM ".cms_db_prefix()."module_feumailer_logs";
$q = array();
if(isset($archive_id))
	$q[] = "archive_id=".$archive_id;

if(isset($tmp_id))
	$q[] = "tmp_id=".$tmp_id;

if($errors_only==true)
	$q[] = "errorcode>0";
	
if(count($q))
	$query .= " WHERE ".implode(" AND ",$q);

$query .= " GROUP BY tmp_id ";

$dbresult = $db->Execute($query);
if($dbresult && $row = $dbresult->FetchRow()) {
	$logs_count = $row['logs_count'];
	$max_id = $row['maximum'];
	$min_id = $row['minimum'];
}

$max_pages = 0;
if($limit > 0)
	$max_pages = ceil($logs_count/$limit)-1;

$page_limit = $min_id + $page*$limit;

$operator = '>=';
if($sort_order=="DESC") {
	$operator = '<=';
	$page_limit = $max_id - ($page*$limit);
}

// get log data
$query = "SELECT L.*, FEU.username, U.username AS sentby, A.id AS a_id, 
				A.recipients AS recipients_archive, 
				A.processed_users AS processed_users_archive,
				T.id AS t_id, T.recipients AS recipients_tmp, 
				T.processed_users AS processed_users_tmp 
			FROM ".cms_db_prefix()."module_feumailer_logs L 
			LEFT OUTER JOIN ".cms_db_prefix()."users U 
			ON U.user_id=L.sentby_id 
			LEFT OUTER JOIN ".cms_db_prefix()."module_feumailer_archive A 
			ON A.id=L.archive_id
			LEFT OUTER JOIN ".cms_db_prefix()."module_feumailer_tmp T 
			ON T.id=L.tmp_id
			LEFT OUTER JOIN ".cms_db_prefix()."module_feusers_users FEU 
			ON FEU.id=L.recipient_id";

$q = array();
if(isset($archive_id))
	$q[] = "L.archive_id=". $archive_id;

if(isset($tmp_id))
	$q[] = "L.tmp_id=".$tmp_id;

if($errors_only==true)
	$q[] = "L.errorcode>0";

$q[] = "L.id".$operator.$page_limit;

if(count($q))
	$query .= " WHERE ".implode(" AND ",$q);

$query .= " ORDER BY ". $sort_by . " $sort_order " . ($limit>0?" LIMIT ".$limit:"");

$dbresult = $db->Execute($query);
$rowclass = "row1";
$row_groups = array();
$users = array();
$errorlogs_count = 0;
while($dbresult && $row = $dbresult->FetchRow()) {

	$users[$row['recipient_id']]['send_date'] = $row['send_date'];
	$users[$row['recipient_id']]['username'] 	= $row['username'];
	$users[$row['recipient_id']]['log_id'] 	= $row['id'];
	$sentby 				= $row['sentby'];
	$users[$row['recipient_id']]['errorcode'] = $row['tmp_errorcode'];
	if($row['tmp_errorcode']==0) {
		$users[$row['recipient_id']]['img'] 		= $ok;
		$users[$row['recipient_id']]['status'] 	= $this->lang('ok');
	} else {
		$errorlogs_count++;
		$users[$row['recipient_id']]['img'] = $error;
		if ($row['tmp_errorcode']==1) {
			$users[$row['recipient_id']]['status'] = $this->lang('noemailaddressfound');
		}
		if ($row['tmp_errorcode']==2) {
			$users[$row['recipient_id']]['status'] = $this->lang('invalidemailaddress');
		}
	}
	
	if(!empty($row['subject'])) {
		$subject = $row['subject'];
	} else {
		$subject = $this->lang('nosubject');
	}
	
	$grps = explode(';',$row['recipient_groups']);
	if(!empty($grps[0])) {
		foreach($grps as $grp) {
			$g = explode(',',$grp);
			if(isset($g[1])) {
				$row_groups[$g[0]] = $g[1];
			}
		}
	}
	
	if($row['t_id']!='' || $row['a_id']!='') {
		$mail_stored = true;
		if($row['a_id']!='') {
			$mail_id = $row['a_id'];
			$mail_type = "archive";
			
		} else if ($row['t_id']!='') {
			$mail_id = $row['t_id'];
			$mail_type = "tmp";
		}
			
		$processed_users = $row['processed_users_'.$mail_type];
		$recipients = $row['recipients_'.$mail_type];
	}

	$users[$row['recipient_id']]['recieved'] = $row['recieved'];
	$users[$row['recipient_id']]['rowclass'] = $rowclass;
	$rowclass = ($rowclass=='row1'?'row2':'row1');

}

$groups = $this->GetAdditionalGroups($users);
$prop2 = array();
foreach($groups as $group_id=>$group_name)
{
	$proprelations = $feusers->GetGroupPropertyRelations($group_id);
	$prop2 = RRUtils::array_merge_by_name_required($prop2, $proprelations);
	uasort($prop2, array('RRUtils','compare_elements_by_sortorder_key'));
}

// now we merge in all of the property definitions
$defns = $feusers->GetPropertyDefns();
$prop3 = array();
foreach($prop2 as $oneprop)
{
	foreach($defns as $onedefn)
	{
		if($onedefn['name'] == $oneprop['name'])
		{
			$oneprop['prompt'] = $onedefn['prompt'];
			$oneprop['type'] = $onedefn['type'];
			break;
		}
	}
	$prop3[] = $oneprop;
}

// And now merge in the values
$username_is_email = $feusers->GetPreference('username_is_email',false);

foreach($users as $userid=>$data) {
	$userprops = $feusers->GetUserProperties($userid);
	$emails = array();
	foreach($prop3 as $oneprop)
	{
		foreach($userprops as $oneval)
		{
			if($oneprop['name'] == $oneval['title'])
			{
				$oneprop['data'] = $oneval['data'];
				break;
			}
		}
		if(isset($oneprop['data'])) {
			if($oneprop['type']==2 && $oneprop['data']!='') {
				$emails[] = $oneprop['data'];
			}
		}
	}
	
	if($username_is_email) {
		$emails[] = $data['username'];
	}
	
	$onerow 			= new stdClass();
	$onerow->emails 	= $emails;
	$onerow->username 	= $data['username'];
	$onerow->send_date = $data['send_date'];
	$onerow->log_id 	= $data['log_id'];
	$onerow->img 		= $data['img'];
	$onerow->status 	= $data['status'];
	$onerow->selected	= '&nbsp;';
	$onerow->resend		= '&nbsp;';
	$onerow->recieved	= ($data['recieved']==true?$ok:'&nbsp;');
	if($mail_stored && $mail_type!='tmp') {
		$onerow->resend = $this->CreateLink($id,'prepareSendMail',$returnid,$resend,
													array('clear_log'=>$clear_log,
														'task'=>'user',
														'userid'=>$userid,
														'username'=>$data['username'],
														'mail_type'=>$mail_type,
														'mail_id'=>$mail_id,
														'errorcode'=>$data['errorcode']),
		($username_is_email?$this->lang('resenduserconfirm_1',$data['username']):
							$this->lang('resenduserconfirm_2',$data['username'],implode(", ",$emails))));
		$onerow->selected = $this->CreateInputCheckbox($id,'log-'.$userid,
									$userid.'-'.$data['username'].'-'.$data['errorcode'],
									'','class="logs"');

	}

	$onerow->rowclass 	= $data['rowclass'];
	$logs[]=$onerow;
}

$groups = implode(", ",$row_groups);
$groups_confirm = implode("\\n",$row_groups);
$total_users = count($this->GetUsers($row_groups));

$limits = array();
$limits['10'] 	= '10';
$limits['50'] 	= '50';
$limits['100'] 	= '100';
$limits['200'] 	= '200';
$limits['500'] 	= '500';
$limits['1000'] = '1000';
$limits['2000'] = '2000';
$limits['5000'] = '5000';
$limits['10000'] = '10000';
$limits[$this->lang('nolimit')] = '0';
$this->smarty->assign('limit',	$this->CreateInputDropdown($id, 'limit', $limits, '', $limit));

$sorts = array();
$sorts[$this->lang('send_order')] 	= 'L.id';
$sorts[$this->lang('username')] 	= 'FEU.username';
$sorts[$this->lang('send_date')] 	= 'L.send_date';
$this->smarty->assign('sort_by', $this->CreateInputDropdown($id, 'sort_by', $sorts, '', $sort_by));

$orders = array();
$orders[$this->lang('asc')] 	= 'ASC';
$orders[$this->lang('desc')] 	= 'DESC';
$this->smarty->assign('sort_order',$this->CreateInputDropdown($id, 'sort_order', $orders, '', $sort_order));

$this->smarty->assign('filter_text', $this->lang('filter'));
$this->smarty->assign('sortby_text', $this->lang('sortby'));
#$this->smarty->assign('sortorder_text', $this->lang('sortorder'));
$this->smarty->assign('limit_text', $this->lang('limit'));

$this->smarty->assign('savefilter', $this->CreateInputCheckbox($id, 'savefilter',1,'',''));
$this->smarty->assign('savefilter_text', $this->lang('savedefault'));

$this->smarty->assign('errors_only', $this->CreateInputCheckbox($id, 'errors_only',1,$errors_only,''));
$this->smarty->assign('errorsonly_text', $this->lang('errorsonly'));

$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->lang('submit')));
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', $this->lang('cancel')));
$this->smarty->assign('endForm', $this->CreateFormEnd());

$this->smarty->assign('startFilterForm', $this->CreateFormStart( $id, 'viewLogs', 
											$returnid,'post','',false,'',array('active_tab'=>$active_tab,
																					'tmp_id'=>(isset($tmp_id)?$tmp_id:''),
																					'archive_id'=>(isset($archive_id)?$archive_id:''),
																					'page'=>$page,
																					'clear_log'=>$clear_log,
																					'old_limit'=>$limit)));
																					
$this->smarty->assign('startLogsForm', $this->CreateFormStart( $id, 'viewLogs', 
											$returnid,'post','',false,'',array('active_tab'=>$active_tab)));

// smarty stuff
$this->smarty->assign_by_ref('logs',$logs);
$this->smarty->assign('currentlogs_count',count($logs));

$this->smarty->assign('errorlogs_count', $errorlogs_count);
$this->smarty->assign('totallogs_count', $logs_count);
$this->smarty->assign('errorlogs_text', $this->lang('errorlogs'));
$this->smarty->assign('totallogs_text', $this->lang('totallogs'));

$this->smarty->assign('nologs',$this->lang('nologs'));
$this->smarty->assign('logid_text',$this->lang('logid'));

$this->smarty->assign('subject_text',$this->lang('subject'));
$this->smarty->assign('subject',$subject);

$this->smarty->assign('username_text',$this->lang('username'));
$this->smarty->assign('email_text',$this->lang('emailaddress'));
$this->smarty->assign('send_date_text',$this->lang('send_date'));
$this->smarty->assign('status_text',$this->lang('status'));
$this->smarty->assign('recieved_text',$this->lang('recieved'));

$this->smarty->assign('subject_text',$this->lang('subject'));
$this->smarty->assign('subject_input',$subject);
$this->smarty->assign('username_is_email',$username_is_email);

$this->smarty->assign('sentby_text',$this->lang('sentby'));
$this->smarty->assign('groups_text',$this->lang('groups'));
$this->smarty->assign('groups',$groups);
$this->smarty->assign('sentby',$sentby);
$this->smarty->assign('heading',$this->lang('view_logs'));

$this->smarty->assign('selectall','&nbsp;');
$this->smarty->assign('resend_text','&nbsp;');
if($mail_stored && $mail_type!='tmp') {
	$this->smarty->assign('selectall',
							$this->CreateInputCheckbox($id,'logs',true,false,
									'id="logs" onclick="selectAll(this)"'));
	$this->smarty->assign('resend_text',$this->lang('resend'));
}
$pages = array();
if($limit > 0 && $max_pages>0) {
	for($i=0; $i<=$max_pages; $i++) {
		$onerow = new stdClass();
		if($i==$page) {
			$onerow->number = "&nbsp;". ($i+1) ."&nbsp;";
		}
		else {
		$onerow->number = $this->CreateLink($id,'viewLogs',$returnid,"&nbsp;". ($i+1) ."&nbsp;",
														array('clear_log'=>$clear_log,
															'tmp_id'=>(isset($tmp_id)?$tmp_id:''),
															'archive_id'=>(isset($archive_id)?$archive_id:''),
															'page'=>$i,
															'limit'=>$limit,
														'sort_by'=>$sort_by,
														'sort_order'=>$sort_order,
														'errors_only'=>$errors_only));
		}
		$pages[] = $onerow;
	}
}
$this->smarty->assign_by_ref('pages',$pages);

$this->smarty->assign_by_ref('pages_text',$this->lang('pages'));
$this->smarty->assign('first','&nbsp;');
$this->smarty->assign('prev','&nbsp;');
$this->smarty->assign('last','&nbsp;');
$this->smarty->assign('next','&nbsp;');

if($limit > 0 && (($page * $limit)+$limit<$logs_count) && $max_pages>0) {
$this->smarty->assign('next',$this->CreateLink($id,'viewLogs',$returnid,"&nbsp;>&nbsp;",
													array('clear_log'=>$clear_log,
														'tmp_id'=>(isset($tmp_id)?$tmp_id:''),
														'archive_id'=>(isset($archive_id)?$archive_id:''),
														'page'=>($page+1),
														'limit'=>$limit,
														'sort_by'=>$sort_by,
														'sort_order'=>$sort_order,
														'errors_only'=>$errors_only)));

$this->smarty->assign('last',$this->CreateLink($id,'viewLogs',$returnid,"&nbsp;>>&nbsp;",
													array('clear_log'=>$clear_log,
														'tmp_id'=>(isset($tmp_id)?$tmp_id:''),
														'archive_id'=>(isset($archive_id)?$archive_id:''),
														'page'=>$max_pages,
														'limit'=>$limit,
														'sort_by'=>$sort_by,
														'sort_order'=>$sort_order,
														'errors_only'=>$errors_only)));
}

$this->smarty->assign('pages_count',$max_pages);

if($page>0 && $max_pages>0) {
	$this->smarty->assign('prev',$this->CreateLink($id,'viewLogs',$returnid,"&nbsp;<&nbsp;",
													array('clear_log'=>$clear_log,
														'tmp_id'=>(isset($tmp_id)?$tmp_id:''),
														'archive_id'=>(isset($archive_id)?$archive_id:''),
														'page'=>($page-1),
														'limit'=>$limit,
														'sort_by'=>$sort_by,
														'sort_order'=>$sort_order,
														'errors_only'=>$errors_only)));

	$this->smarty->assign('first',$this->CreateLink($id,'viewLogs',$returnid,"&nbsp;<<&nbsp;",
													array('clear_log'=>$clear_log,
														'tmp_id'=>(isset($tmp_id)?$tmp_id:''),
														'archive_id'=>(isset($archive_id)?$archive_id:''),
														'page'=>0,
														'limit'=>$limit,
														'sort_by'=>$sort_by,
														'sort_order'=>$sort_order,
														'errors_only'=>$errors_only)));

}
$this->smarty->assign('resend_selected','');
$this->smarty->assign('resend_all','');
$this->smarty->assign('resend_new','');
$this->smarty->assign('resend_errors','');
$this->smarty->assign('hidden','');
if($mail_stored==true && $mail_type!='tmp') {
	$this->smarty->assign('resend_selected', 
					$this->CreateInputSubmit($id, 
								'resend_selected', 
								$this->lang('resend_selected'),'','',
								$this->lang('resendselectedconfirm')));
																	
	$this->smarty->assign('resend_all', 
					$this->CreateInputSubmit($id, 'resend_all', 
								$this->lang('resend_all'),'','',
								$this->lang('resendall'.$mail_type.'confirm_full',
																	$groups,
																	$total_users)));

	if(($total_users-$processed_users)>0) {
		$this->smarty->assign('resend_new', 
					$this->CreateInputSubmit($id, 'resend_new', 
								$this->lang('continue_'.$mail_type),'','',
								$this->lang('resendnew'.$mail_type.'confirm_full',
												$groups,
												$total_users,
												$processed_users,
												$recipients,
												($total_users-$processed_users))));
	}

	if(($processed_users-$recipients)>0) {
		$this->smarty->assign('resend_errors', 
					$this->CreateInputSubmit($id, 'resend_errors', 
								$this->lang('resend_errors'),'','',
								$this->lang('resenderror'.$mail_type.'confirm_full',
												$groups,
												$total_users,
												$processed_users,
												$recipients,
												($processed_users-$recipients))));
	}
	$this->smarty->assign('hidden',$this->CreateInputHidden($id,'mail_id',$mail_id).
									$this->CreateInputHidden($id,'mail_type',$mail_type));
}

if(!isset($archive_id)) {
	$message[] = $this->lang('task_open');
	if(!$mail_stored)
		$message[] = $this->lang('cannotcontinue');
	$this->smarty->assign('errormessage',implode("<br />",$message));
} else {
	$message[] = $this->lang('task_finished');
	if(!$mail_stored)
		$message[] = $this->lang('cannotcontinue');
	$this->smarty->assign('message',implode("<br />",$message));
}
// Display the populated template
echo $this->ProcessTemplate('viewLogs.tpl');
?>
