<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : FrontendUser Mailer (c) 2008-2010 by Georg Busch (georg.busch@gmx.net)
#          An addon module for CMS Made Simple to provide backend users ability 
#          to easily send an email to all frontend users or just specific front-
#          end usergroups within a CMS Made Simple powered website.
# Version: 0.9.3
# File   : action.sendMail.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if (!isset($gCms)) exit;

if (!$this->CheckPermission('Use FEUMailer'))
	return $this->DisplayErrorPage($id, $returnid,
												$this->Lang('error_permissions'));

$feusers =& $this->GetModuleInstance('FrontEndUsers');
if(!$feusers)
	return $this->DisplayErrorPage($id,$returnid,$this->Lang('error_feusers'));

$cmsmailer = $this->GetModuleInstance('CMSMailer');
if(!$cmsmailer)
	return $this->DisplayErrorPage($id, $returnid,
												$this->Lang('error_cmsmailer'));

$sentby_id = get_userid();

if(isset($params['mail_id'])) {
	$mail_id = intval(trim($params['mail_id']));
} else {
	echo $id."response:error=1:".$id."end_response";
	exit;
}

$last_userid=0;
$groups = array();
#$grpids = array();
$recipient_groups = '';
$recipients_count = 0;
$subject = '';
$mailbody = '';
$error = array();

if(empty($this->prefs))
	$prefs = $this->GetPrefs();
else
	$prefs =& $this->prefs;

$mail = $this->GetMail($mail_id,"tmp");
if($mail!=false) {
	
	$recipient_groups=$mail['recipient_groups'];
	$tmp_groups=explode(';',$mail['recipient_groups']);
	if(!empty($tmp_groups[0])) {
		foreach($tmp_groups as $tmp_group) {
			if(!empty($tmp_group)) {
				$g = explode(',',$tmp_group);
				if(isset($g[1]))
					$groups[$g[0]]=$g[1]; // key=id;value=name
					#$grpids[] = $g[0];
			}
		}
	}
	$subject			= $mail['subject'];
	$mailbody			= $mail['mailbody'];
	$last_userid		= $mail['last_userid'];
	$recipients_count 	= $mail['recipients'];
	$processed_users 	= $mail['processed_users'];
	$task 				= $mail['task'];
	$archive_id 		= $mail['archive_id'];
	$prefs['autosave'] = $mail['save_message'];
	
} else { 
	echo $id."response:error=2:".$id."end_response";
	exit;
}

$current_users=array();
$errorcodes = array();
if($task=='error') {
	$u = $this->GetUsersErrors($archive_id,0,0,'>=',$groups);
	$users = count($u);
	foreach($u as $userid=>$username) {
		if($userid > $last_userid) {
			if(($prefs['maxmails']>0 && count($current_users)<$prefs['maxmails']) || $prefs['maxmails']==0) {
				$current_users[$userid] = $username;
			}
		}
	}
} else if ($task=='selected') {
	$query = "SELECT * FROM ".cms_db_prefix()."module_feumailer_users 
				WHERE tmp_id=".$mail_id."
				ORDER BY userid ASC ". 
				($prefs['maxmails']>0?" LIMIT ".$prefs['maxmails']:'');
	$dbresult = $db->Execute($query);
	while($dbresult && $row = $dbresult->FetchRow()) {
		$users = $row['usercount'];
		$current_users[$row['userid']] = $row['username'];
		$errorcodes[$row['userid']] = $row['errorcode'];
	}
} else {
	$u = $this->GetUsers($groups);
	#$u = $this->GetUsersFull($grpids);

	$users = count($u);
	foreach($u as $userid=>$username) {
		if($userid > $last_userid) {
			if(($prefs['maxmails']>0 && count($current_users)<$prefs['maxmails']) || $prefs['maxmails']==0) {
				$current_users[$userid] = $username;
			}
		}
	}
}

// get additional groups the users also belongs to
// to get ALL user properties (not just of this one specified group) 
$groups = $this->GetAdditionalGroups($current_users);

// get users and userproperties (code from feusers module):
// now we have the groups, we build a union of all of the groups properties
$prop2 = array();
foreach($groups as $group_id=>$group_name)
{
	$proprelations = $feusers->GetGroupPropertyRelations($group_id);
	$prop2 = RRUtils::array_merge_by_name_required($prop2, $proprelations);
	uasort($prop2, array('RRUtils','compare_elements_by_sortorder_key'));
}

// now we merge in all of the property definitions
$defns = $feusers->GetPropertyDefns();
$prop3 = array();
foreach($prop2 as $oneprop)
{
	foreach($defns as $onedefn)
	{
		if($onedefn['name'] == $oneprop['name'])
		{
			$oneprop['prompt'] = $onedefn['prompt'];
			$oneprop['type'] = $onedefn['type'];
			break;
		}
	}
	$prop3[] = $oneprop;
}

// And now merge in the values
$properties = array();
$recipients = array();
$username_is_email = $feusers->GetPreference('username_is_email',false);

foreach($current_users as $userid=>$username) {
	$userprops = $feusers->GetUserProperties($userid);
	
	$properties[$userid]['username'] = $username;
	$properties[$userid]['userid'] = $userid;
	
	$recipients[$userid]['username'] = $username;
	
	foreach($prop3 as $oneprop)
	{
		foreach($userprops as $oneval)
		{
			if($oneprop['name'] == $oneval['title'])
			{
				$oneprop['data'] = $oneval['data'];
				break;
			}
		}
		if(isset($oneprop['data'])) {
			$properties[$userid][$oneprop['name']]['data']  = $oneprop['data'];
			$properties[$userid][$oneprop['name']]['prompt']= $oneprop['prompt'];
			$properties[$userid][$oneprop['name']]['type']  = $oneprop['type'];
			$properties[$userid][$oneprop['name']]['name']  = $oneprop['name'];
			if($oneprop['type']==2 && $oneprop['data']!='' && !isset($recipients[$userid]['email'])) {
				$recipients[$userid]['email'] = $oneprop['data'];
			}
		}
	}
	
	if($username_is_email) {
		$recipients[$userid]['email'] = $username;
	}
}

foreach($recipients as $userid=>$data) {
	
	$errorcode = 1;
	$log_id = '';
	
	if(isset($data['email']) && $this->IsValidEmailAddress($data['email'])) {

		$this->smarty->assign('username',$data['username']);
		$this->smarty->assign('userprops',$properties[$userid]);
		if($prefs['is_html']) {
			$mail_content = "<html><body>";
			$mail_content .= $this->ProcessTemplateFromData($mailbody);

			// insert tracking bug to check if mail has been read
			if($prefs['save_logs'] && !$prefs['save_errorlogs_only'] && 
			$task!='error' && $task!='selected') {
				
				$log_id = $db->GenID(cms_db_prefix()."module_feumailer_logs_seq");
				$page_extension = $gCms->config['page_extension'];
				$gCms->config['page_extension'] = '';
				$prettyurl = md5('FEUMailer').'/' . $log_id . "/logo.gif";
				$trackBug = $this->CreateLink($id, 'trackBug', $returnid, '', array('log_id' => $log_id, 'showtemplate' => 'false') ,'', true, false, '', true, $prettyurl);
				$mail_content .= '<img src="'.$trackBug.'" width="1" height="1" alt="" />';
				$gCms->config['page_extension'] = $page_extension;
				
			}
			
			$mail_content .= "</body></html>";
		} else {
			$mail_content = $this->ProcessTemplateFromData($mailbody);
		}
		
		$cmsmailer->AddAddress($data['email']);
		$cmsmailer->SetBody($mail_content);
		$cmsmailer->IsHTML($prefs['is_html']);
		$cmsmailer->SetSubject($subject);
		$cmsmailer->Send();
		$cmsmailer->ClearAddresses();

		$errorcode = 0;
		if(($task=='selected' && isset($errorcodes[$userid]) && $errorcodes[$userid]>0) 
		|| $task!='selected')
			$recipients_count++;
	}
	else if(isset($data['email']) && !$this->IsValidEmailAddress($data['email']))
		$errorcode = 2;
	
	if(($prefs['save_logs'] && (($prefs['save_errorlogs_only'] && 
	$errorcode !=0) || !$prefs['save_errorlogs_only'])) || 
	(($task=='error' || $task=='selected') && $prefs['save_logs'])) {
		
		if($task=='error' || $task=='selected') {
			$query = "UPDATE ".cms_db_prefix()."module_feumailer_logs 
						SET send_date=". $db->DBTimeStamp(time()) .", 
							tmp_errorcode=". $errorcode .", sentby_id=".$sentby_id." 
						WHERE archive_id=". $archive_id ." 
							AND recipient_id=". $userid;
			$dbresult = $db->Execute($query);
			if(!$dbresult) {
				$error[] = 8;
			}
		} else {
			// do log entry (for tmp mails)
			$log_result = $this->CreateLog(array($log_id,
								$archive_id,
								$mail_id,
								$sentby_id,
								$userid,
								$recipient_groups,
								$errorcode,
								$subject,
								$errorcode,
								NULL));

			if(!$log_result) {
				$error[] = 3;
			}
		}
	}
	$processed_users++;
	$last_userid = $userid;
	
	// update temp mail
	$query = "UPDATE ".cms_db_prefix()."module_feumailer_tmp 
				SET last_userid=".$userid.", processed_users=".$processed_users.", 
					recipients=".$recipients_count. " 
				WHERE id=".$mail_id;
	$dbresult = $db->Execute($query);
	if(!$dbresult) {
		echo $id."response:error=4:".$id."end_response";
		exit;
	}
	
	$query = "DELETE FROM ".cms_db_prefix()."module_feumailer_users 
				WHERE userid=". $userid ." AND tmp_id=".$mail_id;
	$dbresult = $db->Execute($query);
	unset($log_id);
}

$remaining = $users - $processed_users;
if($prefs['maxmails']>0)
	$processing_users = $processed_users+$prefs['maxmails'];
else
	$processing_users = $users;

if($processing_users>$users)
	$processing_users = $users;

if(($processed_users == $users) || ($remaining <=0) ) {
	
	if($prefs['autosave']==true) {
		
		if($task!='error' && $task!='continue' && $task!='user' && $task!='selected') {
			
			$archive_id = $this->CreateArchiveMail($recipient_groups,
													$subject,
													$mailbody,
													$last_userid,
													$processed_users,
													$recipients_count);
			if(!$archive_id) {
				$error[] = 5;
			}
			if($prefs['save_logs']) {

				// update logs with archive mail_id
				$query = "UPDATE ".cms_db_prefix()."module_feumailer_logs 
							SET archive_id=". $archive_id ." WHERE tmp_id=". $mail_id;
				$dbresult = $db->Execute($query);
				if(!$dbresult) {
					$error[] = 3;
				}
			}

		} else {

			// todo: if task=selected -> only add recipients if old errorcode>0
			if($task=='error' || $task=='selected') {
				$query = "SELECT last_userid, processed_users, recipients 
							FROM ".cms_db_prefix()."module_feumailer_archive 
							WHERE id=".$archive_id;
				$dbresult = $db->Execute($query);
				if($dbresult && $row = $dbresult->FetchRow()) {
					$processed_users = $row['processed_users'];
					$last_userid = $row['last_userid'];
					if(($row['recipients']+$recipients_count)<$processed_users)
						$recipients_count = $recipients_count + $row['recipients'];
					else
						$recipients_count = $processed_users;
				} 
			}

			$query = "UPDATE ".cms_db_prefix()."module_feumailer_archive 
						SET last_userid=".$last_userid.", 
							processed_users=". $processed_users .", 
							recipients=".$recipients_count." 
						WHERE id=".$archive_id;
			$dbresult = $db->Execute($query);
			if(!$dbresult) {
				$error[] = 6;
			}
			if($prefs['save_logs']) {

				if(($task=='error' || $task=='selected') && 
				$prefs['save_errorlogs_only']) {
					$query = "DELETE FROM ".cms_db_prefix()."module_feumailer_logs 
							WHERE archive_id=". $archive_id ." AND tmp_errorcode=0";
					$dbresult = $db->Execute($query);
					if(!$dbresult) {
						$error[] = 3;
					}
				}

				// update logs with archive mail_id
				// (not needed i guess)
				$query = "UPDATE ".cms_db_prefix()."module_feumailer_logs 
							SET tmp_id=". $mail_id ." WHERE archive_id=". $archive_id;
				$dbresult = $db->Execute($query);
				if(!$dbresult) {
					$error[] = 3;
				}
			}
		}
	}
	// delete temporary mails
	if(!$this->DeleteMail('tmp',$mail_id))
		$error[] = 7;
	
	/*
	$this->DoAction('deleteMail',$id,array('disable_theme','disable_buffer',
											'output'=>false,'mail_type'=>'tmp',
											'mail_id'=>$mail_id), 
										$returnid);
	*/

	// the javascript will print out the message
	echo $id."response:counter=".$processed_users." - ".$processing_users.";status=ready;error=".implode(",",$error).":".$id."end_response";
}
// calling from queue
else {
	echo $id."response:counter=".$processed_users." - ".$processing_users.";status=sending;error=".implode(",",$error).":".$id."end_response";
}
?>
