<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : FrontendUser Mailer (c) 2008-2010 by Georg Busch (georg.busch@gmx.net)
#          An addon module for CMS Made Simple to provide backend users ability 
#          to easily send an email to all frontend users or just specific front-
#          end usergroups within a CMS Made Simple powered website.
# Version: 0.9.3
# File   : action.savePrefs.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if (!isset($gCms)) exit;

if (!isset($params['submit_prefs'])) exit;

if(!$this->CheckPermission('Use FEUMailer'))
	return $this->DisplayErrorPage($id,$returnid,$this->Lang('error_permissions'));

$message = $this->lang('prefs_updated');

$autosave=false;
$autoclear_archivemails=false;
$autoclear_value=3;
$autoclear_time='month';
$autoclear_tmpmails=false;
$is_html=false;
$maxmails=50;
$autoclear_logs = false;
$request_delay = '';
$save_logs=false;
$save_errorlogs_only=false;
$random_delay = false;

if(isset($params['random_delay']))
	$random_delay = true;

if(isset($params['autosave']))
	$autosave = true;

if(isset($params['save_logs']))
	$save_logs = true;

if(isset($params['save_errorlogs_only']))
	$save_errorlogs_only = true;

if(isset($params['autoclear_logs']))
	$autoclear_logs = true;

if(isset($params['autoclear_archivemails'])) {
	$autoclear_archivemails = true;

	if(isset($params['autoclear_value']) && $params['autoclear_value']!='')
		$autoclear_value = intval(trim($params['autoclear_value']));

	if(isset($params['autoclear_time']) && $params['autoclear_time']!='')
		$autoclear_time = trim($params['autoclear_time']);

	if(isset($params['autoclear_tmpmails']))
		$autoclear_tmpmails = true;

}

if(isset($params['is_html']))
	$is_html = true;
else
	$is_html = false;

if(isset($params['maxmails']))
		$maxmails = intval(trim($params['maxmails']));

if(isset($params['request_delay']))
		$request_delay = intval(trim($params['request_delay']));

if(isset($params['default_groups']) && is_array($params['default_groups']) 
   && !empty($params['default_groups'])) {
	foreach($params['default_groups'] as $def_group) {
		$dg = explode(",",$def_group);
		if(isset($dg[1]))
			$default_groups[$dg[1]." (".$dg[2]." ". $this->lang("users") .")"] = $dg[0].",".$dg[1];
	}
}

$this->SetPreference("autosave", $autosave);
$this->SetPreference("autoclear_archivemails",$autoclear_archivemails);
$this->SetPreference("autoclear_value", $autoclear_value);
$this->SetPreference("autoclear_time", $autoclear_time);
$this->SetPreference("autoclear_tmpmails", $autoclear_tmpmails);
$this->SetPreference("is_html", $is_html);
$this->SetPreference("maxmails", $maxmails);
$this->SetPreference("save_logs", $save_logs);
$this->SetPreference("save_errorlogs_only", $save_errorlogs_only);
$this->SetPreference("autoclear_logs", $autoclear_logs);
$this->SetPreference("default_groups", implode(";",$default_groups));
$this->SetPreference("request_delay", $request_delay);
$this->SetPreference("random_delay", $random_delay);
$this->prefs = $this->GetPrefs();
$this->Redirect($id, 'defaultadmin', $returnid, array('message'=>$message,
															'active_tab'=>'pref'));
?>