<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : FrontendUser Mailer (c) 2008-2010 by Georg Busch (georg.busch@gmx.net)
#          An addon module for CMS Made Simple to provide backend users ability 
#          to easily send an email to all frontend users or just specific front-
#          end usergroups within a CMS Made Simple powered website.
# Version: 0.9.3
# File   : action.prepareSendMail.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if (!isset($gCms)) exit;

if (!$this->CheckPermission('Use FEUMailer'))
	return $this->DisplayErrorPage($id, $returnid,
												$this->Lang('error_permissions'));

$feusers =& $this->GetModuleInstance('FrontEndUsers');
if(!$feusers)
	return $this->DisplayErrorPage($id,$returnid,$this->Lang('error_feusers'));

$cmsmailer = $this->GetModuleInstance('CMSMailer');
if(!$cmsmailer)
	return $this->DisplayErrorPage($id, $returnid,
												$this->Lang('error_cmsmailer'));

$task='all';
if(isset($params['task']) && !empty($params['task'])) {
	$task=trim($params['task']);
}

$sentby_id = get_userid();

$autosave = $this->GetPref("autosave",true);
if(isset($params['autosave'])) {
	$autosave=true;
} else if(!isset($params['autosave']) && isset($params['submit']))
	$autosave=false;

if(isset($params['mail_type']) && !empty($params['mail_type'])) {
	$mail_type = trim($params['mail_type']);
} else {
	return $this->DisplayErrorPage($id, $returnid,
		$this->Lang('error_insuffucientparams','mail_type','prepareSendMail'));
}

if(isset($params['mail_id'])) {
	$mail_id = intval(trim($params['mail_id']));
} else {
	return $this->DisplayErrorPage($id, $returnid,
		$this->Lang('error_insuffucientparams','mail_id','prepareSendMail'));
}

$last_userid=0;
$groups = array();
$recipient_groups = '';
$recipients_count = 0;
$subject = '';
$mailbody = '';
$mail = $this->GetMail($mail_id,$mail_type);
if($mail != false) {
	
	$recipient_groups=$mail['recipient_groups'];
	$tmp_groups=explode(';',$mail['recipient_groups']);
	if(!empty($tmp_groups[0])) {
		foreach($tmp_groups as $tmp_group) {
			if(!empty($tmp_group)) {
				$g = explode(',',$tmp_group);
				if(isset($g[1]))
					$groups[$g[0]]=$g[1]; // key=id;value=name
			}
		}
	}
	$subject		= $mail['subject'];
	$mailbody		= $mail['mailbody'];
	$last_userid	= $mail['last_userid'];
	$recipients_count = $mail['recipients'];
	$processed_users = $mail['processed_users'];
	if($mail_type=='tmp') {
		$task = $mail['task'];
		$autosave = $mail['save_message'];
		$archive_id = $mail['archive_id'];
	}
	
} else {
	return $this->DisplayErrorPage($id, $returnid,
			$this->Lang('error_db_get_'.$mail_type.'mail',$mail_id,$query));
}

$users = 0;

if($mail_type=='archive') {
	
	$archive_id = $mail_id;
	if($task=='user' || $task=='selected') {
	
		$current_users = array();
		$errorcodes = array();
		if($task=='user' && isset($params['username']) && 
		isset($params['userid']) && isset($params['errorcode'])) {
			
			$current_users[intval($params['userid'])] = trim($params['username']);
			$errorcodes[intval($params['userid'])] = intval($params['errorcode']);
			
		} else if($task=='selected') {
			
			foreach($params as $name=>$value) {
				
				if(startswith($name, 'log-') && $value!='') {
					
					$val = explode('-',trim($value));
					
					if(isset($val[2])) {
						$current_users[intval(trim($val[0]))] = trim($val[1]);
						$errorcodes[intval(trim($val[0]))] = intval(trim($val[2]));
					}
				}
			}
		}
		
		if(count($current_users)>0 && 
		(count($current_users)<=$this->GetPref('maxmails',50) || 
		$this->GetPref('maxmails',50)==0)) {
			
			// get groups
			// get properties
			// do send mail
			// redirect default admin with message "done"
			$groups = $this->GetAdditionalGroups($current_users);
	
			$prop2 = array();
			foreach($groups as $group_id=>$group_name)
			{
				$proprelations = $feusers->GetGroupPropertyRelations($group_id);
				$prop2 = RRUtils::array_merge_by_name_required($prop2, $proprelations);
				uasort($prop2, array('RRUtils','compare_elements_by_sortorder_key'));
			}
			
			// now we merge in all of the property definitions
			$defns = $feusers->GetPropertyDefns();
			$prop3 = array();
			foreach($prop2 as $oneprop)
			{
				foreach($defns as $onedefn)
				{
					if($onedefn['name'] == $oneprop['name'])
					{
						$oneprop['prompt'] = $onedefn['prompt'];
						$oneprop['type'] = $onedefn['type'];
						break;
					}
				}
				$prop3[] = $oneprop;
			}
			
			// And now merge in the values
			$properties = array();
			$recipients = array();
			$username_is_email = $feusers->GetPreference('username_is_email',false);
			
			foreach($current_users as $userid=>$username) {
				$userprops = $feusers->GetUserProperties($userid);
				
				$properties[$userid]['username'] = $username;
				$properties[$userid]['userid'] = $userid;
				
				$recipients[$userid]['username'] = $username;
				
				foreach($prop3 as $oneprop)
				{
					foreach($userprops as $oneval)
					{
						if($oneprop['name'] == $oneval['title'])
						{
							$oneprop['data'] = $oneval['data'];
							break;
						}
					}
					if(isset($oneprop['data'])) {
						$properties[$userid][$oneprop['name']]['data']  = $oneprop['data'];
						$properties[$userid][$oneprop['name']]['prompt']= $oneprop['prompt'];
						$properties[$userid][$oneprop['name']]['type']  = $oneprop['type'];
						$properties[$userid][$oneprop['name']]['name']  = $oneprop['name'];
						if($oneprop['type']==2 && $oneprop['data']!='' && 
						!isset($recipients[$userid]['email'])) {
							$recipients[$userid]['email'] = $oneprop['data'];
						}
					}
				}
				
				if($username_is_email) {
					$recipients[$userid]['email'] = $username;
				}
			}
			$recipients_count = 0;
			foreach($recipients as $userid=>$data) {
				
				$errorcode = 1;
				
				if(isset($data['email']) && $this->IsValidEmailAddress($data['email'])) {
					
					$this->smarty->assign('username',$data['username']);
					$this->smarty->assign('userprops',$properties[$userid]);
					if($this->GetPref('is_html',false)) {
						$mail_content = "<html><body>";
						$mail_content .= $this->ProcessTemplateFromData($mailbody);
						
						// insert tracking bug to check if mail has been read
						if($this->GetPref('save_logs') && !$this->GetPref('save_errorlogs_only') && 
						$task!='error' && $task!='selected' && ($log_id = $this->GetLogID($mail_id, $userid))) {
							
							$page_extension = $gCms->config['page_extension'];
							$gCms->config['page_extension'] = '';
							$prettyurl = md5('FEUMailer').'/' . $log_id . "/logo.gif";
							$trackBug = $this->CreateLink($id, 'trackBug', $returnid, '', array('log_id' => $log_id,'showtemplate' => 'false') ,'', true, false, '', true, $prettyurl);
							$mail_content .= '<img src="'.$trackBug.'" width="1" height="1" alt="" />';
							$gCms->config['page_extension'] = $page_extension;
						}
						
						$mail_content .= "</body></html>";
					} else {
						$mail_content = $this->ProcessTemplateFromData($mailbody);
					}
					
					$cmsmailer->AddAddress($data['email']);
					$cmsmailer->SetBody($mail_content);
					$cmsmailer->IsHTML($this->GetPref('is_html',false));
					$cmsmailer->SetSubject($subject);
					$cmsmailer->Send();
					$cmsmailer->ClearAddresses();
					
					$errorcode = 0;
					if(isset($errorcodes[$userid]) && $errorcodes[$userid]>0)
						$recipients_count++; 
				}
				else if(isset($data['email']) && !$this->IsValidEmailAddress($data['email']))
					$errorcode = 2;
				
				if(($this->GetPref('save_logs',true) && 
				(($this->GetPref('save_errorlogs_only',true) && $errorcode !=0) 
				|| !$this->GetPref('save_errorlogs_only',true)))) {
					
					$query = "UPDATE ".cms_db_prefix()."module_feumailer_logs 
								SET send_date=". $db->DBTimeStamp(time()) .", 
									errorcode=". $errorcode .", sentby_id=".$sentby_id." 
								WHERE archive_id=". $mail_id ." 
									AND recipient_id=". $userid;
					$dbresult = $db->Execute($query);
					if(!$dbresult) {
						// todo: display errormessage
					}
				}
			}

			// todo: if task=selected -> only add recipients if old errorcode>0
			$query = "SELECT last_userid, processed_users, recipients 
						FROM ".cms_db_prefix()."module_feumailer_archive 
						WHERE id=".$mail_id;
			$dbresult = $db->Execute($query);
			if($dbresult && $row = $dbresult->FetchRow()) {
				if(($row['recipients']+$recipients_count)<$row['processed_users']) {
					$recipients_count = $recipients_count + $row['recipients'];
				} else {
					$recipients_count = $row['processed_users'];
				}
				$query = "UPDATE ".cms_db_prefix()."module_feumailer_archive 
							SET recipients=".$recipients_count." 
							WHERE id=".$mail_id;
				$dbresult = $db->Execute($query);
				if(!$dbresult) {
					// todo: display errormessage
				}
			}
	
			if($this->GetPref('save_logs',true)) {
	
				if($this->GetPref('save_errorlogs_only',true)) {
					$query = "DELETE FROM ".cms_db_prefix()."module_feumailer_logs 
							WHERE archive_id=". $mail_id ." AND errorcode=0";
					$dbresult = $db->Execute($query);
					if(!$dbresult) {
						// todo: display errormessage
					}
				}
			}
			$this->Redirect($id, 'defaultadmin', $returnid,
				array("active_tab"=>$active_tab,
					'message'=>$this->lang('mails_sent')));
			return;
		}
	}
	
	if($task=='all') {
		
		$recipients_count = 0;
		$processed_users = 0;
		$last_userid = 0;
		$archive_id = '';
		
	} else if ($task=='selected') {
		
		$recipients_count = 0;
		$processed_users = 0;
		$last_userid = 0;

	} else if ($task=='error') {
		
		$current_users = array();
		$recipients_count = 0;
		$processed_users = 0;
		$u = $this->GetUsersErrors($mail_id,0,0,'>=',$groups);
		$users = count($u);
		foreach($u as $userid=>$username) {
			if(($this->GetPref('maxmails',50)>0 && 
			count($current_users)<$this->GetPref('maxmails',50)) || 
			$this->GetPref('maxmails',50)==0) {
				$current_users[$userid] = $username;
			}
		}

		reset($current_users);
		$last_userid = (key($current_users)-1);
		
	}
	
	$ret = $this->createTempMail($recipient_groups,
									$subject,
									$mailbody,
									$last_userid,
									$processed_users,
									$recipients_count,
									$task,
									$archive_id,
									$autosave);
	if(!$ret[0]) {
		return $this->DisplayErrorPage($id,$returnid,$ret[1]);
	}
	$mail_id = $ret[1];
	if($task=='selected') {
		$users = count($current_users);
		foreach($current_users as $uid=>$uname) {
			$query = "INSERT INTO ".cms_db_prefix()."module_feumailer_users 
						(id, userid, username, tmp_id, usercount,errorcode)
						VALUES (?,?,?,?,?,?)";
			$dbresult = $db->Execute($query, 
				array($db->GenID(cms_db_prefix()."module_feumailer_users_seq"),
					$uid,
					$uname,
					$mail_id,
					$users,
					$errorcodes[$uid]));
		}
	}
} else if($mail_type=='tmp') {
	
	if ($task=='error') {
		$users = count($this->GetUsersErrors($archive_id,0,0,'>=',$groups));
	}
	else if ($task=='selected') {
		$query = "SELECT * FROM ".cms_db_prefix()."module_feumailer_users 
				WHERE tmp_id=".$mail_id."
				ORDER BY userid ASC ". 
				($this->GetPref('maxmails',50)>0?" LIMIT ".$this->GetPref('maxmails',50):'');
		$dbresult = $db->Execute($query);
		while($dbresult && $row = $dbresult->FetchRow()) {
			$users = $row['usercount'];
			$current_users[$row['userid']] = $row['username'];
		}
	}
	// if we try to continue with a temp or archive mail -> update mail
	$query = "UPDATE ".cms_db_prefix()."module_feumailer_tmp 
				SET send_date=". $db->DBTimeStamp(time()) .", 
					sentby_id=". $sentby_id ." 
				WHERE id=".$mail_id;
	$dbresult = $db->Execute($query);
	if(!$dbresult)
		return $this->DisplayErrorPage($id, $returnid,
								$this->Lang('error_db_update_tmpmail',$query));

}

if($task!='error' && $task!='user' && $task!='selected') {
	$users = count($this->GetUsers($groups));
}

// Display the populated template
$img=$gCms->variables['admintheme']->DisplayImage('icons/system/accept.gif',
														'','','','systemicon');
$this->smarty->assign('message',$img.'&nbsp;'.$this->lang('mails_sent'));
$this->smarty->assign('id',$id);
$this->smarty->assign('delay',intval($this->GetPref('request_delay','')));
$this->smarty->assign('random_delay',intval($this->GetPref('random_delay',false)));
$this->smarty->assign('ok_link',
	$this->CreateLink($id,'defaultadmin','',$this->lang('ok'),array(),'',
		false,false,'onclick"window.close()"'));

#$this->smarty->assign('ok_link','<a href="javascript:onclick=window.close()">OK</a>');

$this->smarty->assign('error_1',
	$this->lang('error_insufficientparams_ajax','mail_id','sendMail'));
$this->smarty->assign('error_2',
	$this->lang('error_db_get_tmpmail_ajax',$mail_id));
$this->smarty->assign('error_3',$this->lang('error_db_create_log'));
$this->smarty->assign('error_4',$this->lang('error_db_update_tmpmail_ajax'));
$this->smarty->assign('error_5',$this->lang('error_db_savemail',''));
$this->smarty->assign('error_6',$this->lang('error_db_update_archive'));
$this->smarty->assign('error_7',$this->lang('error_db_delete_tmp'));
$this->smarty->assign('error_8',$this->lang('error_db_update_log'));
$this->smarty->assign('heading',$this->lang('sendmail'));
$this->smarty->assign('error_ajax',$this->lang('error_ajax'));
$this->smarty->assign('error_request_status',
										$this->lang('error_request_status'));
$this->smarty->assign('error_xmlhttp_instance',
									$this->lang('error_xmlhttp_instance'));
$this->smarty->assign('sendmessage',$this->lang('wait'));

if($this->GetPref('maxmails',50)>0)
	$processing_users = $processed_users+$this->GetPref('maxmails',50);
else
	$processing_users = $users;

if($processing_users>$users)
	$processing_users = $users;

$this->smarty->assign('counter',$this->lang('sending').
					'&nbsp;&nbsp;<span id="processing">'.
					$processed_users .
					' - '.$processing_users.'</span>&nbsp;'. $this->lang('of').
					'&nbsp;'. $users);

// create an url for the xmlhttp request (ajax)
// need to replace &amp; with & otherwise it won't work with CMSms > 1.5 (?)
$parms = array('mail_id'=>$mail_id,'mail_type'=>$mail_type,'task'=>$task,
				'disable_theme'=>true,'disable_buffer'=>true,'ajax'=>true);

$smarty->assign('url', str_replace('&amp;', '&', 
								$this->CreateLink($id,'sendMail',$returnid,'',
															$parms, '', true)));

echo $this->ProcessTemplate('sendMail.tpl');
?>
