<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : FrontendUser Mailer (c) 2008-2010 by Georg Busch (georg.busch@gmx.net)
#          An addon module for CMS Made Simple to provide backend users ability 
#          to easily send an email to all frontend users or just specific front-
#          end usergroups within a CMS Made Simple powered website.
# Version: 0.9.3
# File   : action.multiAction.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if(!isset($gCms))
	exit;

// script will only be executed when submitted by the right forms
if(!isset($params['submit_tmp']) && !isset($params['submit_archive']))
	$this->Redirect($id, 'defaultadmin', $returnid);

if(!$this->CheckPermission('Use FEUMailer')) {
	return $this->DisplayErrorPage($id,$returnid,
												$this->Lang('error_permissions'));
}

if(isset($params['mail_type']) && !empty($params['mail_type'])) {
	$mail_type = trim($params['mail_type']);
} else {
	return $this->DisplayErrorPage($id,$returnid,$this->Lang('error_mailtype'));
}

$mails = array();
foreach($params as $name=>$value) {
		if(startswith($name, 'mail-') && $value!='') {
			$val = explode('-',trim($value));
			$mails[$val[0]]['id'] = intval(trim($val[0]));
			$mails[$val[0]]['clear_log'] = intval(trim($val[1]));
		}
}

if(empty($mails) || !count($mails)) {
	return $this->DisplayErrorPage($id,$returnid,
								$this->Lang('error_selected'.$mail_type.'mails'));
}

$where = array();
$query1 = "DELETE FROM ".cms_db_prefix()."module_feumailer_".$mail_type." 
			WHERE ";
$query2 = "DELETE FROM ".cms_db_prefix()."module_feumailer_logs";
$i=0;
foreach($mails as $mail) {
	$i++;
	$query1 .= "id = ".$mail['id'];
	if($i<sizeof($mails)) {
		$query1 .= " OR ";
	}
	if($mail['clear_log']) {
		$where[] = $mail_type."_id=".$mail['id'];
	}
	
}

$dbresult = $db->Execute($query1);
if(!$dbresult) {
	return $this->DisplayErrorPage($id,$returnid,
						$this->lang('error_db_delete_'.$mail_type,$query1));
}

if($this->GetPref("autoclear_logs",false)) {
	// i've seen this "$where=array() and implode" stuff in FEUsers Module
	// great idea
	if(count($where))
	{
		$query2 .= " WHERE " . implode(" OR ",$where); 
		$dbresult = $db->Execute($query2);
		if(!$dbresult) {
			return $this->DisplayErrorPage($id,$returnid,
							$this->lang('error_db_autoclearlog',$query2));
		}
	}
}

$this->Redirect($id, 'defaultadmin', $returnid, array('active_tab'=>$mail_type,
							'message'=>$this->lang($mail_type.'maildeleted')));
?>
