<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : FrontendUser Mailer (c) 2008-2010 by Georg Busch (georg.busch@gmx.net)
#          An addon module for CMS Made Simple to provide backend users ability 
#          to easily send an email to all frontend users or just specific front-
#          end usergroups within a CMS Made Simple powered website.
# Version: 0.9.3
# File   : action.getUsers.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if(!isset($gCms))
	exit;

if(!$this->CheckPermission('Use FEUMailer')) {
	exit;
}

$total_users = $processed_users = $recipients = 0;
$selected_groups = array();
$recipient_groups = array();
$groups_changed = 0;
$message = '';
$mail_id = 0;

$resend = 'all';
if(isset($params['resend']))
	$resend = trim($params['resend']);

if(isset($params['mail_id']))
	$mail_id = $params['mail_id'];

foreach($params as $name=>$value) {
	if(startswith($name, 'group_')) {
		$v = explode(",",$value);
		if(isset($v[1]))
			$selected_groups[$v[0]]=$v[1];
	}
}

if($mail_id > 0) {
	$query = "SELECT * FROM ".cms_db_prefix()."module_feumailer_archive
				WHERE id=".$mail_id." LIMIT 1";
	$dbresult = $db->Execute($query);
	if($dbresult && $row = $dbresult->FetchRow()) {
		$grps = explode(';',$row['recipient_groups']);
		if(!empty($grps[0])) {
			foreach($grps as $grp) {
				$g = explode(',',$grp);
				if(isset($g[1])) {
					$recipient_groups[$g[0]] = $g[1];
				}
			}
		}
		$processed_users = $row['processed_users'];
		$recipients = $row['recipients'];
		$last_userid = $row['last_userid'];
	}
}

// get number of users in selected groups
if(count($selected_groups)) {
	
	if(implode("",$selected_groups) != implode("",$recipient_groups))
		$groups_changed = true;
		
	$total_users = count($this->GetUsers($selected_groups));
	
	if($total_users < $processed_users)
		$processed_users = $total_users;
	if($total_users < $recipients)
		$recipients = $total_users;
	$message = "groups=".implode(", ",$selected_groups).";total_users=".$total_users.";processed_users=".$processed_users.";recipients=".$recipients.";groups_changed=".$groups_changed.";resend=".$resend;
}
echo $id."response:".$message.":".$id."end_response";
?>
