<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : FrontendUser Mailer (c) 2008-2010 by Georg Busch (georg.busch@gmx.net)
#          An addon module for CMS Made Simple to provide backend users ability 
#          to easily send an email to all frontend users or just specific front-
#          end usergroups within a CMS Made Simple powered website.
# Version: 0.9.3
# File   : action.editMail.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if(!isset($gCms))
	exit;

if(!$this->CheckPermission('Use FEUMailer')) {
	return $this->DisplayErrorPage($id,$returnid,
												$this->Lang('error_permissions'));
}

if(isset($params['submit_form']))
	$submit = $params['submit_form'];

# ToDo: Check if this is needed!
#if(isset($submit) && $submit=='error')
#	$this->Redirect($id, 'prepareSendMail', $returnid,$params);

if(isset($params['mail_id'])) {
	$mail_id = intval(trim($params['mail_id']));
} else {
	$this->Redirect($id, 'defaultadmin', $returnid);
}

if(isset($params['mail_type']) && !empty($params['mail_type'])) {
	$mail_type = trim($params['mail_type']);
} else {
	$this->Redirect($id, 'defaultadmin', $returnid);
}

if(isset($params['cancel'])) {
	$this->Redirect($id, 'defaultadmin', $returnid, 
												array('active_tab'=>$mail_type));
}

$error 				= false;
$errormessage 		= '';
$sel_groups 		= array();
$rec_groups 		= array();
$check_groups 		= array();
$selected_groups 	= array();
$subject 			= '';
$mailbody 			= '';
$sentby 			= '';
$last_userid 		= 0;
$send_date 			= '';
$processed_users 	= 0;
$recipients 		= 0;
$errorcode 			= 0;

$clear_log = false;
if(isset($params['clear_log']) && $params['clear_log']==true) {
	$clear_log = true;
}

// get mail data
$mail = $this->GetMail($mail_id,$mail_type);
if($mail!=false) {

	$grps=explode(';',$mail['recipient_groups']);
	if(!empty($grps)) {
		foreach($grps as $grp) {
			if(!empty($grp)) {
				$g = explode(',',$grp);
				if(isset($g[1])) {
					$sel_groups[$g[0]] 		= $g[1];
					$check_groups[$g[0]] 	= $g[1];
					$rec_groups[] 			= $g[0].','.$g[1];
				}
			}
		}
	}
	$subject 			= $mail['subject'];
	$mailbody 			= $mail['mailbody'];
	$sentby 			= $mail['username'];
	$last_userid 		= $mail['last_userid'];
	$send_date 			= $mail['send_date'];
	$processed_users 	= $mail['processed_users'];
	$recipients 		= $mail['recipients'];
	
	if($mail['recipients']==$mail['processed_users'])
		$errorcode 	= 0;
	else
		$errorcode 	= 1;
	
	if($mail['logs']>0)
		$logs 			= true;
	else
		$logs 			= false;
}

// get feusergroups
$groups = $this->GetGroups();
// if no groups -> display errormessage
if(empty($groups)) {
	$this->Redirect($id, 'defaultadmin', $returnid, 
							array('errormessage'=>$this->Lang('error_groups')));

}

foreach($groups as $k=>$v) {
	$grp_vars = explode(',',$v);
	if(isset($grp_vars[2]) && isset($sel_groups[$grp_vars[0]])) {
		$selected_groups[$grp_vars[1]." (".$grp_vars[2]." ".$this->lang("users").")"] = implode(",",$grp_vars);
	}
}

if(isset($params['subject']) && !empty($params['subject'])) {
	$subject = trim($params['subject']);
}

if(isset($params['mailbody'])) {
	$mailbody = trim($params['mailbody']);
}

$autosave = $this->GetPref("autosave",true);
if(isset($params['autosave']) && isset($submit)) {
	$autosave=true;
} else if(!isset($params['autosave']) && isset($submit)) {
	$autosave=false;
}

if(isset($params['groups']) && !empty($params['groups'])
   && is_array($params['groups'])) {
	unset($selected_groups);
	unset($check_groups);
	unset($rec_groups);
	$selected_groups = array();
	$check_groups = array();
	$rec_groups = array();
	foreach($params['groups'] as $group) {
		if(!empty($group)) {
			$g = explode(',',trim($group));
			if(isset($g[2])) {
				$selected_groups[$g[1]." (".$g['2']." ".$this->lang("users").")"] = $g[0].",".$g[1].",".$g[2];
				$check_groups[$g[0]]=$g[1];
				$rec_groups[] = $g[0].','.$g[1];
			}
		}
	}
}

if(isset($submit)) {
	$users = count($this->GetUsers($check_groups));
	if(empty($selected_groups)) {
		$error = true;
		$errormessage .= $this->lang('error_selectedgroups').'<br />';
	} else {
		if($users==0) {
			$error = true;
			$errormessage .= $this->lang('error_nousersfound').'<br />';
		}
	}
	if(empty($mailbody)) {
		$error = true;
		$errormessage .= $this->lang('error_mailbody').'<br />';
	}
	
### do action ##########################################################################################################################################################################################################################################################################################################################################

	if($error==false) {
		$recipient_groups = implode(";",$selected_groups);
		if($submit == 'all') {
			
			$last_userid 			= 0;
			$processed_users 		= 0;
			$recipients 			= 0;
			
		}

		$ret = $this->createTempMail($recipient_groups,
										$subject,
										$mailbody,
										$last_userid,
										$processed_users,
										$recipients,
										$submit,
										'',
										$autosave);
		if(!$ret[0]) {
			return $this->DisplayErrorPage($id,$returnid,$ret[1]);
		} else {
			$parms['mail_id'] 		= $ret[1];
			$parms['mail_type'] 	= 'tmp';
			$this->DoAction('prepareSendMail',$id,$parms,$returnid);
			return;
		}
	}

################################################################################

}

// smarty stuff
$this->smarty->assign('startForm',
		$this->CreateFormStart($id, 'editMail', $returnid, 'post', '', false, 'myForm'));
$this->smarty->assign('endForm',$this->CreateFormEnd());

$this->smarty->assign('id',$id);
$smarty->assign('url', str_replace('&amp;', '&', 
	$this->CreateLink($id,'getUsers',$returnid,'',array('mail_type'=>$mail_type,
															'mail_id'=>$mail_id,
															'disable_theme'=>true,
															'disable_buffer'=>true,
															'ajax'=>true), '', true)));

$this->smarty->assign('error_ajax',$this->lang('error_ajax'));
$this->smarty->assign('nousers', $this->lang('error_nousersfound'));
$this->smarty->assign('nogroups', $this->lang('error_selectedgroups'));
$this->smarty->assign('nomessage', $this->lang('error_mailbody'));

$this->smarty->assign('resend_all',$this->lang('resend_all'));
$this->smarty->assign('resend_new',$this->lang('continue_'.$mail_type));
if($logs==true)
	$this->smarty->assign('resend_error',$this->lang('resend_errors'));

$this->smarty->assign('resendall_confirm',$this->lang('resendall'.$mail_type.'confirm'));
$this->smarty->assign('resendnew_confirm',$this->lang('resendnew'.$mail_type.'confirm'));
$this->smarty->assign('resenderror_confirm',$this->lang('resenderror'.$mail_type.'confirm'));

$this->smarty->assign('totalusers',$this->lang('totalusers'));
$this->smarty->assign('processed_users',$this->lang('processedusers'));
$this->smarty->assign('recipients',$this->lang('recipients'));
$this->smarty->assign('remaining',$this->lang('remaining'));
$this->smarty->assign('groups_changed',$this->lang('groups_changed'));

$this->smarty->assign('cancel',
				$this->CreateInputSubmit($id,'cancel',$this->lang('cancel')));

$this->smarty->assign('groups_text',$this->lang('groups'));
$this->smarty->assign('groups_input',$this->CreateInputSelectList($id,'groups[]',
					$groups,$selected_groups,count($groups),'id="groups"',true));

// prefs
$this->smarty->assign('save_text',$this->lang('save'));
$this->smarty->assign('save_input',$this->CreateInputCheckbox($id,
											'autosave',1,($autosave==true?1:'')));

$this->smarty->assign('subject_text',$this->lang('subject'));
$this->smarty->assign('subject_input',$this->CreateInputText($id,'subject',
																$subject,64,128));

$this->smarty->assign('hidden',$this->CreateInputHidden($id,'mail_id',$mail_id).
		$this->CreateInputHidden($id,'mail_type',$mail_type).
		$this->CreateInputHidden($id, 'submit_form', false, 'id="submit_form"'));

$this->smarty->assign('mailbody_text',$this->lang('message'));
$this->smarty->assign('mailbody_input',
$this->CreateTextArea(($this->GetPref('is_html',false)==true?true:false),
						$id,
						$mailbody,
						'mailbody',
						'',
						'message'));

if($errormessage!='') {
	$this->smarty->assign('errormessage',$errormessage);
}

// Display the populated template
echo $this->ProcessTemplate('editMail.tpl');
?>
