<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : FrontendUser Mailer (c) 2008-2010 by Georg Busch (georg.busch@gmx.net)
#          An addon module for CMS Made Simple to provide backend users ability 
#          to easily send an email to all frontend users or just specific front-
#          end usergroups within a CMS Made Simple powered website.
# Version: 0.9.3
# File   : action.deleteMail.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if(!isset($gCms))
	exit;

if(!$this->CheckPermission('Use FEUMailer')) {
	return $this->DisplayErrorPage($id,$returnid,
					$this->Lang('error_permissions'));
}

if(isset($params['mail_type']) && !empty($params['mail_type'])) {
	$mail_type = trim($params['mail_type']);
} else {
	return $this->DisplayErrorPage($id,$returnid,
		$this->Lang('error_insufficientparams','mail_type','deleteMail'));
}

$active_tab = $mail_type;

if(isset($params['mail_id'])) {
	$mail_id = intval(trim($params['mail_id']));
} else {
	return $this->DisplayErrorPage($id,$returnid,
		$this->Lang('error_insufficientparams','mail_id','deleteMail'));
}

if(!$this->DeleteMail($mail_type,$mail_id) && (!isset($params['output']) || $params['output']!=false))
	return $this->DisplayErrorPage($id,$returnid,
										$this->lang('error_db_deletemail',$query));

if($this->GetPref("autoclear_logs",false)) {
	if(isset($params['clear_log']) && $params['clear_log']==true) {
		if(!$this->DeleteLog($mail_type,$mail_id) && (!isset($params['output']) || $params['output']!=false))
			return $this->DisplayErrorPage($id,$returnid,
								$this->lang('error_db_deletelogs',$query));
	}
}

if(!isset($params['output']) || $params['output']!=false) {
	$this->Redirect($id, 'defaultadmin', $returnid, array('active_tab'=>$mail_type,
								'message'=>$this->lang($mail_type.'maildeleted')));
} else
	return TRUE;
?>
