<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : FrontendUser Mailer (c) 2008-2010 by Georg Busch (georg.busch@gmx.net)
#          An addon module for CMS Made Simple to provide backend users ability 
#          to easily send an email to all frontend users or just specific front-
#          end usergroups within a CMS Made Simple powered website.
# Version: 0.9.3
# File   : action.defaultadmin.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if(!isset($gCms))
	exit;

if(!$this->CheckPermission('Use FEUMailer'))
	return $this->DisplayErrorPage($id,$returnid,	$this->Lang('error_permissions'));

$feusers =& $this->GetModuleInstance('FrontEndUsers');
if(!$feusers)
	return $this->DisplayErrorPage($id,$returnid,	$this->Lang('error_feusers'));

if(!$this->GetModuleInstance('CMSMailer'))
	return $this->DisplayErrorPage($id,$returnid, $this->Lang('error_cmsmailer'));

// systemicons
#$new = $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->lang('newmail'),'','','systemicon');
$new = '<img src="'.$gCms->config['root_url'].'/modules/FEUMailer/images/newmail.gif" alt="" title="'.$this->lang('newmail').'" class="systemicon" />';
$read = $gCms->variables['admintheme']->DisplayImage('icons/system/view.gif', $this->lang('read'),'','','systemicon');
$edit = $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->lang('edit'),'','','systemicon');
$delete = $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->lang('delete'),'','','systemicon');
$resend_all = '<img src="'.$gCms->config['root_url'].'/modules/FEUMailer/images/resend_all.gif" alt="'.$this->lang('resend_all').'" title="'.$this->lang('resend_all').'" class="systemicon" />';
$continue_archive = '<img src="'.$gCms->config['root_url'].'/modules/FEUMailer/images/continue.gif" alt="'.$this->lang('continue_archive').'" title="'.$this->lang('continue_archive').'" class="systemicon" />';
$continue_tmp = '<img src="'.$gCms->config['root_url'].'/modules/FEUMailer/images/continue.gif" alt="'.$this->lang('continue_tmp').'" title="'.$this->lang('continue_tmp').'" class="systemicon" />';
$resend_errors = '<img src="'.$gCms->config['root_url'].'/modules/FEUMailer/images/resend_errors.gif" alt="'.$this->lang('resend_errors').'" title="'.$this->lang('resend_errors').'" class="systemicon" />';
$ok = $gCms->variables['admintheme']->DisplayImage('icons/system/accept.gif', '','','','systemicon');
$view_errorlogs = $gCms->variables['admintheme']->DisplayImage('icons/extra/yellow.gif', $this->lang('view_logs'),'','','systemicon');
$view_logs = $gCms->variables['admintheme']->DisplayImage('icons/system/info.gif', $this->lang('view_logs'),'','','systemicon');

$active_tab = 'archive';
if(isset($params['active_tab']))
	$active_tab = $params['active_tab'];

$errormessage = '';
if(isset($params['errormessage']))
	$errormessage .= $params['errormessage'].'<br />';

$message = '';
if(isset($params['message']))
	$message .= $params['message'].'<br />';

// get preferences
$default_groups = array();
$def_groups = explode(';',$this->GetPref('default_groups',''));
if(!empty($def_groups[0])) {
	foreach($def_groups as $def_group) {
		$dg = explode(',',$def_group);
		if(isset($dg[1]))
			$default_groups[$dg[0]]=$dg[1];
	}
}

$groups=$this->GetGroups();
if(empty($groups))
	$errormessage .= $this->lang('error_groups').'<br />';

$selected_groups = array();
foreach($groups as $k=>$v) {
	$grp_vars = explode(',',$v);
	if(isset($grp_vars[2]) && isset($default_groups[$grp_vars[0]])) {
		$selected_groups[$grp_vars[1]." (".$grp_vars[2]." ".$this->lang("users").")"] = implode(",",$grp_vars);
	}
}

// get sent mails
$old_mails = array();
$archive_mails=$this->GetArchiveMails();
foreach($archive_mails as $mail) {
		if($mail['send_date']<$db->DBTimeStamp(strtotime("-".$this->GetPref("autoclear_value",3).' '.$this->GetPref("autoclear_time",'month'))))
			$old_mails[$mail['id']]=$mail['tmp_id'];
}

// get temp mails (only exists if there where errors when a mail was send)
$old_tmpmails = array();
$tmp_mails=$this->GetTempMails();
foreach($tmp_mails as $mail) {
		if($mail['send_date']<$db->DBTimeStamp(strtotime("-".$this->GetPref("autoclear_value",3).' '.$this->GetPref("autoclear_time",'month'))))
			$old_tmpmails[$mail['id']]=$mail['log_archive_id'];
}

// get logs
$rowclass = 'row1';
$logs=array();
$logs_array = $this->GetLogs();
foreach($logs_array as $row) {
	$onerow = new stdClass();
	$onerow->selected = $this->CreateInputCheckbox($id,'log-'.($row['tmp_id']>0?$row['tmp_id']:0).'-'.($row['archive_id']>0?$row['archive_id']:0),
								$row['tmp_id'].'-'.$row['archive_id'],'','class="logs"');
	
	$onerow->view = '&nbsp;';
	if($row['log_error']==0) {
		$onerow->view = $this->CreateLink($id,'viewLogs',$returnid,$view_logs,
														array('active_tab'=>'log','tmp_id'=>$row['tmp_id'],
															'archive_id'=>$row['archive_id']));
	} else {
		$onerow->view = $this->CreateLink($id,'viewLogs',$returnid,$view_errorlogs,
														array('active_tab'=>'log','tmp_id'=>$row['tmp_id'],
															'archive_id'=>$row['archive_id']));
	}

	$onerow->delete = $this->CreateLink($id,'clearLogs',$returnid,$delete,
														array('active_tab'=>'log','tmp_id'=>$row['tmp_id'],
															'archive_id'=>$row['archive_id']),
														$this->lang('deletelogconfirm'));
	if(!empty($row['subject']))
		$onerow->subject 	= $row['subject'];
	else
		$onerow->subject 	= $this->lang('nosubject');
	$onerow->sentby 	= $row['username'];
	$onerow->send_date 	= $row['send_date'];

	$row_groups = array();
	$grps = explode(';',$row['recipient_groups']);
	if(!empty($grps[0])) {
		foreach($grps as $grp) {
			$g = explode(',',$grp);
			if(isset($g[1])) {
				$row_groups[$g[0]] = $g[1];
			}
		}
	}
	$onerow->recipient_groups = implode("<br />",$row_groups);

	$onerow->rowclass = $rowclass;
	$rowclass = ($rowclass=='row1'?'row2':'row1');
	
	$logs[] = $onerow;
}


// delete old mails
if($this->GetPref("autoclear_archivemails",true)==true) {

	$query = "DELETE FROM ".cms_db_prefix()."module_feumailer_archive 
				WHERE send_date<". $db->DBTimeStamp(strtotime("-".$this->GetPref("autoclear_value",3).' '.$this->GetPref("autoclear_time",'month')));
	$dbresult = $db->Execute($query);

	if($this->GetPref("autoclear_logs",false)==true) {
		$where = array();
		$query = "DELETE FROM ".cms_db_prefix()."module_feumailer_logs";
		foreach($old_mails as $old_id=>$old_tmpid) {
			if(!isset($tmp_mails[$old_tmpid]))
				$where[] = "archive_id=". $old_id;
				unset($archive_mails[$old_id]);
		}

		if(count($where )) {
			$query .= " WHERE " . implode(" OR ",$where);
			$dbresult = $db->Execute($query);
		}
	}

	if($this->GetPref("autoclear_tmpmails",true)==true) {
		$query = "DELETE FROM ".cms_db_prefix()."module_feumailer_tmp 
					WHERE send_date<". $db->DBTimeStamp(strtotime("-".$this->GetPref("autoclear_value",3).' '.$this->GetPref("autoclear_time",'month')));
		$dbresult = $db->Execute($query);

		if($this->GetPref("autoclear_logs",false)==true) {
			$where = array();
			$query = "DELETE FROM ".cms_db_prefix()."module_feumailer_logs";
			foreach($old_tmpmails as $old_tmpid=>$old_id) {
				if(!isset($archive_mails[$old_id]))
					$where[] = "tmp_id=". $old_tmpid;
					unset($tmp_mails[$old_tmpid]);
			}

			if(count($where )) {
				$query .= " WHERE " . implode(" OR ",$where);
				$dbresult = $db->Execute($query);
			}
		}
	}
}

// prepare array of archive mails to assign to smarty
$archive_mails_array = array();
$rowclass = 'row1';
foreach($archive_mails as $archive_mail) {

	// check if archive_mail shares log with tmp_mail
	if(isset($tmp_mails[$archive_mail['tmp_id']]) 
	&& $tmp_mails[$archive_mail['tmp_id']]['archive_id']==$archive_mail['id'])
		$clear_log = false;
	else
		$clear_log = true;
	
	$onerow = new stdClass();
	$onerow->selected = $this->CreateInputCheckbox($id,'mail-'.$archive_mail['id'],
						$archive_mail['id'].'-'.$clear_log,'','class="archive"');

	$onerow->send_date = $archive_mail['send_date'];

	if(!empty($archive_mail['subject'])) {
		$subject = $archive_mail['subject'];
	} else {
		$subject = $this->lang('nosubject');
	}
	$onerow->subject =  $this->CreateLink($id,'readMail',$returnid,$subject,
												array('mail_type'=>'archive',
														'mail_id'=>$archive_mail['id'],
														'clear_log'=>$clear_log),
										'',false,'',
										'title="'.$this->lang('read').'"');

	$row_groups = array();
	$grps = explode(';',$archive_mail['recipient_groups']);
	if(!empty($grps[0])) {
		foreach($grps as $grp) {
			$g = explode(',',$grp);
			if(isset($g[1])) {
				$row_groups[$g[0]] = $g[1];
			}
		}
	}
	
	$onerow->recipient_groups = implode("<br />",$row_groups);
	$groups_confirm = str_replace("<br />","\\n",$onerow->recipient_groups);
	$onerow->total_users = count($this->GetUsers($row_groups));
	$onerow->processed_users = $archive_mail['processed_users'];
	$onerow->recipients = $archive_mail['recipients'];
	
	$remaining = ($onerow->total_users - $onerow->processed_users);
	
	if($remaining<0)
		$remaining=0;
	
	$onerow->sentby = $archive_mail['sentby'];
	$onerow->read_mail =  $this->CreateLink($id,'readMail',$returnid, $read,
													array('mail_type'=>'archive',
														'clear_log'=>$clear_log,
														'mail_id'=>$archive_mail['id']));

	if(!empty($groups)) {
		$onerow->edit =  $this->CreateLink($id,'editMail',$returnid, $edit,
													array('mail_type'=>'archive',
														'clear_log'=>$clear_log,
														'mail_id'=>$archive_mail['id']));

		$onerow->resend_all = $this->CreateLink($id,'prepareSendMail',$returnid,$resend_all,
														array('task'=>'all',
															'mail_type'=>'archive',
															'clear_log'=>$clear_log,
															'mail_id'=>$archive_mail['id']),
												$this->lang('resendallarchiveconfirm_full',
																$groups_confirm,
																$onerow->total_users),false,false,'target="_blank"');
	
		if($remaining>0) { 
			$onerow->resend_new = $this->CreateLink($id,'prepareSendMail',$returnid,$continue_archive,
															array('task'=>'continue',
																'mail_type'=>'archive',
																'clear_log'=>$clear_log,
																'mail_id'=>$archive_mail['id']),
													$this->lang('resendnewarchiveconfirm_full',
																$groups_confirm,
																$onerow->total_users,
																$onerow->processed_users,
																$onerow->recipients,
																($onerow->total_users - $onerow->processed_users)),false,false,'target="_blank"');
		}
	}
	$onerow->delete =  $this->CreateLink($id,'deleteMail',$returnid,$delete,
												array('mail_type'=>'archive',
														'mail_id'=>$archive_mail['id'],
														'clear_log'=>$clear_log),
											$this->lang('deletearchiveconfirm'));

	$onerow->view_logs = '&nbsp;';
	if($archive_mail['errorcode']==0 && $archive_mail['logs']==true) {
		$onerow->view_logs =  $this->CreateLink($id,'viewLogs',$returnid,$view_logs,
													array('mail_type'=>'archive',
														'clear_log'=>$clear_log,
														'archive_id'=>$archive_mail['id']));

	} else if ($archive_mail['errorcode']==1 && $archive_mail['logs']==true) {
		if(!empty($groups)) {
			$onerow->resend_error = $this->CreateLink($id,'prepareSendMail',$returnid,$resend_errors,
													array('task'=>'error',
														'mail_type'=>'archive',
														'clear_log'=>$clear_log,
														'mail_id'=>$archive_mail['id']),
											$this->lang('resenderrorarchiveconfirm_full',
														$groups_confirm,
														$onerow->total_users,
														$onerow->processed_users,
														$onerow->recipients,
														($onerow->processed_users - intval($onerow->recipients))),false,false,'target="_blank"');
		}
		
		$onerow->view_logs =  $this->CreateLink($id,'viewLogs',$returnid,$view_errorlogs,
														array('mail_type'=>'archive',
															'clear_log'=>$clear_log,
															'archive_id'=>$archive_mail['id']));
	}

	$onerow->rowclass = $rowclass;
	$rowclass = ($rowclass=='row1'?'row2':'row1');

	$archive_mails_array[]=$onerow;
}

// prepare array of temp mails to assign to smarty
$tmp_mails_array=array();
$rowclass = 'row1';
foreach($tmp_mails as $tmp_mail) {

	// if mail shares log with tmp...
	// (should never happen unless the script is interupted after sending
	// process is completed but before tmp mail could be deleted)
	if(isset($archive_mails[$tmp_mail['archive_id']]) 
	&& $archive_mails[$tmp_mail['archive_id']]['tmp_id']==$tmp_mail['id'])
		$clear_log = false;
	else
		$clear_log = true;

	$onerow = new stdClass();
	$onerow->selected = $this->CreateInputCheckbox($id,'mail-'.$tmp_mail['id'],
								$tmp_mail['id'].'-'.$clear_log,'','class="tmp"');
		
	$onerow->send_date = $tmp_mail['send_date'];

	if(!empty($tmp_mail['subject'])) {
		$subject = $tmp_mail['subject'];
	} else {
		$subject = $this->lang('nosubject');
	}
	$onerow->subject =  $this->CreateLink($id,'readMail',$returnid,$subject,
														array('mail_type'=>'tmp',
														'clear_log'=>$clear_log,
														'mail_id'=>$tmp_mail['id']),
										'',false,'',
										'title="'.$this->lang('read').'"');

	$row_groups = array();
	$grps = explode(';',$tmp_mail['recipient_groups']);
	if(!empty($grps[0])) {
		foreach($grps as $grp) {
			$g = explode(',',$grp);
			if(isset($g[1])) {
				$row_groups[$g[0]] = $g[1];
			}
		}
	}
	
	$onerow->recipient_groups = implode("<br />",$row_groups);
	$groups_confirm = str_replace("<br />","\\n",$onerow->recipient_groups);
	
	if($tmp_mail['task']=='error')
		$onerow->total_users = count($this->GetUsersErrors($tmp_mail['a_id'],0,0,'>=',$row_groups));
	else
		$onerow->total_users = count($this->GetUsers($row_groups));

	$onerow->processed_users = $tmp_mail['processed_users'];
	$onerow->recipients = $tmp_mail['recipients'];
	
	$remaining = ($onerow->total_users - $onerow->processed_users);
	if($remaining<0)
		$remaining=0;
	
	$onerow->sentby = $tmp_mail['sentby'];
	$onerow->read_mail = $this->CreateLink($id,'readMail',$returnid,$read,
													array('mail_type'=>'tmp',
														'clear_log'=>$clear_log,
														'mail_id'=>$tmp_mail['id']));

	if(!empty($groups)) {
		
		if($remaining>0) {

			$onerow->resend_new = $this->CreateLink($id,'prepareSendMail',$returnid,$continue_tmp,
															array('task'=>'continue',
																'mail_type'=>'tmp',
																'clear_log'=>$clear_log,
																'mail_id'=>$tmp_mail['id']),
													$this->lang('resendnewtmpconfirm_full',
																$groups_confirm,
																$onerow->total_users,
																$onerow->processed_users,
																$onerow->recipients,
																($onerow->total_users - $onerow->processed_users)),false,false,'target="_blank"');
		}
		
	}

	$onerow->delete = $this->CreateLink($id,'deleteMail',$returnid,	$delete,
												array('mail_type'=>'tmp',
														'mail_id'=>$tmp_mail['id'],
														'clear_log'=>$clear_log),
												$this->lang('deletetempconfirm'));

	$onerow->view_logs = '&nbsp;';
	if($tmp_mail['errorcode']==0 && $tmp_mail['logs']==true) {
		$onerow->view_logs =  $this->CreateLink($id,'viewLogs',$returnid,$view_logs,
													array('active_tab'=>'tmp',
														'mail_type'=>'tmp',
														'clear_log'=>$clear_log,
														'archive_id'=>$tmp_mail['archive_id'],
														'tmp_id'=>$tmp_mail['id']));
														
	} else if($tmp_mail['errorcode']==1 && $tmp_mail['logs']==true){
		
		$onerow->view_logs =  $this->CreateLink($id,'viewLogs',$returnid,$view_errorlogs,
													array('mail_type'=>'tmp',
														'clear_log'=>$clear_log,
														'archive_id'=>$tmp_mail['archive_id'],
														'tmp_id'=>$tmp_mail['id']));
	}

	$onerow->rowclass = $rowclass;
	$rowclass = ($rowclass=='row1'?'row2':'row1');

	$tmp_mails_array[]=$onerow;
}

// if there are temp mails show errormessage
if(!empty($tmp_mails_array)) {
	$errormessage .= $this->lang('error_tmpmails').'<br />';
} else if($active_tab=='tmp') {
	$active_tab='archive';
} else if ($active_tab=='log' && empty($logs)) {
	$active_tab='archive';
}


// smarty stuff
// TabHeaders
$this->smarty->assign('startTabHeaders',$this->StartTabHeaders());
$this->smarty->assign('endTabHeaders',$this->EndTabHeaders());
$this->smarty->assign('archive',$this->SetTabHeader('archive',$this->lang('archive'),
													($active_tab=='archive'?true:'')));
						
$this->smarty->assign('temp',$this->SetTabHeader('temp',$this->lang('temp'),
													($active_tab=='tmp'?true:'')));
$this->smarty->assign('pref',$this->SetTabHeader('pref',$this->lang('pref'),
													($active_tab=='pref'?true:'')));
$this->smarty->assign('log',$this->SetTabHeader('log',$this->lang('logs'),
													($active_tab=='log'?true:'')));

// the tabs
$this->smarty->assign('startMailsTab',$this->StartTab('archive'));
$this->smarty->assign('startTempsTab',$this->StartTab('temp'));
$this->smarty->assign('startPrefsTab',$this->StartTab('pref'));
$this->smarty->assign('startLogsTab',$this->StartTab('log'));
$this->smarty->assign('startTabContent',$this->StartTabContent());
$this->smarty->assign('endTabContent',$this->EndTabContent());
$this->smarty->assign('endTab',$this->EndTab());

// forms stuff
$this->smarty->assign('startMailsForm',$this->CreateFormStart($id,'multiAction',
												$returnid,'post','','','',
												array('mail_type'=>'archive')));

$this->smarty->assign('startTempsForm',$this->CreateFormStart($id,'multiAction',
												$returnid,'post','','','',
												array('mail_type'=>'tmp')));

$this->smarty->assign('startPrefsForm',
							$this->CreateFormStart($id,'savePrefs',$returnid));

$this->smarty->assign('startLogsForm',
							$this->CreateFormStart($id,'clearLogs',$returnid));
			
$this->smarty->assign('endForm',$this->CreateFormEnd());
$this->smarty->assign('delete_selected_archive',
									$this->CreateInputSubmit($id,'submit_archive',
											$this->lang('deleteselected'),'',
											'',$this->lang('deleteconfirm')));

$this->smarty->assign('delete_selected_tmp',
			$this->CreateInputSubmit($id,'submit_tmp',$this->lang('deleteselected'),
											'','',$this->lang('deleteconfirm')));

$this->smarty->assign('delete_selected_logs',
			$this->CreateInputSubmit($id,'submit_log',$this->lang('deleteselectedlog'),
											'','',$this->lang('deletelogconfirm')));

$this->smarty->assign('submit_prefs',
			$this->CreateInputSubmit($id,'submit_prefs',$this->lang('submit')));

// general stuff
$this->smarty->assign('date_text',$this->lang('date'));
$this->smarty->assign('subject_text',$this->lang('subject'));
$this->smarty->assign('groups_text',$this->lang('groups'));
$this->smarty->assign('recipients_text',$this->lang('recipients'));
$this->smarty->assign('readmail_text',$this->lang('read'));
$this->smarty->assign('edit_text',$this->lang('edit'));
$this->smarty->assign('logs_text',$this->lang('logs'));
$this->smarty->assign('resend_text',$this->lang('resend'));
$this->smarty->assign('delete_text',$this->lang('delete'));
$this->smarty->assign('processedusers_text',$this->lang('processedusers'));
$this->smarty->assign('totalusers_text',$this->lang('totalusers'));
$this->smarty->assign('resendall_text',$this->lang('resend_all'));
$this->smarty->assign('resendnewarchive_text',$this->lang('continue_archive'));
$this->smarty->assign('resendnewtmp_text',$this->lang('continue_tmp'));
$this->smarty->assign('resenderrors_text',$this->lang('resend_errors'));
$this->smarty->assign('sentby_text',$this->lang('sentby'));

// mailsTab
$this->smarty->assign_by_ref('mails',$archive_mails_array);
$this->smarty->assign('mailscount',count($archive_mails_array));
$this->smarty->assign('nomails',$this->lang('nomails'));
if(!empty($groups)) {
	$this->smarty->assign('newmail',$this->CreateLink($id,'newMail',$returnid,
											$new.'&nbsp;'.$this->lang('newmail')));
}

$this->smarty->assign('selectall_archive',
							$this->CreateInputCheckbox($id,'archive',true,false,
									'id="archive" onclick="selectAll(this)"'));

// tempmailsTab
$this->smarty->assign_by_ref('tempmails',$tmp_mails_array);
$this->smarty->assign('tempmailscount',count($tmp_mails_array));
$this->smarty->assign('notempmails',$this->lang('notempmails'));
$this->smarty->assign('selectall_tmp',
							$this->CreateInputCheckbox($id,'tmp',true,false,
										'id="tmp" onclick="selectAll(this)"'));

// prefsTab
$this->smarty->assign('autosave_text',$this->lang('autosave'));
$this->smarty->assign('autosave_input',$this->CreateInputCheckbox($id,
						'autosave',1,($this->GetPref("autosave",true)==1?1:'')));

$this->smarty->assign('autoclear_archivemails_text',$this->lang('autoclear_archivemails'));
$this->smarty->assign('autoclear_archivemails_input',
	$this->CreateInputCheckbox($id,'autoclear_archivemails',1, 
									($this->GetPref("autoclear_archivemails",true)==true?1:''),
									'onclick="toggleActive(\'autoclear\')"'));
									
$this->smarty->assign('autoclear_style',($this->GetPref("autoclear_archivemails",true)==1?
				'style="display:block;visibility:visible"':
				'style="display:none;visibility:collapse" disabled="disabled"'));

$this->smarty->assign('autoclear_action_text',$this->lang('autoclear_action'));
$this->smarty->assign('autoclear_value_input',$this->CreateInputText($id,
									'autoclear_value',$this->GetPref("autoclear_value",3),3,5));

$autoclear_times = array();
$autoclear_times[$this->lang('days')] = 'day';
$autoclear_times[$this->lang('weeks')] = 'week';
$autoclear_times[$this->lang('months')] = 'month';
$autoclear_times[$this->lang('years')] = 'year';
$this->smarty->assign('autoclear_time_input',
							$this->CreateInputDropdown($id,'autoclear_time',
										$autoclear_times,'',$this->GetPref("autoclear_time",'month')));

$this->smarty->assign('autoclear_tmpmails_text',$this->lang('autoclear_tmpmails'));
$this->smarty->assign('autoclear_tmpmails_input',$this->CreateInputCheckbox($id,
				'autoclear_tmpmails',1,($this->GetPref("autoclear_tmpmails",true)==true?1:'')));

// LOGS
$this->smarty->assign('savelogs_text',$this->lang('save_logs'));
$this->smarty->assign('savelogs_input',
	$this->CreateInputCheckbox($id,'save_logs',1,
									($this->GetPref("save_logs",true)==true?1:''),
									'onclick="toggleActive(\'save_logs\')"'));
$this->smarty->assign('savelogs_style',($this->GetPref("save_logs",true)==true?
													'style="display:block;
															visibility:visible"':
													'style="display:none;
															visibility:collapse" 
															disabled="disabled"'));

$this->smarty->assign('save_errorlogs_only_text',
											$this->lang('save_errorlogs_only'));
$this->smarty->assign('save_errorlogs_only_input',
			$this->CreateInputCheckbox($id,'save_errorlogs_only',1,
				($this->GetPref("save_errorlogs_only",true)==true?1:'')));

$this->smarty->assign('autoclear_logs_text',
											$this->lang('autoclear_logs'));
$this->smarty->assign('autoclear_logs_input',
			$this->CreateInputCheckbox($id,'autoclear_logs',1,
							($this->GetPref("autoclear_logs",false)==1?1:'')));

$this->smarty->assign('default_groups_text',$this->lang('default_groups'));

if(!empty($groups)) {
	$this->smarty->assign('default_groups_input',
			$this->CreateInputSelectList($id,'default_groups[]',
									$groups,$selected_groups,count($groups),'',1));
} else {
	$this->smarty->assign('default_groups_input',$this->lang('error_groups'));
}

$this->smarty->assign('is_html_text',$this->lang('is_html'));
$this->smarty->assign('is_html_input',$this->CreateInputCheckbox($id,
							'is_html',1,($this->GetPref("is_html",false) && $this->GetPref("is_html",false)==true?1:'')));

$this->smarty->assign('maxmails_text',$this->lang('maxmails'));
$this->smarty->assign('maxmails_input',$this->CreateInputText($id,
											'maxmails',$this->GetPref("maxmails",50),3,6));

$this->smarty->assign('request_delay_text',$this->lang('request_delay'));
$this->smarty->assign('request_delay_input',$this->CreateInputText($id,
	'request_delay',($this->GetPref("request_delay",'')==0?'':$this->GetPref("request_delay",'')),5,5));

$this->smarty->assign('random_delay_text',$this->lang('random_delay'));
$this->smarty->assign('random_delay_input',$this->CreateInputCheckbox($id,
	'random_delay',1,($this->GetPref("random_delay",false) && $this->GetPref("random_delay",false)==true?1:'')));

$this->smarty->assign('selectall_logs',
							$this->CreateInputCheckbox($id,'logs',true,false,
										'id="logs" onclick="selectAll(this)"'));

$this->smarty->assign_by_ref('logs',$logs);
$this->smarty->assign_by_ref('view_text',$this->lang('view'));
$this->smarty->assign('logs_count',count($logs));
$this->smarty->assign('heading',$this->lang('adminpanel'));

if($errormessage!='')
	$this->smarty->assign('errormessage',$errormessage);

if($message!='')
	$this->smarty->assign('message',$ok.'&nbsp;'.$message);

// Display the populated template
echo $this->ProcessTemplate('adminpanel.tpl');

?>