<?php

	/*
	 ZipperObject class: Implement some features for a Zipper manipulation
	
	 author: Jean-Christophe Cuvelier - jcc@morris-chapman.com
	 copyrights: Jean-Christophe Cuvelier - Morris & Chapman - 2010
	 GPL License
	
	*/
	
	class ZipperObject extends CmsObject
	{
		var $package = array();
		var $filename;
		var $checksum;
		var $destination;
		
		const UPLOAD_PATH = '/Modules/Zipper';
		
		public function getFilename()
		{
			if (empty($this->filename))
			{				
					$this->filename = 'Zipper-'. time() . '.zip';
			}
			
			return $this->filename;
		}
		
		public function setFilename($value)
		{
			$this->filename = $value;
		}
		
		public function getDestination()
		{
			return self::getUploadsPath() . DIRECTORY_SEPARATOR . $this->getFilename();
		}
		
		public function addFile($filename, $path='/')
		{
			$path = self::checkZipPath($path);
			$file = $this->checkFile($filename);
			
			if ($file)
			{
				$package[$path][] = array(
					'file' => $file, 
					'stat' => array_values((array)stat($file))
					);
			}
			else
			{
				return false;
			}
		}
		
		public static function checkZipPath($path)
		{
			if (strpos($path, '/') != 0)
			{
				$path = '/' . $path;
			}
			
			if (strpos(strrev($path), '/') != 0)
			{
				$path .= '/';
			}
			
			return $path;
		}
		
		public function checkFile($filename)
		{
			$config =& $this->getConfig();
			
			if (is_file($filename))
			{
				return $filename;
			}
			elseif(is_file($config['uploads_path'] . DIRECTORY_SEPARATOR . $filename))
			{							
				return $config['uploads_path'] . DIRECTORY_SEPARATOR . $filename;
			}
			elseif(is_file($config['root_path'] . DIRECTORY_SEPARATOR . $filename))
			{							
				return $config['root_path'] . DIRECTORY_SEPARATOR . $filename;
			}
			else
			{
				return false;
			}
			
		}
		
		public static function getUploadsPath()
		{
			$instance = new self(); // Workaround to get the config...
			$config =& $instance->getConfig(); // $config['uploads_path']
			$zipper_path = $config['uploads_path'] . self::UPLOAD_PATH;
			
			if (!is_dir($zipper_path))
			{
					mkdir($zipper_path, 0777, true);
			}
			
			return $zipper_path;
		}

		public static function getUploadsUrl()
		{
				$instance = new self(); // Workaround to get the config...
				$config =& $instance->getConfig(); // $config['uploads_path']
				return $config['uploads_url'] . self::UPLOAD_PATH;
		}
		
		public static function dirToArray($directory, $recursive = true, $path = '/')
		{
			$dir = scandir($directory);
			$array = array();

			foreach($dir as $atom)
			{
				if ($atom != '.' && $atom != '..')
				{
					if (is_file($directory . DIRECTORY_SEPARATOR . $atom))
					{
						$array[$path][] = $directory . DIRECTORY_SEPARATOR . $atom;
					}
					elseif (is_dir($directory . DIRECTORY_SEPARATOR . $atom) && $recursive == true)
					{
							$array = array_merge($array, self::dirToArray(
							$directory . DIRECTORY_SEPARATOR . $atom, 
						  $recursive, 
						  $path . $atom . DIRECTORY_SEPARATOR
							));
					}
				}
			}
			return $array;
		}
		
		public static function directoryToPackage($directory,$recursive = true, $path = '/')
		{
			$dir = scandir($directory);
			$array = array();

			
			foreach($dir as $atom)
			{
				if ($atom != '.' && $atom != '..' && (strpos($atom, '.') === false || strpos($atom, '.') != 0))
				{
					if (is_file($directory . DIRECTORY_SEPARATOR . $atom))
					{
						$stat = stat($directory . DIRECTORY_SEPARATOR . $atom);
						$array[$path][] = array('file' => $directory . DIRECTORY_SEPARATOR . $atom, 'stat' => array(
							'size' => $stat['size'],
							'mtime' => $stat['mtime']
							));
					}
					elseif (is_dir($directory . DIRECTORY_SEPARATOR . $atom) && $recursive == true)
					{						
							$array = array_merge($array, self::directoryToPackage(
							$directory . DIRECTORY_SEPARATOR . $atom, 
						  $recursive, 
						  $path . $atom . DIRECTORY_SEPARATOR
							));
					}
				}
			}
				
			return $array;
		}
		
		public function sortPackage()
		{
			ksort($this->package);
		}
		
		public function ZipPackage()
		{
			if (count($this->package) > 0)
			{
				$zip = new ZipArchive();
				if (is_file($this->getDestination())) unlink($this->getDestination());
				if ($zip->open($this->getDestination(), ZIPARCHIVE::CREATE) === TRUE)
				{				
					foreach($this->package as $path => $subfiles)
					{
						foreach ($subfiles as $file)
						{
							if (is_file($file['file']))
							{
								$zip->addFile($file['file'], $path . basename($file['file']));
							}
						}	
					}
					$zip->close();
					
					// Create checksum
					
					$this->saveChecksum();
					
					return true;
				}
			}
			
			return false;
		}
		
		public function hasChanged($show_diff = false)
		{
			$old_checksum = $this->retrieveChecksum();
			$new_checksum = $this->getChecksum();
			
			if ($old_checksum != $new_checksum)
			{
				if ($show_diff)
				{
					echo '<pre>';
					var_dump(array_diff(
						unserialize(base64_decode($old_checksum)),
						unserialize(base64_decode($new_checksum))
					));
					
				
									
					$ch2 = unserialize(base64_decode($old_checksum));
					$ch1 = unserialize(base64_decode($new_checksum));
					
					foreach($ch1['package'] as $path => $files)
					{
						foreach ($files as $key => $file)
						{
							$array_diff = array_diff($file['stat'], $ch2['package'][$path][$key]['stat']);
							if (count($array_diff) >0)
							{
								var_dump($file['file']);
								var_dump($ch2['package'][$path][$key]['file']);
								var_dump($array_diff);
							}
							// var_dump();
						}
					}
									
					
					echo '</pre>';
				}
				
				return true; // TRUE: Changes have been made between the zip creation and this package !
			}
			else
			{
				return false; // FALSE: The checksum are the same ! No changes done between package and zip content !
			}
		}
		
		public function generatePackageChecksum()
		{	
			//$this->sortPackage();
			$this->checksum = base64_encode(serialize(array(
				'destination' => $this->getDestination(), 
				'package' => $this->package
				)));
		}
		
		public function getChecksum($force = false)
		{
			if (empty($this->checksum) || $force)
			{
				$this->generatePackageChecksum();
			}
			return $this->checksum;
		}
		
		public function saveChecksum()
		{
			file_put_contents($this->getDestination() . '.checksum', $this->getChecksum());
		}
		
		public function retrieveChecksum()
		{
			if (is_file($this->getDestination() . '.checksum'))
			{
				return file_get_contents($this->getDestination() . '.checksum');
			}
			else
			{
				return base64_encode(serialize(array()));
			}
		}
	}