<?php
  
  /*
   * Relation class
   * 
   * This class allow management of a relation object
   * 
   * 
   * Copyrights: Morris & Chapman Belgium - Jean-Christophe Cuvelier - 2009
   * 
   */

class MX_Relation extends CmsObject 
{
  // Vars

	var $id;
  var $title;
  var $modulename;
  var $rel_type;
  var $rel_id;
  var $is_visible;
  var $have_sub;
  var $position;
  var $is_filter;
  var $is_sortable;
  var $have_column;
  var $is_unique;
  
  var $relation;
  var $related_items;
  
  var $loaded = false;
	
	const DB_NAME  = 'module_modulextender_relations';

	public function __construct($id = null)
	{
		if ($id)
		{
			$this->id = $id;
			$this->load();
		}
	}
	
  public function __toString()
  {
    return $this->getTitle();
  } 
	
	public function getId()
	{
		return $this->id;
	}
	
  public function setId($value)
  {
    $this->id = $value;
  }
	
	public function getType()
	{
		return $this->rel_type;
	}
	
	 public function setType($value)
  {
    $this->rel_type = $value;
  }
  
  public function setHaveSub($value)
  {
  	$this->have_sub = $value;
  }
  
  public function getHaveSub()
  {
  	return $this->have_sub;
  }
	
  public function rotateRelationSubtype()
  {
  	$this->have_sub++;
  	
  	if ($this->have_sub > 2)
  	{
  		$this->have_sub = 0;
  	}
  }
  
  public function getRelationSubtype()
  {
  	switch ($this->have_sub)
  	{
  		case 1:
  			return 'Subpages';
  		case 2:
  			return 'Page & subpages';
  		default:
  			return ucfirst($this->getType());
  	}
  }
  
	public function getRelationId()
	{
		return $this->rel_id;
	}
	
	public function getTitle($with_original = false, $fallback_to_original = false)
	{
		if ($this->title != '')
		{
			if ($with_original)
			{
				return $this->title . ' (' . $this->getOriginalTitle() . ')';
			}
			else
			{
		    return $this->title;		
			}
		}
		else
		{
			if ($with_original || $fallback_to_original)
         {
   			 return $this->getOriginalTitle();
         }
         else 
         {
         	return null;
         }
		}		
	}
	
	public function getOriginalTitle()
	{		
		if ($this->relation)
		{
			return $this->relation->getTitle();
		}
		elseif ($this->getRelation())
		{
			return $this->relation->getTitle();
		}
		else
		{
			return null;
		}
	}
	
	public function getRelatedId()
	{
		return $this->rel_id;
	}
	
	public function setRelatedId($value)
	{
		$this->rel_id = $value;
	}
	
	protected function getRelation()
	{
		if (is_null($this->relation))
		{
			switch($this->rel_type)
			{
				case 'category':
					$this->relation = MX_Category::retrieveByPk($this->rel_id);
					break;
				case 'module':
					$this->relation = MX_XtendedModule::retrieveByPk($this->rel_id);
					break;
				case 'page':
				  $this->relation = MX_Page::retrieveByPk($this->rel_id);
				default: 
					break;
			}
		}
		
		return $this->relation;		
	}
	
	public function getRelationsIds()
	{
		$relations = $this->getRelatedItems();
		
		$relations_ids = array();
		
		foreach($relations as $relation)
		{
			$relations_ids[] = $relation->getId();
		}
		
		return $relations_ids;
	}
	public function getRelatedItems()
	{
		if (is_null($this->related_items))
		{
		  switch($this->rel_type)
	    {
	      case 'category':
	        $this->related_items = $this->relation->getOptions();
	        break;
	      case 'module': 
	        $this->related_items = $this->relation->getItems();
	        break;
	      case 'page':
	        $this->related_items =  $this->relation->getPages($this->have_sub);
	      default: 
	        break;
	    }
		}
		
		return $this->related_items;
	}
	
	public function setTitle($title)
	{
		$this->title = $title; 
	}
	
	public function getModuleName()
	{
		return $this->modulename;
	}
	
	public function setModuleName($value)
	{
		$this->modulename = $value;
	}
		 
  
  public function getIsVisible()
  {
    return $this->is_visible;
  }
  
  public function setIsVisible($value)
  {
    $this->is_visible = $value;
  }
  		
  public function getIsFilter()
  {
    return $this->is_filter;
  }
  
  public function setIsFilter($value)
  {
    $this->is_filter = $value;
  }
  
  public function getIsSortable()
  {
    return $this->is_sortable;
  }
  
  public function setIsSortable($value)
  {
    $this->is_sortable = $value;
  }
  
  public function getHaveColumn()
  {
    return $this->have_column;
  }
  
  public function setHaveColumn($value)
  {
    $this->have_column = $value;
  }
  
  public function getIsUnique()
  {
  	return $this->is_unique;
  }
  
  public function setIsUnique($value)
  {
  	$this->is_unique = $value;
  }
  
	public static function relationExists($modulename, $type, $relation_id)
	{
		if (count(self::doSelect(array('where' => array('modulename' => $modulename, 'rel_type' => $type, 'rel_id' => $relation_id)))) > 0)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
  public function getPosition()
  {
    if ($this->position != '')
    {
      return $this->position;
    }
    else
    {
      return self::retrieveNextPosition($this->modulename);
    }
  }

  public static function retrieveNextPosition($modulename)
  {
    $last_document = self::doSelectOne(array('where' => array('modulename' => $modulename), 'order_by' => array('position desc')));
    
    if ($last_document)
    {
       if ($last_document->position != NULL)
       {
          return $last_document->getPosition()+1;
       }
       else
       {
          // We are in a case there is null elements, we should reset positions
          self::resetPositions($last_document->getModulename());
          return 1; // Not 100% sure but it should be one
       }
    }
    else
    {
      return 1;
    }
  }
  
  public function getNextItem()
  {
    $document =  self::doSelectOne(array('where' => array('modulename' => $this->modulename,  'position' => $this->position+1)));
    
    if ($document)
    {
      return $document;
    }
    else 
    {
      return false;
    }
   }
   
  public function getPreviousItem()
  {
    $document =  self::doSelectOne(array('where' => array('modulename' => $this->modulename,  'position' => $this->position-1)));
    
    if ($document)
    {
      return $document;
    }
    else 
    {
      return false;
    }
   }
  
   public function moveUp()
   {
    $this->switchPosition($this->getPreviousItem());
   }
   
   public function moveDown()
   {
    $this->switchPosition($this->getNextItem());
   }
   
   protected function switchPosition($item)
   {
      if($item)
      {
        $current_position = $this->getPosition();
        $this->setPosition($item->getPosition());
        $item->setPosition($current_position);
        $this->save();
        $item->save();
      }
   }
   
  public function setPosition($position)
  {
    $this->position = $position;
  }

  public static function resetPositions($modulename)
  {
    $documents = self::doSelect(array('where' => array('modulename' => $modulename), 'order_by' => array('position asc')));
    
    $position = 1;
    
    foreach ($documents as $document)
    {
      $document->setPosition($position);
      $position = $document->getPosition() + 1;
      $document->save();
    }
    
  }

  // Public static predefined searchs
  
  /**
   * 
   * @param $module_name Module name for filters
   * @return array of MX_Relation's
   * 
   */
    
  public static function getFilters($module_name)
  {
  	return self::doSelect(array('where' => array('modulename' => $module_name, 'is_filter' => 1)));
  }
  
  public static function getColumns($module_name)
  {  	
    return self::doSelect(array('where' => array('modulename' => $module_name, 'have_column' => 1)));
  }

  // DATABASE OPERATIONS
  
	public function load()
	{
		
    $db =& $this->GetDb();
    
		$query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME . ' WHERE id = ? LIMIT 1';
		
		$dbresult = $db->Execute($query, array($this->id));
		
	   if ($dbresult && $dbresult->RecordCount() > 0)
      {
      	$this->loaded = true;
        while ($dbresult && $row = $dbresult->FetchRow())
        {
          $this->PopulateFromDb($row);
          $this->PerformPostLoadingActions();
        }
      }
	}
	
	public function PopulateFromDb($row)
	{
		  $this->id = $row['id'];
		  $this->title = $row['title'];
		  $this->modulename = $row['modulename'];
		  $this->rel_type = $row['rel_type'];
		  $this->rel_id = $row['rel_id'];
		  $this->is_visible = $row['is_visible'];
		  $this->have_sub = $row['have_sub'];
		  $this->position = $row['position'];
		  $this->is_filter = $row['is_filter'];
		  $this->is_sortable = $row['is_sortable'];
		  $this->have_column = $row['have_column'];
		  $this->is_unique = $row['is_unique'];
	}
	
	protected function PerformPostLoadingActions()
	{
		$this->getRelation();
	}
	
  public function save()
  {
    // Upgrade or Insert ?
    if ($this->id != null)
    {
      $this->update();
    }
    else 
    {     
        $this->insert();
    }   
    
  }
  
  protected function update()
  {
    
    $db =& $this->GetDb();
    

      $query = 'UPDATE  ' . cms_db_prefix() .  self::DB_NAME . ' 
      
      SET ';
            
      $query .= ' title = ?,  modulename = ?,  rel_type = ?,  rel_id = ?,  is_visible = ?,  have_sub = ?, position = ?, is_filter = ?, is_sortable = ?, have_column = ?, is_unique = ?';
      
      $query .= '
      
      WHERE
      
      id = ?  ';
      
      
      $result = $db->Execute($query,
          array(
             $this->title,
             $this->modulename,
             $this->rel_type,
             $this->rel_id,
             $this->is_visible,
             $this->have_sub,
             $this->getPosition(),
             $this->getIsFilter(),
             $this->getIsSortable(),
             $this->getHaveColumn(),
             $this->getIsUnique(),
             $this->getId()
          )
        );        
        
        /*FIXME: Test the $db status; */
        
        return true;
  }
  
  protected function insert()
  {
    $db =& $this->GetDb();
    
    $this->setId($db->GenID(cms_db_prefix() .  self::DB_NAME .'_seq' ));
      
    $query = 'INSERT INTO ' . cms_db_prefix() .  self::DB_NAME .  ' 
      
      SET  id = ?,  ';

      $query .= ' title = ?,  modulename = ?,  rel_type = ?,  rel_id = ?,  is_visible = ?,  have_sub = ?, position = ?, is_filter = ?, is_sortable = ?, have_column = ?, is_unique = ?';
      
      
       $db->Execute($query,
          array(
            $this->getId(), 
             $this->title,
             $this->modulename,
             $this->rel_type,
             $this->rel_id,
             $this->is_visible,
             $this->have_sub,
             $this->getPosition(),
             $this->getIsFilter(),
             $this->getIsSortable(),
             $this->getHaveColumn(),
             $this->getIsUnique(),
          )
        );
        
        return true;    
  }
  
  public function isLoaded()
  {
  	return $this->loaded;
  }
   
  public static function retrieveByPk($id)
  {
    return self::doSelectOne(array('where' => array('id' => $id)));    
  }
  
  public static function doSelectOne($params = array())
  {
    $items = self::doSelect($params);
    if ($items)
    {
      return $items[0];
    }
    else 
    {
      return null;
    }   
  }
  
  public static function doSelect($params = array())
  {
    $instance = new self();
    
    
    $db =& $instance->GetDb();
    
    $query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME;;
    
    $values = array();
    
    if (isset($params['where']))
    {

      $fields = array();
      foreach ($params['where'] as $field => $value) 
      {
        $fields[] = $field . ' =  ?';
        $values[] = $value;
      }
      
      $query .= ' WHERE ' . implode(' AND ', $fields);
    } 
    
    if(isset($params['order_by']))
    {
     $query .= ' ORDER BY ' . implode(', ' , $params['order_by']);
    }
    else
    {
    	$query .= ' ORDER BY position';
    }
    
    $dbresult = $db->Execute($query, $values);
  
    $items = array();
   if ($dbresult && $dbresult->RecordCount() > 0)
    {
      while ($dbresult && $row = $dbresult->FetchRow())
      {
        $item = new self();
        $item->PopulateFromDb($row);        
        $item->PerformPostLoadingActions();
        $items[] = $item;
      }
    }
    
    return  $items;   
  }
  
  public static function resetAllPositions()
  {
    $documents = self::doSelect(array('order_by' => array('modulename asc', 'position asc')));
    
    $modulename ='';
    
    foreach ($documents as $document)
    {
      if ($document->getModuleName() != $modulename )
      {
          $modulename =$document->getModuleName();
          self::resetPositions($modulename);
      }
    }
  }
  
  
    public function delete()
    {   
    
    $db =& $this->GetDb();
    $query = 'DELETE FROM '. cms_db_prefix() . self::DB_NAME;
    $query .= ' WHERE id = ?';
    $db->Execute($query, array($this->id));   

    self::resetPositions($this->getModuleName());
  }
  
}

?>