<?php
  
  /*
   * Relation class
   * 
   * This class allow management of a relation object
   * 
   * 
   * Copyrights: Morris & Chapman Belgium - Jean-Christophe Cuvelier - 2009
   * 
   */

class MX_Image extends MX_Document  
{
	var $sizes = array(	
      'thumbnails' => array('width'=>100  , 'height'=>100) 
    , 'thumbnail' => array('width'=>100  , 'height'=>100) 
    , 'low' => array('width'=>170  , 'height'=>170) 
    , 'home' => array( 'width'=>187, 'height'=>187)
    , 'medium' => array( 'width'=>208, 'height'=>208)
    , 'high' => array('width'=>600, 'height'=>600)
    , 'cover' => array('width'=>57, 'height'=>80)    
    );
    
    var $original_sizes = array(	
        'thumbnails' => array('width'=>100  , 'height'=>100) 
      , 'thumbnail' => array('width'=>100  , 'height'=>100) 
      , 'low' => array('width'=>170  , 'height'=>170) 
      , 'home' => array( 'width'=>187, 'height'=>187)
      , 'medium' => array( 'width'=>208, 'height'=>208)
      , 'high' => array('width'=>600, 'height'=>600)
      , 'cover' => array('width'=>57, 'height'=>80)    
      );
    
  var $allowed_images = array (
         'image/jpeg'
        ,'image/pjpeg'
        ,'image/png'
        ,'image/gif');
	
  public function __construct($id = null)
  {
  	parent::__construct($id);	
  	$this->type = 'image';
  	
    $this->getSizes();
  }
  
  public function getSizes()
  {
    global $gCms;
  	$modulextender = $gCms->modules['ModuleXtender']['object'];  	
  	$this->sizes = unserialize($modulextender->getPreference('images_size'));
  	
  	if (!is_array($this->sizes))
  	{
  	  $this->sizes = $this->original_sizes;
  	  $modulextender->setPreference('images_size', serialize($this->original_sizes));
  	}
  	
  	$this->sizes['admin_thumbnail'] = array('width'=>100  , 'height'=>100);
  }
  
  public function getPath($prefix = null)
  {
    $path = parent::getPath($prefix) . DIRECTORY_SEPARATOR .'images';
	  	  
	  return self::CheckDirectory($path);
  }
  
  public function rename($path, $filename)
  {
  	$source = $this->getFile();
  	
  	parent::rename($path, $filename, $source);
  	foreach ($this->sizes as $size => $details)
  	{
  		parent::rename($path . DIRECTORY_SEPARATOR . $size, $filename, $source);
  	}
  }
  
  public function uploadDocument($path, $document)
  {  	        	
  	if ($this->checkImageType($document))
  	{
	  	if ($this->file != '')
	    {
	    	$this->removeDocument($path);
	    }
  		
	    if (parent::uploadDocument($path, $document))
  		{  			  			
  			// Create thumbnails
  			if ($this->buildThumbnails($path))
  			{  			  				
  				return true;
  			}
  		}	
  	}
  		
  	// If we arive here, something went wrong
  	return false; 	
  }
  
  public function buildThumbnails($path)
  {  	
  	foreach($this->sizes as $format => $size)
  	{
  		if (!$this->resizeImage($path, $format, $size['width'], $size['height']))
  		{
  			return false;
  		}
  	}
  	return true;
  }
  
  public function getThumbnailsPath($path)
  {
  	$thumbnails = array();
  	
  	foreach ($this->sizes as $format => $size)
  	{
  		$thumbnails[$format] = $path . $format . DIRECTORY_SEPARATOR . $this->file;
  	}
  	
  	return $thumbnails;  	
  }
  
  protected function resizeImage($path, $format, $width, $height)
  {
  	$original_image = $path . DIRECTORY_SEPARATOR . $this->file;
  		
  	$resized_image = self::CheckDirectory($path . DIRECTORY_SEPARATOR . $format) . DIRECTORY_SEPARATOR . $this->file;
  	
  	$properties = $this->getImageSize($original_image, $width, $height);
  	
  	if ($image_source = $this->createImage($original_image))
  	{
  		$image = imagecreatetruecolor($properties[0], $properties[1]);
  	        
  		if (
        imagecopyresampled($image, $image_source, 0, 0, 0, 0, $properties[0], $properties[1], $properties[2], $properties[3])
        &&
        imagejpeg($image, $resized_image, 100)
        )
        {
            return true;
        }

        else
        {
            return false;
        }
  	}
  	else 
  	{
  		return false;
  	}
  }
  
    protected function createImage($image)
    {
        switch(exif_imagetype($image))
        {
            case 1:
                $srcimg = imagecreatefromgif($image);
                break;
            case 2:
                $srcimg = imagecreatefromjpeg($image);
                break;
            case 3:
                $srcimg = imagecreatefrompng($image);
                break;
            default:
                return false;
        }

        return $srcimg;
    }
  
   protected function getImageSize($image, $width , $height)
   {
        $imgsize = getimagesize($image);

        if (!$imgsize)
        {
            return false;
        }

        if ($width == 0 && $height == 0)
        {
            $targetsize[0] = $imgsize[0]; // Target Height
            $targetsize[1] = $imgsize[1]; // Target Width
        }
        elseif ($width == 0 && $height != 0)
        {
            $targetsize[0] = round($height*($imgsize[0]/$imgsize[1]));
            $targetsize[1] = $height;
        }
        elseif ($width != 0 && $height == 0)
        {
            $targetsize[0] = $width;
            $targetsize[1] = round($width*($imgsize[0]/$imgsize[1]));
        }
        else
        {
            if (round($width*($imgsize[0]/$imgsize[1])) > $height)
            {
                $targetsize[0] = $height;
                $targetsize[1] = round($height*($imgsize[1]/$imgsize[0]));
            }
            else
            {
                $targetsize[0] = round($width*($imgsize[0]/$imgsize[1]));
                $targetsize[1] = $width;
            }
        }
        
        $properties = array ($targetsize[0] ,$targetsize[1] ,$imgsize[0] ,$imgsize[1]);
        
        return $properties;
    }
  
  protected function checkImageType($image)
  {
        if (in_array($image['type'], $this->allowed_images))
        {
            return true;
        }
        else
        {
        	die($image['type']);
            return false;
        }
  }
  
  protected function removeDocument($path)
  {
  	  // Remove all thumbs
      foreach ($this->sizes as $folder => $size)
      {
        $file = $path . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $this->file;
        unlink($file);
      }

      unlink($path . DIRECTORY_SEPARATOR . $this->file);
  }
  
  public function delete($path = null)
  {
     if ($path)
    {
      $this->removeDocument($path);
    }
    
    $db =& $this->GetDb();
    $query = 'DELETE FROM '. cms_db_prefix() . self::DB_NAME;
    $query .= ' WHERE id = ?';
    $db->Execute($query, array($this->id));   

    self::resetPositions($this->getModuleName(), $this->getModuleId(), $this->getType());
  }
  
}