<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
# Version: 0.3.4
# File   : method.upgrade.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if (!isset($gCms)) exit;

$current_version = $oldversion;
$db              =& $this->GetDb();

switch($current_version) {
	
	case '0.3':
	case '0.3.1':
		
		$this->RemovePermission('Approve AdvancedContent');
		$this->RemovePermission('Modify AdvancedContent Block Order');
		$this->RemovePermission('Add AdvancedContent Blocks');
		$this->RemovePermission('Delete AdvancedContent Blocks');
		$this->RemovePermission('Modify AdvancedContent Block Options');
		
		$this->RemoveEventHandler( 'Core', 'ContentEditPre');
		$this->RemoveEventHandler( 'Core', 'ContentEditPost');
		$this->RemoveEventHandler( 'Core', 'ContentDeletePost');
		$this->RemoveEventHandler( 'Core', 'EditTemplatePost');
		$this->RemoveEventHandler( 'Core', 'DeleteTemplatePost');

		$dict     = NewDataDictionary( $db );
		$sqlarray = $dict->DropTableSQL( cms_db_prefix()."module_AdvancedContent" );
		$dict->ExecuteSQLArray($sqlarray);
		
		$sqlarray = $dict->DropTableSQL( cms_db_prefix()."module_AdvancedContent_drafts" );
		$dict->ExecuteSQLArray($sqlarray);
		
		$sqlarray = $dict->DropTableSQL( cms_db_prefix()."module_AdvancedContent_props" );
		$dict->ExecuteSQLArray($sqlarray);
		
		$sqlarray = $dict->DropTableSQL( cms_db_prefix()."module_AdvancedContent_props_drafts" );
		$dict->ExecuteSQLArray($sqlarray);
		
		$sqlarray = $dict->DropTableSQL( 
			cms_db_prefix()."module_AdvancedContent_addt_editors" );
		$dict->ExecuteSQLArray($sqlarray);
		
		$sqlarray = $dict->DropTableSQL( 
			cms_db_prefix()."module_AdvancedContent_addt_editors_drafts" );
		$dict->ExecuteSQLArray($sqlarray);
		
		// get propname of all content of type AdvancedContent
		$query    = "SELECT CP.prop_name, C.content_id FROM ". cms_db_prefix()."content C 
			LEFT JOIN ".cms_db_prefix()."content_props CP ON CP.content_id = C.content_id 
			WHERE C.type = ?";
			
		$dbresult = $db->Execute($query, array('content2'));
		$contents = array();
		
		while($dbresult && $row = $dbresult->FetchRow()) {
			
			// update propnames (removing special chars, umlauts and whitespaces)
			$query = "UPDATE ".cms_db_prefix()."content_props SET prop_name = ? 
				WHERE content_id = ? AND prop_name = ?";
				
			$db->Execute($query, array(preg_replace('/-+/','_',munge_string_to_url($row['prop_name'])),$row['content_id'],$row['prop_name']));
		}
		
		$current_version = '0.3.2';
		
	case '0.3.2':
	case '0.3.3 pre':
		$this->AddEventHandler( 'Core', 'ContentPostRender', false );
		$current_version = '0.3.3';
		
	case '0.3.3':
		// remove userprefs
		$query    = "DELETE FROM ". cms_db_prefix()."userprefs WHERE preference LIKE 'AdvancedContent_%";
		$dbresult = $db->Execute($query);
		
		// add new table for user prefs
		$taboptarray = array('mysql' => 'TYPE=MyISAM');
		$dict = NewDataDictionary($db);
		$flds = "user_id I, content_id I, block_id X, block_display I";
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_AdvancedContent_blockdisplay", 
			$flds, $taboptarray);
		$dict->ExecuteSQLArray($sqlarray);
		
		$current_version = '0.3.4';
		
	default: 
		$current_version = $this->GetVersion();
		break;
}

?>
