<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
# Version: 0.3.4
# File   : method.uninstall.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if (!isset($gCms)) exit;

$db       =& $this->GetDb();
$dict     = NewDataDictionary( $db );
$sqlarray = $dict->DropTableSQL( cms_db_prefix()."module_AdvancedContent_blockdisplay" );
$dict->ExecuteSQLArray($sqlarray);

if($this->GetPreference('uninstall_action') != '') {
	switch($this->GetPreference('uninstall_action')) {
		case 1:
			// Delete
			// get id of all content of type AdvancedContent
			$query    = "SELECT content_id FROM ". cms_db_prefix()."content WHERE type = ?";
			$dbresult = $db->Execute($query, array('content2'));
			$contents = array();
			while($dbresult && $row = $dbresult->FetchRow()) {
				$contents[] = $row['content_id'];
			}
			// delete all content of type AdvancedContent
			$query    = "DELETE FROM ". cms_db_prefix()."content WHERE type = ?";
			$dbresult = $db->Execute($query, array('content2'));
			
			// delete content props
			$query    = "DELETE FROM ". cms_db_prefix()."content_props WHERE content_id IN (".implode(',',$contents).")";
			$dbresult = $db->Execute($query);
			
			break;
			
		case 2:
			// Set to content
			$query    = "UPDATE ".cms_db_prefix()."content SET type = ? WHERE type = ?";
			$dbresult = $db->Execute($query, array('content','content2'));
			break;
			
		case 3:
			// get id of all content of type AdvancedContent
			$query    = "SELECT content_id FROM ". cms_db_prefix()."content WHERE type = ?";
			$dbresult = $db->Execute($query, array('content2'));
			$contents = array();
			while($dbresult && $row = $dbresult->FetchRow()) {
				$contents[] = $row['content_id'];
			}
			// set to content
			$query    = "UPDATE ".cms_db_prefix()."content SET type = ? WHERE type = ?";
			$dbresult = $db->Execute($query, array('content','content2'));
			
			// delete content props
			$query    = "DELETE FROM ". cms_db_prefix()."content_props 
				WHERE content_id IN (".implode(',',$contents).") AND prop_name != 'content_en'";
			$dbresult = $db->Execute($query);
			
			break;
			
		default: break;
		
	}
}

// remove permissions
$this->RemovePermission('Manage AdvancedContent');
$this->RemovePermission('Manage All AdvancedContent Blocks');
$this->RemovePermission('Approve AdvancedContent');
$this->RemovePermission('Modify AdvancedContent Block Options');
$this->RemovePermission('Modify AdvancedContent Block Order');
$this->RemovePermission('Add AdvancedContent Blocks');
$this->RemovePermission('Delete AdvancedContent Blocks');

$this->RemoveEventHandler( 'Core', 'ContentPostRender');

// remove preferences
$this->RemovePreference();

$this->Audit( 0, $this->Lang('AdvancedContent'), 
	$this->Lang('uninstalled',$this->GetVersion()));

?>
