<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
# Version: 0.3.4
# File   : method.install.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if (!isset($gCms)) exit;

$db =& $this->GetDb();

$taboptarray = array('mysql' => 'TYPE=MyISAM');
$dict        = NewDataDictionary($db);

// User Settings
$flds = "user_id I, content_id I, block_id X, block_display I";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_AdvancedContent_blockdisplay", 
	$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

/*
//create tables
// AdvancedContent (general block props)
$flds = "AdvancedContent_id I, 
	id C(64), 
	sequence I,
	type C(64),
	name X,
	label X,
	default_value X,
	active I,
	inherit I,
	options I,
	feu_access X,
	feu_action I,
	block_tab C(64),
	page_tab C(64),
	area C(46),
	author I,
	wrap I,
	style X,
	create_date I, 
	modified_date I, 
	start_date I, 
	expire_date I";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_AdvancedContent", 
	$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

// AdvancedContent drafts (general block props)
$flds = "AdvancedContent_id I, 
	id C(64), 
	sequence I,
	type C(64),
	name X,
	label X,
	default_value X,
	active I,
	inherit I,
	options I,
	feu_access X,
	feu_action I,
	block_tab C(64),
	page_tab C(64),
	area C(46),
	author I,
	wrap I,
	style X,
	create_date I, 
	modified_date I, 
	start_date I, 
	expire_date I";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_AdvancedContent_drafts", 
	$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

//AdvancedContent props (block type specific)
$flds = "AdvancedContent_id I, 
	block_id C(64), 
	prop_name C(64), 
	prop_value X";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_AdvancedContent_props", 
	$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

//AdvancedContent props drafts (block type specific)
$flds = "AdvancedContent_id I, 
	block_id C(64), 
	prop_name C(64), 
	prop_value X";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_AdvancedContent_props_drafts", 
	$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

// additional editors
$flds     = "content_id I, block_id I, user_id I";
$sqlarray = $dict->CreateTableSQL(
	cms_db_prefix()."module_AdvancedContent_addt_editors", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

// additional editors drafts
$flds     = "content_id I, block_id I, user_id I";
$sqlarray = $dict->CreateTableSQL(
	cms_db_prefix()."module_AdvancedContent_addt_editors_drafts", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

// events
$this->AddEventHandler( 'Core', 'ContentEditPre', false );
$this->AddEventHandler( 'Core', 'ContentEditPost', false );
$this->AddEventHandler( 'Core', 'ContentDeletePost', false );

// create permission
$this->CreatePermission('Approve AdvancedContent', 'Approve AdvancedContent');
$this->CreatePermission('Modify AdvancedContent Block Order', 'Modify AdvancedContent Block Order');
$this->CreatePermission('Add AdvancedContent Blocks', 'Add AdvancedContent Blocks');
$this->CreatePermission('Delete AdvancedContent Blocks', 'Delete AdvancedContent Blocks');
*/

$this->CreatePermission('Manage AdvancedContent', 'Manage AdvancedContent');
$this->CreatePermission('Manage All AdvancedContent Blocks', 'Manage All AdvancedContent Blocks');
#$this->CreatePermission('Modify AdvancedContent Block Options', 'Modify AdvancedContent Block Options');

$this->AddEventHandler( 'Core', 'ContentPostRender', false );

$this->Audit( 0, $this->Lang('AdvancedContent'), 
	$this->Lang('installed',$this->GetVersion()));

?>
