//BEGIN_LICENSE
//------------------------------------------------------------------------------
//
// Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
// Version: 0.3
// File   : functions.js
//
//------------------------------------------------------------------------------
//
// CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
// This project's homepage is: http://www.cmsmadesimple.org
//
//------------------------------------------------------------------------------
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
// Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
//
//------------------------------------------------------------------------------
//END_LICENSE

jQuery.noConflict();

var triggerId;
var triggerAction;
var AdvancedContentXtraPanel = false;
var showEditor;
var moduleId;
var fpWidth = 0;
var fpHeight = 0;
var fpWidthUnit = 'px';
var fpHeightUnit = 'px';

function toggleBlock(tabId, navbar_id) {
	var navbar = document.getElementById(navbar_id);
    var tabs   = navbar.getElementsByTagName('div');

    for (var i = 0; i < tabs.length; i += 1) {
		//tabs[i].onmousedown = function() {
		for (var j = 0; j < tabs.length; j += 1) {
			tabs[j].className                                        = '';
			document.getElementById(tabs[j].id + "_c").style.display = 'none';
		}
		document.getElementById(tabId).className            = 'active';
		document.getElementById(tabId + "_c").style.display = 'block';
		return true;
		//}
    }
}

/**
 * function replaceSuffix(currentStr, oldSuffix, newSuffix)
 * replaces all chars from the last found position of char(s) that matches
 * a certain value (oldSuffix) until the end of a string (currentStr)
 * with new one(s) (newSuffix)
 *
 * @param (string) currentStr - the string to manipulate
 * @param (string) oldSuffix  - the substring to remove
 * @param (string) newSuffix  - the replacement
 *
 * @return string
 */
function replaceSuffix(currentStr, oldSuffix, newSuffix) {
	var tmpStr = currentStr.substr(0, currentStr.lastIndexOf(oldSuffix));
	var newStr = tmpStr + newSuffix;
	return newStr;
}


/**
 * function replacePrefix(currentStr, oldPrefix, newPrefix)
 * replaces all chars from the first found position of char(s) that matches
 * a certain value (oldPrefix) until the end of a string (currentStr)
 * with new one(s) (newPrefix)
 *
 * @param (string) currentStr - the string to manipulate
 * @param (string) oldPrefix  - the substring to remove
 * @param (string) newPrefix  - the replacement
 *
 * @return string
 */
function replacePrefix(currentStr, oldPrefix, newPrefix) {
	var tmpStr = currentStr.substr(eval(currentStr.indexOf(oldPrefix)+oldPrefix.length));
	var newStr = tmpStr + newPrefix;
	return newStr;
}


/**
 * function trim(str)
 * removes all leading and ending spaces of a string (str)
 *
 * @param (string) str - the string to manipulate
 *
 * @return string
 */
function trim(str) {
	var regExp = /^\s*(.+[^\s])\s*$/;
	var result = regExp.exec(str);
	var newStr = '';
	if(result != null) {
		newStr = result[1];
	}
	return newStr;
}

function toggleImage(id, url) {
	// ToDo: show image thumb instead of full image
	jQuery(id).attr('src', url);
}

function closeXtraPanel() {
	jQuery('#AdvancedContentXtraPanel').fadeTo(500,0, function () {
		jQuery('#AdvancedContentXtraPanel').remove();
	});
	AdvancedContentXtraPanel = false;
	return false;
}

function getDir(url) {
	jQuery.get(url, function(data){
		jQuery('#AdvancedContentFilePickerContent').html(jQuery('result',data).text());
		resizeFilePicker();
		if(AdvancedContentXtraPanel == false) {
			jQuery('#AdvancedContentFilePicker').fadeTo(500, 1, function () {
				AdvancedContentXtraPanel = true;
			});
		}
	}, 'xml');
	return false;
}

function submitForm(button, targetId, messageId, autoClose) {
	var form = jQuery(button).parents('form:first');
	if(form.length) {
		if(targetId != '' && !form.parents('#'+targetId).length) {
			jQuery('#'+targetId).html('');
		}
		if(messageId != '' && !form.parents('#'+messageId).length) {
			jQuery('#'+messageId).html('');
		}
		var options = {
			dataType:  'xml',
			success: function(responseText) {
				
				if(autoClose)
					closeXtraPanel();
				
				if(jQuery('message',responseText).length && messageId != '') {
					jQuery('#'+messageId).html(jQuery('message',responseText).text());
				}
				if(jQuery('result',responseText).length && targetId != '') {
					jQuery('#'+targetId).html(jQuery('result',responseText).text());
				}
				if(targetId == 'AdvancedContentFilePickerContent')
					resizeFilePicker();
				
				return false;
			}
		}
		form.append('<input type="hidden" class="AdvancedContent_AjaxFields" name="disable_theme" value="1" />');
		form.append('<input type="hidden" class="AdvancedContent_AjaxFields" name="'+button.name+'" value="'+button.value+'" />');
		form.append('<input type="hidden" class="AdvancedContent_AjaxFields" name="'+moduleId+'ajax" value="1" />');
		form.ajaxSubmit(options);
	}
	return false;
}

function deleteFile(url, confirmMsg) {
	var conf = confirm(confirmMsg);
	if(conf) {
		getDir(url);
	}
	return false;
}

function pickFile(url, pickerId) {
	var inputId = pickerId + '_AdvancedContentFilePickerInput';
	var imageId = pickerId + '_AdvancedContentFilePickerImage';
	jQuery(inputId).val(url);
	toggleImage(imageId, url);
	return closeXtraPanel();
}

function resizeFilePicker() {
	try {
		if(fpHeight == 0) {
			var maxHeight = eval(jQuery(window).height()-jQuery('#filePickerHeader').height()-jQuery('#filePickerHeader').css('padding-top').replace(/[^\d]*/g, '')-jQuery('#filePickerHeader').css('padding-bottom').replace(/[^\d]*/g, '')-jQuery('#filePickerHeader').css('margin-top').replace(/[^\d]*/g, '')-jQuery('#filePickerHeader').css('margin-bottom').replace(/[^\d]*/g, '')-jQuery('#filePickerHeader').css('border-bottom-width').replace(/[^\d]*/g, '')-jQuery('#filePickerHeader').css('border-top-width').replace(/[^\d]*/g, '')-jQuery('#AdvancedContentFilePickerContent #filelist').css('margin-top').replace(/[^\d]*/g, '')-jQuery('#AdvancedContentFilePickerContent #filelist').css('margin-bottom').replace(/[^\d]*/g, '')-jQuery('#AdvancedContentFilePickerContent #filelist').css('padding-top').replace(/[^\d]*/g, '')-jQuery('#AdvancedContentFilePickerContent #filelist').css('padding-bottom').replace(/[^\d]*/g, '')-jQuery('#AdvancedContentFilePickerContent #filelist').css('border-bottom-width').replace(/[^\d]*/g, '')-jQuery('#AdvancedContentFilePickerContent #filelist').css('border-top-width').replace(/[^\d]*/g, '')-jQuery('#titlebar').height()-jQuery('#titlebar').css('padding-top').replace(/[^\d]*/g, '')-jQuery('#titlebar').css('padding-bottom').replace(/[^\d]*/g, '')-jQuery('#titlebar').css('margin-top').replace(/[^\d]*/g, '')-jQuery('#titlebar').css('margin-bottom').replace(/[^\d]*/g, '')-jQuery('#titlebar').css('border-bottom-width').replace(/[^\d]*/g, '')-jQuery('#titlebar').css('border-top-width').replace(/[^\d]*/g, '')-10);
			var minHeight = eval(jQuery('#AdvancedContentFilePickerContent #filelist').css('min-height').replace(/[^\d]*/g,''));
			if(maxHeight <= minHeight)
				maxHeight = minHeight;
			jQuery('#AdvancedContentFilePickerContent #filelist').css('max-height', maxHeight);
		}
		else {
			var height = eval(jQuery('#AdvancedContentFilePicker').height() - jQuery('#filePickerHeader').height()-jQuery('#filePickerHeader').css('padding-top').replace(/[^\d]*/g, '')-jQuery('#filePickerHeader').css('padding-bottom').replace(/[^\d]*/g, '')-jQuery('#filePickerHeader').css('margin-top').replace(/[^\d]*/g, '')-jQuery('#filePickerHeader').css('margin-bottom').replace(/[^\d]*/g, '')-jQuery('#filePickerHeader').css('border-bottom-width').replace(/[^\d]*/g, '')-jQuery('#filePickerHeader').css('border-top-width').replace(/[^\d]*/g, '')-jQuery('#titlebar').height()-jQuery('#titlebar').css('padding-top').replace(/[^\d]*/g, '')-jQuery('#titlebar').css('padding-bottom').replace(/[^\d]*/g, '')-jQuery('#titlebar').css('margin-top').replace(/[^\d]*/g, '')-jQuery('#titlebar').css('margin-bottom').replace(/[^\d]*/g, '')-jQuery('#titlebar').css('border-bottom-width').replace(/[^\d]*/g, '')-jQuery('#titlebar').css('border-top-width').replace(/[^\d]*/g, '')-5-jQuery('#AdvancedContentFilePickerContent #filelist').css('margin-top').replace(/[^\d]*/g, '')-jQuery('#AdvancedContentFilePickerContent #filelist').css('margin-bottom').replace(/[^\d]*/g, '')-jQuery('#AdvancedContentFilePickerContent #filelist').css('padding-top').replace(/[^\d]*/g, '')-jQuery('#AdvancedContentFilePickerContent #filelist').css('padding-bottom').replace(/[^\d]*/g, '')-jQuery('#AdvancedContentFilePickerContent #filelist').css('border-bottom-width').replace(/[^\d]*/g, '')-jQuery('#AdvancedContentFilePickerContent #filelist').css('border-top-width').replace(/[^\d]*/g, ''));
			jQuery('#AdvancedContentFilePickerContent #filelist').css('height', height); 
		}
	} catch (err) {}
}