<?php

if(!isset($gCms)) exit;

$templateops =& $gCms->GetTemplateOperations();

if ($this->TemplateId() && $this->TemplateId() > -1) {
	$template = $templateops->LoadTemplateByID($this->TemplateId()); /* @var $template Template */
	$this->stylesheet = '../stylesheet.php?templateid='.$this->TemplateId();
}
else {
	$template = $templateops->LoadDefaultTemplate();
}

$this->contentBlocks = array();
if($template !== false) {
	
	$content = $template->content;
	
	// read content blocks
	# this will search for {content} and {AdvancedContent} with or without params (case insensitive)
	#$pattern = '/{(Advanced)?Content([^}]*)}/i';
	$pattern = '/{(AdvancedContent|content|content_image|content_module)([^}]*)}/i';
	$pattern2 = '/([\w]+)=(["][^"]*["]|[\'][^\']*[\']|[^\'"\s]*)/';
	
	$matches = array();
	// get all the tags
	$result = preg_match_all($pattern, $content, $matches);
	
	if ($result && count($matches[2]) > 0) {
		
		$j = 0;
		// foreach tag
		foreach ($matches[2] as $wholetag) {
			
			$j++;
			
			// get the arguments.
			$morematches = array();
			$result2 = preg_match_all($pattern2, $wholetag, $morematches);
			
			$keyval = array();
			for ($i = 0; $i < count($morematches[1]); $i++) {
				if(startswith($morematches[2][$i],'\''))
					$morematches[2][$i] = trim($morematches[2][$i],'\'');
				else if(startswith($morematches[2][$i],'"'))
					$morematches[2][$i] = trim($morematches[2][$i],'"');
				
				$keyval[strtolower($morematches[1][$i])] = $morematches[2][$i];
			}
			
			// block = active?
			if(isset($keyval['active']) && (strtolower($keyval['active'])== 'false' || $keyval['active'] == false)) {
				continue; // don't process inactive blocks
			}
			
			// additional editors
			$editorGroups = '';
			if(isset($keyval['editor_groups']) && $keyval['editor_groups'] != '') {
				$editorGroups = trim($keyval['editor_groups']);
			}
			$editorUsers = '';
			if(isset($keyval['editor_users']) && $keyval['editor_users'] != '') {
				$editorUsers = trim($keyval['editor_users']);
			}
			
			// blocktype
			$type      = 'text';
			$_wholetag = strtolower($wholetag);
			if(startswith($_wholetag, 'content_image'))
				$type = 'image';
			elseif(startswith($wholetag, 'content_module'))
				$type = 'module';
			elseif(isset($keyval['type']) && $keyval['type'] != '')
				$type = strtolower($keyval['type']);
			
			// blockname
			if($type == 'area')
				$name = 'default';
			else
				$name = 'content_en';
			
			if(isset($keyval['block']) && $keyval['block'] != '')
				$name = trim($keyval['block']);
			
			// block id
			$blockId = preg_replace('/-+/','_',munge_string_to_url($name));
			
			if($type == 'area') {
				$this->contentAreas[$blockId] = $name;
				continue;
			}
			
			$smarty = false;
			if(isset($keyval['smarty']) && ($keyval['smarty'] == true || strtolower($keyval['smarty']) == 'true')) {
				$smarty = true;
			}
			
			$area = 'default';
			if(isset($keyval['area']) && $keyval['area'] != '')
				$area = strtolower($keyval['area']);
			
			// prompt in backend
			if($name == 'content_en')
				$label = lang('content');
			else
				$label = ucwords($name);
			
			if(isset($keyval['label']) && $keyval['label'] != '')
				$label = trim($keyval['label']);
			
			// default content/value
			$defaultValue 	= '';
			if(isset($keyval['default']) && $keyval['default'] != '')
				$defaultValue = $keyval['default'];
			
			// backend style (e.g. to mark required fields...)
			$style = '';
			if(isset($keyval['style'])) {
				$style = $keyval['style'];
			}
			
			// size of the input field
			$size = '';
			if(isset($keyval['size'])) {
				$size = intval($keyval['size']);
			}
			
			$pageTab = 'main';
			if(isset($keyval['page_tab']) && $keyval['page_tab'] != '')
				$pageTab = strtolower($keyval['page_tab']);
			
			$blockTab = '';
			if(isset($keyval['block_tab']) && $keyval['block_tab'] != '') {
				$blockTab = strtolower($keyval['block_tab']);
			}
			
			$allowNone = true;
			if(isset($keyval['allow_none']) && (strtolower($keyval['allow_none']) == 'false' || $keyval['allow_none'] == false))
				$allowNone = false;
			
			// if this block has been added to the template after page has been created
			$newBlock = false;
			if(!in_array($blockId,$this->mProperties->mPropertyNames)) {
				$newBlock = true;
			}
			
			// this will create an invalid block type to print out a 
			// message when using duplicate content block names or basic 
			// content property as block name (e.g. block="title")
			if(isset($this->contentBlocks[$blockId]) 
			|| in_array($blockId, $this->_attributes)
			|| $blockId == $blockId . '_feu_action' 
			|| $blockId == $blockId . '_feu_action[]'
			|| $blockId == $blockId . '_feu_access' 
			|| $blockId == $blockId . '_feu_access[]'
			|| $blockId == 'AdvancedContentStartDate'
			|| $blockId == 'AdvancedContentEndDate'
			|| $blockId == 'AdvancedContentStartTime'
			|| $blockId == 'AdvancedContentEndTime'
			|| $blockId == $blockId . '_AdvancedContentTime'
			|| $blockId == $blockId . '_AdvancedContentDate') {
				$this->contentBlocks[md5($blockId . $j)]['name']     = $name;
				$this->contentBlocks[md5($blockId . $j)]['block_id'] = md5($blockId . $j);
				$this->contentBlocks[md5($blockId . $j)]['type']     = '';
				
				if(isset($this->contentBlocks[$blockId]))
					$this->contentBlocks[md5($blockId . $j)]['default_value'] = $this->lang('error_duplicatecontent', $name);
				else
					$this->contentBlocks[md5($blockId . $j)]['default_value'] = $this->lang('error_basicattrib', $name);
				
				$this->contentBlocks[md5($blockId . $j)]['block_tab'] = $blockTab;
				$this->contentBlocks[md5($blockId . $j)]['page_tab']  = $pageTab;
				$this->contentBlocks[md5($blockId . $j)]['style']     = '';
				$this->contentBlocks[md5($blockId . $j)]['label']     = $label;
				$this->contentBlocks[md5($blockId . $j)]['options']   = false;
				$this->contentBlocks[md5($blockId . $j)]['allow_none']= false;
				$this->contentBlocks[md5($blockId . $j)]['sortable']  = false;
				$this->contentBlocks[md5($blockId . $j)]['save_db']   = false;
				$this->contentBlocks[md5($blockId . $j)]['smarty']    = false;
				$this->contentBlocks[md5($blockId . $j)]['sequence']  = count($this->contentBlocks);
				
				continue;
			}
			
			if($type == 'text') {
				
				$maxlength = '';
				if(isset($keyval['maxlength'])) {
					$maxlength = $keyval['maxlength'];
				}
				
				$usewysiwyg = true;
				if(isset($keyval['wysiwyg']) && (strtolower($keyval['wysiwyg']) == 'false' || $keyval['wysiwyg'] == false)) {
					$usewysiwyg = false;
				}
				
				if($this->GetPropertyValue('disable_wysiwyg'))
					$usewysiwyg = false;
				
				$oneline = false;
				if(isset($keyval['oneline']) && (strtolower($keyval['oneline'])== 'true' || $keyval['oneline'] == true)) {
					$oneline = true;
				}
				
				$this->contentBlocks[$blockId]['maxlength']  = $maxlength;
				$this->contentBlocks[$blockId]['usewysiwyg'] = $usewysiwyg;
				$this->contentBlocks[$blockId]['oneline']    = $oneline;
				$this->contentBlocks[$blockId]['size']       = $size;
			}
			else if ($type == 'date') {
				
				$mode = 'calendar';
				if(isset($keyval['mode']) && strtolower($keyval['mode']) == 'dropdown')
					$mode = 'dropdown';
				
				$show24h = true;
				if(isset($keyval['show24h']) && (strtolower($keyval['show24h']) == 'false' || strtolower($keyval['show24h']) == false))
					$show24h = false;
				
				$startHour = 0;
				$endHour   = ($show24h?23:12);
				if(isset($keyval['start_hour']) && $keyval['start_hour'] > 0 && $keyval['start_hour'] <= $endHour)
					$startHour = trim($keyval['start_hour']);
				
				if(isset($keyval['end_hour']) && $keyval['end_hour'] >= 0 && $keyval['end_hour'] < $endHour)
					$endHour = trim($keyval['end_hour']);
				
				if($endHour < $startHour)
					$endHour = $startHour;
				
				$startMinute = 0;
				if(isset($keyval['start_minute']) && $keyval['start_minute'] > 0 && $keyval['start_minute'] <= 59)
					$startMinute = trim($keyval['start_minute']);
				
				$endMinute = 59;
				if(isset($keyval['end_minute']) && $keyval['end_minute'] >= 0 && $keyval['end_minute'] < 59)
					$endMinute = trim($keyval['end_minute']);
				
				if($endMinute < $startMinute)
					$endMinute = $startMinute;
				
				$startSecond = 0;
				if(isset($keyval['start_second']) && $keyval['start_second'] > 0 && $keyval['start_second'] <= 59)
					$startSecond = trim($keyval['start_second']);
				
				$endSecond = 59;
				if(isset($keyval['end_second']) && $keyval['end_second'] >= 0 && $keyval['end_second'] < 59)
					$endSecond = trim($keyval['end_second']);
				
				if($endSecond < $startSecond)
					$endSecond = $startSecond;
				
				$stepHours = 1;
				if(isset($keyval['step_hours']) && $keyval['step_hours'] > 0 && $keyval['step_hours'] <= ($endHour-$startHour))
					$stepHours = trim($keyval['step_hours']);
				else if(isset($keyval['step_hours']) && $keyval['step_hours'] > 0 && $keyval['step_hours'] >= ($endHour-$startHour))
					$stepHours = $endHour-$startHour;
				
				$stepMinutes = 10;
				if(isset($keyval['step_minutes']) && $keyval['step_minutes'] > 0 && $keyval['step_minutes'] <= ($endMinute-$startMinute))
					$stepMinutes = trim($keyval['step_minutes']);
				else if(isset($keyval['step_minutes']) && $keyval['step_minutes'] > 0 && $keyval['step_minutes'] >= ($endMinute-$startMinute))
					$stepMinutes = $endMinute-$startMinute;
				
				$stepSeconds = 1;
				if(isset($keyval['step_seconds']) && $keyval['step_seconds'] > 0 && $keyval['step_seconds'] <= ($endSecond-$startSeconds))
					$stepSeconds = trim($keyval['step_seconds']);
				else if(isset($keyval['step_seconds']) && $keyval['step_seconds'] > 0 && $keyval['step_seconds'] >= ($endSecond-$startSeconds))
					$stepSeconds = $endSecond-$startSeconds;
				
				$this->contentBlocks[$blockId]['show24h']      = $show24h;
				$this->contentBlocks[$blockId]['mode']         = $mode;
				$this->contentBlocks[$blockId]['start_hour']   = $startHour;
				$this->contentBlocks[$blockId]['end_hour']     = $endHour;
				$this->contentBlocks[$blockId]['start_minute'] = $startMinute;
				$this->contentBlocks[$blockId]['end_minute']   = $endMinute;
				$this->contentBlocks[$blockId]['start_second'] = $startSecond;
				$this->contentBlocks[$blockId]['end_second']   = $endSecond;
				$this->contentBlocks[$blockId]['step_hours']   = $stepHours;
				$this->contentBlocks[$blockId]['step_minutes'] = $stepMinutes;
				$this->contentBlocks[$blockId]['step_seconds'] = $stepSeconds;
			}
			else if($type == 'file' || $type == 'image') {
				
				$upload = check_permission(get_userid(false), 'Modify Files');
				if(isset($keyval['upload']) && (strtolower($keyval['upload']) == 'true' || $keyval['upload'] == true)) {
					$upload = true;
				}
				$dir = '';
				if(isset($keyval['dir']))
					$dir = trim($keyval['dir']);
				
				$filter = '';
				if(isset($keyval['filter']))
					$filter = $keyval['filter'];
				
				$mode = 'dropdown';
				if(isset($keyval['mode']) && strtolower($keyval['mode']) == 'filepicker')
					$mode = 'filepicker';
				
				$lockInput = $this->isAdmin;
				if(isset($keyval['lock_input']) && (strtolower($keyval['lock_input']) == 'false' || $keyval['lock_input'] == false))
					$lockInput = false;
				
				$fileExt = '';
				if($type == 'image')
					$fileExt = 'jpg,jpeg,gif,png,tif,tiff';
				if(isset($keyval['file_extensions']))
					$fileExt = $keyval['file_extensions'];
				
				$showSubDirs = $this->isAdmin;
				if(isset($keyval['show_subdirs']) && ($keyval['show_subdirs'] == true || $keyval['show_subdirs'] == 'true'))
					$showSubDirs = true;
				
				$this->contentBlocks[$blockId]['upload']          = $upload;
				$this->contentBlocks[$blockId]['dir']             = $dir;
				$this->contentBlocks[$blockId]['filter']          = $filter;
				$this->contentBlocks[$blockId]['mode']            = $mode;
				$this->contentBlocks[$blockId]['file_extensions'] = $fileExt;
				$this->contentBlocks[$blockId]['size']            = $size;
				$this->contentBlocks[$blockId]['lock_input']      = $lockInput;
				$this->contentBlocks[$blockId]['show_subdirs']    = $showSubDirs;
			}
			else if($type == 'checkbox') {
				// nothing to do here; checkbox is created in template
			}
			else if($type == 'dropdown' || $type == 'select_multiple') {
				
				if($type == 'select_multiple') {
					$sortable = false;
					if(isset($keyval['sortable_items']) && ($keyval['sortable_items'] == 'true' || $keyval['sortable_items'] == true)) {
						$sortable = true;
					}
					$this->contentBlocks[$blockId]['sortable_items'] = $sortable;
				}
				
				$delimiter = '|';
				if(isset($keyval['delimiter']) && $keyval['delimiter'] != '') {
					$delimiter = $keyval['delimiter'];
				}
				$items = '';
				if(isset($keyval['items']) && $keyval['items'] != '') {
					$items = trim($keyval['items']);
				}
				$values = '';
				if(isset($keyval['values']) && $keyval['values'] != '') {
					$values = trim($keyval['values']);
				}
				
				$this->contentBlocks[$blockId]['items']     = $items;
				$this->contentBlocks[$blockId]['values']    = $values;
				$this->contentBlocks[$blockId]['delimiter'] = $delimiter;
				
			}
			else if($type == 'module') {
				// ToDo
			}
			
			$this->contentBlocks[$blockId]['smarty']        = $smarty;
			$this->contentBlocks[$blockId]['style']         = $style;
			$this->contentBlocks[$blockId]['name']          = $name;
			$this->contentBlocks[$blockId]['block_id']      = $blockId;
			$this->contentBlocks[$blockId]['type']          = $type;
			$this->contentBlocks[$blockId]['default_value'] = $defaultValue;
			$this->contentBlocks[$blockId]['label']         = $label;
			$this->contentBlocks[$blockId]['block_tab']     = $blockTab;
			$this->contentBlocks[$blockId]['page_tab']      = $pageTab;
			$this->contentBlocks[$blockId]['options']       = false;
			$this->contentBlocks[$blockId]['save_db']       = false;
			$this->contentBlocks[$blockId]['sortable']      = false;
			$this->contentBlocks[$blockId]['new_block']     = $newBlock;
			$this->contentBlocks[$blockId]['editor_users']  = $editorUsers;
			$this->contentBlocks[$blockId]['editor_groups'] = $editorGroups;
			$this->contentBlocks[$blockId]['allow_none']    = $allowNone;
			$this->contentBlocks[$blockId]['sequence']      = count($this->contentBlocks);
			
			$this->AddExtraProperty($blockId);
			
		}
		
	}
	
	// force a load
	$this->GetPropertyValue('extra1');
	$this->contentBlocksLoaded = true;
}

?>
