<?php

if(!isset($gCms)) exit;

if(!empty($params)) {
	
	$parameters = array('pagedata', 'searchable', 'disable_wysiwyg', 'redirect_page', 'feu_action', 'feu_access', 'start_date', 'end_date', 'use_expire_date');
	$this->contentBlocksLoaded = false;
	
	//pick up the template id before we do parameters
	if (isset($params['template_id'])) {
		$this->mTemplateId = $params['template_id'];
	}
	//pick up the content type before we do parameters
	if (isset($params['content_type'])) {
		$this->mType = $params['content_type'];
	}
	if($this->mType = 'content2') {
		// add content blocks
		$this->GetContentBlocks();
		
		# added by NaN:
		$parentId = -1;
		if(isset($params['parent_id']))
			$parentId = $params['parent_id'];
		
		if(isset($params['feu_access'])) {
			
			if(!is_array($params['feu_access']))
				$feuAccess = array();
			else
				$feuAccess = $params['feu_access'];
			
			// if page has no parents but wants to inherit -> remove inheritance
			if($parentId <= 0 && in_array('-1', $feuAccess)) {
				foreach($feuAccess as $k=>$v) {
					if($v == '-1') 
						unset($feuAccess[$k]);
				}
			}
			
			// if there is still inheritance -> check if there actually is any feu group selected by parents
			$_feuAccess = array();
			if(in_array('-1', $feuAccess)) {
				// $_feuAccess contains all feu groups (of current page as well as of all parent pages)
				$_feuAccess = $this->InheritParentProp($parentId, 'feu_access', $feuAccess);
			}
			
			// if we have selected any feu group -> disable caching and search
			if(count($_feuAccess) || (count($feuAccess) && !in_array('-1', $feuAccess))) {
				$params['cachable']   = false; // ToDo: Check if this is really needed
				$this->mCachable      = false;
				$params['searchable'] = false;
			}
			
			$params['feu_access'] = implode(';', $feuAccess);
			
			$redirectPage = '';
			if(isset($params['redirect_page'])) {
				$redirectPage = $params['redirect_page'];
			}
			// if page has no parents but wants to inherit -> remove inheritance
			if($parentId <= 0 && $redirectPage == -1) {
				$redirectPage = '';
			}
			
			$feuAction = ''; 
			if(isset($params['feu_action']))
				$feuAction = $params['feu_action'];
			// if page has no parents but wants to inherit -> remove inheritance
			if($parentId <= 0 && $feuAction == -1) {
				$feuAction = '';
			}
			$params['redirect_page'] = $redirectPage;
			$params['feu_action']    = $feuAction;
		}
		
		// do the content property parameters
		foreach ($parameters as $oneparam) {
			if($oneparam == 'start_date' || $oneparam == 'end_date') {
				$_string           = ucfirst(str_replace('_date','',$oneparam));
				$params[$oneparam] = 0;
				if(isset($params['AdvancedContent'.$_string.'Time']) && isset($params['AdvancedContent'.$_string.'Date']))
					$params[$oneparam] = $params['AdvancedContent'.$_string.'Time'] + $params['AdvancedContent'.$_string.'Date'];
			}
			if (isset($params[$oneparam])) {
				$this->SetPropertyValue($oneparam, $params[$oneparam]);
			}
		}
		
		if(isset($params['start_date']) && isset($params['use_expire_date']) && $params['use_expire_date'] == 1 && $params['start_date'] > time()) {
			$params['active'] = false;
			$this->mActive    = false;
		}
		
		// metadata
		if (isset($params['metadata'])) {
			$this->mMetadata = $params['metadata'];
		}
		
		// content blocks
		$i = 0;
		foreach($params as $paramName => $paramValue) {
			
			$paramName = str_replace('_AdvancedContentTime', '', $paramName);
			if(isset($this->contentBlocks[$paramName])) {
				$i++;
				$value = '';
				if($this->contentBlocks[$paramName]['type'] == 'select_multiple') {
					if(is_array($paramValue))
						$value = implode($this->contentBlocks[$paramName]['delimiter'], $paramValue);
					else if ($this->contentBlocks[$paramName]['sortable_items']) {
						$items = array();
						foreach($params as $itemName => $itemValue) {
							if(startswith($itemName,$paramName.'_AdvancedContentSortableItem_')) {
								$items[] = $itemValue;
							}
						}
						$value = implode($this->contentBlocks[$paramName]['delimiter'], $items);
					}
				}
				else if($this->contentBlocks[$paramName]['type'] == 'date' 
				&& $this->contentBlocks[$paramName]['mode'] == 'calendar' 
				&& isset($params[$paramName . '_AdvancedContentTime']) 
				&& isset($params[$paramName . '_AdvancedContentDate'])) {
					#$_tmp         = explode(':', $params[$paramName . '_AdvancedContentTime']);
					#$time_seconds = (($_tmp[0] * 3600) + ($_tmp[1] * 60));
					#$value       = $time_seconds + $params[$paramName . '_AdvancedContentDate'];
					$value        = $params[$paramName . '_AdvancedContentTime'] + $params[$paramName . '_AdvancedContentDate'];
				}
				else if(($this->contentBlocks[$paramName]['type'] == 'file' || $this->contentBlocks[$paramName]['type'] == 'image') && $paramValue == '-1' ) {
					$value = '';
				}
				else {
					$value = trim($paramValue);
				}
				if($value == '' && !$this->contentBlocks[$paramName]['allow_none']) {
					$value = $this->contentBlocks[$paramName]['default_value'];
					if($this->contentBlocks[$paramName]['smarty'])
						$value = $this->DoSmarty($value);
				}
				
				$this->AddExtraProperty($paramName);
				$this->SetPropertyValue($paramName, $value);
			}
		}
		#if(isset($params['submitbutton']) || isset($params['applybutton']))
		#	$this->SortContentBlocks();
		
		// this is only while bug #4952 of CMSms isn't fixed
		// ToDo: get cms version -> only do this if cms version is <= CMSms 1.7.?
		// if we have a new menutext -> use new one
		if(isset($params['menutext']))
			$this->mMenuText = trim($params['menutext']);
		// else use old one
		else
			$params['menutext'] = $this->mMenuText;
			
		// if we have a new title -> use new one
		if(isset($params['title']))
			$this->mName = trim($params['title']);
		// else use old one
		else
			$params['title'] = $this->mName;
		
		// if we have no title given but menutext -> use menutext as title
		if($this->mName == '' && $this->mMenuText !='') {
			$this->mName     = $this->mMenuText;
			$params['title'] = $this->mName;
		}
		// if we have no menutext given but title -> use title as menutext
		if($this->mMenuText == '' && $this->mName != '') {
			$this->mMenuText    = $this->mName;
			$params['menutext'] = $this->mMenuText;
		}
		
		// if we have a new alias -> use new one
		if(isset($params['alias']))
			$this->mAlias = munge_string_to_url(trim($params['alias']),true);
		// else use old one
		else
			$params['alias'] = $this->mAlias;
		
		// if alias is empty -> use menutext as alias
		if($this->mAlias == '') {
			$this->mAlias    = munge_string_to_url($this->mMenuText, true);
			$params['alias'] = $this->mAlias;
		}
	}
}

?>
