<?php

if(!isset($gCms)) exit;

$blockTabs = array();

$this->GetModule();

// display the content blocks
foreach($this->contentBlocks as $blockInfo) {
	
	// check if user has permission to edit this block
	if($blockInfo['type'] != '' && !$blockInfo['save_db'] && !check_permission(get_userid(), 'Manage All AdvancedContent Blocks')) {
		if($blockInfo['editor_users'] == '' && $blockInfo['editor_groups'] == '')
			$this->contentBlocks[$blockInfo['block_id']]['addt_editors'] = array(get_userid());
		else {
			$this->contentBlocks[$blockInfo['block_id']]['addt_editors'] = array();
			$userops      =& $gCms->GetUserOperations();
			$groupops     =& $gCms->GetGroupOperations();
			$allusers     =& $userops->LoadUsers();
			$allgroups    =& $groupops->LoadGroups();
			$editorGroups =  explode(',',$blockInfo['editor_groups']);
			$editorUsers  =  explode(',',$blockInfo['editor_users']);
			foreach ($allgroups as $oneGroup) {
				if(in_array($oneGroup->name,$editorGroups))
					$this->contentBlocks[$blockInfo['block_id']]['addt_editors'][] = $oneGroup->id*-1;
			}
			
			foreach ($allusers as $oneUser) {
				if(in_array($oneUser->username,$editorUsers))
					$this->contentBlocks[$blockInfo['block_id']]['addt_editors'][] = $oneUser->id;
			}
		}
	}
	
	if(!check_permission(get_userid(), 'Manage All AdvancedContent Blocks') 
	&& (!in_array(get_userid(),$this->contentBlocks[$blockInfo['block_id']]['addt_editors']))
	&& !count(array_intersect($this->userGroups,$this->contentBlocks[$blockInfo['block_id']]['addt_editors']))) {
		unset($this->contentBlocks[$blockInfo['block_id']]);
		continue;
	}
	
	if(isset($this->pageTabs[$tab]) && $this->pageTabs[$tab] == $blockInfo['page_tab']) {
		
		if($blockInfo['type'] != '' && $blockInfo['smarty']) {
			foreach($blockInfo as $propName=>$propValue) {
				$blockInfo[$propName]                                   = $this->DoSmarty($propValue);
				$this->contentBlocks[$blockInfo['block_id']][$propName] = $blockInfo[$propName];
			}
		}
		
		if($blockInfo['block_tab'] != '' && !in_array($blockInfo['block_tab'], $blockTabs))
			$blockTabs[] = $blockInfo['block_tab'];
		
		$data = $this->GetPropertyValue($blockInfo['block_id']);
		if(($adding && $data == '') || 
		($data == '' && !$blockInfo['allow_none']) || $blockInfo['new_block'])
			$data = $blockInfo['default_value'];
		
		$this->contentBlocks[$blockInfo['block_id']]['content'] = cms_htmlentities($data, ENT_NOQUOTES, get_encoding(''));
		$this->contentBlocks[$blockInfo['block_id']]['input']   = '- invalid -';
		
		#$blockInfo['options'] = ($blockInfo['type'] != '' && check_permission(get_userid(), 'Modify AdvancedContent Block Options') && $blockInfo['options']);
		
		if($blockInfo['options']) {
			$this->contentBlocks[$blockInfo['block_id']]['block_options'] = $this->DisplayBlockOptions($blockInfo['block_id']);
		}
		
		$blockDisplay = $this->module->GetBlockDisplay($this->mId, $blockInfo['block_id']);
		$this->contentBlocks[$blockInfo['block_id']]['display']  = $blockDisplay;
		$this->contentBlocks[$blockInfo['block_id']]['pref_url'] = str_replace('&amp;','&',
			$this->module->CreateLink('m1_', 'savePrefs', '', $this->lang('toggle_block'), 
				array('toggle'=>'block',
					'disable_theme'=>true, 
					'ajax'=>true, 
					'content_id'=>$this->mId,
					'block_id'=>$blockInfo['block_id']), 
				'', true));
		
		switch($blockInfo['type']) {
			
			case 'module':
				break;
			
			case 'date':
				
				if($data == '')
					$data = time();
				
				$date        = strftime('%x', intval($data));
				$time        = strftime('%H:%M', intval($data));
				
				$_tmp        = explode(':',$time);
				$timeSeconds = (($_tmp[0] * 3600) + ($_tmp[1] * 60));
				$dateSeconds = $data - $timeSeconds;
				
				$suffix      = ($blockInfo['show24h']?'':' am');
				$timeInput   = '<select name="'.$blockInfo['block_id'].'_AdvancedContentTime">';
				$_i          = 0;
				for($i=$blockInfo['start_hour']; $i<=$blockInfo['end_hour']; $i += $blockInfo['step_hours']) {
					
					for($j=$blockInfo['start_minute']; $j<=$blockInfo['end_minute']; $j += $blockInfo['step_minutes']) {
						if($suffix == ' pm' && $i < 12)
							$_i = 12;
						$value = (($i+$_i)*3600) + ($j*60);
						
						$timeInput .= '<option value="'. $value .'"'. ($value == $timeSeconds? ' selected="selected"':'') .'>'. ($i<10?'0'.$i:$i) .':'. ($j<10?'0'.$j:$j) . $suffix . '</option>';
					}
					
					$j = $blockInfo['start_minute'];
					
					if($i==11 && !$blockInfo['show24h'] && $suffix == ' am') {
						$suffix = ' pm';
					}
					else if($i==11 && !$blockInfo['show24h'] && $suffix == ' pm') {
						break;
					}
					else if($i==12 && !$blockInfo['show24h'] && $suffix == ' pm') {
						$i = 0;
					}
				}
				
				$timeInput .= '</select>';
				
				$this->contentBlocks[$blockInfo['block_id']]['date']       = $date;
				$this->contentBlocks[$blockInfo['block_id']]['date_value'] = $dateSeconds;
				$this->contentBlocks[$blockInfo['block_id']]['time']       = $time;
				$this->contentBlocks[$blockInfo['block_id']]['time_value'] = $timeSeconds;
				$this->contentBlocks[$blockInfo['block_id']]['time_input'] = $timeInput;
				
				break;
			
			case 'file':
			case 'image':
				
				$excludeFiles = false;
				$filePrefix   = '';
				
				if($blockInfo['filter'] != '') {
					$filePrefix   = str_ireplace(array('exclude:','include:'), '', $blockInfo['filter']);
					$excludeFiles = (stripos($blockInfo['filter'], 'exclude:') !== false && $filePrefix != '');
				}
				
				if($blockInfo['mode'] == 'dropdown') {
					if($blockInfo['type'] == 'image') {
						$this->contentBlocks[$blockInfo['block_id']]['input'] = '
							<span id="'.$blockInfo['block_id'].'_DropdownWrapper">'.
							str_ireplace('<select', 
								'<select id="'.$blockInfo['block_id'].'_AdvancedContentFilePickerInput" onchange="toggleImage(\'#' . $blockInfo['block_id'] . '_AdvancedContentFilePickerImage\',this.value)" ',
								create_file_dropdown($blockInfo['block_id'], 
									$gCms->config['image_uploads_path'] . DIRECTORY_SEPARATOR . $blockInfo['dir'], 
									$data, 
									$blockInfo['file_extensions'],
									trim($gCms->config['image_uploads_url'] . '/' . $blockInfo['dir'],'/'), 
									$blockInfo['allow_none'], 
									($blockInfo['style'] != ''?'style="' . $blockInfo['style'] . '"':''), 
									$filePrefix, $excludeFiles)).
							'</span>';
					}
					else if($blockInfo['type'] == 'file') {
						$this->contentBlocks[$blockInfo['block_id']]['input'] = '
							<span id="'.$blockInfo['block_id'].'_DropdownWrapper">'.
								create_file_dropdown($blockInfo['block_id'], 
									$gCms->config['uploads_path'] . DIRECTORY_SEPARATOR . $blockInfo['dir'], 
									$data, 
									$blockInfo['file_extensions'],
									trim($gCms->config['uploads_url'] . '/' . $blockInfo['dir'],'/'), 
									$blockInfo['allow_none'], 
									($blockInfo['style'] != ''?'style="' . $blockInfo['style'] . '"':''), 
									$filePrefix, $excludeFiles).
							'</span>';
						
					}
					if($blockInfo['upload'] && $this->module->GetPreference('showfilemanagement', 0)) {
						$this->contentBlocks[$blockInfo['block_id']]['input'] .= '&nbsp;|&nbsp;<input type="button" value="'.$this->lang('uploadfile').'" 
								id="'.$blockInfo['block_id'].'_AdvancedContentFilePickerTrigger" class="FilePicker AdvancedContentXtraPanelTrigger" onclick="return false;" href="'.
								$this->module->CreateLink('m1_', 'filePicker', '', $this->lang('uploadfile'), 
									array('dropdown'=>true,
										'disable_theme'=>true, 
										'show_subdirs'=>$blockInfo['show_subdirs'], 
										'subdir'=>($this->isAdmin?$blockInfo['dir']:''), 
										'startdir'=>($this->isAdmin?'':$blockInfo['dir']), 
										'type'=>$blockInfo['type'], 
										'picker_id' =>$blockInfo['block_id'], 
										'filter'=>$blockInfo['filter'], 
										'file_extensions'=>$blockInfo['file_extensions'], 
										'upload'=>$blockInfo['upload'],
										'allow_none'=>$blockInfo['allow_none']), 
									'', true).
							'" />';
					}
				}
				else if($blockInfo['mode'] == 'filepicker') {
					if($blockInfo['type'] == 'image')
						$this->contentBlocks[$blockInfo['block_id']]['input'] = '<input id="'.$blockInfo['block_id'].'_AdvancedContentFilePickerInput" type="hidden" name="'.$blockInfo['block_id'].'" value="' . $this->contentBlocks[$blockInfo['block_id']]['content'] . '" />';
					else if($blockInfo['type'] == 'file')
						$this->contentBlocks[$blockInfo['block_id']]['input'] = '<input id="'.$blockInfo['block_id'].'_AdvancedContentFilePickerInput" type="text"' . ($blockInfo['lock_input']?' disabled="disabled"':'') . ($blockInfo['style'] != ''?' style="' . $blockInfo['style'] . '"':'') . ($blockInfo['size'] != ''?' size="' . $blockInfo['size'] . '"':'') . ' name="' . $blockInfo['block_id'] . '" value="' . $this->contentBlocks[$blockInfo['block_id']]['content'] . '" />';
					
					$this->contentBlocks[$blockInfo['block_id']]['input'] .= '
						<input type="button" value="'.$this->lang('select'.$blockInfo['type']).'"
							id="'.$blockInfo['block_id'].'_AdvancedContentFilePickerTrigger" class="FilePicker AdvancedContentXtraPanelTrigger" onclick="return false;" href="'.
							$this->module->CreateLink('m1_', 'filePicker', '', $this->lang('select'.$blockInfo['type']), 
							array('disable_theme'=>true, 
								'show_subdirs'=>$blockInfo['show_subdirs'], 
								'subdir'=>($this->isAdmin?$blockInfo['dir']:''), 
								'startdir'=>($this->isAdmin?'':$blockInfo['dir']), 
								'type'=>$blockInfo['type'], 
								'picker_id' =>$blockInfo['block_id'], 
								'filter'=>$blockInfo['filter'], 
								'file_extensions'=>$blockInfo['file_extensions'], 
								'upload'=>$blockInfo['upload']), 
							'', true).
						'" />';
					if($blockInfo['allow_none']) {
						$this->contentBlocks[$blockInfo['block_id']]['input'] .= '&nbsp;|&nbsp;<input type="button" value="'.lang('none').'" onclick="jQuery(\'#'.$blockInfo['block_id'].'_AdvancedContentFilePickerInput\').val(\'\'); jQuery(\'#'.$blockInfo['block_id'].'_AdvancedContentFilePickerImage\').attr(\'src\',\'\'); return false;" />';
					}
					$this->contentBlocks[$blockInfo['block_id']]['url'] = $this->module->CreateLink('m1_', 'filePicker', '', 'filePicker', array('disable_theme'=>true, 'show_subdirs'=>$blockInfo['show_subdirs'], 'subdir'=>($this->isAdmin?$blockInfo['dir']:''), 'startdir'=>($this->isAdmin?'':$blockInfo['dir']), 'type'=>$blockInfo['type'], 'picker_id' =>$blockInfo['block_id'], 'filter'=>$blockInfo['filter'], 'file_extensions'=>$blockInfo['file_extensions'], 'upload'=>$blockInfo['upload']), '', true);
				}
				break;
			
			case 'checkbox':
				$this->contentBlocks[$blockInfo['block_id']]['input'] = '
					<input type="hidden" name="' . $blockInfo['block_id'] . '" value="0" />
					<input class="pagecheckbox"' . ($blockInfo['style'] != ''?' style="' . $blockInfo['style'] . ' "':'') . ' type="checkbox" value="1" name="' . $blockInfo['block_id'] . '"' . ($data == 1 ? ' checked="checked"':'') . ' />';
				break;
			
			case 'dropdown':
				
				$items = array();
				if($blockInfo['items'] != '') {
					foreach(explode($blockInfo['delimiter'], $blockInfo['items']) as $key => $val) {
						$items[$key]['label']    = trim($val);
						$items[$key]['value']    = $items[$key]['label'];
						$items[$key]['selected'] = ($data === $val);
					}
				}
				if($blockInfo['values'] != '') {
					foreach(explode($blockInfo['delimiter'], $blockInfo['values']) as $key => $val) {
						$items[$key]['value']    = trim($val);
						$items[$key]['selected'] = ($data === $items[$key]['value']);
						
						if(!isset($items[$key]['label']))
							$items[$key]['label'] = $items[$key]['value'];
					}
				}
				
				$this->contentBlocks[$blockInfo['block_id']]['input'] = '<select name="' . $blockInfo['block_id'] . '" ' . ($blockInfo['style'] != ''?'style="' . $blockInfo['style'] . ' "':'') . ' >';
				foreach($items as $item) {
					
					$this->contentBlocks[$blockInfo['block_id']]['input'] .= '<option value="' . $item['value'] . '"';
					if($item['selected'])
						$this->contentBlocks[$blockInfo['block_id']]['input'] .= ' selected="selected"';
					$this->contentBlocks[$blockInfo['block_id']]['input'] .= '>' . $item['label'] . '</option>';
				}
				$this->contentBlocks[$blockInfo['block_id']]['input'] .= '</select>';
				
				break;
			
			case 'select_multiple':
				
				$selItems = array();
				foreach(explode($blockInfo['delimiter'], $data) as $key => $val) {
					$selItems[$key] = trim($val);
				}
				$items = array();
				if($blockInfo['items'] != '') {
					foreach(explode($blockInfo['delimiter'], $blockInfo['items']) as $key => $val) {
						$items[$key]['label']    = trim($val);
						$items[$key]['value']    = $items[$key]['label'];
						$items[$key]['selected'] = in_array($items[$key]['label'],$selItems);
					}
				}
				if($blockInfo['values'] != '') {
					foreach(explode($blockInfo['delimiter'], $blockInfo['values']) as $key => $val) {
						$items[$key]['value']    = trim($val);
						$items[$key]['selected'] = in_array($items[$key]['value'],$selItems);
						if(!isset($items[$key]['label']))
							$items[$key]['label'] = $items[$key]['value'];
					}
				}
				
				$this->contentBlocks[$blockInfo['block_id']]['input'] = '
					<input type="hidden" value="" "name="' . $blockInfo['block_id'] . '" />';
				
				if(!$blockInfo['sortable_items']) {
					$size = count($items);
					if(isset($blockInfo['size']))
						$size = $blockInfo['size'];
					
					$this->contentBlocks[$blockInfo['block_id']]['input'] .= '
						<select name="' . $blockInfo['block_id'] . '[]"' . ($blockInfo['style'] != ''?' style="' . $blockInfo['style'] . ' "':'') . '  multiple="multiple" size="'.$size.'">';
					foreach($items as $item) {
						
						$this->contentBlocks[$blockInfo['block_id']]['input'] .= '<option value="' . $item['value'] . '"';
						if($item['selected'])
							$this->contentBlocks[$blockInfo['block_id']]['input'] .= ' selected="selected"';
						$this->contentBlocks[$blockInfo['block_id']]['input'] .= '>' . $item['label'] . '</option>';
					}
					$this->contentBlocks[$blockInfo['block_id']]['input'] .= '</select>';
				}
				else {
					
					// sort the items
					$_items = array();
					foreach($selItems as $selKey => $selItem) {
						reset($items);
						foreach($items as $itemKey => $item) {
							if($item['value'] === $selItem) {
								$_items[] = $item;
								unset($items[$itemKey]);
								unset($selItems[$selKey]);
								break;
							}
						}
					}
					
					$items = array_merge($_items,$items);
					$this->contentBlocks[$blockInfo['block_id']]['input'] .= '<div class="sortable_items">';
					foreach($items as $item) {
						$this->contentBlocks[$blockInfo['block_id']]['input'] .= 
						'<div class="sortable_item">
							<img class="sortable_item_handler" src="../modules/AdvancedContent/images/sort.png" />
							<input class="pagecheckbox"' . ($blockInfo['style'] != ''?' style="' . $blockInfo['style'] . ' "':'') . ' type="checkbox" value="'.$item['value'].'" name="' . $blockInfo['block_id'] . '_AdvancedContentSortableItem_' . munge_string_to_url($item['label'], true) . '"' . ($item['selected']? ' checked="checked"':'') . ' />
							'.$item['label'].'
						</div>';
					}
					$this->contentBlocks[$blockInfo['block_id']]['input'] .= '</div>';
				}
				break;
			
			case 'text':
				if ($blockInfo['oneline'] == false) {
					$this->contentBlocks[$blockInfo['block_id']]['input'] = create_textarea($blockInfo['usewysiwyg'], $data, $blockInfo['block_id'], '', $blockInfo['block_id'], '', $this->stylesheet);
				}
				else {
					$this->contentBlocks[$blockInfo['block_id']]['input'] = '<input type="text"' . ($blockInfo['style'] != ''?'style="' . $blockInfo['style'] . ' "':'') . ($blockInfo['maxlength'] != ''?' maxlength="' . $blockInfo['maxlength'] . ' "':'') . ($blockInfo['size'] != ''?' size="' . $blockInfo['size'] . ' "':'') . ' name="' . $blockInfo['block_id'] . '" value="' . $this->contentBlocks[$blockInfo['block_id']]['content'] . '" />';
				}
				break;
				
			default: 
				$this->contentBlocks[$blockInfo['block_id']]['content'] = $blockInfo['default_value'];
				break;
		}
	}
}

$gCms->smarty->assign('fpWidth', $this->module->GetPreference('filepickerwidth',0));
$gCms->smarty->assign('fpHeight', $this->module->GetPreference('filepickerheight',0));

$gCms->smarty->assign('fpWidthUnit', $this->module->GetPreference('filepickerwidthunit','px'));
$gCms->smarty->assign('fpHeightUnit', $this->module->GetPreference('filepickerheightunit','px'));

$gCms->smarty->assign('blockContent_text', $this->module->lang('blockcontent'));
$gCms->smarty->assign('blockOptions_text', $this->module->lang('blockoptions'));
$gCms->smarty->assign('none_text', lang('none'));
$gCms->smarty->assign('moduleId', 'm1_');
$gCms->smarty->assign('tab', $tab);
$gCms->smarty->assign('pageTab', $this->pageTabs[$tab]);
$gCms->smarty->assign('blockTabs', $blockTabs);
$gCms->smarty->assign('contentBlocks', $this->contentBlocks);

$ret[] = array('', $this->module->ProcessTemplate('contentType.tpl'));
?>
