<?php

class AdvancedContentFilePicker {
	
	/**
	 * function GetMimeType($file)
	 * not part of the module api
	 * gets the mimne type of a file
	 * 
	 * @param string $file - the path to a file to check the mime type
	 *
	 * @return mixed - false if no mime type functions available; otherwise the mime type (lowercase)
	 */
	function GetMimeType($file, $useMime = true) {
		
		$mimeType = false;
		if($useMime) {
			if (version_compare(PHP_VERSION, '5.3.0') >= 0 && function_exists('finfo_open')) {
				$finfo    = finfo_open(FILEINFO_MIME_TYPE); 
				$mimeType = strtolower(finfo_file($finfo, $file));
				finfo_close($finfo);
			}
			else if(function_exists('mime_content_type')) {
				$mimeType = strtolower(mime_content_type($file));
			}
		}
		return $mimeType;
	}
	
	
	/**
	 * function GetThumbnailFile($file, $path, $url)
	 * not part of the module api
	 * taken from TinyMCE Module
	 */
	function GetThumbnail($file, $path, $url, $makethumbnail) {
		
		$image     = '';
		$thumbPath = $this->_slashes($path . '/thumb_' . $file);
		$thumbUrl  = $this->_slashes($url . '/thumb_' . rawurlencode($file));
		
		if (!file_exists($thumbPath)) {
			if($makethumbnail) {
				if(!$this->HandleFileResizing($path . '/' . $file, $thumbPath,get_site_preference('thumbnail_width',96),get_site_preference('thumbnail_height',96)))
					return;
			}
			else
				return;
		}
		$image = '<img src="' . $thumbUrl . '" alt="' . $file . '" title="' . $file . '" />';
		return $image;
	}
	
	
	/**
	 * function _slashes($url)
	 * not part of the module api
	 * taken from TinyMCE Module
	 */
	function _slashes($url) {
		$result = str_replace('\\', '/', $url);
		return $result;
	}
	
	
	/**
	 * function IsDirEmpty($dir)
	 * not part of the module api
	 * taken from TinyMCE Module (extracted from filepicker)
	 */
	function IsDirEmpty($dir) {
		$d = dir($dir);
		while ($entry = $d->read()) {  
			if ($entry == '.') continue;
			if ($entry == '..') continue;
			return false;
		}
		return true;
	}
	
	
	/**
	 * function SortFiles($file1, $file2)
	 * not part of the module api
	 * taken from TinyMCE Module (extracted from filepicker)
	 */
	function SortFiles($file1, $file2) {
		if ($file1['isdir'] && !$file2['isdir']) return -1;
		if (!$file1['isdir'] && $file2['isdir']) return 1;
		return strnatcasecmp($file1['name'], $file2['name']);
	}
	
	
	/**
	 * function Slash($str, $str2 = '', $str3 = '')
	 * not part of the module api
	 * taken from TinyMCE Module
	 */
	function Slash($str, $str2 = '', $str3 = '') {
		if ($str == '') return $str2;
		if ($str2 == '') return $str;
		if ($str[strlen($str)-1] != '/') {
			if ($str2[0] != '/') {
				return $str . '/' . $str2;
			} else {
				return $str . $str2;
			}
		} else {
			if ($str2[0] != '/') {
				return $str . $str2;
			} else {
				return $str . substr($str2, 1); //trim away one of the slashes
			}
		}
		//Three strings not supported yet...
		return "Error in _slash-function. Please report";
	}
	
	
	/**
	 * function HandleFileResizing($tempname, $outname, $size_x, $size_y, $switchdimensions = true)
	 * not part of the module api
	 * taken from TinyMCE Module
	 */
	function HandleFileResizing($tempname, $outname, $size_x, $size_y, $switchdimensions = false, $keepAspectRatio = true, $allowUpscaling = false) {
		$tempname = $this->_slashes($tempname);
		$outname  = $this->_slashes($outname);
		
		$img_data = @getimagesize($tempname);
		if (!$img_data) return false;
		$mime  = $img_data['mime'];
		$image = '';
		switch($mime) {
			case 'image/jpeg': $image = @imagecreatefromjpeg($tempname); break;
			case 'image/gif' : $image = @imagecreatefromgif($tempname); break;
			case 'image/png' : $image = @imagecreatefrompng($tempname); break;
			default: return false;
		}
		$width     = @imagesx($image);
		$height    = @imagesy($image);
		$whratio   = $width/$height;
		$hwratio   = $height/$width;
		$newwidth  = '';
		$newheight = '';
		/*
		$this->Lang('forcewidth')=>1,
		$this->Lang('forceheight')=>2,
		$this->Lang('forcelargest')=>3,
		$this->Lang('forceboth')=>4,
		*/
		$resizing = '1';
		if ($switchdimensions) {
			if ($width<$height) {
				$resizing = '2';
				$tmp      = $size_x;
				$size_x   = $size_y;
				$size_y   = $tmp;
			}
		}
		
		switch ($resizing) {
			case '1' : {
				if ($width < $size_x && !$allowUpscaling) {
					$newwidth  = $width;
					$newheight = $height;
				}
				else {
					$newwidth = $size_x;
					if($keepAspectRatio) {
						$newheight = $newwidth*$hwratio;
					}
					else {
						$newheight = $size_y;
					}
				}
				break;
			}
			case '2' : {
				if ($height < $size_y && !$allowUpscaling) {
					$newwidth  = $width;
					$newheight = $height;
				}
				else {
					$newheight = $size_y;
					if($keepAspectRatio) {
						$newwidth = $newheight*$whratio;
					}
					else {
						$newwidth = $size_x;
					}
				}
				break;
			}
		}
		
		$newimage = @imagecreatetruecolor(round($newwidth), round($newheight));
		@imagecopyresampled($newimage, $image, 0, 0, 0, 0, $newwidth, $newheight,$width, $height);
		//todo: enable format change
		$format = 'unchanged';
		if ($format=='unchanged') {
			switch($mime) {
				case 'image/jpeg': return @imagejpeg($newimage, $outname,90);
				case 'image/gif' : return @imagegif($newimage, $outname);
				case 'image/png' : return @imagepng($newimage, $outname);
				default          : return false;
			}
		} else {
			switch ($format) {
				case 'jpg': return @imagejpeg($newimage, $outname,90);
				case 'gif': return @imagegif($newimage, $outname);
				case 'png': return @imagepng($newimage, $outname);
				default   : return;
			}
		}
	}
	
	
	/**
	 * function ContainsIllegalChars($filename)
	 * not part of the module api
	 * taken from TinyMCE Module
	 */
	function ContainsIllegalChars($filename) {
		if (strpos($filename, '\'') !== false) return true;
		if (strpos($filename, '"' ) !== false) return true;
		if (strpos($filename, '/' ) !== false) return true;
		if (strpos($filename, '\\') !== false) return true;
		if (strpos($filename, '&' ) !== false) return true;
		if (strpos($filename, '\$') !== false) return true;
		if (strpos($filename, '+' ) !== false) return true;
		return false;
	}
}

$filePicker = new AdvancedContentFilePicker();

?>
