<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          This file is a modification of the default content type "Content"
# Version: 0.3.4
# File   : contenttype.Content2.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

class Content2 extends CMSModuleContentType
{
    var $stylesheet;
    var $contentBlocks;
    var $contentBlocksLoaded;
    var $contentAreas;
    var $pageTabs;
    var $blockTabs;
	var $module;
	var $userGroups;
	var $isAdmin;
	
	function Content2() {
		$this->__construct();
	}
	
	function __construct() {
		parent::ContentBase();
		$this->contentBlocks       = array();
		$this->contentAreas        = array('none'=>lang('none'));
		$this->contentBlocksLoaded = false;
		global $CMS_ADMIN_PAGE;
		if(isset($CMS_ADMIN_PAGE) && $CMS_ADMIN_PAGE == 1) {
			$this->pageTabs   = array('main', 'options');
			$this->userGroups = $this->GetGroups();
			global $gCms;
			$userOps =& $gCms->GetUserOperations();
			$this->isAdmin = $userOps->UserInGroup(get_userid(),1);
			#$this->wysiwyg   = get_preference(get_userid(false), 'wysiwyg');
		}
	}
	
	function ModuleName() {
		return 'AdvancedContent';
	}
	
	function IsDefaultPossible() {
		return TRUE;
	}
	
	function IsCopyable() {
		return TRUE;
	}
	
	function FriendlyName() {
		return $this->lang('AdvancedContent');
	}
	
	function SetProperties() {
		parent::SetProperties();
		
		$this->AddBaseProperty('template', 4, 0, 'int');
		$this->AddBaseProperty('pagemetadata', 20);
		$this->AddContentProperty('searchable', 8, 0, 'int');
		$this->AddContentProperty('pagedata', 25);
		$this->AddContentProperty('disable_wysiwyg', 60, 0, 'int');
		
		$this->AddContentProperty('redirect_page', 100, 0, 'int');
		$this->AddContentProperty('feu_access', 99);
		$this->AddContentProperty('feu_action', 101, 0, 'int');
		
		$this->AddContentProperty('use_expire_date', 102, 0, 'int');
		$this->AddContentProperty('start_date', 103, 0, 'int');
		$this->AddContentProperty('end_date', 104, 0, 'int');
		
		$this->mPreview = true;
	}
	
	function ReadyForEdit() {
		$this->GetContentBlocks();
	}
	
	function Show($param = 'content_en') {
		// check for additional content blocks
		$this->GetContentBlocks();
		return $this->GetPropertyValue($param);
	}
	
	function TabNames() {
		$res = array(lang('main'));
		if( check_permission(get_userid(), 'Manage All Content') ) {
			$res[] = lang('options');
		}
		
		# so we can create additional tabs for the content blocks
		# (depends on the param "page_tab")
		$this->pageTabs = array('main');
		if( check_permission(get_userid(), 'Manage All Content') ) {
			$this->pageTabs[] = 'options';
		}
		$this->GetContentBlocks();
		foreach($this->contentBlocks as $blockInfo) {
			if(!in_array($blockInfo['page_tab'], $this->pageTabs) && $blockInfo['page_tab'] != '') {
				$res[] = ucwords($blockInfo['page_tab']);
				$this->pageTabs[] = $blockInfo['page_tab'];
			}
		}
		
		return $res;
	}
	
	function FillParams($params) {
		global $gCms;
		parent::FillParams($params);
		require(cms_join_path(dirname(__FILE__), 'inc', 'function.fillParams.inc.php'));
	}
	
	function EditAsArray($adding = false, $tab = 0, $showadmin = false) {
		$this->GetContentBlocks();
		$ret = array();
		
		// basic attributes
		if($tab == 0 || ($tab == 1 && check_permission(get_userid(), 'Manage All Content'))) {
			$tmp = $this->display_attributes($adding, $tab);
			if( !empty($tmp) ) {
				foreach( $tmp as $one ) {
					$ret[] = $one;
				}
			}
		}
		
		global $gCms;
		require(cms_join_path(dirname(__FILE__), 'inc', 'function.displayContentBlocks.inc.php'));
		
		return $ret;
	}
	
	function ValidateData() {
		$errors = parent::ValidateData();
		if( $errors === FALSE ){
			$errors = array();
		}
		
		if ($this->mTemplateId <= 0 ) {
			$errors[] = lang('nofieldgiven', array(lang('template')));
			$result   = false;
		}
		
		#if ($this->GetPropertyValue('content_en') == '') {
		#	$errors[] = lang('nofieldgiven', array(lang('content')));
		#	$result   = false;
		#}
		if ($this->GetPropertyValue('use_expire_date') == '1' && $this->GetPropertyValue('end_date') <= $this->GetPropertyValue('start_date')) {
			$this->GetModule();
			$errors[] = $this->module->lang('error_expiredate');
			$result   = false;
		}
		
		return (count($errors) > 0?$errors:FALSE);
	}
	
	function ContentPreRender($tplSource) {
		// check for additional content blocks
		$this->GetContentBlocks();
		return $tplSource;
	}
	
	function display_single_element($one, $adding) {
		global $gCms;
		return require(cms_join_path(dirname(__FILE__), 'inc', 'function.displaySingleElement.inc.php'));
	}

/**
 * -----------------------------------------------------------------------------
 * Custom functions
 * -----------------------------------------------------------------------------
 */
	
	
	/**
	 * function GetContentBlocks()
	 * not part of the module api
	 * gets all content blocks that are defined in template
	 *
	 * @return bool
	 */
	function GetContentBlocks() {
		if ($this->contentBlocksLoaded) return true;
		
		global $gCms;
		require(cms_join_path(dirname(__FILE__), 'inc', 'function.getContentBlocks.inc.php'));
		
		return $this->contentBlocksLoaded;
	}
	
	
	/**
	 * function DoSmarty($data)
	 * not part of the module api
	 * this is just a wrapper to process a template from data
	 *
	 * @param string $data - The template content to process
	 *
	 * @return string - The processed template data
	 */
	function DoSmarty($data) {
		global $gCms;
		// only process smarty there is actually something to process
		if(!is_array($data) && !is_object($data) && preg_match_all('/:::([^:]+):::/', $data, $matches)) {
			
			$this->GetModule();
			// only do this if we did not do this before
			if(!isset($gCms->variables['pageinfo']->content_id)) {
				// fake frontend rendering
				$gCms->variables['pageinfo']                              = new stdClass();
				$gCms->variables['pageinfo']->content_id                  = $this->mId;
				$gCms->variables['pageinfo']->content_title               = $this->mName;
				$gCms->variables['pageinfo']->content_alias               = $this->mAlias;
				$gCms->variables['pageinfo']->content_menutext            = $this->mMenuText;
				$gCms->variables['pageinfo']->content_titleattribute      = $this->mTitleAttribute;
				$gCms->variables['pageinfo']->content_hierarchy           = $this->mHierarchy;
				$gCms->variables['pageinfo']->content_id_hierarchy        = $this->mIdHierarchy;
				$gCms->variables['pageinfo']->content_type                = $this->mType;
				$gCms->variables['pageinfo']->content_props               = $this->mProperties->mPropertyNames;
				$gCms->variables['pageinfo']->content_metadata            = $this->mMetadata;
				$gCms->variables['pageinfo']->content_modified_date       = $this->mModifiedDate;
				$gCms->variables['pageinfo']->content_created_date        = $this->mCreationDate;
				$gCms->variables['pageinfo']->content_last_modified_date  = $this->mModifiedDate;
				$gCms->variables['pageinfo']->content_last_modified_by_id = $this->mOwner;
				$gCms->variables['pageinfo']->template_id                 = $this->mTemplateId;
				$gCms->variables['pageinfo']->template_encoding           = get_encoding('');
				$gCms->variables['pageinfo']->template_modified_date      = time(); // ???
				$gCms->variables['pageinfo']->cachable                    = $this->mCachable;
				$gCms->variables['pageinfo']->content_hierarchy_path      = $this->mHierarchyPath;
				
				$gCms->variables['content_id']                            = $this->mId;
				$gCms->variables['page']                                  = $this->mAlias;
				$gCms->variables['page_id']                               = $this->mAlias;
				$gCms->variables['page_alias']                            = $this->mAlias;
				$gCms->variables['content_alias']                         = $this->mAlias;
				$gCms->variables['page_name']                             = $this->mAlias;
				$gCms->variables['position']                              = $this->mHierarchy;
				$gCms->variables['friendly_position']                     = ContentOperations::CreateFriendlyHierarchyPosition($this->mHierarchy);
				
				$this->module->smarty->assign('content_id', $this->mId);
				$this->module->smarty->assign('content_alias', $this->mAlias);
				$this->module->smarty->assign('page', $this->mAlias);
				$this->module->smarty->assign('page_id', $this->mAlias);
				$this->module->smarty->assign('page_alias', $this->mAlias);
				$this->module->smarty->assign('page_name', $this->mAlias);
				$this->module->smarty->assign('position', $this->mHierarchy);
				$this->module->smarty->assign('friendly_position', ContentOperations::CreateFriendlyHierarchyPosition($this->mHierarchy));
			}
			$data = $this->module->ProcessTemplateFromData(preg_replace('/:::([^:]+):::/', '{$1}', $data));
		}
		return $data;
	}
	
	
	/**
	 * function InheritParentProp($parentId, $propName, $currentProp)
	 * not part of the module api
	 * inherits a property of a parent page;
	 * if parent page has also selected inheritance for that property -> do recursion
	 *
	 * @param int $parentId - The id of the parent page
	 * @param string $propName - The name of the property to inherit
	 * @param array $currentProp (optional) - If prop is an array this will be the items of the current page; So return array will contain all items of the current page and parent pages; otherwise only the parents items will be returned
	 *
	 * @return array|string - The prop of the last found parent that has no inheritance or an array of items of all parents that have inheritance
	 */
	function InheritParentProp($parentId, $propName, $currentProp = array()) {
		
		// default return value
		// feu_access is a special case (because of multiple selections are possible)
		if($propName == 'feu_access') {
			$prop = array();
			
			// this will "merge" the parents prop with the current one
			// but removing the inherit stuff; 
			// so if currentProp is set this will return an array with all props 
			// (real values only; no inherit flag)
			// including the parents ones and the current one but without duplicate values
			foreach($currentProp as $k=>$v) {
				if($v != '-1')
					$prop[] = $v;
			}
		}
		else
			$prop = '';
		
		// as long as page has parents...
		while( $parentId > 0 ) {
			
			$content = $this->GetContentProp($parentId, $propName, 'content2');
			
			if(!$content)
				return $prop;
			
			$parentId  = $content['parent_id'];
			$propValue = $content['prop_value'];
			
			// feu_access is a special case (because of multiple selections are possible)
			if($propName == 'feu_access') {
				
				$_prop = explode(";", $propValue);
				
				foreach($_prop as $_p) {
					if(!in_array($_p, $prop) && $_p != '-1' && $_p != '') 
						$prop[] = $_p;
				}
				
				// if the current obj does not inherit its prop anymore OR has no parents 
				// but wants to inherit -> return the prop array
				if(!in_array('-1', $_prop) || ($parentId <= 0 && in_array('-1', $_prop))) 
					return $prop;
				
			}
			else {
				
				// if content has no parents but wants to inherit -> return
				if($parentId <= 0 && $propValue == '-1') {
					return;
				}
				// if no inheritance anymore -> return the prop
				else if($propertyValue != '-1') {
					return $propValue;
				}
			}
		}
	}
	
	
	/**
	 * function CreateRedirectDropdown()
	 * not part of the module api
	 * this creates a dropdown of pages including only pages of type content but
	 * excluding the current page and pages that may only be accessed by frontend users
	 *
	 * @return string - HTML select element with options
	 */
	function CreateRedirectDropdown($adding) {
		global $gCms;
		
		$db = $gCms->GetDb();
		$redirectPage = '';
		if(!$adding)
			$redirectPage = $this->GetPropertyValue("redirect_page");
		
		$query = "SELECT C.active, C.type, C.content_id, C.hierarchy, C.menu_text, CP.content FROM " . cms_db_prefix() . "content C 
			LEFT JOIN " . cms_db_prefix() . "content_props CP ON CP.content_id = C.content_id AND CP.prop_name = ? 
			ORDER BY hierarchy";
		
		$dbresult = $db->Execute($query, array('feu_access'));
		$pages    = '';
		
		$dropdown = '<select name="redirect_page" >';
		$dropdown .= '<option value=""' . ($redirectPage == ''?' selected="selected"':'') . '>' . lang('none') . '</option>';
		$dropdown .= '<option value="-1"' . ($redirectPage == '-1'?' selected="selected"':'') . '>' . $this->lang('inherit_from_parent') . '</option>';
		
		while($dbresult && $row = $dbresult->FetchRow()) {
			
			$disabled = '';
			// don't redirect to pages with no public access, invalid content type, inactive or same content id
			if($row['active'] != 1 || $row['content']>0 || $row['content_id'] == $this->mId || ($row['type'] != 'content' && $row['type'] != 'content2'))
				$disabled = ' disabled="disabled"';
			
			$dropdown .= '<option'. $disabled .' value="' . $row['content_id'] . '" ' . 
				($redirectPage == $row['content_id'] && $disabled == ''?'selected="selected"':'') . '>' . 
				ContentOperations::CreateFriendlyHierarchyPosition($row['hierarchy']) . 
				' - ' . $row['menu_text'] . ($disabled != ''?' (' . $this->module->lang('invalid') . ')':'') . '</option>';
		}
		$dropdown .= '</select>';
		
		return $dropdown;
	}
	
	
	/**
	 * function GetContentProp()
	 * not part of the module api
	 * gets a property of a content page
	 *
	 * @param int $contentId - The id of the content to get the property from
	 * @param string $propName - The name of the property to get the value from
	 * @param string $contentType (optional) - The type of the content
	 *
	 * @return bool|array - False if not exists or array('parent_id','prop_value')
	 *
	 */
	function GetContentProp($contentId, $propName, $contentType = '') {
		global $gCms;
		$db =& $gCms->GetDb();
		$query = "SELECT CP.content, C.parent_id, C.content_alias FROM " . cms_db_prefix() . "content_props CP 
			LEFT JOIN " . cms_db_prefix() . "content C ON C.content_id = CP.content_id 
			WHERE CP.content_id = ? AND CP.prop_name = ?";
		$p = array($contentId, $propName);
		if($contentType != '') {
			$query .= " AND C.type = ?";
			$p[]    = $contentType;
		}
		$query .= " LIMIT 1";
		$dbresult = $db->Execute($query, $p);
		if($dbresult && $row = $dbresult->FetchRow())
			return array('parent_id'=>$row['parent_id'], 'prop_value'=>$row['content'], 'alias'=>$row['alias']);
		
		return false;
	}
	
	
	/**
	 * function GetModule()
	 * not part of the module api
	 * gets the module instance
	 */
	function GetModule() {
		if(!is_object($this->module)) {
			$module       =& $this->GetModuleInstance();
			$this->module =& $module->GetModuleInstance('AdvancedContent');
		}
	}
	
	
	/**
	 * function SortContentBlocks()
	 * not part of the module api
	 * simple sorting function
	 * sorts the content blocks by sequence attribute that is given in FillParams()
	 * this is only important for content blocks that are not defined in template
	 */
	function SortContentBlocks() {
		$_contentBlocks = array();
		foreach($this->contentBlocks as $blockInfo) {
			$_contentBlocks['number_'.$blockInfo['sequence']] = $blockInfo;
		}
		$this->contentBlocks = array();
		ksort($_contentBlocks);
		reset($_contentBlocks);
		foreach($_contentBlocks as $blockInfo) {
			$this->contentBlocks[$blockInfo['block_id']] = $blockInfo;
		}
	}
	
	
	function DisplayBlockOptions($blockId, $adding = false) {
		
		global $gCms;
		$blockOptions = '';
		if($this->contentBlocks[$blockId]['save_db']) {
			require(cms_join_path(dirname(__FILE__), 'inc', 'function.displayBlockOptions.inc.php'));
		}
		return $blockOptions;
	}
	
	
	function GetGroups() {
		global $gCms;
		$db =& $gCms->GetDb();
		$groups = array();
		$query = "SELECT group_id FROM ".cms_db_prefix()."user_groups WHERE user_id = ?";
		$dbresult = $db->Execute($query, array(get_userid()));
		while( $dbresult && $row = $dbresult->FetchRow() ) {
			$groups[] = $row['group_id'] * -1;
		}
		return $groups;
	}
	
}
?>
