<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          This file is a modification of the TinyMCE filepicker that comes by 
#          default with CMSms
# Version: 0.3.4
# File   : action.filePicker.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if(!isset($gCms)) exit;

//make sure that this action only can be accessed when logged in in backend
global $CMS_ADMIN_PAGE;
if(!isset($CMS_ADMIN_PAGE) || $CMS_ADMIN_PAGE !== 1)
	exit;

require_once(cms_join_path(dirname(__FILE__), 'inc', 'class.filePicker.inc.php'));

// ToDo: Check Permission?

if(!isset($params['picker_id']) || $params['picker_id']=='')
	exit;
else
	$pickerId = trim($params['picker_id']);

$filePickerstyle = $this->GetPreference('filepickerstyle','both');

$type = 'image';
if(isset($params['type']))
	$type = $params['type'];

if($type == 'image') {
	$rootPath = $gCms->config['image_uploads_path'];
	$rootUrl  = $gCms->config['image_uploads_url'];
	$isImage  = true;
	$fileExt  = array('jpg','jpeg','gif','png','tif','tiff');
}
else {
	$fileExt = array();
	$rootPath = $gCms->config['uploads_path'];
	$rootUrl  = $gCms->config['uploads_url'];
	$isImage  = false;
}

$startDir = '';
if(isset($params['startdir']) && $params['startdir'] != '') {
	$startDir = $params['startdir'];
	$rootPath = $rootPath . DIRECTORY_SEPARATOR . str_replace('/', DIRECTORY_SEPARATOR, $startDir);
	$rootUrl  = $rootUrl . '/' . $startDir;
}

$allowNone = true;
if(isset($params['allow_none']) && (strtolower($params['allow_none']) == 'false' || $params['allow_none'] == false))
	$allowNone = false;

$dropdown = false;
if(isset($params['dropdown']) && ($params['dropdown'] == '1' || $params['dropdown'] == 'true'))
	$dropdown = true;

if(isset($params['file_extensions']) && !empty($params['file_extensions'])) {
	$_fileExt = explode(',',$params['file_extensions']);
	if($type == 'image')
		$_fileExt = array_intersect($_fileExt, $fileExt);
	if(empty($_fileExt) || (count($_fileExt) == 1 && $_fileExt[0] == ''))
		$_fileExt = $fileExt;
	
	$fileExt = $_fileExt;
}

$filePrefixes = array();
$filter       = '';
if(isset($params['filter']) && trim($params['filter']) != '') {
	$filePrefixes = explode(',', str_ireplace(array('exclude:','include:'), '', $params['filter']));
	if(startswith($params['filter'], 'exclude:') && !empty($filePrefixes))
		$filter = 'exclude';
	else if(startswith($params['filter'], 'include:') && !empty($filePrefixes))
		$filter = 'include';
}

$showSubDirs = false;
if(isset($params['show_subdirs']) && ($params['show_subdirs'] == true || $params['show_subdirs'] == 'true'))
	$showSubDirs = true;

if (($this->GetPreference('restrictdirs', 0) == 1)) {
	$username = $gCms->variables['username'];
	
	$rootPath .= DIRECTORY_SEPARATOR . $username;
	$rootUrl .= '/' . $username;
	@mkdir($rootPath);
	
}

$subDir = '';
if (isset($params['subdir']))
	#$subDir = str_replace('.','',trim($params['subdir'], '/'));
	$subDir = trim(preg_replace('/(\/\.)|(\.\/)|(\/?\.\.\/?)/','',trim($params['subdir'], '/')),'.');

$thisDir = $rootPath . DIRECTORY_SEPARATOR;
if ($subDir != '')
	$thisDir .= str_replace('/', DIRECTORY_SEPARATOR, $subDir) . DIRECTORY_SEPARATOR;

$thisUrl = $rootUrl . '/';
if ($subDir != '') 
	$thisUrl .= $subDir . '/';

if(file_exists($thisDir)) {

	$fmallowed = $this->CheckPermission('Modify Files');
	$showfm    = $this->GetPreference('showfilemanagement', 0);
	$upload    = $this->CheckPermission('Modify Files');
	if(isset($params['upload']) && $params['upload'] == true) {
		$upload = true;
	}
	
	$usefm = (($fmallowed || $upload) && $showfm);
	
	//Handle File upload and dir creation
	if ($usefm) {
		if (isset($params['upload_file'])) {
			if (isset($_FILES[$id.'newfile'])) {
				//CHeck for uploaded file
				if ($_FILES[$id.'newfile']['name'] != '') {
					
					// get mime type
					if(!$mimeType = $filePicker->GetMimeType($_FILES[$id.'newfile']['tmp_name'],$this->GetPreference('use_mime',1)))
						$mimeType = $_FILES[$id.'newfile']['type'];
					
					//check filename
					if ($filePicker->ContainsIllegalChars($_FILES[$id.'newfile']['name'])) {
						$errorMessage = $this->Lang('containsillegalchars');
					} 
					else if (($_FILES[$id.'newfile']['size']>$config['max_upload_size'])
					|| ($_FILES[$id.'newfile']['error'] == 1)) {
						$errorMessage = $this->Lang('containsillegalchars', $this->Lang('filetoobig'));
					}
					else if($type == 'image' && !in_array(str_replace('image/','',$mimeType),$fileExt)) {
						$errorMessage = $this->Lang('noimagefile') . '<br />' . $mimeType;;
					}
					else if($type != 'image' && !empty($fileExt) && !in_array(strtolower(substr($_FILES[$id.'newfile']['name'], strrpos($_FILES[$id.'newfile']['name'], '.') + 1)),$fileExt)) {
						$errorMessage = $this->Lang('filetypenotallowed') . '<br />' . $mimeType;
					}
					else {
						$filename = $filePicker->Slash($thisDir, $_FILES[$id.'newfile']['name']);
						if (isset($params['resize_on']) && is_numeric($params['resize_x']) && is_numeric($params['resize_y'])) {
							if ($filePicker->HandleFileResizing($_FILES[$id.'newfile']['tmp_name'], $filename,$params['resize_x'], $params['resize_y'],false,$params['keep_aspectratio'],$this->GetPreference('allowupscaling',0))) {
								if ($this->GetPreference('makethumbnail',0)==1) {
									$thumbname = $filePicker->Slash($thisDir,"thumb_".$_FILES[$id.'newfile']['name']);
									$filePicker->HandleFileResizing($filename,$thumbname,get_site_preference('thumbnail_width',96),get_site_preference('thumbnail_height',96));
								}
								$message = $this->Lang('fileuploaded');
							} else {
								$errorMessage = $this->Lang('uploadfailed');
							}
						} else {
							if (cms_move_uploaded_file($_FILES[$id.'newfile']['tmp_name'], $filename)) {
								if ($this->GetPreference('makethumbnail',0)==1) {
									$thumbname = $filePicker->Slash($thisDir,"thumb_".$_FILES[$id.'newfile']['name']);
									$filePicker->HandleFileResizing($filename,$thumbname,get_site_preference('thumbnail_width',96),get_site_preference('thumbnail_height',96));
								}
								$message = $this->Lang('fileuploaded');
							} else {
								$errorMessage = $this->Lang('uploadfailed');
							}
						}
					}
				} else {
					$errorMessage = $this->Lang('nofile');
				}
			} else {
				//This shouldn't happen
				$errorMessage = $this->Lang('nofile');
			}
		}
		
		if (isset($params['create_dir']) && $fmallowed) {
			
			if (isset($params['newdir']) && $params['newdir']!='') {
				$newdir = $filePicker->Slash($thisDir, $params['newdir']);
				if (!is_dir($newdir)) {
					if (mkdir($newdir)) {
						$message = $this->Lang('newdircreated');
					} else {
						$errorMessage = $this->Lang('newdirfailed');
					}
				} else {
					$errorMessage = $this->Lang('direxists');
				}
			} else {
				$errorMessage = $this->Lang('nodirname');
			}
		}
		if (isset($params['deletefilename']) && $fmallowed) {
			$filename = $filePicker->Slash($thisDir, base64_decode($params['deletefilename']));
			if (@unlink($filename)) {
				@unlink($filePicker->Slash($thisDir, 'thumb_'.base64_decode($params['deletefilename'])));
				$message = base64_decode($params['deletefilename']) . ' ' . $this->Lang('deletefilesuccess');
			} else {
				$errorMessage = base64_decode($params['deletefilename']) . ' ' . $this->Lang('deletefilefailed');
			}
		}
		if (isset($params['deletesubdir']) && $fmallowed) {
			$filename = $filePicker->Slash($thisDir, base64_decode($params['deletesubdir']));
			if (@rmdir($filename)) {
				$message = base64_decode($params['deletesubdir']) . ' ' . $this->Lang('deletesubdirsuccess');
			} else {
				$errorMessage = base64_decode($params['deletesubdir']) . ' ' . $this->Lang('deletesubdirfailed');
			}
		}
	}
	if(!$dropdown) {
		$fileManager = $this->GetModuleInstance('FileManager');
		
		$files = Array();
		$d = dir($thisDir);
		while ($entry = $d->read()) {
			
			if ($entry[0] == '.') continue;
			
			$skip         = false;
			$includeThumb = false;
			if($filter != '' && !empty($filePrefixes)) {
				foreach($filePrefixes as $prefix) {
					if(startswith($prefix,'thumb_') && $filter == 'include') {
						$includeThumb = true;
					}
					if((startswith($entry,$prefix) && $filter == 'exclude')
					|| (!startswith($entry,$prefix) && $filter == 'include')) {
						$skip = true;
						break;
					}
				}
				if($skip) continue;
			}
			if(startswith($entry,'thumb_') && !$this->GetPreference('showthumbnailfiles',0) && !$includeThumb) {
				continue;
			}
			$isDir    = is_dir($thisDir.$entry);
			$fExt     = strtolower(substr(strrchr($entry, "."), 1));
			if(!$mimeType = $filePicker->GetMimeType($thisDir.$entry,$this->GetPreference('use_mime',1)))
				$mimeType = $fExt;
			
			if (!$isDir && $type=='image' && !in_array(str_replace('image/','',$mimeType),$fileExt)) {
				continue;
			}
			else if(!$isDir && $type!='image' && !in_array($fExt,$fileExt) && !empty($fileExt)) {
				continue;
			}
			
			
			$file             = array();
			$file['name']     = $entry;
			$file['isimage']  = false;
			if(startswith($mimeType,'image')) {
				$file['isimage'] = true;
			}
			$file['fullpath'] = $thisDir.$entry;
			$file['fullurl']  = $thisUrl.rawurlencode($entry);
			$file['ext']      = $fExt;
			$file['isdir']    = $isDir;
			$file['type']     = $mimeType;
			
			if (!$file['isdir']) {
				
				if($file['isimage']) {
					if ($filePickerstyle != 'filename') {
						if ($this->GetPreference('showthumbnailfiles',0) || $includeThumb) {
							$file['thumbnail'] = $filePicker->GetThumbnail(str_replace('thumb_', '', $entry), $thisDir, trim($thisUrl,'/'), $this->GetPreference('makethumbnail',0));
						} else {
							$file['thumbnail'] = $filePicker->GetThumbnail($entry, $thisDir, trim($thisUrl,'/'), $this->GetPreference('makethumbnail',0));
						}
						if ($file['thumbnail'] == '') {
							$file['thumbnail'] = $fileManager->GetFileIcon($file['ext'], $file['isdir']);
						}
					}
					else
						$file['thumbnail'] = $fileManager->GetFileIcon($file['ext'], $file['isdir']);
					
					$imgsize = @getimagesize($file['fullpath']);
					if ($imgsize) {
						$file['dimensions'] = $imgsize[0] . ' x ' . $imgsize[1];
					} else {
						$file['dimensions'] = '&nbsp;';
					}
				}
			}
			
			if ($fileManager) {
				$file['fileicon'] = $fileManager->GetFileIcon($file['ext'], $file['isdir']);
				if($file['isimage'] && $file['thumbnail'] == '')
					$file['thumbnail'] = $file['fileicon'];
			}
			
			
			if (!$file['isdir']) {
				$info = @stat($file['fullpath']);
				if ($info) {
					$file['size'] = $info['size'];
				}
			}
			$files[] = $file;
		}
		$d->close();
		usort($files, array($filePicker, 'SortFiles'));
		
		$showFiles = array();
		
		if ($subDir != '') {
			$onerow             = new stdClass();
			$onerow->isdir      = '1';
			$onerow->thumbnail  = '';
			$onerow->dimensions = '';
			$onerow->size       = '';
			$newSubDir          = dirname($subDir);
			$onerow->namelink   = $this->CreateLink($id, 'filePicker', $returnid,'[..]', 
				array('disable_theme'=>true, 'type'=>$type, 'subdir'=>$newSubDir, 'show_subdirs'=>$showSubDirs, 'startdir'=>$startDir,'picker_id'=>$pickerId, 'upload'=>$upload, 'filter'=>$filter.':'.implode(',',$filePrefixes), 'file_extensions'=>implode(',',$fileExt)),'','','','onclick="return getDir(this.href)"');
			array_push($showFiles, $onerow);
		}
		
		$fileCount = 0;
		$dirCount = 0;
		foreach($files as $file) {
			
			if ($file['isdir'] && !$showSubDirs)
				continue;
			
			$onerow = new stdClass();
			$onerow->name = $file['name'];
			$onerow->fileicon = $file['fileicon'];
			if ($file['isdir']) {
				$onerow->isdir = '1';
				$onerow->namelink = $this->CreateLink($id, 'filePicker', $returnid, '[' . $file['name'] . ']', 
					array('disable_theme'=>true, 'type'=>$type, 'startdir'=>$startDir, 'show_subdirs'=>$showSubDirs, 'subdir'=>$subDir . '/' . $file['name'], 'picker_id'=>$pickerId, 'upload'=>$upload,'filter'=>$filter.':'.implode(',',$filePrefixes), 'file_extensions'=>implode(',',$fileExt)),'','','','onclick="return getDir(this.href)"');
				if ($filePicker->IsDirEmpty($filePicker->Slash($thisDir, $file['name']))) {
					if ($usefm && $fmallowed) {
						$onerow->deletelink = $this->CreateLink($id, 'filePicker', $returnid, $fileManager->GetActionIcon('delete'), 
							array('disable_theme'=>true, 'type'=>$type, 
								'startdir'=>$startDir, 
								'show_subdirs'=>$showSubDirs, 
								'deletesubdir'=>base64_encode($file['name']), 
								'subdir'=>$subDir, 'picker_id'=>$pickerId, 
								'upload'=>$upload),
							'','','','onclick="return deleteFile(this.href, \''.$this->lang('confirmdeletedir',$file['name']).'\')"');
					}
				}
				$dirCount++;
			}
			else {
				$onerow->type = $file['type'];
				$onerow->isdir = '0';
				$onerow->isimage = $file['isimage'];
				if (isset($file['thumbnail'])) $onerow->thumbnail = $file['thumbnail'];
					$onerow->fullurl = $file['fullurl'];
				if (isset($file['dimensions'])) {
					$onerow->dimensions = $file['dimensions'];
				} 
				else {
					$onerow->dimensions = '&nbsp;';
				}
				if ($usefm && $fmallowed) {
					$onerow->deletelink = $this->CreateLink($id, 'filePicker', $returnid, $fileManager->GetActionIcon('delete'), 
							array('disable_theme'=>true, 'type'=>$type, 
								'startdir'=>$startDir, 
								'show_subdirs'=>$showSubDirs, 
								'deletefilename'=>base64_encode($file['name']), 
								'subdir'=>$subDir, 'picker_id'=>$pickerId, 
								'upload'=>$upload),
							'','','','onclick="return deleteFile(this.href, \''.$this->lang('confirmdelete',$file['name']).'\')"');
				}
				$i = 0;
				$unit = ' B';
				while($file['size'] > 1024) {
					$i++;
					$file['size'] = $file['size']/1024;
				}
				switch($i) {
					case '1': $unit = ' KB'; break;
					case '2': $unit = ' MB'; break;
					case '3': $unit = ' TB'; break;
				}
				$file['size'] = number_format($file['size'], ($i>0?2:0), $this->lang('decimaldelimiter'), $this->lang('thousanddelimiter'));
				$onerow->size = $file['size'] . $unit;
				$fileCount++;
			}
			array_push($showFiles, $onerow);
		}
		
		$this->smarty->assign('dirCount', $dirCount);
		$this->smarty->assign('fileCount', $fileCount);
		
		$this->smarty->assign('sizetext', $this->Lang('size'));
		$this->smarty->assign('dimensionstext', $this->Lang('dimensions'));
		$this->smarty->assign('delete', ($usefm && $fmallowed));
		$this->smarty->assign('upload', $upload);
		$this->smarty->assign('newdir', ($usefm && $showSubDirs && $fmallowed));
		
		$breadCrumbs = explode('/', $subDir);
		$_subDir = '';
		foreach($breadCrumbs as $k => $v) {
			$_subDir .= '/' . $v;
			if(trim($_subDir,'/') != $subDir) {
				$breadCrumbs[$k] = $this->CreateLink($id, 'filePicker', $returnid, $v, 
					array('disable_theme'=>true, 
						'type'=>$type, 
						'startdir'=>$startDir, 
						'show_subdirs'=>$showSubDirs, 
						'subdir'=> trim($_subDir,'/'),
						'picker_id'=>$pickerId, 
						'upload'=>$upload,
						'filter'=>$filter.':'.implode(',',$filePrefixes), 
						'file_extensions'=>implode(',',$fileExt))
					,'','','','onclick="return getDir(this.href)"');
			}
			
		}
		$this->smarty->assign('breadCrumbs', implode('/',$breadCrumbs));
		$this->smarty->assign('root', $this->CreateLink($id, 'filePicker', $returnid, 'root', 
				array('disable_theme'=>true, 
					'type'=>$type, 
					'startdir'=>$startDir, 
					'show_subdirs'=>$showSubDirs, 
					'subdir'=> '',
					'picker_id'=>$pickerId, 
					'upload'=>$upload,
					'filter'=>$filter.':'.implode(',',$filePrefixes), 
					'file_extensions'=>implode(',',$fileExt)),
				'',true,'','onclick="return getDir(this.href)"'));
		
		$this->smarty->assign('pickerId', $pickerId);
		$this->smarty->assign('filepickerstyle', $filePickerstyle);
		$this->smarty->assign('filePickertitle', $this->Lang('filePickertitle'));
		$this->smarty->assign('youareintext', $this->Lang('youareintext'));
		$this->smarty->assign('isimage', $isImage);
		$this->smarty->assign('subDir', $subDir);
		$this->smarty->assign_by_ref('files', $showFiles);
		$this->smarty->assign('filesCount', count($showFiles));
	}
	if ($usefm) {
		if(($dropdown && !isset($params['upload_file'])) || !$dropdown) {
			$this->smarty->assign('successtext', $this->Lang('success'));
			$this->smarty->assign('errortext', $this->Lang('error'));
			$this->smarty->assign('securityfield', $this->CreateInputHidden('', CMS_SECURE_PARAM_NAME, $_SESSION[CMS_USER_KEY]));
			
			$this->smarty->assign('fileoperations', $this->Lang('fileoperations'));
			
			$controlDisplay = get_preference(get_userid(),'file_operations_display',1);
			$this->smarty->assign('fileOperationsDisplay', $controlDisplay);
			$prefUrl        = $this->CreateLink($id, 'savePrefs', $returnid, $this->lang('toggle_fileoperations'), 
				array('toggle'=>'fileoperations',
					'disable_theme'=>true, 
					'ajax'=>true),
				'',true);
			$this->smarty->assign('prefUrl', $prefUrl);
			
			$this->smarty->assign('formstart', $this->CreateFormStart($id, 'filePicker', 
				$returnid, 'post', 'multipart/form-data', false, '', 
				array('picker_id'=>$pickerId,
					'type'=>$type,
					'startdir'=>$startDir,
					'file_extensions' => implode(',',$fileExt),
					'filter' => $filter.':'.implode(',',$filePrefixes),
					'show_subdirs'=>$showSubDirs,
					'subdir'=>$subDir, 
					'upload'=>$upload,
					'disable_theme'=>true,
					'dropdown'=>$dropdown,
					'allow_none'=>$allowNone)));
			
			$this->smarty->assign('fileuploadtext', $this->Lang('uploadnewfile'));
			
			$this->smarty->assign('fileuploadinput', $this->CreateInputFile($id, 'newfile', 'id="'.$pickerId.'_FileUpload"', 20));
			
			$targetId = 'AdvancedContentFilePickerContent';
			$autoClosePanel = false;
			$messageId = '';
			if($dropdown) {
				$messageId = 'Edit_Content_Result';
				$autoClosePanel = true;
				$targetId = $pickerId.'_DropdownWrapper';
			}
			
			$this->smarty->assign('fileuploadsubmit', $this->CreateInputSubmit($id, 'upload_file', $this->Lang('uploadfile'), 'onClick="return submitForm(this,\''.$targetId.'\',\''.$messageId.'\',\''.$autoClosePanel.'\')"'));
			if($showSubDirs && $fmallowed) {
				$this->smarty->assign('newdirtext', $this->Lang('createnewdir'));
				$this->smarty->assign('newdirinput', $this->CreateInputText($id, 'newdir', '', 20, 255, 'id="'.$pickerId.'_CreateDir"'));
				$this->smarty->assign('newdirsubmit', $this->CreateInputSubmit($id, 'create_dir', $this->Lang('createdir'), 'onClick="return submitForm(this,\'AdvancedContentFilePickerContent\')"'));
			}
			if ($this->GetPreference('allowscaling') == '1') {
				$this->smarty->assign('resizeto', $this->Lang('resizeto'));
				$this->smarty->assign('resize_x', $this->CreateInputText($id, 'resize_x', $this->GetPreference('scalingwidth'), 4, 4));
				$this->smarty->assign('resize_y', $this->CreateInputText($id, 'resize_y', $this->GetPreference('scalingheight'), 4, 4));
				$this->smarty->assign('resize_on', $this->CreateInputCheckbox($id, 'resize_on', '1'));
				$this->smarty->assign('keepaspectratio_text', $this->Lang('keepaspectratio'));
				$this->smarty->assign('keepaspectratio_input', 
					$this->CreateInputHidden($id,'keep_aspectratio',0).
					$this->CreateInputCheckbox($id, 'keep_aspectratio', '1',1));
			}
			$this->smarty->assign('formend', $this->CreateFormEnd());
			
			$this->smarty->assign('moduleId', $id);
			$this->smarty->assign('fpHeight', $this->GetPreference('filepickerheight',0));
			$this->smarty->assign('fpWidth', $this->GetPreference('filepickerwidth',0));
			$this->smarty->assign('fpWidthUnit', $this->GetPreference('filepickerwidthunit','px'));
			$this->smarty->assign('fpHeightUnit', $this->GetPreference('filepickerheightunit','px'));
		}
		else {
			$error = false;
			header('Content-Type: text/xml');
			print '<?xml version="1.0" encoding="UTF-8"?>';
			print '<response>';
			print '<message>';
			if(isset($errorMessage)) {
				$error = true;
				print '<![CDATA[<div class="pageerrorcontainer"><ul class="pageerror"><li>'.$errorMessage.'</li></ul></div>]]>';
			}
			if(isset($message)) {
				print '<![CDATA[<div class="pagemcontainer"><p class="pagemessage">'.$message.'</p></div>]]>';
			}
			print '</message>';
			#if(!$error) {
				print '<result>';
				if($type == 'image') {
					print '<![CDATA['.str_ireplace('<select', 
						'<select id="'.$pickerId.'_AdvancedContentFilePickerInput" onchange="toggleImage(\'#' . $pickerId . '_AdvancedContentFilePickerImage\',this.value)" ', 
						create_file_dropdown($pickerId, 
							$thisDir, 
							'', 
							implode(',',$fileExt),
							trim($thisUrl,'/'), 
							$allowNone, 
							'',
							implode(',',$filePrefixes), 
							($filter=='exclude'?1:0))).
					']]>';
				}
				else {
					print '<![CDATA['.create_file_dropdown($pickerId, $thisDir, '', implode(',',$fileExt),
						trim($thisUrl,'/'), $allowNone, '',implode(',',$filePrefixes), ($filter=='exclude'?1:0)).']]>';
				}
				print '</result>';
			#}
			print '</response>';
			exit;
		}
	}
} 
else {
	$this->smarty->assign('errortext', $this->Lang('error'));
	$this->smarty->assign('errorMessage', $this->Lang('dirnotfound',$thisDir));
}
if(isset($errorMessage))
	$this->smarty->assign('errorMessage', $errorMessage);
if(isset($message))
	$this->smarty->assign('message', $message);

$this->smarty->assign('dropdown',$dropdown);
$this->smarty->assign('type', $type);

header('Content-Type: text/xml');
print '<?xml version="1.0" encoding="UTF-8"?>';
print '<response>';
print '<result>';
print '<![CDATA[' . $this->ProcessTemplate('filePicker.tpl') . ']]>';
print '</result>';
print '</response>';
exit;

?>