<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
# Version: 0.3.4
# File   : action.defaultadmin.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if(!isset($gCms)) exit;

$this->smarty->assign('startform', $this->CreateFormStart($id, 
	'savePrefs', $returnid,'post','multipart/form-data'));

$this->smarty->assign('endform', $this->CreateFormEnd());
$this->smarty->assign('uninstallaction_text', $this->lang('uninstallaction'));

$this->smarty->assign('restrictdirs_text', $this->lang('restrictdirs'));
$this->smarty->assign('restrictdirs_input', 
	$this->CreateInputHidden($id,'restrictdirs',0) . 
	$this->CreateInputCheckbox($id, 'restrictdirs', '1', 
		$this->GetPreference('restrictdirs'), 'class="pagecheckbox"'));

$this->smarty->assign('showfilemanagement_text', 
	$this->lang('showfilemanagement'));
$this->smarty->assign('showfilemanagement_input',
	$this->CreateInputHidden($id,'showfilemanagement',0) .
	$this->CreateInputCheckbox($id, 'showfilemanagement', '1', 
		$this->GetPreference('showfilemanagement'), 'class="pagecheckbox"'));

$this->smarty->assign('showthumbnailfiles_text', 
	$this->lang('showthumbnailfiles'));
$this->smarty->assign('showthumbnailfiles_input', 
	$this->CreateInputHidden($id,'showthumbnailfiles',0) .
	$this->CreateInputCheckbox($id, 'showthumbnailfiles', '1', 
		$this->GetPreference('showthumbnailfiles'), 'class="pagecheckbox"'));

$this->smarty->assign('allowscaling_text', $this->lang('allowscaling'));
$this->smarty->assign('allowscaling_input', 
	$this->CreateInputHidden($id,'allowscaling',0) .
	$this->CreateInputCheckbox($id, 'allowscaling', '1', 
		$this->GetPreference('allowscaling'), 'class="pagecheckbox"'));

$this->smarty->assign('filepickerstyle_text', $this->lang('filepickerstyle'));
$filepickerstyles = array($this->Lang("filenameonly")=>"filename",
	$this->Lang('thumbnailsonly')=>'thumbnails',
	$this->Lang('filenameandthumbnails')=>'both');
$this->smarty->assign('filepickerstyle_input', 
	$this->CreateInputDropdown($id,'filepickerstyle',$filepickerstyles,0,
		$this->GetPreference('filepickerstyle')));

$this->smarty->assign('allowupscaling_text', $this->lang('allowupscaling'));
$this->smarty->assign('allowupscaling_input', 
	$this->CreateInputHidden($id,'allowupscaling',0) .
	$this->CreateInputCheckbox($id, 'allowupscaling', '1', 
		$this->GetPreference('allowupscaling',0), 'class="pagecheckbox"'));

$this->smarty->assign('makethumbnail_text', $this->lang('makethumbnail'));
$this->smarty->assign('makethumbnail_input', 
	$this->CreateInputHidden($id,'makethumbnail',0) .
	$this->CreateInputCheckbox($id, 'makethumbnail', '1', 
		$this->GetPreference('makethumbnail'), 'class="pagecheckbox"'));

$this->smarty->assign('defaultdimensions_text', $this->lang('defaultdimensions'));
$this->smarty->assign('filepickersettings_text', $this->lang('filepickersettings'));

$this->smarty->assign('filepickersize_text', $this->lang('filepickersize'));
$this->smarty->assign('filepickerwidth_input', 
	$this->CreateInputText($id, 'filepickerwidth', 
		$this->GetPreference('filepickerwidth'), 5, 4));
$this->smarty->assign('filepickerheight_input', 
	$this->CreateInputText($id, 'filepickerheight', 
		$this->GetPreference('filepickerheight',''), 5, 4));

$this->smarty->assign('filepickerheightunit_input', 
	$this->CreateInputDropdown($id,'filepickerheightunit',array('px'=>'px','%'=>'%','em'=>'em'),0,
		$this->GetPreference('filepickerheightunit','px')));

$this->smarty->assign('filepickerwidthunit_input', 
	$this->CreateInputDropdown($id,'filepickerwidthunit',array('px'=>'px','%'=>'%','em'=>'em'),0,
		$this->GetPreference('filepickerwidthunit','px')));

$this->smarty->assign('scalingwidth_text', $this->lang('scalingwidth'));
$this->smarty->assign('scalingwidth_input', 
	$this->CreateInputText($id, 'scalingwidth', 
		$this->GetPreference('scalingwidth'), 5, 4));

$this->smarty->assign('scalingheight_text', $this->lang('scalingheight'));
$this->smarty->assign('scalingheight_input', 
	$this->CreateInputText($id, 'scalingheight', 
		$this->GetPreference('scalingheight'), 5, 4));

$actions = array(lang('none')=>'', 
	lang('delete')=>1, 
	$this->lang('setcontent1')=>2, 
	$this->lang('setcontent2')=>3);

$this->smarty->assign('uninstallaction_input', 
	$this->CreateInputDropdown($id, 'uninstall_action', $actions, '', 
		$this->GetPreference('uninstall_action')));

if(isset($params['message']) && isset($params['submit']))
	$this->smarty->assign('message', $this->lang($params['message']));

$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', 
	lang('submit'),'onClick="return submitForm(this,\'\',\'AdvancedContentResult\')"'));
$this->smarty->assign('moduleId', $id);
echo $this->ProcessTemplate('defaultadmin.tpl');

?>
