<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          This file is a modification of the default plugin {content}
# Version: 0.3.4
# File   : action.default.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if(!isset($gCms)) exit;

if(isset($params['active']) && (strtolower($params['active'])== 'false' || $params['active'] == false)) {
	return; // don't process inactive blocks
}

// not ready yet
if(isset($params['area']))
	return;

$pageinfo =& $gCms->variables['pageinfo'];
$result   = '';

$block = 'content_en';
if(isset($params['block']))
	$block = strtolower(preg_replace('/-+/','_',munge_string_to_url($params['block'], true)));

$defaultValue = '';
if(isset($params['default']))
	$defaultValue = trim($params['default']);

$doSmarty = false;
if(isset($params['smarty']) && (strtolower($params['smarty']) == 'true' || $params['smarty'] == true))
	$doSmarty = true;

if($doSmarty) {
	$defaultValue = $gCms->smarty->_tpl_vars['content_obj']->DoSmarty($gCms->smarty->_tpl_vars['content_obj']->contentBlocks[$block]['default_value']);
}

$allowNone = true;
if(isset($params['allow_none']) && (strtolower($params['allow_none']) == 'false' || $params['allow_none'] == false))
	$allowNone = false;

if (isset($pageinfo) && $pageinfo !== FALSE && isset($pageinfo->content_id) )
{
	$id         = '';
	$modulename = '';
	$action     = '';
	$inline     = false;
	if (isset($_REQUEST['module'])) 
		$modulename = $_REQUEST['module'];
	
	if (isset($_REQUEST['id'])) {
		$id = $_REQUEST['id'];
	}
	elseif (isset($_REQUEST['mact'])) {
		$ary        = explode(',', cms_htmlentities($_REQUEST['mact']), 4);
		$modulename = (isset($ary[0])?$ary[0]:'');
		$id         = (isset($ary[1])?$ary[1]:'');
		$action     = (isset($ary[2])?$ary[2]:'');
		$inline     = (isset($ary[3]) && $ary[3] == 1?true:false);
	}
	
	if (isset($_REQUEST[$id.'action'])) {
		$action = $_REQUEST[$id.'action'];
	}
	else if (isset($_REQUEST['action'])) {
		$action = $_REQUEST['action'];
	}
	
	if (!isset($params['block']) && ($id == 'cntnt01' || ($id != '' && $inline == false))) {
		
		$cmsmodules = &$gCms->modules;
	
		if (isset($cmsmodules)) {
			
			foreach ($cmsmodules as $key=>$value) {
				if (strtolower($modulename) == strtolower($key)) {
					$modulename = $key; }
			}
	
			if (isset($modulename)) {
				if (isset($cmsmodules[$modulename])) {
					if (isset($cmsmodules[$modulename]['object'])
						&& $cmsmodules[$modulename]['installed'] == true
						&& $cmsmodules[$modulename]['active'] == true
						&& $cmsmodules[$modulename]['object']->IsPluginModule())
					{
						@ob_start();

						unset($params['label']);
						unset($params['class']);
						unset($params['id']);
						unset($params['name']);
						unset($params['width']);
						unset($params['height']);
						unset($params['alt']);
						unset($params['block']);
						unset($params['smarty']);
						unset($params['label']);
						unset($params['type']);
						unset($params['default']);
						unset($params['style']);
						unset($params['size']);
						unset($params['block_tab']);
						unset($params['page_tab']);
						unset($params['maxlength']);
						unset($params['wysiwyg']);
						unset($params['oneline']);
						unset($params['mode']);
						unset($params['start_time']);
						unset($params['end_time']);
						unset($params['show24h']);
						unset($params['step']);
						unset($params['upload']);
						unset($params['dir']);
						unset($params['allow_none']);
						unset($params['filter']);
						unset($params['mode']);
						unset($params['lock_input']);
						unset($params['file_extension']);
						#unset($params['checked']);
						unset($params['delimiter']);
						#unset($params['selected']);
						unset($params['items']);
						unset($params['values']);
						unset($params['size']);
						unset($params['module']);
						unset($params['defaultModules']);
						unset($params['urlonly']);
						unset($params['feu_action']);
						unset($params['feu_access']);
						unset($params['editor_groups']);
						unset($params['editor_users']);
						
						$params = array_merge($params, GetModuleParameters($id));
						#$params = GetModuleParameters($id);
						
						// calguy1000 ... increment the modulenum 
						// if we're not in inlined mode.
						if( $id != 'cntnt01' ) {
							++$gCms->variables["modulenum"]; 
						}

						$returnid = '';
						if (isset($params['returnid'])) {
							$returnid = $params['returnid'];
						}
						else {
							$returnid = $pageinfo->content_id;
						}
						$result = $cmsmodules[$modulename]['object']->DoActionBase($action, $id, $params, $returnid);
						if ($result !== FALSE) {
							echo $result;
						}
						$modresult = @ob_get_contents();
						@ob_end_clean();
						$result = $modresult;
					}
					else {
					  $result = "<!-- Not a tag module -->\n";
					}
				}
			}
		}
	}
	else {
		$oldvalue              = $gCms->smarty->caching;
		$gCms->smarty->caching = false;
		$result                = $gCms->smarty->fetch(str_replace(' ', '_', 'content:' . $block), '', $pageinfo->content_id);
		$gCms->smarty->caching = $oldvalue;
		
		if($result == '' && !$allowNone)
			$result = $defaultValue;
		
		// ToDo: inherit?
		if (isset($params['type']) && (strtolower($params['type'])=='image' || strtolower($params['type'])=='file') && $result == '-1') 
			$result = '';
		
		if (isset($params['type']) && (strtolower($params['type'])=='image' || strtolower($params['type'])=='file') && $result != '') {
			$name    = ' name="AdvancedContent'.ucfirst(strtolower($block)).'"';
			$urlonly = false;
			$elmId   = ' id="AdvancedContent'.ucfirst(strtolower($block)).'"';
			$class   = ' class="AdvancedContent'.ucfirst(strtolower($params['type'])).'"';
			$alt     = ' alt="'.ucfirst(strtolower($block)).'"';
			$width   = '';
			$height  = '';
			$title   = '';
			$text    = ucfirst(strtolower($block));
			
			if( isset($params['name']) )    $name    = ' name="'.$params['name'].'"';
			if( isset($params['class']) )   $class   = ' class="'.$params['class'];
			if( isset($params['id']) )      $elmId   = ' id="'.$params['id'];
			if( isset($params['alt']) )     $alt     = ' alt="'.$params['alt'];
			if( isset($params['width']) )   $width   = ' width="'.$params['width'];
			if( isset($params['height']) )  $height  = ' height="'.$params['height'];
			if( isset($params['title']) )   $title   = ' title="'.$params['title'];
			if( isset($params['text']) )    $text    = $params['text'];
			if( isset($params['urlonly']) ) $urlonly = true;
			
			if( !$urlonly ) {
				if(strtolower($params['type'])=='image')
					$result = '<img src="'.$result.'"'.$name.$elmId.$class.$alt.$width.$height.$title.' />';
				else if(strtolower($params['type'])=='file')
					$result = '<a href="'.$result.'"'.$name.$elmId.$class.$title.'>'.$text.'</a>';
			}
		}
	}
	
	// grant page access by default
	$access = true;
	
	// only process feu_acces if there is a frontendusers module
	if( $feusers =& $this->GetModuleInstance('FrontEndUsers' )) {
		
		$feuAccess = $gCms->smarty->fetch(str_replace(' ', '_', 'content:' . 'feu_access'), '', $pageinfo->content_id);
		
		// only process if we have selected anything in backend for feu access
		if(!empty($feuAccess)) {
			
			$feuAccess = explode(';',$feuAccess);
			
			// if page has no parents but inheritance -> remove inheritance (should never happen but just in case)
			if($gCms->smarty->_tpl_vars['content_obj']->mParentId <= 0 && in_array("-1",$feuAccess)) {
				foreach($feuAccess as $k=>$v) {
					if($v=='-1') unset($feuAccess[$k]);
				}
			}
			
			// if there still is inheritance ...
			if(in_array('-1',$feuAccess)) {
				
				// ... finally inherit
				$feuAccess = $gCms->smarty->_tpl_vars['content_obj']->inheritParentsProp($gCms->smarty->_tpl_vars['content_obj']->mParentId,'feu_access',$feuAccess);

			}
			
			// if we have access for certain feu groups only ...
			if( !empty($feuAccess) ) {
				
				// ... deny access by default now ...
				$access = false;
				
				// ... check if user is logged in ...
				$userId = $feusers->LoggedInId();
				if($userId != false) {
					
					// ... and actually belongs to a selected group ...
					foreach($feuAccess as $groupId) {
						// get user groups
						if($groups = $feusers->MemberOfGroup($userId)) {
							// compare with selected ones
							foreach($groups as $oneGroup) {
								if($oneGroup['groupid'] == $groupId)
									// if match -> grant access
									$access = true;
									break;
							}
						}
						else
							break;
						
						if($access)
							break;
					}
				}
			}
		}
	}

	// if we have access to the page...
	if($access) {
		/* WHY THE HECK IS THIS NOT WORKING ANYMORE ?!?
		if(!isset($params['assign']) || empty($params['assign'])) {
			echo trim($result);
			return;
		}
		else {
			$gCms->smarty->assign($params['assign'], trim($result));
			return;
		}
		*/
		
		// ToDo: make assign working!
		//       protect single block
		
		echo trim($result);
	}
	else {
		
		// get the page to redirect to
		$redirectPage = $gCms->smarty->_tpl_vars['content_obj']->mProperties->mPropertyValues['redirect_page'];
		if($redirectPage == '-1')
			$redirectPage = $gCms->smarty->_tpl_vars['content_obj']->inheritParentsProp($gCms->smarty->_tpl_vars['content_obj']->mParentId,'redirect_page');
		
		// do not redirect to current page -> will result in endless recursive redirection
		if($redirectPage == $returnid || $redirectPage == $pageinfo->content_id || $redirectPage == $pageinfo->content_alias)
			$redirectPage = '';
		
		// get feu action
		$feuAction = $gCms->smarty->fetch(str_replace(' ', '_', 'content:' . 'feu_action'), '', $pageinfo->content_id);
		if($feuAction == '-1')
			$feuAction = $gCms->smarty->_tpl_vars['content_obj']->inheritParentsProp($gCms->smarty->_tpl_vars['content_obj']->mParentId,'feu_action');
		
		// if we still don't have a redirect page -> do feu action in current page
		if($redirectPage == '') {
			
			// if we want an action (and we have not done this before) ...
			if($feuAction && !isset($gCms->smarty->_tpl_vars['content_obj']->mProperties->mPropertyValues['feu_action_flag'])) {
				// ... set a flag that we already have a login form now (just to prevent to display it again for other content blocks) ...
				$gCms->smarty->_tpl_vars['content_obj']->AddExtraProperty("feu_action_flag");
				$gCms->smarty->_tpl_vars['content_obj']->SetPropertyValue("feu_action_flag", true);
				// ... and finally do feu action
				return $feusers->DoAction('default', 'cntnt01', array(), $returnid);
			}
			else {
				// ... otherwise just return nothing
				return;
			}
			
		}
		// else if we have a redirect page ...
		else {
			// ... and if we want an action ...
			if($feuAction) {
				// ... redirect to the specified page and do feu action
				return $feusers->RedirectForFrontEnd('cntnt01', $redirectPage, 'default', array(), false);
			}
			else {
				// ... otherwise just redirect
				return $this->RedirectContent($redirectPage);
			}
		}
	}
}

?>
