<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
# Version: 0.3.4
# File   : AdvancedContent.module.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

class AdvancedContent extends CMSModule {
	
	var $blockDisplay;
	
	function AdvancedContent() {
		$this->__construct();
	}
	
	function __construct() {
		parent::CMSModule();
		$this->RegisterContentType('Content2', dirname(__FILE__) . 
			DIRECTORY_SEPARATOR . 'contenttype.Content2.php', 'AdvancedContent');
		$this->blockDisplay = array();
	}
	
	function GetName() {
		return 'AdvancedContent';
	}
	
	function GetFriendlyName() {
		return $this->Lang('AdvancedContent');
	}
	
	function GetVersion() {
		return '0.3.4';
	}
	
	function GetDependencies() {
		return array('FileManager' => '1.0.2');
	}
	
	function GetHelp() {
		$path = dirname(__FILE__) . DIRECTORY_SEPARATOR . 'doc' . DIRECTORY_SEPARATOR;
		if(file_exists($path . 'help_' . $this->curlang . '.html'))
			return file_get_contents($path . 'help_' . $this->curlang . '.html');
		else
			return file_get_contents($path . 'help_en_US.html');
	}
	
	function GetAuthor() {
		return 'NaN';
	}
	
	function GetAuthorEmail() {
		return;
	}
	
	function GetChangeLog() {
		$changelog = dirname(__FILE__) . DIRECTORY_SEPARATOR . 
			'doc' . DIRECTORY_SEPARATOR . 'changelog.html';
		if(file_exists($changelog))
			return file_get_contents($changelog);
	}
	
	function HasContentType() {
		return true;
	}
	
	function IsPluginModule() {
		return true;
	}
	
	function HasAdmin() {
		return true;
	}
	
	function GetAdminSection() {
		return 'extensions';
	}
	
	function GetAdminDescription() {
		return $this->lang('admindescription');
	}
	
	function VisibleToAdminUser() {
		return $this->Checkpermission('Manage AdvancedContent');
	}
	
	function MinimumCMSVersion() {
		return "1.6.7";
	}
	
	function MaximumCMSVersion() {
		return "1.9.9";
	}
	
	function InstallPostMessage() {
		return $this->Lang('postinstall', $this->GetVersion());
	}
	
	function UninstallPostMessage() {
		return $this->Lang('postuninstall', $this->GetVersion());
	}
	
	function UninstallPreMessage() {
		return $this->Lang('confirmuninstall');
	}
	
	function HandlesEvents() {
		return true;
	}
	
	function DoAction($action, $id, &$params, $returnId = -1) {
		switch($action) {
			case 'default':
			case 'savePrefs':
			case 'filePicker':
			case 'defaultadmin':
				parent::DoAction($action, $id, $params, $returnId);
				break;
				
			default: break;
		}
	}
	
	function DoEvent($originator, $eventname, &$params) {
		
		$db =& $this->GetDb();
		// get all content of type advanced that need to be set to active/inactive
		$query = "SELECT C.content_id, C.active
			FROM " . cms_db_prefix() . "content C 
			LEFT JOIN " . cms_db_prefix() . "content_props USE_EXP
				ON USE_EXP.content_id = C.content_id
			LEFT JOIN " . cms_db_prefix() . "content_props START_DATE
				ON START_DATE.content_id = C.content_id
			LEFT JOIN " . cms_db_prefix() . "content_props END_DATE
				ON END_DATE.content_id = C.content_id
			WHERE 
				C.type = ? AND 
				USE_EXP.prop_name = ? AND 
				USE_EXP.content = ? AND (
					(
						START_DATE.prop_name = ? AND 
						START_DATE.content <= ? AND 
						END_DATE.prop_name = ? AND 
						END_DATE.content > ? AND
						C.active = ?
					)
					OR
					(
						END_DATE.prop_name = ? AND 
						END_DATE.content <= ? AND
						C.active = ?
					)
				)
			";
			
		$dbresult = $db->Execute($query, array('content2', 'use_expire_date', 
			'1', 'start_date', time(), 'end_date', time(), 0, 'end_date', 
			time(), 1));
		
		$contents = array();
		while($dbresult && $row = $dbresult->FetchRow()) {
			if($row['active'])
				$contents[$row['content_id']] = 0;
			else
				$contents[$row['content_id']] = 1;
		}
		if(count($contents)) {
			global $gCms;
			$gCms->smarty->clear_all_cache();
			foreach($contents as $contentId=>$active) {
				$query = "UPDATE ". cms_db_prefix() . "content 
					SET active = ? WHERE content_id = ?";
				$dbresult = $db->Execute($query, array($active, $contentId));
			}
		}
	}
	
	function SetParameters() {
		
		$this->RegisterModulePlugin();
		// ToDo: create parameters...
		#$this->RestrictUnknownParams();
		
	}
	
	function _getBlockDisplay($contentId) {
		$db =& $this->GetDb();
		$query = "SELECT * FROM ". cms_db_prefix() . "module_AdvancedContent_blockdisplay
			WHERE user_id = ? AND content_id = ?";
		$dbresult = $db->Execute($query, array(get_userid(), $contentId));
		while($dbresult && $row = $dbresult->FetchRow()) {
			$this->blockDisplay[$row['content_id']][$row['block_id']] = $row['block_display'];
		}
	}
	
	function GetBlockDisplay($contentId,$blockId,$defaultValue = 1) {
		if(!isset($this->blockDisplay[$contentId]))
			$this->_getBlockDisplay($contentId);
		if(!isset($this->blockDisplay[$contentId][$blockId]))
			$this->blockDisplay[$contentId][$blockId] = $defaultValue;
		
		return $this->blockDisplay[$contentId][$blockId];
	}
	
	
	function SetBlockDisplay($contentId,$blockId,$blockDisplay) {
		$db =& $this->GetDb();
		$query = "SELECT block_display FROM ". cms_db_prefix() . "module_AdvancedContent_blockdisplay
			WHERE user_id = ? AND content_id = ? AND block_id = ?";
		$dbresult = $db->Execute($query, array(get_userid(), $contentId, $blockId));
		if($dbresult && $row = $dbresult->FetchRow()) {
			$query = "UPDATE ". cms_db_prefix() . "module_AdvancedContent_blockdisplay 
				SET block_display = ? WHERE user_id = ? AND content_id = ? AND block_id = ?";
			$dbresult = $db->Execute($query, array($blockDisplay, get_userid(), $contentId, $blockId));
		}
		else {
			$query = "INSERT INTO ". cms_db_prefix() ."module_AdvancedContent_blockdisplay 
				(user_id, content_id, block_id, block_display) VALUES (?,?,?,?)";
			$dbresult = $db->Execute($query, array(get_userid(), $contentId, $blockId, $blockDisplay));
		}
		$this->blockDisplay[$contentId][$blockId] = $blockDisplay;
	}
	
}
?>
