<?php
  
  /*
   * Log class
   * 
   * Copyrights: Morris & Chapman Belgium - Jean-Christophe Cuvelier - 2010
   * 
   */

class NTSubscription extends CmsObject 
{
  // Vars

	var $id;
  var $user;
  var $module_name;
  var $period;
	
	const DB_NAME  = 'module_feunotification_subscriptions';

	public static function periods()
	{ 
		return array(
		'Never'	=> 'Never',
		//'Directly' => 'Directly', // TO IMPLEMENT LATER TODO
		'Daily' => 'Daily',
		'Weekly'=>'Weekly',
		'Monthly' => 'Monthly');
	}
	
	public static function excluded_periods()
	{
		return array(
		'Never'	=> 'Never',
		'Directly' => 'Directly'
		);
	}

	public function getId()
	{
		return $this->id;
	}

	public function setId($value)
  {
    $this->id = $value;
  }
  	
	public function __toString()
	{
		return $this->getUser();
	}	
	
	public function getUser()
	{
		return $this->user;
	}
	
	 public function setUser($value)
  {
    $this->user = $value;
  }
  
	public function getModuleName()
	{
		return $this->module_name;
	}
	
	 public function setModuleName($value)
  {
    $this->module_name = $value;
  }

	public function getModule()
	{
		return NTModule::retrieveByPk($this->module_name);
	}

	public function getPeriod()
	{
		return $this->period;
	}
	
  public function setPeriod($value)
  {
    $this->period = $value;
  }



	public function PopulateFromDb($row)
	{
		  $this->id = $row['id'];
		  $this->user = $row['user'];
		  $this->module_name = $row['module_name'];
		  $this->period = $row['period'];
	}
	
	public function checkDuplicate()
	{
		$obj = self::doSelectOne(array('where' => array('module_name' => $this->module_name, 'user' => $this->user)));
		if (!is_null($obj))
		{
			$this->id = $obj->getId();
		}
	}
	
  public function save()
  {
		// Check duplicate
		if ($this->id == null)
		{
			$this->checkDuplicate();
		}
    // Upgrade or Insert ?
    if ($this->id != null)
    {
      $this->update();
    }
    else 
    {     
      $this->insert();
    }   
    
  }
  
  protected function update()
  {
    
    $db =& $this->GetDb();
    

      $query = 'UPDATE  ' . cms_db_prefix() .  self::DB_NAME . ' 
      
      SET ';
            
      $query .= ' user = ?, module_name = ?, period= ?';
      
      $query .= '
      
      WHERE
      
      id = ?  ';
      
      
      $result = $db->Execute($query,
          array(
             $this->getUser(), $this->getModuleName(), $this->getPeriod(),

             $this->getId()
          )
        );        
        
        /*FIXME: Test the $db status; */
        
        return true;
  }
  
  protected function insert()
  {
    $db =& $this->GetDb();
          
    $query = 'INSERT INTO ' . cms_db_prefix() .  self::DB_NAME .  ' 
      
      SET ';
		          
    $query .= ' user = ?, module_name = ?, period= ?';
      
      
       $db->Execute($query,
          array(
             $this->getUser(), $this->getModuleName(), $this->getPeriod(),
          )
        );
        
        return true;    
  }
    
  public static function retrieveByPk($id)
  {
    return self::doSelectOne(array('where' => array('id' => $id)));    
  }
  
  public static function doSelectOne($params = array())
  {
    $items = self::doSelect($params);
    if ($items)
    {
      return $items[0];
    }
    else 
    {
      return null;
    }   
  }
    
  public static function doSelect($params = array())
  {
    $instance = new self();
    
    $db =& $instance->GetDb();
    
    $query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME;;
    
    $values = array();
    
    if (isset($params['where']))
    {

      $fields = array();
      foreach ($params['where'] as $field => $value) 
      {
        $fields[] = $field . ' =  ?';
        $values[] = $value;
      }
      
      $query .= ' WHERE ' . implode(' AND ', $fields);
    } 
    
    if(isset($params['order_by']))
    {
     $query .= ' ORDER BY ' . implode(', ' , $params['order_by']);
    }
    elseif (!isset($params['group_by']))
    {
      $query .= ' ORDER BY user';
    }
    
		if (isset($params['group_by']))
		{
			$query .= ' GROUP BY ' . $params['group_by'];
		}

    $dbresult = $db->Execute($query, $values);
  
    $items = array();
   if ($dbresult && $dbresult->RecordCount() > 0)
    {
      while ($dbresult && $row = $dbresult->FetchRow())
      {
        $item = new self();
        $item->PopulateFromDb($row);
        $items[] = $item;
      }
    }
    
    return  $items;   
  }
  
   public function delete()
   {           
   	$db =& $this->GetDb();
   	$query = 'DELETE FROM '. cms_db_prefix() . self::DB_NAME;
   	$query .= ' WHERE id = ?';
   	$db->Execute($query, array($this->id));   
  }

	// SPECIFIC FUNCTIONS
	
	public static function getExistingPeriods()
	{
		$subscriptions = self::doSelect(array('group_by' => 'period'));
		$periods = array();
		foreach($subscriptions as $subscription)
		{
			if (!in_array($subscription->getPeriod(), self::excluded_periods()))
			{
				$periods[] = $subscription->getPeriod();
			}
		}
		return $periods;
	}
	
	public static function getModulesForPeriod($period)
	{
		$subscriptions = self::doSelect(array('where' => array('period' => $period), 'group_by' => 'module_name'));
		//var_dump($subscriptions);
		$modules = array();
		foreach ($subscriptions as $subscription)
		{
			$modules[$subscription->getModuleName()] = $subscription->getModule();
		}
		return $modules;
	}
	
	public static function getUsersForPeriod($period)
	{
		$subscriptions = self::doSelect(array('where' => array('period' => $period)));
		$users = array();
		foreach($subscriptions as $subscription)
		{
			$users[$subscription->getUser()][] = $subscription->getModuleName();
		}
		return $users;
	}
	
	public static function getTimeForPeriod($period)
	{
		switch($period)
		{
			case 'Daily':
				return strtotime('-1 day');
			case 'Weekly':
				return strtotime('-1 week');
			case 'Monthly':
				return strtotime('-1 month');
			default:
				// We should not be here. In case of, we'll give tomorrow date. TCP over time do not exists yet...
				return strtotime('+1 day');
		}
	}
	
	public static function getDateForPeriod($period)
	{
		return date('Y-m-d', self::getTimeForPeriod($period));
	}
	
	 
} // END CLASS

?>