<?php
  
  /*
   * Log class
   * 
   * Copyrights: Morris & Chapman Belgium - Jean-Christophe Cuvelier - 2010
   * 
   */

class NTLog extends CmsObject 
{
  // Vars

	var $id;
  var $timestamp;
  var $title;
  var $details;
	
	const DB_NAME  = 'module_feunotification_logs';


	public function getId()
	{
		return $this->id;
	}

	public function setId($value)
  {
    $this->id = $value;
  }
  	
	public function __toString()
	{
		return $this->getTitle();
	}	
	
	public function getTitle()
	{
		return $this->title;
	}
	
	 public function setTitle($value)
  {
    $this->title = $value;
  }
  
	
	public function getTimestamp()
	{
		return $this->timestamp;
	}
	
	 public function setTimestamp($value)
  {
    $this->timestamp = $value;
  }

	public function getDateTime()
	{
		return date('d/m/Y H:i:s', $this->timestamp);
	}
  
	public function getDetails()
	{
		return $this->details;
	}
	
	 public function setDetails($value)
  {
    $this->details = $value;
  }

	public function PopulateFromDb($row)
	{
		  $this->id = $row['id'];
		  $this->title = $row['title'];
		  $this->timestamp = $row['timestamp'];
		  $this->details = $row['details'];
	}
	
  public function save()
  {
    // Upgrade or Insert ?
    if ($this->id != null)
    {
      $this->update();
    }
    else 
    {     
      $this->insert();
    }   
    
  }
  
  protected function update()
  {
    
    $db =& $this->GetDb();
    

      $query = 'UPDATE  ' . cms_db_prefix() .  self::DB_NAME . ' 
      
      SET ';
            
      $query .= ' title = ?, timestamp = ?, details= ?';
      
      $query .= '
      
      WHERE
      
      id = ?  ';
      
      
      $result = $db->Execute($query,
          array(
             $this->title, $this->getTimestamp(), $this->details,

             $this->getId()
          )
        );        
        
        /*FIXME: Test the $db status; */
        
        return true;
  }
  
  protected function insert()
  {
    $db =& $this->GetDb();
          
    $query = 'INSERT INTO ' . cms_db_prefix() .  self::DB_NAME .  ' 
      
      SET ';
		
		$query .= ' title = ?, timestamp = ?, details= ?';
      
      
       $db->Execute($query,
          array(
	          $this->title, $this->getTimestamp(), $this->details
          )
        );
        
        return true;    
  }
    
  public static function retrieveByPk($id)
  {
    return self::doSelectOne(array('where' => array('id' => $id)));    
  }
  
  public static function doSelectOne($params = array())
  {
    $items = self::doSelect($params);
    if ($items)
    {
      return $items[0];
    }
    else 
    {
      return null;
    }   
  }
    
  public static function doSelect($params = array())
  {
    $instance = new self();
    
    $db =& $instance->GetDb();
    
    $query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME;;
    
    $values = array();
    
    $fields = array();

    if (isset($params['where']))
    {
      foreach ($params['where'] as $field => $value) 
      {
        $fields[] = $field . ' =  ?';
        $values[] = $value;
      }
    } 

		if (isset($params['where_adv']))
		{
			foreach($params['where_adv'] as $field => $value)
			{
				$fields[] = $field . ' ' . $value[1] . ' ?';
				$values[] = $value[0];
			}
		}

		if (!empty($fields))
		{	
      $query .= ' WHERE ' . implode(' AND ', $fields);
		}    
		
    if(isset($params['order_by']))
    {
     $query .= ' ORDER BY ' . implode(', ' , $params['order_by']);
    }
    else
    {
      $query .= ' ORDER BY timestamp';
    }
    
		if (isset($params['limit']))
		{
			$query .= ' LIMIT ' . $params['limit'];
		}
    $dbresult = $db->Execute($query, $values);
  
    $items = array();
   if ($dbresult && $dbresult->RecordCount() > 0)
    {
      while ($dbresult && $row = $dbresult->FetchRow())
      {
        $item = new self();
        $item->PopulateFromDb($row);
        $items[] = $item;
      }
    }
    
    return  $items;   
  }
  
   public function delete()
   {           
   	$db =& $this->GetDb();
   	$query = 'DELETE FROM '. cms_db_prefix() . self::DB_NAME;
   	$query .= ' WHERE id = ?';
   	$db->Execute($query, array($this->id));   
  }
}

?>