<?php

if (!isset($gCms)) exit;

if (! $this->CheckPermission('Use NotificationTool')) {
  return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
}

if (!isset($params['modulename']) || $params['modulename'] == '' || isset($params['cancel']))
{
	 $this->Redirect($id, 'defaultadmin', $returnid);
}

$module = NTModule::retrieveByPk($params['modulename']);

if (is_null($module))
{
	$module = new NTModule();
	$module->setModuleName($params['modulename']);
}

if (isset($params['submit']) || isset($params['apply']))
{
	$module->setTemplate($params['template']);
	$module->setParams($params['parameters']);
	$module->save();
	
	if (isset($params['submit']))
	{
		$this->Redirect($id, 'defaultadmin', $returnid);
	}
}

//FORM
$this->smarty->assign('form_start',$this->CreateFormStart($id, 'manageModule', $returnid));
$this->smarty->assign('modulename',$this->CreateInputHidden($id, 'modulename', $module->getModuleName()));

$this->smarty->assign('title_section',str_replace('%module%', $module->getModuleName(), $this->Lang('manage %module% notifications')));

$this->smarty->assign('title_template',$this->Lang('template'));
$this->smarty->assign('input_template',$this->CreateInputSelectList($id, 'template', array_flip($module->getTemplatesList()), array($module->getTemplate()), 1, '', false));

$this->smarty->assign('title_params',$this->Lang('params'));
$this->smarty->assign('input_params',$this->CreateInputText($id, 'parameters', $module->getParams(), 50));

$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', $this->Lang('cancel')));
$this->smarty->assign('submit_button',$this->CreateInputSubmit($id, 'submit', $this->Lang('submit')));
$this->smarty->assign('apply_button',$this->CreateInputSubmit($id, 'apply', $this->Lang('apply')));
$this->smarty->assign('form_end',$this->CreateFormEnd());


echo $this->ProcessTemplate('manageModule.tpl');