<?php

require_once('libraries/classes/NTModule.class.php');
require_once('libraries/classes/NTLog.class.php');
require_once('libraries/classes/NTSubscription.class.php');

class FEUNotification extends CMSModule
{
  function GetName()  {		return 'FEUNotification';  }
  function GetFriendlyName()  {    return $this->Lang('friendlyname');  }
  function GetVersion()  {    return '0.1.1';  }
  function GetHelp()  {    return $this->Lang('help');  }
  function GetAuthor()  {    return 'Jean-Christophe Cuvelier';  }
  function GetAuthorEmail()  {    return 'jcc@morris-chapman.com';  }
  function GetChangeLog()  {    return $this->Lang('changelog');  }
  function IsPluginModule()  {    return true;  }
  function HasAdmin()  {    return true;  }
  function GetAdminSection()  {    return 'usersgroups';  }
  function GetAdminDescription()  {    return $this->Lang('moddescription');  }
  function VisibleToAdminUser()  {    return $this->CheckPermission('Use NotificationTool');  }
  function GetDependencies()  {	return array( 'CMSMailer' => '1.73.9',	'FrontEndUsers' => '1.6.6', 'Cron' => '0.0.1');  }
	function SetParameters()
	{
	   $this->RegisterModulePlugin();
	}
  /**
   * GetEventDescription()
   * If your module can create events, you will need
   * to provide the API with documentation of what
   * that event does. This method wraps up a simple
   * return of the localized description.
   * @param string Eventname
   * @return string Description for event 
   */
  function GetEventDescription ( $eventname )
  {
    return $this->Lang('event_info_'.$eventname );
  }
  
  /**
   * GetEventHelp()
   * If your module can create events, you will need
   * to provide the API with documentation of how to
   * use the event. This method wraps up a simple
   * return of the localized description.
   * @param string Eventname
   * @return string Help for event
   */
  function GetEventHelp ( $eventname )
  {
    return $this->Lang('event_help_'.$eventname );
  }


  /**
   * DoEvent()
   * If your module receives/handles/processes events generated
   * by the core or by other modules, you will need to provide
   * this method to do whatever it is you're going to do.
   * Other than the event details, the parameters passed to your
   * method depend entirely on the event originator. You can
   * see what those parameters are by clicking on the Information
   * button for the event in the Admin > Extensions > Event Manager
   *
   * @param string originator where the event originated, e.g. "Core",
   * "News", etc.
   * @param string eventname the name of the event
   * @param mixed params the parameters passed by the event initiator

    function DoEvent( $originator, $eventname, &$params )
	{
	if ($originator == 'Core' && $eventname == 'ContentPostRender')
		{
		// stupid example -- lowercases entire output
		$params['content'] = strtolower($params['content']);
		}
	}
   */

  function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }

  function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }

  function UninstallPreMessage()
  {
    return $this->Lang('really_uninstall');
  }
  
  function GetModulesList($username)
  {
	$i=0;  
	$db =& $this->GetDb();
	$result = array();
	$dbmcfact= cms_db_prefix()."module_mcfactory_modules";
	$dbmodule= cms_db_prefix()."modules";
    $q = "SELECT ".$dbmcfact.".module_name FROM ".cms_db_prefix()."module_mcfactory_modules INNER JOIN ".$dbmodule." ON ".$dbmcfact.".module_name=".$dbmodule.".module_name WHERE ".$dbmcfact.".module_name NOT IN ( SELECT module FROM ".cms_db_prefix()."module_notificationtool WHERE user='$username');";
    $dbresult = $db->Execute( $q );
    if( $dbresult ) {
    while( $row = $dbresult->FetchRow() )
      {
		  $result[$row['module_name']] = $row['module_name'];
		  $i++;
      }
    }
    return $result;
  }
  
  function GetMemberOf($user)
  {
	$db =&  $this->GetDb();
	$query= "SELECT DISTINCT module FROM ".cms_db_prefix()."module_notificationtool WHERE user= '$user';";
	$dbresult=$db->Execute($query);
	if( $dbresult ) {
    while( $row = $dbresult->FetchRow() )
      {
		  $result[$i] = $row['module'];
		  $i++;
      }
    }
	return $result;
  }
 
 /*function DoEvent($originator, $eventname, $params) {
		if($eventname == 'NewItemAdded')
		{
			$db = & $this->GetDb();
			$query = "INSERT INTO ".cms_db_prefix()."module_notificationtool_events VALUES ('','".$eventname."','".$originator."','".date("y-m-d-H-m-s")."');";
			$db->Execute($query);			
			$this->sendmail($originator);
			//$this->redirect($id,'test',$returnid);
		}
	}*/
	
  function HandlesEvents ()
  {
    return true;
  }
  
	function sendmail($module)
	{
		$db=& $this->GetDb();
		$query = "SELECT user FROM ".cms_db_prefix()."module_notificationtool WHERE module='$module' AND frequence='direct'";
		$dbresult=$db->Execute($query);
		$cmsmailer =& $this->GetModuleInstance('CMSMailer');
		$subject=$this->Lang('subject');
		$body= $this->Lang('body');
		if( !$cmsmailer ) {
			echo "erreur CMSMailer";
		}
		else
		{
			while( $row = $dbresult->FetchRow())
			{
				$cmsmailer->SetSubject($subject);
				$cmsmailer->reset();
				$cmsmailer->AddAddress($row['user']);
				$cmsmailer->SetBody($body);
				$cmsmailer->IsHTML(true);
				$cmsmailer->Send();
			}
		}
	}
	
	function sendEmailsForPeriod($params)
	{
		if (isset($params['period']) && in_array($params['period'], NTSubscription::periods()) && $params['period'] != 'None')
		{	
			// 1. Get Modules
			$modules = NTSubscription::getModulesForPeriod($params['period']);
			if(isset($params['demo_email']))
			{
				// If it is a demo email we check all the modules
				$modules = array();
				$allmodules = NTModule::doSelect();
				foreach($allmodules as $module)
				{
					$modules[$module->getModuleName()] = $module;
				}
			}
			// 2. Fetch Content
			$logs = '';
			foreach($modules as $module)
			{
				$module->fetchContent($params['period']);
			}
			// 3. Get users
			$users = NTSubscription::getUsersForPeriod($params['period']);
			if(isset($params['demo_email']))
			{
				$users = array();
				// We check all users
				foreach($modules as $modulename => $module)
				{
					$users[$params['demo_email']][] = $modulename;
				}
			}
			// 4. Send Content
			$cmsmailer =& $this->GetModuleInstance('CMSMailer');
			$subject = str_replace('%PERIOD%', $params['period'], $this->GetPreference('email_subject'));
			$sent = false;
			foreach($users as $user => $user_modules)
			{
				// Check content first
				$contents = array();
				foreach ($user_modules as $module)
				{
					if ($modules[$module]->getContent() != null)
					{
						$contents[$modules[$module]->getModuleName()] = $modules[$module]->getContent();
					}
				}
				// If there is content, we continue, bingo !
				if (!empty($contents))
				{			
					$this->smarty->assign('contents', $contents);
					$body = $this->ProcessTemplateFromDatabase('email_body');

					if($cmsmailer ) 
					{
							$cmsmailer->SetSubject($subject);
							$cmsmailer->reset();
							$cmsmailer->AddAddress($user);
							$cmsmailer->SetBody($body);
							$cmsmailer->IsHTML(true);
							$logs .= 'Send content for ' . $user . ': ' . $subject . "\n";
							if ($this->GetPreference('send_emails') == 'true' || isset($params['demo_email']))
							{
								$cmsmailer->Send();
								$sent = true;
							}
							else
							{
								//echo //'<p> Send content for ' . $user . ': ' . $subject . '</p>';
							}
					}	
				}
				else
				{					
					$logs .= 'No content for ' . $user . ': ' . $subject . "\n";
				}		
			}
			
			// Log it
			$logs .= 'USERS: [[[' . serialize($users) . "]]]\n";
			$logs .= 'CONTENT: [[['. serialize($contents) . "]]]\n";
			
			$log = new NTLog();
			$log->setTimestamp(time());

			if(isset($params['demo_email']))
			{
				$log->setTitle('[DEMO]' . $params['period'] . ' notifications sent');
			}
			elseif ($sent)
			{
				$log->setTitle($params['period'] . ' notifications sent');
			}
			else
			{
				$log->setTitle($params['period'] . ' notifications not sent');
			}
			$log->setDetails($logs);
			$log->save();
		}
		else
		{
			//echo 'Not a valid period';
		}
	} // endSendEmails

	function checkPeriod($period)
	{
		$last_period = NTLog::doSelectOne(
				array(
				'where' => array('title' => $period . ' notifications sent'),
				'where_adv' => array('timestamp' => array(NTSubscription::getTimeForPeriod($period),'>')) // >= ?
				)
																		);
																		
		if (is_null($last_period))
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	function doSendAll()
	{
		$periods = NTSubscription::getExistingPeriods();

		$sent_periods = array();
		
		foreach($periods as $period)
		{
			echo '<p>' . $period . '</p>';

			if ($this->checkPeriod($period))
			{
				$sent_periods[] = $period;
				echo '<p>Sending for '.$period . '</p>';
				$this->sendEmailsForPeriod(array('period' => $period));
			}	
		}
		
		if (!empty($sent_periods))
		{
			$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('sent_log',implode(' ,', $sent_periods)));
		}
	}
	
	public function DoEvent($originator, $eventname, $params) {
		if ($eventname == 'CronDaily') {
			// Do desired action here
			if ($this->GetPreference('send_emails') == 'true')
			{
				$this->doSendAll();
				//$this->Audit( 0, $this->Lang('friendlyname'), 'Event fired');
			}
		}
	}

} //end class
?>
