<?php
#-------------------------------------------------------------------------
# Module: Notification Tool
# Version: 0.1
# Method: Install
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------

/**
 * For separated methods, you'll always want to start with the following
 * line which check to make sure that method was called from the module
 * API, and that everything's safe to continue:
 */ 
if (!isset($gCms)) exit;

$db =& $gCms->GetDb();

$dict = NewDataDictionary( $db );
$taboptarray = array( 'mysql' => 'TYPE=MyISAM' );

// Databases

	$flds = '
	module_name C(255),
	template C(255),
	params C(255)
	';
	$sqlarray = $dict->CreateTableSQL( cms_db_prefix()."module_feunotification_modules",
					   $flds, 
					   $taboptarray);
	$dict->ExecuteSQLArray($sqlarray);
	
	$flds = '
	id I KEY AUTOINCREMENT,
	user C(255),
	module_name C(255),
	period C(255)
	';
	$sqlarray = $dict->CreateTableSQL( cms_db_prefix()."module_feunotification_subscriptions",
					   $flds, 
					   $taboptarray);
	$dict->ExecuteSQLArray($sqlarray);
	
	$flds = '
	id I KEY AUTOINCREMENT,
	timestamp I,
	title C(255),
	details XL
	';
	$sqlarray = $dict->CreateTableSQL( cms_db_prefix()."module_feunotification_logs",
					   $flds, 
					   $taboptarray);
	$dict->ExecuteSQLArray($sqlarray);
	
	
	// TEMPLATES
	
	$this->SetTemplate('email_body', $this->GetTemplateFromFile('email_body'));
	
	
	// Preferences
	
	$this->SetPreference('email_subject', '%PERIOD% updates');
	$this->SetPreference('email_template', 'email_body');
	$this->SetPreference('send_emails', 'false');
		
	$this->SetPreference('send_key', time());
	

// old table schema description
/*
$flds = "
        Notification_id I KEY AUTOINCREMENT,
	 	user C(40) NOT NULL,
		module C(40) NOT NULL,
		frequence C(40) NOT NULL
";

$flds2 = "
        events_id I KEY AUTOINCREMENT,
	 	event C(40) NOT NULL,
		module C(40) NOT NULL,
		date ".CMS_ADODB_DT."
";



// create it. This should do error checking, but I'm a lazy sod.
$sqlarray = $dict->CreateTableSQL( cms_db_prefix()."module_notificationtool",
				   $flds, 
				   $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$sqlarray2 = $dict->CreateTableSQL( cms_db_prefix()."module_notificationtool_events",
				   $flds2, 
				   $taboptarray);
$dict->ExecuteSQLArray($sqlarray2);
// create a permission
$this->CreatePermission('Use NotificationTool', 'Use NotificationTool');

$query = "SELECT module_name FROM ".cms_db_prefix()."module_mcfactory_modules";
$dbresult=$db->Execute($query);
if( $dbresult ) {
    while( $row = $dbresult->FetchRow() )
      {
		  $this->AddEventHandler($row['module_name'], 'NewItemAdded', false);
      }
    }
*/
// put mention into the admin log
$this->Audit( 0, 
	      $this->Lang('friendlyname'), 
	      $this->Lang('installed', $this->GetVersion()) );

	      
?>