<?php
  
  /*
   * Log class
   * 
   * Copyrights: Morris & Chapman Belgium - Jean-Christophe Cuvelier - 2010
   * 
   */

class NTModule extends CmsObject 
{
  // Vars

  var $module_name;
  var $template;
	var $params;
	var $content;
	
	const DB_NAME  = 'module_feunotification_modules';
	
	public function getModuleName()
	{
		return $this->module_name;
	}
	
	 public function setModuleName($value)
  {
    $this->module_name = $value;
  }
  
	public function getTemplate()
	{
		return $this->template;
	}
	
	 public function setTemplate($value)
  {
    $this->template = $value;
  }

	public function getParams()
	{
		return $this->params;
	}
	
	public function getParamsAsArray()
	{
		$params = array();
		
		$xml = simplexml_load_string('<vars><params ' . $this->params . ' /></vars>');
		
		if (isset($xml->params))
		{
			foreach($xml->params[0]->attributes() as $param => $value)
			{
				$params[$param] = ''.$value;
			}
		}
		
		return $params;
	}
	
	 public function setParams($value)
  {
    $this->params = $value;
  }
	
	public function getContent()
	{
		return $this->content;
	}
	
	public function setContent($value)
	{
		$this->content = $value;
	}
	
	public function PopulateFromDb($row)
	{
		  $this->module_name = $row['module_name'];
		  $this->template = $row['template'];
		  $this->params = $row['params'];
	}
	
  public function save()
  {
    // Upgrade or Insert ?
    if (self::retrieveByPk($this->module_name) != null)
    {
      $this->update();
    }
    else 
    {     
      $this->insert();
    }   
    
  }

  protected function update()
  {
    
    $db =& $this->GetDb();
    

      $query = 'UPDATE  ' . cms_db_prefix() .  self::DB_NAME . ' 
      
      SET ';
            
      $query .= ' template = ?, params = ?';
      
      $query .= '
      
      WHERE
      
      module_name = ?  ';
      
      
      $result = $db->Execute($query,
          array(
             $this->getTemplate(), $this->getParams(),

             $this->getModuleName()
          )
        );        
        
        /*FIXME: Test the $db status; */
        
        return true;
  }
  
  protected function insert()
  {
    $db =& $this->GetDb();
          
    $query = 'INSERT INTO ' . cms_db_prefix() .  self::DB_NAME .  ' 
      
      SET ';
		
		$query .= ' module_name = ?, template = ?, params = ?';
      
      
       $db->Execute($query,
          array(
	          $this->getModuleName(), $this->getTemplate(), $this->getParams(),
          )
        );
        
        return true;    
  }
    
  public static function retrieveByPk($module_name)
  {
    return self::doSelectOne(array('where' => array('module_name' => $module_name)));    
  }
  
  public static function doSelectOne($params = array())
  {
    $items = self::doSelect($params);
    if ($items)
    {
      return $items[0];
    }
    else 
    {
      return null;
    }   
  }
    
  public static function doSelect($params = array())
  {
    $instance = new self();
    
    $db =& $instance->GetDb();
    
    $query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME;;
    
    $values = array();
    
    if (isset($params['where']))
    {

      $fields = array();
      foreach ($params['where'] as $field => $value) 
      {
        $fields[] = $field . ' =  ?';
        $values[] = $value;
      }
      
      $query .= ' WHERE ' . implode(' AND ', $fields);
    } 
    
    if(isset($params['order_by']))
    {
     $query .= ' ORDER BY ' . implode(', ' , $params['order_by']);
    }
    else
    {
      $query .= ' ORDER BY module_name';
    }
    
    $dbresult = $db->Execute($query, $values);
  
    $items = array();
   if ($dbresult && $dbresult->RecordCount() > 0)
    {
      while ($dbresult && $row = $dbresult->FetchRow())
      {
        $item = new self();
        $item->PopulateFromDb($row);
        $items[] = $item;
      }
    }
    
    return  $items;   
  }
  
   public function delete()
   {           
   	$db =& $this->GetDb();
   	$query = 'DELETE FROM '. cms_db_prefix() . self::DB_NAME;
   	$query .= ' WHERE module_name = ?';
   	$db->Execute($query, array($this->module_name));   
  }

  // SPECIFIC FUNCTIONS

	public static function getCompatibleModules()
	{
		global $gCms;
		$modules = array();
		foreach ($gCms->modules as $module_name => $module)
		{			
			$object = $module['object'];			
			
			if (method_exists($object, 'NTList'))
			{
				$obj = self::retrieveByPk($module_name);
				if (is_null($obj))
				{
					$obj = new self();
					$obj->setModuleName($module_name);
				}
				$modules[$module_name] = $obj;
			}
		}
		
		return $modules;
	}
	
	public function getTemplatesList()
	{
		global $gCms;
		$module =& $gCms->modules[$this->module_name]['object'];
		$templates = $module->ListTemplates();
		
		$list = array('Choose one');
		foreach($templates as $template)
		{
			$list[$template] = $template;
		}
		return $list;
	}
	
	public function fetchContent($period)
	{
		$date = NTSubscription::getDateForPeriod($period);
		global $gCms;
		$module =& $gCms->modules[$this->module_name]['object'];
		$this->content = $module->NTList($date, $this->getTemplate(), $this->getParamsAsArray());
	}

} // END CLASS
?>