<?php

if (!isset($gCms)) exit;

if (! $this->CheckPermission('Use NotificationTool')) {
  return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
}

if (FALSE == empty($params['active_tab']))
  {
    $tab = $params['active_tab'];
  } else {
  $tab = '';
 }

$tab_header = $this->StartTabHeaders() .
    $this->SetTabHeader('general',$this->Lang('title_general'),('general' == $tab)?true:false)
		.	$this->SetTabHeader('templates',$this->Lang('templates'),('templates' == $tab)?true:false)
		.	$this->SetTabHeader('logs',$this->Lang('logs'),('logs' == $tab)?true:false)
		. $this->SetTabHeader('preferences',$this->Lang('preferences'),('preferences' == $tab)?true:false);


$this->smarty->assign('start_general_tab',$this->StartTab('general', $params));
$this->smarty->assign('start_templates_tab',$this->StartTab('templates'));
$this->smarty->assign('start_logs_tab',$this->StartTab('logs'));
$this->smarty->assign('start_preferences_tab',$this->StartTab('preferences'));
$this->smarty->assign('start_prefs_tab','');   

$this->smarty->assign('tabs_start',$tab_header.$this->EndTabHeaders().$this->StartTabContent());
$this->smarty->assign('tab_end',$this->EndTab());
$this->smarty->assign('tabs_end',$this->EndTabContent());


// pass a reference to the module, so smarty has access to module methods
$smarty->assign_by_ref('mod',$this);

// List of compatible modules

$modules = NTModule::getCompatibleModules();

foreach ($modules as $module)
{
	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
	$module->active = (!is_null($module->getTemplate()))?$gCms->variables['admintheme']->DisplayImage('icons/system/true.gif', $this->Lang('desactivemodule'),'','','systemicon'):$gCms->variables['admintheme']->DisplayImage('icons/system/false.gif', $this->Lang('activemodule'),'','','systemicon');
		$module->edit = $this->CreateLink($id, 'manageModule', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->lang('edit'),'','','systemicon'), array('modulename'=>$module->getModuleName()), '');
		
		if (!is_null($module->getTemplate()))
		{
			$module->delete = $this->CreateLink($id, 'deleteModule', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('modulename'=>$module->modulename), $this->Lang('areyousure'));
		}
		else
		{
			$module->delete = '';
		}
		
	$module->rowclass = $rowclass;
}

$smarty->assign('modules',$modules);

$smarty->assign('module_name', $this->lang('module_name'));
$smarty->assign('template_name', $this->lang('template_name'));
$smarty->assign('is_active', $this->lang('is_active'));
$smarty->assign('edit', $this->lang('edit'));
$smarty->assign('delete', $this->lang('delete'));

// TEMPLATES LIST

$template_list = $this->ListTemplates();

$rowclass = 'row1';

$templates = array();

foreach ($template_list as $template)
{
    $onerow = new stdClass();

    $onerow->name = $template;

    $onerow->deletelink = $this->CreateLink($id, 'deleteTemplate', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('deleteTemplate'),'','','systemicon'), array('template'=>$template), $this->Lang('areyousure'));
   
    $onerow->editlink = $this->CreateLink($id, 'manageTemplate', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('editTemplate'),'','','systemicon'), array('template'=>$template));

    $onerow->rowclass = $rowclass;

    $templates[] = $onerow;

    ($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}

$this->smarty->assign('templates', $templates);
$this->smarty->assign('title_template', $this->Lang('template'));    
$this->smarty->assign('addtemplatelink',$this->CreateLink($id, 'manageTemplate', '', $this->Lang('title_add_template'),array()));    
$this->smarty->assign('addtemplateicon',$this->CreateLink($id, 'manageTemplate', '', $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('title_add_template'),'', '','systemicon'), array()));

// PREFERENCES

if(isset($params['email_subject']) && !isset($params['cancelbutton']))
{
  $this->SetPreference('email_subject', $params['email_subject']);
}

if(isset($params['send_key']) && !isset($params['cancelbutton']))
{
  $this->SetPreference('send_key', $params['send_key']);
}

if(isset($params['email_template']) && !isset($params['cancelbutton']))
{
  $this->SetPreference('email_template', $params['email_template']);
}

if(isset($params['active_tab']) && $params['active_tab'] == 'preferences' && !isset($params['cancelbutton']))
{
	if (isset($params['send_emails']))
	{
		$this->SetPreference('send_emails', 'true');
	}
	else
	{
		$this->SetPreference('send_emails', 'false');
	}
}

$this->smarty->assign('email_subject_title',$this->lang('email_subject'));    
$this->smarty->assign('email_subject',$this->CreateInputText($id, 'email_subject', $this->GetPreference('email_subject'), 80));    

$this->smarty->assign('send_key_title',$this->lang('send_key'));    
$this->smarty->assign('send_key',$this->CreateInputText($id, 'send_key', $this->GetPreference('send_key'), 80));    

// Logs

$logs = NTLog::doSelect(array('limit' => 20, 'order_by' => array('timestamp DESC')));
$rowclass = 'row1';

foreach($logs as $log)
{
		$log->details_link = $this->CreateLink($id, 'viewLog', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/view.gif', $this->Lang('view_log'),'','','systemicon'), array('test' => 'test', 'log_id'=>$log->getId()));
	  $log->rowclass = $rowclass;
    ($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}

$this->smarty->assign('logs', $logs);

// Tpls List
$tpls = array();
foreach ($template_list as $template)
{
	$tpls[$template] = $template;
}
$this->smarty->assign('email_template',$this->CreateInputSelectList($id, 'email_template', array_flip($tpls), array($this->getPreference('email_template')), 1, '', false));
$this->smarty->assign('email_template_title',$this->lang('email_template'));  

$this->smarty->assign('send_emails', $this->CreateInputCheckbox($id, 'send_emails', 'true', $this->getPreference('send_emails', 'false')));
$this->smarty->assign('send_emails_title',$this->lang('send_emails'));   

$this->smarty->assign('form_start', $this->CreateFormStart($id, 'defaultadmin', $returnid));
$this->smarty->assign('form_end',$this->CreateFormEnd());
$this->smarty->assign('pref_tabs',$this->CreateInputHidden($id, 'active_tab', 'preferences'));
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submitbutton', $this->Lang('submit'))); 
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancelbutton', $this->Lang('cancel')));

if (isset($params['email_address']) && !empty($params['email_address']))
{
		$this->sendEmailsForPeriod(array('period' => $params['period'], 'demo_email' => $params['email_address']));
		echo '<div><p>' . 'Demo email sent to ' . $params['email_address'] . ' for period ' . $params['period'] . '</p></div>';
}

$this->smarty->assign('send_email_test',$this->lang('send_email_test'));   
$this->smarty->assign('send_email_test_address',$this->CreateInputText($id, 'email_address','', 80));   
$this->smarty->assign('period', $this->CreateInputDropDown($id, 'period', array_flip(NTSubscription::periods()),-1,-1));
$this->smarty->assign('send', $this->CreateInputSubmit($id, 'send', $this->Lang('send'))); 

echo $this->ProcessTemplate('adminpanel.tpl');

echo '<div><p>' . $this->CreateLink($id, 'send', $returnid, 'Send', array('period'=> 'Daily'), $this->Lang('areyousure')) . '</p></div>';
?>