<?php
if (!isset($gCms)) exit;

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for DocumentsLibrary "manageTemplate" admin action
   
   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/
if (isset($params['modulename']) && $params['modulename'] != '')
{
	$module = MX_XtendedModule::retrieveByPk($params['modulename']);
	
	if (!$module)
	{
		$module = new MX_XtendedModule();
	}
	
	if (isset($params['submitbutton']))
	{		
		if (isset($params['option_documents']))
		{
			$module->setOption('documents');
		}
		else 
		{
			$module->unsetOption('documents');
		}
		
		if (isset($params['option_images']))
		{
      $module->setOption('images');			
		}
		else 
		{			
      $module->unsetOption('images');
		}
		
		if (isset($params['option_links']))
		{
      $module->setOption('links');			
		}
		else 
		{			
      $module->unsetOption('links');
		}
		
		if (isset($params['option_relations']))
		{
			$module->setOption('relations');			
		}
		else
		{
      $module->unsetOption('relations');			
		}		
		
		$module->save();
		
		$this->Redirect($id, 'defaultadmin', $returnid, array('active_tab' => 'xtendedmodules'));
		// Submit and redirect
	}
	
	if (isset($params['cancelbutton']))
	{
		$this->Redirect($id, 'defaultadmin', $returnid, array('active_tab' => 'xtendedmodules'));
	}
	
	
	
	// Form part
	
	$this->smarty->assign('form_start', $this->CreateFormStart($id, 'manageXtended', $returnid));
	$this->smarty->assign('form_end',$this->CreateFormEnd());
	
	$this->smarty->assign('modulename_title', $module->getModuleFriendlyName());
	$this->smarty->assign('modulename',$this->CreateInputHidden($id, 'modulename', $params['modulename']));
	
	// Options
	
	$options = array('documents', 'images', 'links', 'relations');
	
	$options_inputs = array();
	
	$rowclass = 'row1';
	
	foreach ($options as $option)
	{
		
		$option_input = new stdClass();
    $option_input->title = $this->Lang('option_'.$option.'_title');
    $option_input->input = $this->CreateInputCheckbox($id, 'option_'.$option, $option, $module->optionExists($option)?$option:'');
		$option_input->rowclass = $rowclass;
		
		if ($option == 'relations')
		{
			$option_input->categories = '';
			$option_input->manage = '';
		}
		else
		{
			$categories = MX_RelatedCategory::doSelect(array('where' => array('type' => $option, 'modulename' => $params['modulename'])));

			$option_input->categories = (count($categories) > 0)?$this->lang('categories') . ': ' . implode(', ', $categories):'';
			$option_input->manage = $this->CreateLink($id, 'manageRelatedCategories', $returnid, $this->lang('manage_related_categories'), array('modulename' => $params['modulename'], 'type' => $option));
    
		}
		
		$options_inputs[] = $option_input;
		
    	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
	}
	
	$this->smarty->assign('options', $options_inputs);
		
	$this->smarty->assign('form_submit', $this->CreateInputSubmit($id, 'submitbutton', $this->Lang('submit')));	
	$this->smarty->assign('form_cancel', $this->CreateInputSubmit($id, 'cancelbutton', $this->Lang('cancel')));	
		
	echo $this->ProcessTemplate('admin.manageXtended.tpl');

}

?>