<?php
if (!isset($gCms)) exit;

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for ModuleXtender admin action
   
   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
  This code is aimed to upload and/or display images
   
*/

  if (isset($params['document_id']) && $params['document_id'] != '')
{
  $document = MX_Image::retrieveByPk($params['document_id']);
}
else 
{
  $document = new MX_Image();
}

$document->Populate($params); 
  
// Related categories
$categories = MX_RelatedCategory::doSelect(array('where' => array(
'modulename' => ($document->getModuleName() != '')?$document->getModuleName():$params['module_name'], 
'type' => 'images')));

// Upload image

if (is_uploaded_file($_FILES[$id . 'document_file']['tmp_name']))
{
  if ($document->uploadDocument($document->getPath($this->config['uploads_path']), $_FILES[$id . 'document_file']))
  {      
      $old_document = $document;
      
      $document = new MX_Image();
  }
  else
  {
     echo '<p style="color: red;">' . $this->Lang('image_file_error') . '</p>';
  }
}
elseif (isset($params['is_submitted'])  && isset($params['document_id']) && $params['document_id'] != '')
{ 
  if (isset($params['document_filename']) && $document->getFile() != $params['document_filename'])
  {
    $document->rename($document->getPath($this->config['uploads_path']), $params['document_filename']);
    
  }
  $document->save();
  
  $old_document = $document;
      
  $document = new MX_Image();
}

if (isset($params['is_submitted'])  && isset($old_document) && $old_document->getId() != '')
{
    foreach ($categories as $category)
    {
     if (isset($params['MX_category_'.$category->getId()]))
      {
        $existing_items = MX_RelationLink::doSelect(array('where' => array(
          'modulename' => 'MX_' . $category->getType(),
          'module_id' => $old_document->getId(),
          'rel_code' => 'related_category_' . $category->getId(),
        )));
        
        foreach ($existing_items as $item)
        {
          $item->delete();
        }
          $relation = new MX_RelationLink();
          $relation->setRightModule('MX_' . $category->getType());
          $relation->setRightModuleId($old_document->getId());
          $relation->setLeftModule('related_category_'.$category->getId());
          $relation->setLeftModuleId($params['MX_category_'.$category->getId()]);
          $relation->save();
          
      }
    } 
    
    
  echo $this->javascripts->call();
  echo $this->javascripts->getJSCallFromiFrame($params['js_call']);
}

// FORM PART

$this->smarty->assign('form_start',$this->CreateFormStart($id, 'manageImages', $returnid, 'post', 'multipart/form-data'));

$this->smarty->assign('disable_theme',$this->CreateInputHidden($id, 'disable_theme', 'true'));
$this->smarty->assign('document_id',$this->CreateInputHidden($id, 'disable_theme', $document->getId()));
$this->smarty->assign('is_submitted',$this->CreateInputHidden($id, 'is_submitted', true));

$this->smarty->assign('module_name',$this->CreateInputHidden($id, 'module_name', ($document->getModuleName() != '')?$document->getModuleName():$params['module_name']));
$this->smarty->assign('document_id',$this->CreateInputHidden($id, 'document_id', ($document->getId() != '')?$document->getId():''));
$this->smarty->assign('module_id',$this->CreateInputHidden($id, 'module_id', ($document->getModuleId() != '')?$document->getModuleId():$params['module_id']));
$this->smarty->assign('js_call',$this->CreateInputHidden($id, 'js_call', isset($params['js_call'])?$params['js_call']:''));

$this->smarty->assign('title_document_title', $this->Lang('caption'));
$this->smarty->assign('title_document_file', $this->Lang('image'));

$this->smarty->assign('document_title',$this->CreateInputText($id, 'document_title', $document->getTitle(), 50));

if ($filename = $document->getFile())
{
  $this->smarty->assign('document_file', $this->CreateInputText($id, 'document_filename', $filename, 50) . ' ' . $this->CreateFileUploadInput($id, 'document_file', '', 50));
}
else 
{
  $this->smarty->assign('document_file',$this->CreateFileUploadInput($id, 'document_file', '', 50));
}

foreach ($categories as $category)
{ 
  $category->input = MC_CreateInputSelectList($id, 'MX_category_' . $category->getId(), 
     array('')+$category->getCategory()->getOptionsById(),
     array($category->checkRelation($document->getId())),
      1, '', false );      
}

$this->smarty->assign('categories', $categories);

$this->smarty->assign('upload', $this->Lang('upload'));

echo $this->ProcessTemplate('admin.manageDocuments.tpl');