<?php
#-------------------------------------------------------------------------
# Module: modulextender - This module extend compatibles modules to give them more stuffs like a categories/pages relation system, a form field extender system, etc.
# Version: 0.0.1, Jean-Christophe Cuvelier
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2007 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
# This file originally created by ModuleMaker module, version 0.3.1
# Copyright (c) 2007 by Samuel Goldstein (sjg@cmsmadesimple.org)
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

#-------------------------------------------------------------------------
# For Help building modules:
# - Read the Documentation as it becomes available at
#   http://dev.cmsmadesimple.org/
# - Check out the Skeleton Module for a commented example
# - Look at other modules, and learn from the source
# - Check out the forums at http://forums.cmsmadesimple.org
# - Chat with developers on the #cms IRC channel
#-------------------------------------------------------------------------


// Required classes

require_once('Classes/XT_Countries.class.php');
require_once('Classes/XT_Tools.class.php');
require_once('Classes/XT_Documents.class.php');
require_once('Classes/XT_Categories.class.php');
require_once('Classes/XT_Relations.class.php');
require_once('Classes/XT_Pages.class.php');
require_once('Classes/XT_XtendedModule.class.php');
require_once('Classes/XT_Javascripts.class.php');
//require_once('Classes/Objects/MX_Object.class.php');
require_once('Classes/Objects/MX_XtendedModule.class.php');
require_once('Classes/Objects/MX_Document.class.php');
require_once('Classes/Objects/MX_Image.class.php');
require_once('Classes/Objects/MX_Link.class.php');
require_once('Classes/Objects/MX_Relation.class.php');
require_once('Classes/Objects/MX_RelationLink.class.php');
require_once('Classes/Objects/MX_Category.class.php');
require_once('Classes/Objects/MX_Option.class.php');
require_once('Classes/Objects/MX_Page.class.php');
require_once('Classes/Objects/MX_RelatedCategory.class.php');
require_once('Classes/Objects/MX_ModuleItem.class.php');
//require_once('Classes/MX_Compiler.class.php');

class ModuleXtender extends CMSModule
{

  //var $countries;
  var $relations;
  var $categories;
  var $pages;
  //var $customfields;
  //var $language;
  var $documents;
  //var $ajax;
  //var $javascripts;
  //var $settings;

  function ModuleXtender()
  {
    parent::CMSModule();
    
    // Load all the subclasses (Should be deprecated)
    $this->categories = new XT_Categories($this);
    $this->relations = new XT_Relations($this);
    $this->documents = new XT_Documents($this);
    $this->pages = new XT_Pages($this);

    // Used in document/images box
    $this->javascripts = new XT_Javascripts();
   
    // DEPRECATED
    /*$this->settings = array('img_sizes' => $imgsizes = array(
      array('id'=>'thumbnails', 'width'=>100  , 'height'=>100) //
    , array('id'=>'low', 'width'=>170  , 'height'=>170) //
    , array('id'=>'home', 'width'=>187, 'height'=>187)
    , array('id'=>'medium', 'width'=>208, 'height'=>208)
    , array('id'=>'high', 'width'=>600, 'height'=>600)
    , array('id' =>'cover', 'width'=>80, 'height'=>57)    
    ));*/
  }
  //



function GetName() { return 'ModuleXtender'; } 
function GetFriendlyName() { return $this->Lang('friendlyname'); } 
function GetVersion() { return '1.5.0'; } 
function GetHelp() { return $this->Lang('help'); } 
function GetAuthor() { return 'Jean-Christophe Cuvelier'; } 
function GetAuthorEmail() { return 'jcc@morris-chapman.com'; }
function GetChangeLog() { return $this->Lang('changelog'); } 
function IsPluginModule() { return true; }
function HasAdmin() { return true; }

function SetParameters()
{
   $this->RegisterModulePlugin();
}

  /*---------------------------------------------------------
  GetAdminSection()
  If your module has an Admin Panel, you can specify
  which Admin Section (or top-level Admin Menu) it shows
  up in. This method returns a string to specify that
  section. Valid return values are:

  main        - the Main menu tab.
  content     - the Content menu
  layout      - the Layout menu
  usersgroups - the Users and Groups menu
  extensions  - the Extensions menu (this is the default)
  siteadmin   - the Site Admin menu
  viewsite    - the View Site menu tab
  logout      - the Logout menu tab

  Note that if you place your module in the main,
  viewsite, or logout sections, it will show up in the
  menus, but will not be visible in any top-level
  section pages.
  ---------------------------------------------------------*/
  function GetAdminSection()
  {
    return 'extensions';
  }


  /*---------------------------------------------------------
  GetAdminDescription()
  If your module does have an Admin Panel, you
  can have it return a description string that gets shown
  in the Admin Section page that contains the module.
  ---------------------------------------------------------*/
  function GetAdminDescription()
  {
    return $this->Lang('admindescription');
  }


  /*---------------------------------------------------------
  VisibleToAdminUser()
  If your module does have an Admin Panel, you
  can control whether or not it's displayed by the boolean
  that is returned by this method. This is primarily used
  to hide modules from admins who lack permission to use
  them.

  Typically, you'll use some permission to set this
  (e.g., $this->CheckPermission('Some Permission'); )
  ---------------------------------------------------------*/
  function VisibleToAdminUser()
  {
    return true;
  }


  /*---------------------------------------------------------
  CheckAccess()
  This wrapper function will check against the specified permission,
  and display an error page if the user doesn't have adequate permissions.
  ---------------------------------------------------------*/
  function CheckAccess($perm = '')
  {
    return $this->CheckPermission($perm);
  }

  /*---------------------------------------------------------
  DisplayErrorPage()
  This is a simple function for generating error pages.
  ---------------------------------------------------------*/
  function DisplayErrorPage($id, &$params, $return_id, $message='')
  {
    $this->smarty->assign('title_error', $this->Lang('error'));
    $this->smarty->assign_by_ref('message', $message);

    // Display the populated template
    echo $this->ProcessTemplate('error.tpl');
  }



  /*---------------------------------------------------------
  GetDependencies()
  Your module may need another module to already be installed
  before you can install it.
  This method returns a list of those dependencies and
  minimum version numbers that this module requires.

  It should return an hash, eg.
  return array('somemodule'=>'1.0', 'othermodule'=>'1.1');
  ---------------------------------------------------------*/
  function GetDependencies()
  {
    return array(); //'CMSMailer'=>'1.73.6');
  }

  /*---------------------------------------------------------
  MinimumCMSVersion()
  Your module may require functions or objects from
  a specific version of CMS Made Simple.
  Ever since version 0.11, you can specify which minimum
  CMS MS version is required for your module, which will
  prevent it from being installed by a version of CMS that
  can't run it.

  This method returns a string representing the
  minimum version that this module requires.
  ---------------------------------------------------------*/
  function MinimumCMSVersion()
  {
    return "1.4";
  }


  /*---------------------------------------------------------
  MaximumCMSVersion()
  You may want to prevent people from using your module in
  future versions of CMS Made Simple, especially if you
  think API features you use may change -- after all, you
  never really know how the CMS MS API could evolve.

  So, to prevent people from flooding you with bug reports
  when a new version of CMS MS is released, you can simply
  restrict the version. Then, of course, the onus is on you
  to release a new version of your module when a new version
  of the CMS is released...

  This method returns a string representing the
  maximum version that this module supports.
  ---------------------------------------------------------*/
  /*function MaximumCMSVersion()
  {
  return "1.2.4";
  }
  */

  /*---------------------------------------------------------
  InstallPostMessage()
  After installation, there may be things you want to
  communicate to your admin. This function returns a
  string which will be displayed.
  ---------------------------------------------------------*/
  function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }

  /*---------------------------------------------------------
  UninstallPostMessage()
  After removing a module, there may be things you want to
  communicate to your admin. This function returns a
  string which will be displayed.
  ---------------------------------------------------------*/
  function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }




  /**
	 * UninstallPreMessage()
	 * This allows you to display a message along with a Yes/No dialog box. If the user responds
	 * in the affirmative to your message, the uninstall will proceed. If they respond in the
	 * negative, the uninstall will be canceled. Thus, your message should be of the form
	 * "All module data will be deleted. Are you sure you want to uninstall this module?"
	 *
	 * If you don't want the dialog, have this method return a FALSE, which will cause the
	 * module to uninstall immediately if the user clicks the "uninstall" link.
	 */
  function UninstallPreMessage()
  {
    return $this->Lang('really_uninstall');
  }


  /*

  Core Module Functions

  */
  
  /*function ContentPostRender(&$content)
  {
  	$html = '<!-- ModuleXtender -->';
  	$content = str_replace('</head', $html . '</head', $content);
  }*/

  /********************************************************************************************************************
    * Xtended Modules (Revision 2009) 
    *******************************************************************************************************************/

  function GetExtendedModules()
  {   
    return MX_XtendedModule::doSelectByModuleName(array('where' => array('isactive' => 1)));     
  }

  function GetReverseExtendedModules()
  {
    $array = $this->GetExtendedModules();
    $returnarray = array();

    foreach ($array as $key=>$value) {
      $returnarray[$value->getModuleFriendlyName()] = $key;
    }

    return $returnarray;
  }
  
  public function isXtendedModule ($modulename)
  {
  	// Deprecated: Use the Tool class instead (XT_XtendedModule)
    return XT_XtendedModule::isXtendedModule($modulename);
  }

  
  /* RELATIONS / CATEGORIES / DOCUMENTS / IMAGES STUFFS */

  function FEModuleFilters ($params)
  {
    // This aim to build a filter list
    // This list will contain : pages, categories, fields

    global $gCms;

    $filters = array();

    /* INCLUDE THE FILTER_ON PARAMS */
    if (isset($params['filter_on']))
    {
      $f_params  = explode('||', $params['filter_on']);
      
      foreach ($f_params as $f_param)
      {
        $tmp = explode('|', $f_param);
        
        switch ($tmp[0])
        {
          case 'pages':
            $params['pages'] = (isset($params['pages']))?$params['pages'] . ',' . $tmp[1]:$tmp[1];           
            break;
          case 'categories':
            $params['categories'] = (isset($params['categories']))?$params['categories'] . ',' . $tmp[1]:$tmp[1];           
            break;
          case 'field':
            $filters['fields'][] = $tmp[1];
            break;
        }
      }
    }
        
    /* PAGES */

    if (isset($params['currentpage']))
    {
      $filters['pages'][] = $gCms->variables['content_id'];
    }

    if (isset($params['pages']))
    { 
        $pages = $this->arrayUnserialise($params['pages']);
        
        foreach ($pages as $page)
        {
          $filters['pages'][] = $page;
        }
    }

    if (isset($params['subpages']))
    {
      $subpages = $this->relations->getSubPagesItems ($params['subpages']);

      $filters['pages'][] = $params['subpages'];

      foreach ($subpages as $key => $onepage)
      {
        $filters['pages'][] = $key;
      }
    }

    // CATEGORIES


    if (isset($params['category']))
    {
      $filters['categories'] = array($params['category']);
    }


    if (isset($params['categories']))
    {
      if (isset($filters['categories']))
      {
        $filters['categories'] = array_merge($filters['categories'] , $this->arrayUnserialise($params['categories']));
      }
      else
      {
        $filters['categories'] = $this->arrayUnserialise($params['categories']);
      }
    }

    return $filters;
  }

  function FEModuleQuery ($modulename, $moduleTableName, $moduleIdName, $filters, $params, $custom_query = '')
  {
    $db =& $this->GetDb();
    
    $query = "SELECT * FROM ".cms_db_prefix()."module_modulextender_relations_link
			
			LEFT JOIN ".cms_db_prefix().$moduleTableName."
			ON
			".cms_db_prefix().$moduleTableName.".".$moduleIdName." = ".cms_db_prefix()."module_modulextender_relations_link.module_id
			AND modulename = '".$modulename."'";


    $query .= ' WHERE ';
    // Pages filter

    if (count($filters['pages']) > 0)
    {
      $query .= "(rel_code = 'pages' AND (";

      $first = 0;

      foreach ($filters['pages'] as $pageid)
      {
        if (!$first)
        {
          $query .= 'rel_id = ' . $db->qstr($pageid);
        }
        else
        {
          $query .= ' OR rel_id = ' . $db->qstr($pageid);
        }

        $first++;
      }

      $query .= "))";
    }

    if (count($filters['pages']) > 0 && count($filters['categories']) > 0)
    {
      $query .= ' OR ';
    }

    if (count($filters['categories']) > 0)
    {
      $query .= "(rel_code = 'options' AND (";

      $first = 0;

      foreach ($filters['categories'] as $optionid)
      {
        if (!$first)
        {
          $query .= 'rel_id = ' . $db->qstr($optionid);
        }
        else
        {
          $query .= ' OR rel_id =' . $db->qstr($optionid);
        }

        $first++;
      }

      $query .= "))";
    }

    if (isset($filters['fields']))
    {
      if (count($filters['categories']) > 0 || count($filters['pages']) >0)
      {
        $first = false;
      }
      else 
      {
        $first = true;
      }
      
      foreach ($filters['fields'] as $field)
      {
        if ($first)
        {
          $first = false;
        }
        else 
        {
          $query .= ' AND ';
        }
        
           $tmp = explode('=', $field);
        
          $query .= $tmp[0] . ' =  ' . $db->qstr($tmp[1]);
      }
    }
        
    if(isset($custom_query))
    {

      $query .= ' '.$custom_query;

    }
    
      $query .= ' GROUP BY ' . cms_db_prefix() . "module_modulextender_relations_link.module_id";// . $moduleIdName;
    

    if (isset($params['join_cat']) || (isset($params['search_type']) && $params['search_type'] == 'AND')) 
    {
    	// join_cat => solvayreach.com
    	
    	$count = 0;
    	if (isset($filters['categories']))
    	{
    		$count += count($filters['categories']);
    	}
    	if (isset($filters['pages']))
      {
        $count += count($filters['pages']);
      }
             
      $query .= ' HAVING COUNT(*) >= ' . $count;
    }
 
      

    // return a query string

    return $query;
  }

  function XtendModuleForm ($modulename, $module_id, $id)
  {
    // Related items

    $this->smarty->assign('show_relations', false);
    $this->smarty->assign('show_documents', false);
    $this->smarty->assign('show_images', false);
    $this->smarty->assign('show_links', false);

    $xtended_module = MX_XtendedModule::retrieveByPk($modulename);
    
    if ($xtended_module->optionExists('relations'))
    {
    	$this->smarty->assign('relations', $this->RelationsForm($id, $modulename, $module_id));    	
      $this->smarty->assign('show_relations', true);    
    }

    // Smarty stuffs

    if ($xtended_module->optionExists('documents'))
    {
      $this->smarty->assign('show_documents', true);

      if ($module_id != '')
      {
        $this->smarty->assign('mx_documents', $this->DocumentsWindow($modulename, $module_id));
      }
      else
      {
        $this->smarty->assign('mx_documents', '<p>'.$this->Lang('firstapplydoc').'</p>');
      }

    }

    if ($xtended_module->optionExists('images'))
    {
      $this->smarty->assign('show_images', true);

      if ($module_id != '')
      {
        $this->smarty->assign('mx_images', $this->ImagesWindow($id, $modulename, $module_id));
      }
      else
      {
        $this->smarty->assign('mx_images', '<p>'.$this->Lang('firstapplyimg').'</p>');
      }

    }
    
    
    if ($xtended_module->optionExists('links'))
    {
      $this->smarty->assign('show_links', true);

      if ($module_id != '')
      {
        $this->smarty->assign('mx_links', $this->LinksWindow($id, $modulename, $module_id));
      }
      else
      {
        $this->smarty->assign('mx_links', '<p>'.$this->Lang('firstapplylink').'</p>');
      }

    }

    if ($xtended_module->optionExists('images') || $xtended_module->optionExists('documents'))
    {
      $this->smarty->assign('mx_javascript', $this->javascripts->call());
    }
    else
    {
    	$this->smarty->assign('mx_javascript', '');
    }

    //echo $_SESSION['ajaxmsgeneratedcode'];

    return $this->ProcessTemplate('xtended_form.tpl');
  }


   public function getSmartyFields($module_name)
   {
    $list = '<ul>
  <li>$item->xtended_felist</li>';
    
    // $item->xtended_felist
    
    $xtended_module = MX_XtendedModule::retrieveByPk($module_name);
    
    if ($xtended_module->optionExists('relations'))
    {
    	$list .= '<ul>
    	<li>$item->xtended_felist->pages</li>
    	<li>$item->xtended_felist->categories</li>
    	</ul>';
    }
    
    if ($xtended_module->optionExists('documents'))
    {
      $list .= '<ul>
      <li>$item->xtended_felist->documents</li>
      </ul>';
    }
    
        if ($xtended_module->optionExists('images'))
    {
      $list .= '<ul>
      <li>$item->xtended_felist->images</li>
      </ul>';
    }
    
    
    
    $list .= '</ul>';
    
    return $list;
   }
  
  function getFormInput ($modulename, $moduleid, $params)
  {
    $relations_link = MX_RelationLink::doSelect(array('where' => array('modulename' => $modulename, 'module_id' => $moduleid)));
	
		// echo '<pre>TEST';
    // var_dump($relations_link);  
        
    foreach($relations_link as $relation_link)
    {
    	if ($relation = $relation_link->getRelation())
    	{
    	 // var_dump($relation);
	    	if (isset($params['mx_' . $relation->getItemName()][$relation->getId()]))
	    	{
	    		unset($params['mx_' . $relation->getItemName()][$relation->getId()]);
	    	}
	    	elseif(isset($params['mxs_' . $relation->getItemName()]) && array_search($relation->getId(), $params['mxs_' . $relation->getItemName()]) !== false)
	    	{
	    		unset($params['mxs_' . $relation->getItemName()][array_search($relation->getId(), $params['mxs_' . $relation->getItemName()])]);
	    	}	    	
	    	else
	    	{
	    		$relation_link->delete();
	    	}
    	}
    	else 
    	{
        // This case should never happen
        // var_dump($relation_link);
    	}
    }    
        //echo '</pre>';
    
    // Treath pages
    if (isset($params['mx_' . MX_Page::ITEM_NAME]) && is_array($params['mx_' . MX_Page::ITEM_NAME] ))
    {
	    foreach ($params['mx_' . MX_Page::ITEM_NAME] as $new_relation_id => $value)
	    {
	    	$new_relation = new MX_RelationLink();
	    	$new_relation->setLeftModule(MX_Page::ITEMS_NAME);
	    	$new_relation->setType(MX_Page::ITEMS_NAME);
	    	$new_relation->setLeftModuleId($new_relation_id);
	    	$new_relation->setRightModule($modulename);
	    	$new_relation->setRightModuleId($moduleid);
	    	$new_relation->save();
	    }
    }
    
      if (isset($params['mxs_' . MX_Page::ITEM_NAME]) && is_array($params['mxs_' . MX_Page::ITEM_NAME] ))
    {
      foreach ($params['mxs_' . MX_Page::ITEM_NAME] as $new_relation_id)
      {
        $new_relation = new MX_RelationLink();
        $new_relation->setLeftModule(MX_Page::ITEMS_NAME);
        $new_relation->setType(MX_Page::ITEMS_NAME);
        $new_relation->setLeftModuleId($new_relation_id);
        $new_relation->setRightModule($modulename);
        $new_relation->setRightModuleId($moduleid);
        $new_relation->save();
      }
    }
    // Treath options
    if (isset($params['mx_' . MX_Option::ITEM_NAME]) && is_array($params['mx_' . MX_Option::ITEM_NAME] ))
    {
      foreach ($params['mx_' . MX_Option::ITEM_NAME] as $new_relation_id => $value)
      {
        $new_relation = new MX_RelationLink();
        $new_relation->setLeftModule(MX_Option::ITEMS_NAME);
        $new_relation->setType(MX_Option::ITEMS_NAME);
        $new_relation->setLeftModuleId($new_relation_id);
        $new_relation->setRightModule($modulename);
        $new_relation->setRightModuleId($moduleid);
        $new_relation->save();
      }
    }
    
    if (isset($params['mxs_' . MX_Option::ITEM_NAME]) && is_array($params['mxs_' . MX_Option::ITEM_NAME] ))
    {
      foreach ($params['mxs_' . MX_Option::ITEM_NAME] as $new_relation_id)
      {
        $new_relation = new MX_RelationLink();
        $new_relation->setLeftModule(MX_Option::ITEMS_NAME);
        $new_relation->setType(MX_Option::ITEMS_NAME);
        $new_relation->setLeftModuleId($new_relation_id);
        $new_relation->setRightModule($modulename);
        $new_relation->setRightModuleId($moduleid);
        $new_relation->save();
      }
    }
      
    // Treath Modules
    
    $modules = MX_Relation::doSelect(array('where' => array('modulename' => $modulename, 'rel_type' => 'module')));
    
    var_dump($modules);
    
    foreach ($modules as $module)
    {
       if (isset($params['mx_' . $module->getRelationId()]) && is_array($params['mx_' . $module->getRelationId()] ))
       {
          foreach ($params['mx_' . $module->getRelationId()] as $new_relation_id => $value)
          {
             
             echo 'test';
             $new_relation = new MX_RelationLink();
             $new_relation->setLeftModule($module->getRelationId());
             $new_relation->setType(MX_ModuleItem::ITEMS_NAME);
             $new_relation->setLeftModuleId($new_relation_id);
             $new_relation->setRightModule($modulename);
             $new_relation->setRightModuleId($moduleid);
             $new_relation->save();
          }
       }

       if (isset($params['mxs_' . $module->getRelationId()]) && is_array($params['mxs_' .  $module->getRelationId()] ))
       {
          foreach ($params['mxs_' .  $module->getRelationId()] as $new_relation_id)
          {
             $new_relation = new MX_RelationLink();
             $new_relation->setLeftModule($module->getRelationId());
             $new_relation->setType(MX_ModuleItem::ITEMS_NAME);
             $new_relation->setLeftModuleId($new_relation_id);
             $new_relation->setRightModule($modulename);
             $new_relation->setRightModuleId($moduleid);
             $new_relation->save();
          }
       }
    }
  }

  function RelationsForm($id, $modulename, $module_id)
  {  	    
     
  	$relations = MX_Relation::doSelect(array('where' => array('modulename' => $modulename, 'is_visible' => 1)));

  	$relations_link = MX_RelationLink::getRelatedLinks($modulename, $module_id);
  	
  	$relations_sorted = array();

  	foreach ($relations as $relation)
  	{
  		if ($relation->getType() == 'page' && ($relation->getHaveSub() == 0 || $relation->getHaveSub() == null))
  		{
  			$relations_sorted['related'][$relation->getId()] =$relation;
  		}
  		else
  		{        
  			$relations_sorted[$relation->getId()] = $relation;
  		}
  	}

    // Fill a big array with all the parameters
    
  	$relation_tables = array();
  	$tips = false;
  	foreach ($relations_sorted as $key => $relation)
    {    	
    	if ($key == 'related')
      {
        $relation_tables['related']['title'] = $this->Lang('related_pages');
        
      if (count($relation) >= 15)
      {
        $tips = true;
      }
        
        foreach ($relation as $item)
        {
        	if (is_object($item->relation))
        	{
	        	$relation_tables['related']['items'][] = array(
	        	'id' => $item->relation->getId(),        	
	         'type' => $item->relation->getItemName(),
	        	'name' =>  $item->relation->getItemName() . '[' . $item->relation->getId() . ']',
	        	'title' => $item->relation->getTitle(true),  	
	        	'selected' => (isset($relations_link[$item->relation->getItemsName()][$item->relation->getId()]))?true:false,
	        	);
        	}	
        }
       }
       else 
       {
       	$relation_tables[$key]['title'] =  $relation->getTitle(false, true);        

       	$related = $relation->getRelatedItems();
         if (count($related) >= 15)
		      {
		        $tips = true;
		      }
		      
       	foreach ($related as $item)
        {
        	if (is_object($item))
          {
	          $relation_tables[$key]['items'][] = array(
	          'id' => $item->getId(),
	          'type' => $item->getItemName(),
	          'name' =>  $item->getItemName() . '[' . $item->getId() . ']',
	          'title' => $item->getTitle(true),   
	          'selected' => (isset($relations_link[$item->getItemsName()][$item->getId()]))?true:false,
	          );
          }  
        }
       }
    }
    
  $content = '
    <fieldset>
    <legend>' . $this->Lang('relations') . '</legend>';
    
  	foreach ($relation_tables as $key => $relation)
  	{
  		  $content .= '
        <div style="margin: 10px; list-style:none; float: left; min-height: 200px; text-align: center; border: 1px solid #999; background-color: #fff;">
        <p style="background-color: #385c72; padding: 7px; color: #fff; margin: 0px;">' . $relation['title'] .'</p>
        ' . $this->createRelationInput($id, $relation['items']) . '
        </div>';
  	}
  	
  	
  	if ($tips)
  	{
  		$content .= '<div style="clear: both;"><p>' . $this->Lang('tips') . '<br />' . $this->Lang('tips1') . '</p></div>';
  	}
  	
    $content .= '</fieldset>';
  	
  	return $content;
  }
  
  public function createRelationInput($id, $items)
  {
  	   $content = '';  	 
  	
  	    if (count($items) > 0 && count($items) < 15)
        {
          $content .= '<ul style="text-align: left; padding: 5px; float: left; list-style: none;">';
          foreach ($items as  $key => $item)
          {
             $content .= '<li>
             <input type="checkbox" name="' . $id . 'mx_' . $item['name'] . '"';

               if ($item['selected'])
               {
                $content .= ' checked="true"';
               }
                  
               $content .= ' />' . $item['title'] . '</li>';
          }          
          $content .= '</ul>';
         }
         elseif (count ($items) >= 15)
         {
         	  $content .= '<select multiple="true" size="15" name="' . $id . 'mxs_' . $items[0]['type']. '[]">';
         	  
         	    foreach ($items as  $key => $item)
		          {
		             $content .= '<option value="' . $item['id'] . '"';
		
		               if ($item['selected'])
		               {
		                $content .= ' selected="true"';
		               }
		                  
		               $content .= ' />' . $item['title'] . '</option>';
		          }    
         	  
         	  $content .= '</select>';
         }
  	
         return $content;
  }
  
  function GetXtendedFrontendList ($modulename, $moduleid, $listmode = false)
  {
     //return $this->relations->getFrontendRelations($this, $modulename, $moduleid, $listmode);
		return 	MX_XtendedModule::getRelatedItems($modulename, $moduleid);
  }


  /**************************************************************************************

  Relations -- /!\ DEPRECATED /!\ USE THE $this->relations instead /!\

  ***************************************************************************************/


  function getRelatedItems ($modulename)
  {
    return $this->relations->getRelatedItems($modulename);
  }

  function getRelatedItemsById ($modulename, $module_id, $type)
  {
    return $this->relations->getRelatedItemsById ($modulename, $module_id, $type);
  }

  function getSubPagesItems ($pageid, $level = 0, $limit = 0, $separator='-', $separatorend='> ')
  {
    return $this->relations->getSubPagesItems ($pageid, $level, $limit, $separator, $separatorend);
  }

  function insertRelation ($modulename, $relationtype, $relationid, $moduleid)
  {
    return $this->relations->insertRelation ($modulename, $relationtype, $relationid, $moduleid);
  }

  function deleteRelations ($modulename, $moduleid)
  {
    return $this->relations->deleteRelations($modulename, $moduleid);
  }

  function buildFormInput ($modulename, $module_id=0, $type, $items, $formitemname, $id)
  {
    return $this->relations->buildFormInput ($modulename, $module_id, $type, $items, $formitemname, $id);
  }

  function GetMainRelationsSelector ()
  {
    return $this->relations->GetMainRelationsSelector();
  }

  function GetRelationsList ($id, $returnid,$action='defaultadmin')
  {
    return  $this->relations->GetRelationsList ($id, $returnid,$action);
  }

  function relationsAdd($modulename, $type, $relid)
  {
    return $this->relations->relationsAdd($modulename, $type, $relid);
  }

  function removeDeletedRelationByModule ($modulename, $type, $relation_id)
  {
    return $this->relations->removeDeletedRelationByModule ($modulename, $type, $relation_id);
  }

  function removeDeletedRelation ($type, $relation_id)
  {
    return $this->relationsremoveDeletedRelation ($type, $relation_id);
  }



  /***************************************************************************************

  CATEGORY MANAGER FUNCTION -- /!\ DEPRECATED /!\ USE THE $this->categories instead /!\

  ***************************************************************************************/

  function getCategories()
  {
    return $this->categories->getCategories();
  }

  function getReverseCategories()
  {
    return $this->categories->getReverseCategories();
  }

  function getOptions($category_id)
  {
    return $this->categories->getOptions($category_id);
  }

  function getReverseOptions($category_id)
  {
    return $this->categories->getReverseOptions($category_id);
  }

  function getCategoryName($category_id)
  {
    return $this->categories->getCategoryName($category_id);
  }

  function getOptionName($option_id)
  {
    return $this->categories->getOptionName($option_id);
  }

  function getMultiOptions($categories_id)
  {
    return $this->categories->getMultiOptions($categories_id);
  }
  
  //*********************************************
  // Multiple Documents // Images
  //*********************************************

  function DocumentsWindow ($modulename, $moduleid)
  {  	
    global $id; 
    
    $js_call_function = $this->javascripts->loadContentFromHttpFunctionName('multidoc');
    
    $documents_url = html_entity_decode($this->CreateLink($id, 'showDocuments', $returnid, 'show documents', array(
      'disable_theme' => 'true',
      'module_name' => $modulename,
      'module_id' => $moduleid,
      'js_call' => $js_call_function,
  ), '', true));
  
   $this->javascripts->loadContentFromHttp('multidoc', $documents_url);    
        
    $iframe_url = html_entity_decode($this->CreateLink($id, 'manageDocuments', $returnid, 'manage documents', array(
  'disable_theme' => 'true',
   'module_name' => $modulename,
    'module_id' => $moduleid,
    'js_call' => $js_call_function,
    
), '', true));

    $content = '
    <fieldset>
    <legend>' . $this->Lang('documents') . '</legend>
    <div id="multidoc" class="multidoc" style="padding: 5px;"></div>
    ' . $this->javascripts->getJsCall($js_call_function) . '
    <iframe name="manageDocument" src="'. $iframe_url. '"  width="100%" height="70" scrolling="auto" frameborder="0"></iframe>
    </fieldset>';
    
    return $content;
  }

  function ImagesWindow($id, $modulename, $moduleid)
  {
  	$js_call_function = $this->javascripts->loadContentFromHttpFunctionName('xt_images');
    
  	$iframe_url = html_entity_decode($this->CreateLink($id, 'manageImages', $returnid, 'manage images', array(
    'disable_theme' => 'true',
    'module_name' => $modulename,
    'module_id' => $moduleid,
    'js_call' => $js_call_function,    
    ), '', true));
      	
    $images_url = html_entity_decode($this->CreateLink($id, 'showImages', $returnid, 'show images', array(
      'disable_theme' => 'true',
      'module_name' => $modulename,
      'module_id' => $moduleid,
      'js_call' => $js_call_function,
      ), '', true));
          
   $this->javascripts->loadContentFromHttp('xt_images', $images_url);    
  	  	
       $content = '
    <fieldset>
    <legend>' . $this->Lang('images') . '</legend>
    <div id="xt_images" class="xt_images" style="padding: 5px;"></div>
    ' . $this->javascripts->getJsCall($js_call_function) . '
    <iframe name="manageImage" src="'. $iframe_url. '"  width="100%" height="70" scrolling="auto" frameborder="0"></iframe>
    </fieldset>';
    
    return $content;
  }

  function LinksWindow($id, $modulename, $moduleid)
  {
    $js_call_function = $this->javascripts->loadContentFromHttpFunctionName('xt_links');
    
    $iframe_url = html_entity_decode($this->CreateLink($id, 'manageLinks', $returnid, 'manage links', array(
    'disable_theme' => 'true',
    'module_name' => $modulename,
    'module_id' => $moduleid,
    'js_call' => $js_call_function,    
    ), '', true));
        
    $links_url = html_entity_decode($this->CreateLink($id, 'showLinks', $returnid, 'show links', array(
      'disable_theme' => 'true',
      'module_name' => $modulename,
      'module_id' => $moduleid,
      'js_call' => $js_call_function,
      ), '', true));
          
   $this->javascripts->loadContentFromHttp('xt_links', $links_url);    
        
  	
  	 $content = '
    <fieldset>
    <legend>' . $this->Lang('links') . '</legend>
    <div id="xt_links" class="xt_links" style="padding: 5px;"></div>
    ' . $this->javascripts->getJsCall($js_call_function) . '
    <iframe name="manageLinks" src="'. $iframe_url. '"  width="100%" height="70" scrolling="auto" frameborder="0"></iframe>
    </fieldset>';
    
    return $content;
  }
  
  /********************************************
  Tools
  ********************************************/

  function arrayUnserialise ($string, $type='')
  {
    // This function unserialise an array given like a string

    $array1 = split(',', $string);

    if ($type == 'assoc')
    {
      $array2 = array();

      foreach ($array1 as $subarray)
      {
        $tmparray = array();
        $tmparray = split('=>', $subarray);
        $array2[trim($tmparray[0])] = trim($tmparray[1]);
      }
    }
    else
    {
      $array2 = $array1;
    }

    return $array2;
  }  
  /* CLASS END */
}

/* BEHAVIOR TO THE SELECT GENERATOR */
if(!function_exists('MC_CreateInputSelectList'))
{

	function MC_CreateInputSelectList($id, $name, $items, $selecteditems=array(), $size=3, $addttext='', $multiple = true)
	{
	  $id = cms_htmlentities($id);
	  $name = cms_htmlentities($name);
	  $size = cms_htmlentities($size);
	  $multiple = cms_htmlentities($multiple);
	
		$text = '<select name="'.$id.$name.'"';
		if ($addttext != '')
		{
			$text .= ' ' . $addttext;
		}
		if( $multiple )
		  {
			$text .= ' multiple="multiple" ';
		  }
		  
		  if ($size > 1)
		  {
		  	$text .= ' size="'.$size.'"';
		  }
		
		$text .= '>';
		
		$count = 0;
		foreach ($items as $key=>$value)
		{
		  $value = cms_htmlentities($value);
	
			$text .= '<option value="'.$key.'"';
			if (in_array($key, $selecteditems))
			{
				$text .= ' ' . 'selected="selected"';
			}
			$text .= '>';
			$text .= $value;
			$text .= '</option>';
			$count++;
		}
		$text .= '</select>'."\n";
	
		return $text;
	}
}
?>