<?php

	/* 
	
	Relation Module class
	
	This class is made to provide a relation system for the module.
		
	Copyrights: Jean-Christophe Cuvelier - Morris & Chapman Belgium
	
	VERSION: 0.0.1
		
	REQUIRE: CategoryManager
	
	*/
	
	class XT_Relations extends CmsObject {
		
			
		var $module;
		var $deleteicon = '/modules/ModuleXtender/images/icons/delete.gif';
		var $editicon = '/modules/ModuleXtender/images/icons/edit.gif';
		var $config = array();
		
		
		function XT_Relations(&$module)
		{
			$this->module = $module;
			$this->config = $this->module->GetConfig();
			$this->deleteicon = $this->config['root_url'].'/modules/ModuleXtender/images/icons/delete.gif';
			$this->editicon = $this->config['root_url'].'/modules/ModuleXtender/images/icons/edit.gif';
		}
		
		// Refactorised 2009
	/*	
		public static function RetrieveRelations($modulename, $module_id)
		{
			$main_relations = MX_Relation::doSelect(array('where' => array('modulename' => $modulename, 'is_visible' => 1)));
      			
			$relations = array();
			
		  foreach ($relations as $relation)
	    {
	      if ($relation->getType() == 'page' && $relation->getHaveSub() == 0)
	      {
	        $relations['related']['items'][$relation->getId()] = $relation->getTitle(false, true);
	      }
	      else
	      {        
	      	//$tmp = $relation->getRelated
	       // $relations[$relation->getId()]['items'] = $relation;
	      }
	    }
			
		}		*/
		
		//------------------------
		
	  function getItemsRelatedByPages($modulename, $rightjoin, $pages, $order = array())
    {
      global $gCms;
      $db =& $this->module->GetDb();
      
      $query = '
      SELECT *, count(module_id) as nbpages
      FROM ' . cms_db_prefix() . 'module_modulextender_relations_link 
      RIGHT JOIN ' . $rightjoin . ' ON ' . $rightjoin . '.id = cms_module_modulextender_relations_link.module_id
      WHERE modulename = \'' . $modulename . '\' AND rel_code = \'pages\' AND rel_id IN (' .
      
      implode(',', $pages)
      
      . ') GROUP BY module_id';
      
      if(count($order) > 0)
          {
              $query .= ' ORDER BY ' . implode(' , ', $order);
          }
      
      
      $dbresult = $db->Execute($query);
      
      $rows = array();
      
      while ($dbresult && $row = $dbresult->FetchRow())
        {
         if ($row['nbpages'] == count($pages))
          {
             $rows[] = $row;   
         }
     }
      
     return $rows; 
    }
		
		function getRelatedItems ($modulename)
		{
						// Should return all related pages and categories
			
			$returnarray = array();
			
			global $gCms;
	
			$contentops =& $gCms->GetContentOperations();
			
			$db =& $this->module->GetDb();
			
			$query = "SELECT * FROM ".cms_db_prefix()."module_modulextender_relations WHERE modulename = ? ORDER BY position";
			
			$dbresult = $db->Execute($query, array($modulename));
			
			$pagescount = 0;
			$categoriescount = 0;
			
			while ($dbresult && $row = $dbresult->FetchRow())
			{
				if ($row['rel_type'] == 'page' && $row['have_sub'] == 0 && $currow = &$contentops->LoadContentFromId($row['rel_id']))
				{			
					$returnarray['relatedpages']['friendlyname'] = $this->module->Lang('related_pages');
					$returnarray['relatedpages']['type'] = 'pages';
	
					$returnarray['relatedpages']['items'][$row['rel_id']] = $currow->MenuText();
				}
				elseif ($row['rel_type'] == 'page'&& $row['have_sub'] == 1 && $currow = &$contentops->LoadContentFromId($row['rel_id']))
				{
					if ($row['title'] != '')
					{
						$returnarray['pages'.$pagescount]['friendlyname'] = $row['title'];
					}
					else 
					{
						$returnarray['pages'.$pagescount]['friendlyname'] = $currow->MenuText();
					}
					$returnarray['pages'.$pagescount]['type'] = 'pages';
						
					$returnarray['pages'.$pagescount]['items'] = $this->getSubPagesItems($row['rel_id']);
						
					$pagescount++;
				}
			   elseif ($row['rel_type'] == 'page'&& $row['have_sub'] == 2 && $currow = &$contentops->LoadContentFromId($row['rel_id']))
        {
        	
          if ($row['title'] != '')
          {
            $returnarray['pages'.$pagescount]['friendlyname'] = $row['title'];
          }
          else 
          {
            $returnarray['pages'.$pagescount]['friendlyname'] = $currow->MenuText();
          }
          $returnarray['pages'.$pagescount]['type'] = 'pages';
            
          $array0 = array($row['rel_id'] => $currow->MenuText());
          $array1 =  $this->getSubPagesItems($row['rel_id'], 1, 0, ' -');
          
          $returnarray['pages'.$pagescount]['items'] = $array0 + $array1;
            
          $pagescount++;
        }
				elseif ($row['rel_type'] == 'category')
				{
				
          if ($row['title'] != '')
          {
            $returnarray['category'.$categoriescount]['friendlyname']  = $row['title'];
          }
          else 
          {
          	$returnarray['category'.$categoriescount]['friendlyname'] = $this->module->categories->getCategoryName($row['rel_id']);
          }
					$returnarray['category'.$categoriescount]['type'] = 'options';
					$returnarray['category'.$categoriescount]['items'] = $this->module->categories->getOptions($row['rel_id']);
					
					$categoriescount++;
				}
			}	
			
			return $returnarray;
		}
		
		function getRelatedItemsById ($modulename, $module_id, $type)
		{
			// First, retrive defined ones
			
			$db =& $this->module->GetDb();	
			
			$query = 'SELECT * FROM '.cms_db_prefix().'module_modulextender_relations_link WHERE rel_code = ? AND modulename = ? AND module_id = ?';
			$dbresult = $db->Execute($query, array($type, $modulename, $module_id));
			
			$itemselected = array();
			
			while ($dbresult && $row = $dbresult->FetchRow())
			{
				$itemselected[] = $row['rel_id'];
			}
			
			return $itemselected;
		}
		
		function getRelatedModuleItemsPerType($modulename, $item_id, $type)
		{			
			 /*
			 $db =& $this->module->GetDb();  
      
			 if (is_array($item_id))
			 {
			 	$list = array();
			 	foreach ($item_id as $item) 
			 	{
			 		$list[] = mysql_real_escape_string($item);
			 	}			 	
			 	
        $query = 'SELECT * FROM '.cms_db_prefix().'module_modulextender_relations_link WHERE rel_code = ? AND modulename = ? AND rel_id IN (' ."'" . implode("','", $list) . "'" . ')';
        $dbresult = $db->Execute($query, array($type, $modulename));
			 }
			 else
			 {      
        $query = 'SELECT * FROM '.cms_db_prefix().'module_modulextender_relations_link WHERE rel_code = ? AND modulename = ? AND rel_id = ?';
        $dbresult = $db->Execute($query, array($type, $modulename, $item_id));
      
			 }
			 
      
      $itemselected = array();
      
      while ($dbresult && $row = $dbresult->FetchRow())
      {
        $itemselected[] = $row['module_id'];
      }
      
      return $itemselected;*/
      
         return MX_RelationLink::getRelatedItemsIds($modulename, $item_id, $type);
		}
		
		function getRelatedModuleItemsPerPage($modulename, $page_id)
		{
			return $this->getRelatedModuleItemsPerType($modulename, $page_id, 'pages');
		}
		
		function getRelatedModuleItemsFromCurrentPage($modulename)
		{
			global $gCms;
			
			return $this->getRelatedModuleItemsPerPage($modulename, $gCms->variables['content_id']);
		}
		
		function getSubPagesItems ($pageid, $level = 0, $limit = 0, $separator='-', $separatorend='> ')
		{
			// Recursive function 
			
			$prefix = '';
			
			if ($level > 0)
			{				
				for ($i = 0; $i< $level; $i++)
				{
					$prefix .= $separator;
				}
				
				$prefix .= $separatorend;
			}
			
			
			$subpagelist = array();
			
			global $gCms;
			
			$hm =& $gCms->GetHierarchyManager();
			
			// Build the array
			
			$currentnode =& $hm->getNodeById($pageid);
			
			
			if ($currentnode->hasChildren())
			{
				// In this case we can go 'upstair'
				
				$childnodes = &$currentnode->getChildren();
				
				foreach ($childnodes as $node)
				{
					$nodecontent = &$node->GetContent();
					
					if ($nodecontent && $nodecontent->Active())
					{	
						
						$subpagelist[$nodecontent->mId] = $prefix.$nodecontent->MenuText();
						
						if ($limit == 0 || $level <= $limit)
						{
							$subpagelist = $subpagelist + $this->getSubPagesItems($nodecontent->mId, $level+1, $limit, $separator, $separatorend);
						}
						
					}
				}	
			}	
			
			return $subpagelist;
		}
		
		function insertRelation ($modulename, $relationtype, $relationid, $moduleid)
		{
			$db =& $this->module->GetDb();
			
			$relid = $db->GenID(cms_db_prefix()."module_modulextender_relations_link_seq");
							
			$query = "INSERT INTO ".cms_db_prefix()."module_modulextender_relations_link (id, modulename, rel_code, rel_id, module_id) VALUES (?, ?, ?, ?, ?)";
			$db->Execute($query, array($relid, $modulename, $relationtype, $relationid, $moduleid));
	
			return true;	
		}
	
		function deleteRelations ($modulename, $moduleid)
		{
			$db =& $this->module->GetDb();
					
			$query = "DELETE FROM ".cms_db_prefix()."module_modulextender_relations_link WHERE modulename = ? AND module_id = ?";
			$db->Execute($query, array($modulename, $moduleid));
			
			return true;
		}
	
		function buildFormInput ($modulename, $module_id=0, $type, $items, $formitemname, $id)
		{
					
			$itemselected = $this->getRelatedItemsById($modulename, $module_id, $type);
			
			// Then build the form thing
			
			$formhtml = '<div class="pageoverflow">
			<p> ';
			
			if (count($items) < 5)
			{
				foreach ($items as $itemid => $name)
				{
					$formhtml .= $this->module->CreateInputCheckbox($id, $formitemname.'['.$itemid.']', !in_array($itemid, $itemselected)).' '.$name.' <br />';
				}
			}
			
			else 
			{
				$formhtml .= MC_CreateInputSelectList($id, $formitemname.'[]', $items, $itemselected, 10);
				
				$formhtml .= '</p>
				<p>'.$this->module->Lang('tips').'<br />'.$this->module->Lang('tips1');
			}
			
			$formhtml .= '</p>
			</div>';
			
			return $formhtml;
		}
		
		function GetMainRelationsSelector ()
		{
			return false;	
		}	

		function GetRelationsList ($id, $returnid,$action='defaultadmin')
		{
			global $gCms;
			
			$contentops =& $gCms->GetContentOperations();
						
			$db = &$this->module->GetDb();
			
			$query = "SELECT * FROM ".cms_db_prefix()."module_modulextender_relations";
			$dbresult = $db->Execute($query);
			
			$relarray = array();
			
			$rowclass = 'row1';
		
				while ($dbresult && $row = $dbresult->FetchRow())
				{
					$onerow = new stdClass();
							
					$onerow->id = $row['id'];
					
					$onerow->rel_id =  $row['rel_id'];
					
					
					
					if ($row['rel_type'] == 'page' && $row['have_sub'] == 1)
					{
						$onerow->rel_type = $this->module->Lang('title_pages');
					}
					else 
					{
						$onerow->rel_type =  $this->module->Lang('title_'.$row['rel_type']);
					}
					
					
					if ($row['rel_type'] == 'category')
					{
						$onerow->title =  $this->module->categories->getCategoryName($row['rel_id']);
					}
					elseif ($row['rel_type'] == 'page')
					{
						$currow = &$contentops->LoadContentFromId($row['rel_id']);
						
						$onerow->title = $currow->MenuText();
					}
					
					// 
					
					if ($row['rel_type'] == 'page' && $row['have_sub'] == 1)
					{
						// Create an hidde button
						$onerow->sublink = $this->module->CreateLink($id, 'editRelation', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif', $this->module->Lang('deactiveate_rel'),'','','systemicon'), array('relid'=>$row['id'], 'have_sub'=>0), '');
					}
					elseif($row['rel_type'] == 'page')
					{
						// Create a show button
						$onerow->sublink = $this->module->CreateLink($id, 'editRelation', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/false.gif', $this->module->Lang('activeate_rel'),'','','systemicon'), array('relid'=>$row['id'], 'have_sub'=>1), '');
					}
					else 
					{
						$onerow->sublink = '';
					}
					
					if ($row['is_visible'] == 1)
					{
						// Create an hidde button
						$onerow->editlink = $this->module->CreateLink($id, 'editRelation', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif', $this->module->Lang('deactiveate_rel'),'','','systemicon'), array('relid'=>$row['id'], 'is_visible'=>0), '');
					}
					else 
					{
						// Create a show button
						$onerow->editlink = $this->module->CreateLink($id, 'editRelation', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/false.gif', $this->module->Lang('activeate_rel'),'','','systemicon'), array('relid'=>$row['id'], 'is_visible'=>1), '');
					}
					
					$onerow->deletelink = $this->module->CreateLink($id, 'deleteRelation', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->module->Lang('deleterel'),'','','systemicon'), array('relid'=>$row['id']), $this->module->Lang('areyousure'));
							
					$onerow->rowclass = $rowclass;
			
					
					
					$relarray[] = $onerow;
				
					($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
				}
						
				$this->module->smarty->assign_by_ref('relations', $relarray);
				$this->module->smarty->assign('relcount', count($relarray));
				
				// Some other params
				
				//echo $this->module->Lang('')
				
		
		
				$this->module->smarty->assign('title_relations',$this->module->Lang('title_relations'));
				$this->module->smarty->assign('title_type',$this->module->Lang('title_type'));
				$this->module->smarty->assign('title_visible',$this->module->Lang('title_visible'));
				$this->module->smarty->assign('title_subpage',$this->module->Lang('title_subpage'));
			
				// Cat Rels Form	
		
				$this->module->smarty->assign('form_cat_start',$this->module->CreateFormStart($id, $action, $returnid));
				
				$this->module->smarty->assign('title_category',$this->module->Lang('title_category'));
				
			
							
				$this->module->smarty->assign('category_dropdown', $this->module->CreateInputDropdown($id, 'add_cat_id', array_merge(array($this->module->Lang('select_cat')=>''), $this->module->categories->getReverseCategories()), -1) );
					
				
				
				$this->module->smarty->assign('submit_cat_button',$this->module->CreateInputSubmit($id, 'submit', $this->module->Lang('add_cat')));	
						
				$this->module->smarty->assign('form_cat_end',$this->module->CreateFormEnd());
				
				
				// Pages rels forms		          
		    
			    $this->module->smarty->assign('form_page_start',$this->module->CreateFormStart($id, $action, $returnid));
				
				$this->module->smarty->assign('title_page',$this->module->Lang('title_page'));
				
			    $this->module->smarty->assign('content_dropdown', $contentops->CreateHierarchyDropdown());	
				
				$this->module->smarty->assign('submit_page_button',$this->module->CreateInputSubmit($id, 'submit', $this->module->Lang('add_page')));	
						
				$this->module->smarty->assign('form_page_end',$this->module->CreateFormEnd());
				
				$this->module->smarty->assign('tab_rel_selected', $this->module->CreateInputHidden($id, $this->activetab, 'relations'));
				
				$this->module->smarty->assign('relations_page', $this->module->ProcessTemplateFromData($this->relationlisttemplate));
				
				return  $this->module->ProcessTemplateFromData($this->relationlisttemplate);
		}
			
		function relationsAdd($modulename, $type, $relid)
		{
			$db =& $this->module->GetDb();
		
			// We check non existence
		
			$query = "SELECT * FROM ".cms_db_prefix()."module_modulextender_relations WHERE modulename = ? AND rel_type = ? AND rel_id = ?";
		
			
			$dbresult = $db->Execute($query, array($modulename, $type, $relid));
			
			// We populate the array
			
			$rel_exists = false;
			
			while ($dbresult && $row = $dbresult->FetchRow())
			{
				$rel_exists = true;
			}
			
			if (!$rel_exists && $relid != '')
			{
				$dbrelid = $db->GenID(cms_db_prefix()."module_modulextender_relations_seq");
							
				$query = 'INSERT INTO '.cms_db_prefix()."module_modulextender_relations (id, modulename, rel_type, rel_id, is_visible, have_sub) VALUES (?,?,?,?,1,0)";
							
				$db->Execute($query, array($dbrelid,$modulename,$type,$relid));
			}
			
			return true;
		}
		
		function removeDeletedRelationByModule ($modulename, $type, $relation_id)
		{
			$db =& $this->module->GetDb();
			
			$query = "DELETE FROM ".cms_db_prefix()."module_modulextender_relations WHERE modulename = ? AND rel_type = ? AND rel_id = ?";
			
			$dbresult = $db->Execute($query, array($modulename, $type, $relation_id));
			
			return true;
		}
		
		function removeDeletedRelation ($type, $relation_id)
		{
			$db =& $this->module->GetDb();
			
			$query = "DELETE FROM ".cms_db_prefix()."module_modulextender_relations WHERE rel_type = ? AND rel_id = ?";
			
			$dbresult = $db->Execute($query, array($type, $relation_id));
			
			return true;
		}
		//----------------
		// To be refactored
			
		public function getFrontendRelations($module, $modulename, $moduleid, $listmode = false)
		{
			/*
			    $felist = new stdClass();

			    $felist->documents = MX_Document::doSelect(array('where' => array('modulename' => $modulename, 'module_id' => $moduleid, 'type' => 'document')));
			    			    
			    foreach ($felist->documents as $document)
			    {
			    	  $document->url = $document->getUrl($module->config['uploads_url']);
			    	  $document->categories = MX_RelatedCategory::getRelatedOptions($document->getId(), 'documents');
			    }
			    
			    //$felist->documents = $module->documents->GetDocumentsList($modulename, $moduleid, true);
			
			    $module->smarty->assign('listmode', $listmode);
			
			    if (count($felist->documents) > 0)
			    {
			      $module->smarty->assign('XtenderDocuments', $felist->documents);// TODO: To be removed
			      $felist->documentscontent = $module->ProcessTemplateFromDatabase($module->GetPreference('fe.documents'));
			      $module->smarty->assign('XtenderDocumentslist', $felist->documentscontent);
			    }
			    else
			    {
			      $felist->documentscontent = '';
			    }
			
			    $felist->images = MX_Image::doSelect(array('where' => array('modulename' => $modulename, 'module_id' => $moduleid, 'type' =>'image')));
         			   			    
		     foreach ($felist->images as $document)
          {
				    	$document->categories = MX_RelatedCategory::getRelatedOptions($document->getId(), 'images');
              $document->url = $document->getUrl($module->config['uploads_url'], 'images');
              $document->image = $document->url;
              $document->thubnails = $document->getUrl($module->config['uploads_url'], 'images/thumbnails');   
              $document->resized_images = $document->getThumbnailsPath($document->getUrl($module->config['uploads_url'], 'images', false));
          }
			    
			    //  $felist->images = $module->documents->GetImagesList($modulename, $moduleid, true);
			
			    if (count($felist->images) > 0)
			    {
			      $module->smarty->assign('XtenderImages', $felist->images);// TODO: To be removed
			      $felist->imagescontent  =  $module->ProcessTemplateFromDatabase($module->GetPreference('fe.images'));
			      $module->smarty->assign('XtenderImageslist', $felist->imagescontent);
			    }
			    else
			    {
			      $felist->imagescontent = '';
			    }
			
			    $felist->links = MX_Link::doSelect(array('where' => array('modulename' => $modulename, 'module_id' => $moduleid)));
			
			    foreach ($felist->links as $link)
			    {			    	
              $link->categories = MX_RelatedCategory::getRelatedOptions($document->getId(), 'links');
			    }
			    
			    $felist->pages = $module->pages->GetPagesList($modulename, $moduleid);
			
			    if (count($felist->pages) > 0)
			    {
			      $module->smarty->assign('XtenderPages', $felist->pages);// TODO: To be removed
			      $felist->pagescontent  =  $module->ProcessTemplateFromDatabase($module->GetPreference('fe.pages'));
			      $module->smarty->assign('XtenderPageslist', $felist->pagescontent);
			    }
			    else
			    {
			      $felist->pagescontent = '';
			    }
			
			   // Get all related categories from a given module		    
			
			    $felist->categories = $module->categories->GetCategoriesList($modulename, $moduleid);
			
			    if (count($felist->categories) > 0)
			    {
			      $module->smarty->assign('XtenderCategories', $felist->categories); // TODO: To be removed
			      $felist->categoriescontent  =  $module->ProcessTemplateFromDatabase($module->GetPreference('fe.categories'));
			      $module->smarty->assign('XtenderCategorieslist', $felist->categoriescontent);
			    }
			    else
			    {
			      $felist->categoriescontent = '';
			    }
			
			  // Modules
			  
			  $modules = MX_RelationLink::doSelect(array('where' => array('modulename' => $modulename, 'module_id' => $moduleid, 'rel_code' => 'items')));  
			  
			  $modules_array = array();
			  foreach ($modules as $related_module)
			  {
			    $modules_array[] = $related_module->getRelation();
			  }      
			  $felist->modules = $modules_array;
			
			  $felist->general = $module->ProcessTemplateFromDatabase($module->GetPreference('fe.general'));
			
			return $felist;
			*/
			    $module->smarty->assign('listmode', $listmode); // Deprecated
			    return 	MX_XtendedModule::getRelatedItems($modulename, $moduleid);
		}
		
		public function getFEAvailableItems($modulename)
		{
			$db =& $this->GetDb();
			
			
		}				
	}
	
?>