<?php
  
  /*
   * Relation class
   * 
   * This class allow management of a relation object
   * 
   * 
   * Copyrights: Morris & Chapman Belgium - Jean-Christophe Cuvelier - 2009
   * 
   */

class MX_ModuleItem extends CmsObject 
{
  var $id;
  var $title;
  var $module_name;
  
  const ITEMS_NAME = 'items';
	const ITEM_NAME = 'item';
	
  
  public function __toString()
  {
    return $this->getTitle();
  }
  
  public function getItemsName()
  {
    return $this->getModuleName();
  }
  
  public function getItemName()
  {
    return $this->getModuleName();
  }
  
  public function setId($value)
  {
    $this->id = $value;
  }
  
  public function setTitle($value)
  {
    $this->title = $value;
  }
  
  public function setModuleName($value)
  {
     $this->module_name = $value;
  }
  
  public function getModuleName()
  {
     return $this->module_name;
  }
   
  
  public function getId()
  {
    return $this->id;
  }
  
  public function getTitle()
  {
    return $this->title;
  }
  
  public static function loadFromArray($array, $modulename)
  {
    $items = array();
    
    foreach ($array as $id => $relation)
    {
      $item = new self();
      $item->setId($id);
      $item->setTitle($relation);
      //$item->setTitle($relation->getTitle());
      $item->setModuleName($modulename);
      $items[$id] = $item;
    }
    
    return $items;
  }
  
  public static function doSelect($params = array())
  {
    // TODO: This presume we are using MC Factory !
    
    if (isset($params['where']['module_name']) && isset($params['where']['module_id']))
    {
      $called_item = call_user_func(array($params['where']['module_name'] . 'Object', 'getById'), $params['where']['module_id']);
      if (is_object($called_item))
      {
         $item = new self();
         $item->setId($called_item->getId());
         $item->setTitle($called_item->getTitle());
         $item->setModuleName($params['where']['module_name']);
         return $item;
      }
      else
      {
         return null;
      }
    }
    else
    {
      return null;
    }
  }
}