<?php

class MCFTemplate extends Smarty {

	protected $module;
	protected $source;
	protected $destination;
	protected $cmsConfig;

	public function __construct($module, $source, $destination) {
		global $gCms;
		parent::__construct();
		$this->module = $module;
		$this->source = $source;
		$this->destination = $destination;
		$this->cmsConfig = $gCms->GetConfig();
		$this->template_dir = $this->cmsConfig['root_path'] . '/modules/MCFactory/smarty/templates';
		$this->compile_dir = $this->cmsConfig['root_path'] . '/modules/MCFactory/smarty/templates_c';
		$this->config_dir = $this->cmsConfig['root_path'] . '/modules/MCFactory/smarty/config';
		$this->force_compile = true;
		$this->left_delimiter = '{{';
		$this->right_delimiter = '}}';
	}

	public function save() {
		$contents = $this->fetch($this->source);
		file_put_contents($this->cmsConfig['root_path'] . '/modules/' . $this->module . '/' . $this->destination, $contents);
		$this->clear_compiled_tpl();
	}

}

?>