<?php

/**
 * MCFModule Class
 * 
 * This class handle all the manipulations on the M&C Factory Module object
 * 
 * NOTE: It should be split in two classes but for convinience, It won't.
 *
 * FIXME: Check the security processus !
 * 
 */

class MCFModule {

	////////////////////////////////////////////////////////////
	// CLASS PROPERTIES ////////////////////////////////////////
	////////////////////////////////////////////////////////////

	protected $id;
	protected $module_name;
	protected $module_friendlyname;
	protected $module_version = 1;
	protected $title_name;
	protected $created_at;
	protected $created_by;
	protected $updated_at;
	protected $updated_by;
	protected $extra_fields = array();
	protected $delete_fields = array();
	protected $filters = array();
	protected $parent_module;

	protected $is_modified = false;

	////////////////////////////////////////////////////////////
	// CLASS METHODS ///////////////////////////////////////////
	////////////////////////////////////////////////////////////

	// GETTER FUNCTIONS

	public function getId() {
		return $this->id;
	}

	public function getModuleName() {
		return $this->module_name;
	}

	public function getModuleFriendlyname() {
		return $this->module_friendlyname;
	}

	public function getModuleVersion() {
		return $this->module_version;
	}

	public function getCreatedAt() {
		return $this->created_at;
	}

	public function getCreatedBy() {
		return $this->created_by;
	}

	public function getUpdatedAt() {
		return $this->updated_at;
	}

	public function getUpdatedBy() {
		return $this->updated_by;
	}

	public function getExtraFields() {
		return $this->extra_fields;
	}

	public function getDeleteFields() {
		return $this->delete_fields;
	}

	public function getFilters() {
		return $this->filters;
	}

	public function getParentModule() {
		return $this->parent_module;
	}

	// SETTER FUNCTIONS

	protected function set($name, $value) {
		if ($this->$name != $value) {
			$this->$name = $value;
			$this->is_modified = true;
		}
	}

	public function setId($value) {
		$this->set('id', $value);
	}

	public function setModuleName($value) {
		$this->set('module_name', $value);
	}

	public function setModuleFriendlyname($value) {
		$this->set('module_friendlyname', $value);
		$value = preg_replace('/\W/', ' ', $value);
		$value = ucwords(strtolower($value));
		$value = preg_replace('/\s/', '', $value);
		$this->set('module_name', $value);
	}

	public function setModuleVersion($value) {
		$this->set('module_version', $value);
	}

	public function setCreatedAt($value) {
		$this->set('created_at', $value);
	}

	public function setCreatedBy($value) {
		$this->set('created_by', $value);
	}

	public function setUpdatedAt($value) {
		$this->set('updated_at', $value);
	}

	public function setUpdatedBy($value) {
		$this->set('updated_by', $value);
	}

	public function setExtraFields($value) {
		$blacklist = array('id', 'parent_id', 'title', 'created_at', 'created_by', 'updated_at', 'updated_by', 'order_by', 'parent', 'parent_module', 'published', 'order', 'order_by', 'from', 'select', 'in', 'date');
		$filter = array();
		if (is_array($value)) {
			foreach ($value as $field) {
				$field['name'] = preg_replace('/\W/', '', $field['name']);
				if (!empty($field['name']) && !in_array($field['name'], $blacklist)) {
					$filter[] = $field;
				}
			}
		}
		$this->set('extra_fields', $filter);
	}

	public function setDeleteFields($value) {
		$this->set('delete_fields', $value);
	}

	public function setFilters($value) {
		if (is_array($value)) {
			foreach ($value as &$filter) {
				$filter['name'] = preg_replace('/\W/', '', $filter['name']);
				$filter['field'] = preg_replace('/\W/', '', $filter['field']);
			}
		}
		$this->set('filters', $value);
	}

	public function setParentModule($value) {
		$this->set('parent_module', $value);
	}

	// OTHER FUNCTIONS

	public function getFieldTypes() {
		return array(
			'text' => array(
				'type' => 'text',
				'label' => 'Text field',
				'column_type' => 'C(255)',
				'form_type' => 'text',
				'options' => false
			),
			'textarea' => array(
				'type' => 'textarea',
				'label' => 'Text area',
				'column_type' => 'X',
				'form_type' => 'textarea',
				'options' => false
			),
			'textarea_plain' => array(
				'type' => 'textarea_plain',
				'label' => 'Text area (no WYSIWYG)',
				'column_type' => 'X',
				'form_type' => 'textarea_plain',
				'options' => false
			),
			'select' => array(
				'type' => 'select',
				'label' => 'Dropdown',
				'column_type' => 'C(255)',
				'form_type' => 'select',
				'options' => true,
				'options_default' => 'option1,option2'
			),
			'date' => array(
				'type' => 'date',
				'label' => 'Date',
				'column_type' => 'D',
				'form_type' => 'text',
				'options' => false
			),
			'document' => array(
				'type' => 'document',
				'label' => 'Document',
				'column_type' => 'C(255)',
				'form_type' => 'file',
				'options' => false
			),
			'image' => array(
				'type' => 'image',
				'label' => 'Image',
				'column_type' => 'C(255)',
				'form_type' => 'file',
				'options' => true,
				'options_default' => '150x150'
			),
			'country' => array(
				'type' => 'country',
				'label' => 'Country',
				'column_type' => 'C(255)',
				'form_type' => 'select',
				'options' => true,
				'options_default' => ''
			)
		);
	}

	public function getFilterTypes() {
		return array(
			'equal' => array(
				'type' => 'equal',
				'label' => 'Equal',
				'criteria' => 'EQUAL'
			),
			'like' => array(
				'type' => 'like',
				'label' => 'Like (wildcard %)',
				'criteria' => 'LIKE'
			),
			'less' => array(
				'type' => 'less',
				'label' => 'Less than',
				'criteria' => 'LESS_THAN'
			),
			'less_equal' => array(
				'type' => 'less_equal',
				'label' => 'Equal or less than',
				'criteria' => 'LESS_EQUAL'
			),
			'greater' => array(
				'type' => 'greater',
				'label' => 'Greater than',
				'criteria' => 'GREATER_THAN'
			),
			'greater_equal' => array(
				'type' => 'greater_equal',
				'label' => 'Equal or greater than',
				'criteria' => 'GREATER_EQUAL'
			),
			'not_empty' => array(
				'type' => 'not_empty',
				'label' => 'Not empty',
				'criteria' => 'ISNOTEMPTY'
			),
			'empty' => array(
				'type' => 'empty',
				'label' => 'Empty',
				'criteria' => 'ISEMPTY'
			)
		);
	}

	public function populateFromArray(array $params) {
		if (isset($params['id'])) {
			$this->setId($params['id']);
		}
		if (isset($params['module_name'])) {
			$this->setModuleName($params['module_name']);
		}
		if (isset($params['module_friendlyname'])) {
			$this->setModuleFriendlyname($params['module_friendlyname']);
		}
		if (isset($params['module_version'])) {
			$this->setModuleVersion($params['module_version']);
		}
		if (isset($params['created_by'])) {
			$this->setCreatedBy($params['created_by']);
		}
		if (isset($params['created_at'])) {
			$this->setCreatedAt($params['created_at']);
		}
		if (isset($params['updated_by'])) {
			$this->setUpdatedBy($params['updated_by']);
		}
		if (isset($params['updated_at'])) {
			$this->setUpdatedAt($params['updated_at']);
		}
		if (isset($params['extra_fields'])) {
			$this->setExtraFields($params['extra_fields']);
		} else {
			$this->setExtraFields(array());
		}
		if (isset($params['delete_fields'])) {
			$this->setDeleteFields($params['delete_fields']);
		}
		if (isset($params['filters'])) {
			$this->setFilters($params['filters']);
		} else {
			$this->setFilters(array());
		}
		if (isset($params['parent_module'])) {
			$this->setParentModule($params['parent_module']);
		}
	}

	// DATABASE FUNCTIONS

	public static function getById($id) {
		$sql = 'SELECT * FROM '.cms_db_prefix().'module_mcfactory_modules
			WHERE id = ?';
		$values = array($id);
		$result = self::query($sql, $values);
		if ($result && $row = $result->FetchRow()) {
			$module = new self();
			$module->populateFromArray($row);
			return $module;
		} else {
			return false;
		}
	}

	public static function query($sql, $values = array()) {
		global $gCms;
		$db = $gCms->GetDb();
		return $db->execute($sql, $values);
	}

	public static function doSelect(MCFCriteria $c) {
		global $gCms;
		$db = $gCms->GetDb();
		$query = $c->buildQuery(cms_db_prefix().'module_mcfactory_modules');
		$result = $db->execute($query, $c->values);
		$modules = array();
		while ($result && ($row = $result->FetchRow())) {
			$module = new self();
			$row['extra_fields'] = unserialize($row['extra_fields']);
			$row['filters'] = unserialize($row['filters']);
			$module->populateFromArray($row);
			$module->is_modified = false;
		    $modules[] = $module;
		}
		return $modules;
	}

	public static function doSelectOne(MCFCriteria $c) {
		$c->setLimit(1);
		$result = self::doSelect($c);
		if (count($result) > 0) {
			return $result[0];
		} else {
			return false;
		}
	}

	public static function retrieveByPk($pk) {
		$c = new MCFCriteria();
		$c->add('id', $pk);
		return self::doSelectOne($c);
	}

	public function save() {
		if (empty($this->id)) {
			return $this->insert();
		} else {
			return $this->update();
		}
	}

	protected function insert() {
		global $gCms;
		$db = $gCms->GetDb();
		$this->setId($db->GenID(cms_db_prefix().'module_mcfactory_modules_seq'));
		$query = 'INSERT INTO '.cms_db_prefix().'module_mcfactory_modules
			SET id = ?,
				module_name = ?,
				module_friendlyname = ?,
				module_version = 1,
				created_by = ?,
				created_at = NOW(),
				updated_by = ?,
				updated_at = NOW(),
				extra_fields = ?,
				filters = ?,
				parent_module = ?';
		$db->Execute($query, array(
			$this->getId(),
			$this->getModuleName(),
			$this->getModuleFriendlyname(),
			get_userid(),
			get_userid(),
			serialize($this->getExtraFields()),
			serialize($this->getFilters()),
			$this->getParentModule()
		));
		$result = $db->Execute('SELECT LAST_INSERT_ID() AS id');
		$row = $result->FetchRow();
		$this->setId($row['id']);
		return true;
	}

	protected function update() {
		global $gCms;
		$db = $gCms->GetDb();
		$this->setModuleVersion($this->getModuleVersion() + 1);
		$query = 'UPDATE '.cms_db_prefix().'module_mcfactory_modules
			SET module_name = ?,
				module_friendlyname = ?,
				module_version = ?,
				updated_by = ?,
				updated_at = NOW(),
				extra_fields = ?,
				filters = ?,
				parent_module = ?
			WHERE id = ?';
		$db->Execute($query, array(
			$this->getModuleName(),
			$this->getModuleFriendlyname(),
			$this->getModuleVersion(),
			get_userid(),
			serialize($this->getExtraFields()),
			serialize($this->getFilters()),
			$this->getParentModule(),
			$this->getId()
		));
		return true;
	}

	public function delete() {
		if ($this->getId()) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_mcfactory_modules WHERE id = ?';
			$this->query($query, array($this->getId()));
		}
		return true;
	}

	protected function publishFile($destination, $source = null) {
		global $gCms;
		if (is_null($source)) {
			$source = $destination . '.tpl';
		}
		$tpl = new MCFTemplate($this->getModuleName(), $source, $destination);
		$tpl->assign('module', $this);
		$tpl->assign('table_name', strtolower($this->getModuleName()));
		$tpl->assign('has_admin', $this->getParentModule() ? 'false' : 'true');
		$tpl->assign('parent_module', $this->getParentModule() ? MCFModule::retrieveByPk($this->getParentModule()) : false);
		$tpl->assign('mcfactoryversion', $gCms->modules['MCFactory']['object']->getVersion());
		$extra_fields = $this->getExtraFields();
		$fieldTypes = $this->getFieldTypes();
		foreach ($extra_fields as &$field) {
			$words = explode('_', $field['name']);
			foreach ($words as &$word) {
				$word = ucfirst($word);
			}
			unset($word);
			$field['camelcase'] = implode('', $words);
			$field['friendlyname'] = implode(' ', $words);
			$field['column_type'] = $fieldTypes[$field['type']]['column_type'];
			$field['form_type'] = $fieldTypes[$field['type']]['form_type'];
			if ($field['type'] == 'select') {
				$values = explode(',', $field['options']);
				foreach ($values as &$value) {
					$value = "'$value' => '$value'";
				}
				unset($value);
				$field['select_options'] = 'array(' . implode(', ', $values) . ')';
			}
			if ($field['type'] == 'country') {
				if ($field['options']) {
					$whitelist = explode(',', $field['options']);
				} else {
					$whitelist = array_keys(MCFactory::$countries);
				}
				$values = array();
				foreach (MCFactory::$countries as $code => $country) {
					$country = addslashes($country);
					if (in_array($code, $whitelist)) {
						$values[] = "'$country' => '$code'";
					}
				}
				$field['select_options'] = 'array(' . implode(', ', $values) . ')';
			}
			if ($field['type'] == 'image') {
				list($field['image_width'], $field['image_height']) = explode('x', $field['options']);
			}
		}
		unset($field);
		$tpl->assign('extra_fields', $extra_fields);
		$filters = $this->getFilters();
		$filterTypes = $this->getFilterTypes();
		foreach ($filters as &$filter) {
			$filter['criteria'] = $filterTypes[$filter['type']]['criteria'];
		}
		unset($filter);
		$tpl->assign('filters', $filters);
		$tpl->save();
	}

	public function publish() {
		global $gCms;
		$config = $gCms->GetConfig();
		@mkdir($config['root_path'] . '/modules/' . $this->getModuleName());
		@mkdir($config['root_path'] . '/modules/' . $this->getModuleName() . '/classes');
		@mkdir($config['root_path'] . '/modules/' . $this->getModuleName() . '/lang');
		@mkdir($config['root_path'] . '/modules/' . $this->getModuleName() . '/templates');
		$this->publishFile('classes/'. $this->getModuleName() . 'Object.class.php', 'classes/MCFModuleObject.class.php.tpl');
		$this->publishFile('lang/en_US.php');
		$this->publishFile('templates/defaultadmin.items.tpl');
		$this->publishFile('templates/defaultadmin.templates.tpl');
		$this->publishFile('templates/defaultadmin.options.tpl');
		$this->publishFile('templates/edit.tpl');
		$this->publishFile('templates/edittemplate.tpl');
		$this->publishFile('templates/error.tpl');
		$this->publishFile('templates/template.details.tpl');
		$this->publishFile('templates/template.list.tpl');
		$this->publishFile('templates/template.paginated.tpl');
		$this->publishFile('templates/template.search.tpl');
		$this->publishFile('templates/template.calendar.tpl');
		$this->publishFile('action.default.php');
		$this->publishFile('action.defaultadmin.php');
		$this->publishFile('action.delete.php');
		$this->publishFile('action.moveup.php');
		$this->publishFile('action.movedown.php');
		$this->publishFile('action.detail.php');
		$this->publishFile('action.edit.php');
		$this->publishFile('action.edittemplate.php');
		$this->publishFile('action.deletetemplate.php');
		$this->publishFile('action.geturl.php');
		$this->publishFile('action.publish.php');
		$this->publishFile('action.search.php');
		$this->publishFile('action.template.php');
		$this->publishFile('action.count.php');
		$this->publishFile('action.assigntitles.php');
		$this->publishFile('index.html');
		$this->publishFile('function.defaultadmin.items.php');
		$this->publishFile('function.defaultadmin.templates.php');
		$this->publishFile('function.defaultadmin.options.php');
		$this->publishFile('function.defaultadmin.help.php');
		$this->publishFile($this->getModuleName() . '.module.php', 'MCFModule.module.php.tpl');
		if (isset($gCms->modules[$this->getModuleName()])) {
			$db = $gCms->GetDb();
			foreach ($this->getDeleteFields() as $field) {
				$dict = NewDataDictionary($db);
				$sqlarray = $dict->DropColumnSQL(cms_db_prefix() . 'module_' . strtolower($this->getModuleName()), $field);
				$dict->ExecuteSQLArray($sqlarray);
			}
			$fieldTypes = $this->getFieldTypes();
			foreach ($this->getExtraFields() as $field) {
				if (isset($field['new'])) {
					$dict = NewDataDictionary($db);
					$sqlarray = $dict->AddColumnSQL(cms_db_prefix() . 'module_' . strtolower($this->getModuleName()), $field['name'] . ' ' . $fieldTypes[$field['type']]['column_type']);
					$dict->ExecuteSQLArray($sqlarray);
				}
			}
		}
	}

}

?>
