<?php

if (!isset($gCms)) exit;

if (!$this->CheckAccess()) {
	return $this->DisplayErrorPage();
}

if (isset($params['cancel'])) {
	$this->Redirect($id, 'defaultadmin', $returnid);
	exit;
}

if (isset($params['module_id']) && !empty($params['module_id'])) {
	$module = MCFModule::retrieveByPk($params['module_id']);
} else {
	$module = new MCFModule();
	$module->setParentModule(0);
}

if (isset($params['publish'])) {
	$module->populateFromArray($params);
	$module->save();
	$module->publish();
	$this->Redirect($id, 'defaultadmin', $returnid);
	exit;
}

$c = new MCFCriteria();
$c->add('parent_module', 0);
if (isset($params['module_id']) && !empty($params['module_id'])) {
	$c->add('id', $module->getId(), MCFCriteria::NOT_EQUAL);
}
$modules = MCFModule::doSelect($c);
$modules_select = array('' => 0);
foreach ($modules as $mod) {
	$modules_select[$mod->getModuleFriendlyName()] = $mod->getId();
}

$field_types = $module->getFieldTypes();
$field_types_with_options = array();
foreach ($field_types as $field_type) {
	if ($field_type['options']) {
		$field_types_with_options[] = $field_type['type'];
	}
}

$filter_types = $module->getFilterTypes();

$this->smarty->assign('module_id', $id);
$this->smarty->assign('form_start', $this->CreateFormStart($id, 'edit', $returnid, 'post'));
$this->smarty->assign('input_module_id', $this->CreateInputHidden($id, 'module_id', $module->getId()));
$this->smarty->assign('input_module_parent', $this->CreateInputDropdown($id, 'parent_module', $modules_select, -1, $module->getParentModule()));
$this->smarty->assign('input_module_friendlyname', $this->CreateInputText($id, 'module_friendlyname', $module->getModuleFriendlyname(), 50));
$this->smarty->assign('created_by', $gCms->GetUserOperations()->LoadUserByID($module->getCreatedBy())->username);
$this->smarty->assign('created_at', $module->getCreatedAt());
$this->smarty->assign('updated_by', $gCms->GetUserOperations()->LoadUserByID($module->getUpdatedBy())->username);
$this->smarty->assign('updated_at', $module->getUpdatedAt());
$this->smarty->assign('extra_fields', $module->getExtraFields());
$this->smarty->assign('filters', $module->getFilters());
$this->smarty->assign('publish_button', $this->CreateInputSubmit($id, 'publish', 'Publish')); 
$this->smarty->assign('cancel_button', $this->CreateInputSubmit($id, 'cancel', 'Cancel'));
$this->smarty->assign('field_types', $field_types);
$this->smarty->assign('field_types_with_options', $field_types_with_options);
$this->smarty->assign('filter_types', $filter_types);

echo $this->ProcessTemplate('edit.tpl');

?>
