<?php
#-------------------------------------------------------------------------
# Module: VisitorStats - Shows statistics about your visitors such as their useragent, the pages they visit, and where they came from.
# Version: 0.1, Elijah Lofgren
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2006 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
# This file originally created by ModuleMaker module, version 0.2
# Copyright (c) 2006 by Samuel Goldstein (sjg@cmsmadesimple.org) 
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

#-------------------------------------------------------------------------
# For Help building modules:
# - Read the Documentation as it becomes available at
#   http://dev.cmsmadesimple.org/
# - Check out the Skeleton Module for a commented example
# - Look at other modules, and learn from the source
# - Check out the forums at http://forums.cmsmadesimple.org
# - Chat with developers on the #cms IRC channel
#-------------------------------------------------------------------------
class VisitorStats extends CMSModule
{

	function GetName()
	{
		return 'VisitorStats';
	}

	/*---------------------------------------------------------
	   GetFriendlyName()
	   This can return any string, preferably a localized name
	   of the module. This is the name that's shown in the
	   Admin Menus and section pages (if the module has an admin
	   component).
	   
	   See the note on localization at the top of this file.
	  ---------------------------------------------------------*/
	function GetFriendlyName()
	{
		return $this->Lang('friendlyname');
	}

	
	/*---------------------------------------------------------
	   GetVersion()
	   This can return any string, preferably a number or
	   something that makes sense for designating a version.
	   The CMS will use this to identify whether or not
	   the installed version of the module is current, and
	   the module will use it to figure out how to upgrade
	   itself if requested.	   
	  ---------------------------------------------------------*/
	function GetVersion()
	{
		return '0.1';
	}

	/*---------------------------------------------------------
	   GetHelp()
	   This returns HTML information on the module.
	   Typically, you'll want to include information on how to
	   use the module.
	   
	   See the note on localization at the top of this file.
	  ---------------------------------------------------------*/
	function GetHelp()
	{
		return $this->Lang('help');
	}

	/*---------------------------------------------------------
	   GetAuthor()
	   This returns a string that is presented in the Module
	   Admin if you click on the "About" link.
	  ---------------------------------------------------------*/
	function GetAuthor()
	{
		return 'Elijah Lofgren';
	}

	/*---------------------------------------------------------
	   GetAuthorEmail()
	   This returns a string that is presented in the Module
	   Admin if you click on the "About" link. It helps users
	   of your module get in touch with you to send bug reports,
	   questions, cases of beer, and/or large sums of money.
	  ---------------------------------------------------------*/
	function GetAuthorEmail()
	{
		return 'elijahlofgren@elijahlofgren.com';
	}

	/*---------------------------------------------------------
	   GetChangeLog()
	   This returns a string that is presented in the module
	   Admin if you click on the About link. It helps users
	   figure out what's changed between releases.
	   See the note on localization at the top of this file.
	  ---------------------------------------------------------*/
	function GetChangeLog()
	{
		return $this->Lang('changelog');
	}

	/*---------------------------------------------------------
	   IsPluginModule()
	   This function returns true or false, depending upon
	   whether users can include the module in a page or
	   template using a smarty tag of the form
	   {cms_module module='VisitorStats' param1=val param2=val...}
	   
	   If your module does not get included in pages or
	   templates, return "false" here.
	  ---------------------------------------------------------*/
	function IsPluginModule()
	{
		return true;
	}

	/*---------------------------------------------------------
	   HasAdmin()
	   This function returns a boolean value, depending on
	   whether your module adds anything to the Admin area of
	   the site. For the rest of these comments, I'll be calling
	   the admin part of your module the "Admin Panel" for
	   want of a better term.
	  ---------------------------------------------------------*/
	function HasAdmin()
	{
		return true;
	}


	/*---------------------------------------------------------
	   GetAdminSection()
	   If your module has an Admin Panel, you can specify
	   which Admin Section (or top-level Admin Menu) it shows
	   up in. This method returns a string to specify that
	   section. Valid return values are:

	   main        - the Main menu tab.
	   content     - the Content menu
	   layout      - the Layout menu
	   usersgroups - the Users and Groups menu
	   extensions  - the Extensions menu (this is the default)
	   siteadmin   - the Site Admin menu
	   viewsite    - the View Site menu tab
	   logout      - the Logout menu tab
	   
	   Note that if you place your module in the main,
	   viewsite, or logout sections, it will show up in the
	   menus, but will not be visible in any top-level
	   section pages.
	  ---------------------------------------------------------*/
	function GetAdminSection()
	{
		return 'extensions';
	}


	/*---------------------------------------------------------
	   GetAdminDescription()
	   If your module does have an Admin Panel, you
	   can have it return a description string that gets shown
	   in the Admin Section page that contains the module.
	  ---------------------------------------------------------*/
	function GetAdminDescription()
	{
		return $this->Lang('admindescription');
	}


	/*---------------------------------------------------------
	   VisibleToAdminUser()
	   If your module does have an Admin Panel, you
	   can control whether or not it's displayed by the boolean
	   that is returned by this method. This is primarily used
	   to hide modules from admins who lack permission to use
	   them.
	   
	   Typically, you'll use some permission to set this
	   (e.g., $this->CheckPermission('Some Permission'); )
	  ---------------------------------------------------------*/
	function VisibleToAdminUser()
	{
        return true;
	}
	

	/*---------------------------------------------------------
	   CheckAccess()
	   This wrapper function will check against the specified permission,
	   and display an error page if the user doesn't have adequate permissions.
	  ---------------------------------------------------------*/
	function CheckAccess($id, $params, $return_id,$perm = '')
		{
		if (! $this->CheckPermission($perm))
            {
            $this->DisplayErrorPage($id, $params, $return_id,
            			$this->Lang('accessdenied'));
			return false;
			}
		return true;
		}
	
	/*---------------------------------------------------------
	   _DisplayErrorPage()
	   This is a simple function for generating error pages.
	  ---------------------------------------------------------*/
    function _DisplayErrorPage($id, &$params, $return_id, $message='')
    {
		$this->smarty->assign('title_error', $this->Lang('error'));
		$this->smarty->assign_by_ref('message', $message);

        // Display the populated template
        echo $this->ProcessTemplate('error.tpl');
    }
	


	/*---------------------------------------------------------
	   GetDependencies()
	   Your module may need another module to already be installed
	   before you can install it.
	   This method returns a list of those dependencies and
	   minimum version numbers that this module requires.
	   
	   It should return an hash, eg.
	   return array('somemodule'=>'1.0', 'othermodule'=>'1.1');
	  ---------------------------------------------------------*/
	function GetDependencies()
	{
		return array();
	}

	/*---------------------------------------------------------
	   MinimumCMSVersion()
	   Your module may require functions or objects from
	   a specific version of CMS Made Simple.
	   Ever since version 0.11, you can specify which minimum
	   CMS MS version is required for your module, which will
	   prevent it from being installed by a version of CMS that
	   can't run it.
	   
	   This method returns a string representing the
	   minimum version that this module requires.
	   ---------------------------------------------------------*/
	function MinimumCMSVersion()
	{
		return "0.12";
	}


	/*---------------------------------------------------------
	   Install()
	   When your module is installed, you may need to do some
	   setup. Typical things that happen here are the creation
	   and prepopulation of database tables, database sequences,
	   permissions, preferences, etc.
	   	   
	   For information on the creation of database tables,
	   check out the ADODB Data Dictionary page at
	   http://phplens.com/lens/adodb/docs-datadict.htm
	   
	   This function can return a string in case of any error,
	   and CMS will not consider the module installed.
	   Successful installs should return FALSE or nothing at all.
	  ---------------------------------------------------------*/
	function Install()
	{
		
		// Typical Database Initialization
		$db = &$this->cms->db;
		
		// mysql-specific, but ignored by other database
		$taboptarray = array('mysql' => 'TYPE=MyISAM');
		$dict = NewDataDictionary($db);
		
        // table schema description
        $flds = "id I KEY,
             date C(10),
             ip C(255),
             uri C(255),
             referrer C(255),
             ip C(255),
             host C(255),
             ua C(255),
             ip C(255),
             date T,
             status_code C(3)
			";

		// create it. This should do error checking, but I'm a lazy sod.
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_visitorstats",
				$flds, $taboptarray);
		$dict->ExecuteSQLArray($sqlarray);

		// create a sequence
		$db->CreateSequence(cms_db_prefix()."module_visitorstats_seq");
		
		
		// permissions
		

		// put mention into the admin log
		$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('installed',$this->GetVersion()));
	}

	/*---------------------------------------------------------
	   InstallPostMessage()
	   After installation, there may be things you want to
	   communicate to your admin. This function returns a
	   string which will be displayed.
	  ---------------------------------------------------------*/
	function InstallPostMessage()
	{
//		return $this->Lang('postinstall');
	}

	/*---------------------------------------------------------
	   UninstallPostMessage()
	   After removing a module, there may be things you want to
	   communicate to your admin. This function returns a
	   string which will be displayed.
	  ---------------------------------------------------------*/
	function UninstallPostMessage()
	{
		// return $this->Lang('postuninstall');
	}


	/*---------------------------------------------------------
	   Upgrade()
	   If your module version number does not match the version
	   number of the installed module, the CMS Admin will give
	   you a chance to upgrade the module. This is the function
	   that actually handles the upgrade.
	   Ideally, this function should handle upgrades incrementally,
	   so you could upgrade from version 0.0.1 to 10.5.7 with
	   a single call. For a great example of this, see the News
	   module in the standard CMS install.
	  ---------------------------------------------------------*/
	function Upgrade($oldversion, $newversion)
	{
		$current_version = $oldversion;
		switch($current_version)
		{
			case "1.0":
			     break;
			case "1.1":
			     break;
		}
		
		// put mention into the admin log
		$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('upgraded',$this->GetVersion()));
	}


	/**
	 * UninstallPreMessage()
	 * This allows you to display a message along with a Yes/No dialog box. If the user responds
	 * in the affirmative to your message, the uninstall will proceed. If they respond in the
	 * negative, the uninstall will be canceled. Thus, your message should be of the form
	 * "All module data will be deleted. Are you sure you want to uninstall this module?"
	 *
	 * If you don't want the dialog, have this method return a FALSE, which will cause the
	 * module to uninstall immediately if the user clicks the "uninstall" link.
	 */
	function UninstallPreMessage()
	{
		return $this->Lang('really_uninstall');
	}
	
	/*---------------------------------------------------------
	   Uninstall()
	   Sometimes, an exceptionally unenlightened or ignorant
	   admin will wish to uninstall your module. While it
	   would be best to lay into these idiots with a cluestick,
	   we will do the magnanimous thing and remove the module
	   and clean up the database, permissions, and preferences
	   that are specific to it.
	   This is the method where we do this.
	  ---------------------------------------------------------*/
	function Uninstall()
	{
		// Typical Database Removal
		$db = &$this->cms->db;
		
		// remove the database table
		$dict = NewDataDictionary( $db );
		$sqlarray = $dict->DropTableSQL( cms_db_prefix()."module_visitorstats" );
		$dict->ExecuteSQLArray($sqlarray);

		// remove the sequence
		$db->DropSequence( cms_db_prefix()."module_visitorstats_seq" );
		
		// remove the permissions
		
		
		// put mention into the admin log
		$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('uninstalled'));
	}

	/*---------------------------------------------------------
	   DoAction($action, $id, $params, $return_id)
	   This is the main function that gets called if your module
	   is a plug-in type module.
	   
	   In general, you'll want to call various different
	   methods, depending upon the requested "action."
	   
	   There are two built-in actions: "default" which gets
	   called if the module is accessed from a page or template,
	   and "defaultadmin" which gets called from the Admin
	   panel.
	   
	   The Action can be overridden by passing a different
	   action either in your tag, e.g.,
	   {cms_module module='VisitorStats' action='something'}
	   or by passing it in a link create by the CreateLink
	   method.
	  ---------------------------------------------------------*/
	function DoAction($action, $id, $params, $return_id=-1)
	{
		switch ($action)
		{
			case 'default':
			case 'loghit':
				{
				//  Default User-Side Method
				$this->loghit($id, $params, $return_id);
				break;
				}


			case 'defaultadmin':
			case 'showvisits':
				{
				// Default Admin-Side Method
				$this->showvisits($id, $params, $return_id);
				break;
				}


		}
	}

	/*---------------------------------------------------------
	  loghit()
	  Default User-Side Method
	 This is the function that gets called by default
	 when the module is called from the user-side
	  ---------------------------------------------------------*/
	function loghit($id, &$params, $return_id)
    {
		global $gCms;

		$pageinfo = &$gCms->variables['pageinfo'];

        // If this page does not exist
        if (-1 == $pageinfo->content_id) {
            $status_code = '404';
        } else {
            $status_code = '0';
        }
    
        if (FALSE != isset($_SERVER["HTTP_REFERER"])) {
            $referrer = $_SERVER["HTTP_REFERER"];
        } else {
            $referrer = '';
        }
        $db = $this->cms->db;

        // Convert IP Address into hostname
        $hostname = gethostbyaddr($_SERVER['REMOTE_ADDR']);

        // then add an entry into the database
        $newid = $db->GenID( cms_db_prefix()."module_visitorstats_seq" );

        $q = "INSERT INTO ".cms_db_prefix()."module_visitorstats VALUES (?,?,?,?,?,?,?,?)";
        $dbresult = $db->Execute( $q, array( $newid, $db->DBTimeStamp(time()), 
                                      $_SERVER["REMOTE_ADDR"], $_SERVER['REQUEST_URI'],
                                      $referrer, $hostname, 
                                      $_SERVER["HTTP_USER_AGENT"], $status_code));

        if( !$dbresult )
        {
	       $this->_DisplayErrorPage ($id, $params, $return_id,
			                     	 $this->Lang ('error_dberror'));
           // echo $db->ErrorMsg()."<br/>";
        	return false;
        }

        return true;
    }

	/*---------------------------------------------------------
	  showvisits()
	  Default Admin-Side Method
	 This is the function that gets called by default
	 when the module is called from the admin-side
	  ---------------------------------------------------------*/
	function showvisits($id, &$params, $return_id)
		{
            $db = $this->cms->db;
            // First we get the total number of visits ever
            $q = "SELECT * FROM ".cms_db_prefix()."module_visitorstats ORDER BY id ASC";
            $dbresult = $db->Execute( $q );
            if( !$dbresult ) 
            {
        	   $this->_DisplayErrorPage ($id, $params, $return_id,
                                         $this->Lang ('error_dberror'));
               return false;
            }
            $num_rows = $dbresult->RecordCount();


            // Then we calculate the offset needed so we only show 100 visits per page.
            if (FALSE == isset($_GET['offset']) || 0 == $_GET['offset']) {
                $offset = $num_rows - 100;
            } else {
                $get_offset = (int) $_GET['offset'];
                // echo $num_rows.'<br />';
                $offset = ($num_rows - 100) - $get_offset;
                echo 'true offset: '.$offset.'<br />';
                if (0 > $offset) {
                    $offset = 0;
                }
            }

         // If there have been more than 100 total visits then only select 100 of them
         if ($num_rows > 100) {
            $q = "SELECT * FROM ".cms_db_prefix().'module_visitorstats ORDER BY id ASC LIMIT '.$offset.', 100';
        } else {
            $q = "SELECT * FROM ".cms_db_prefix()."module_visitorstats ORDER BY id ASC";
        }

            $dbresult = $db->Execute( $q );
            if( !$dbresult ) 
            {
            	$this->_DisplayErrorPage ($id, $params, $return_id,
        				                  $this->Lang ('error_dberror'));
                return false;
            }

            $prev_next = $this->_showPrevNextLinks($num_rows);
            $output = $prev_next;
            $output .= "<ul>\n";
            $list_opened = FALSE;
            $last_session_id='';
            $lastip='';
            $lastdate='';
            // Loop through showing details for 100 visits
            while ($dbresult && $event = $dbresult->FetchRow()) {
                if ($event['ip'] != $lastip) {
                    if (FALSE != $list_opened) {
                        $output .= '</ul>';
                        $output .= "</li>\n";
                    }
                    $output .= '<li class="visit">'."\n";
                    $list_opened = TRUE;
                    $output .= 'A visitor from <b>'.$event['host'].'</b>';
                    $output .= ' ('.$event['ip'].') came on ';
                    $output .= $event['date'].'.';
                    $output .= '<br />The browser was '.$event['ua'];
                    $output .= "<ul>\n";
                    $output .= '<li>';

                    if (FALSE == empty($event['referrer'])) {
                        $referrer = str_replace('http://', '', $event['referrer']);
                        $output .= 'This visitor first arrived from <a href="'.$event['referrer'].'">'.$referrer.'</a>';
                    } else {
                        $output .= 'This visitor first arrived without a referring URL';
                    }
                    $output .= '<br /> and visited <a href="'.$event['uri'].'">'.$event['uri'].'</a>';
                    
                } else {
                    $time_after = $this->_CalcTimeDiff(strtotime($lastdate), strtotime($event['date']));
                    $output .= '<li>';
                    $output .= $time_after.' later, ';
                    if (FALSE == empty($event['referrer'])) {
                        $referrer = str_replace('http://', '', $event['referrer']);
                        $output .= 'arrived from <a href="'.$event['referrer'].'">'.$referrer.'</a>';
                    } else {
                        $output .= 'arrived without a referring URL, ';
                    }

                    $output .= '<br /> and visited <a href="'.$event['uri'].'">'.$event['uri']."</a>";
          
                }
                if (404 == $event['status_code']) {
                    $output .= '<span style="color:red;"> encountering a 404 error</span>';
                }
                $output .= "</li>\n";
                $lastip = $event['ip'];
                $lastdate = $event['date'];


            }
         
            $output .= '</ul>';
            $output .= '</li>';
            $output .= '</ul>';
            $output .= $prev_next;

            echo $output;
		}

	/*---------------------------------------------------------
	  _CalcTimeDiff($old_time, $new_time)
	  Calculate difference between two php timestamps
	 Give it two php timestamps and it will return the elapsed time
	 as something like "2 minutes 3 seconds"
	  ---------------------------------------------------------*/
    function _CalcTimeDiff($old_time, $new_time)
    {
        // calculate elapsed time (in seconds!)

        $diff = $new_time-$old_time;
        $days_diff = floor($diff/60/60/24);
        $diff -= $days_diff*60*60*24;
        $hrs_diff = floor($diff/60/60);
        $diff -= $hrs_diff*60*60;
        $mins_diff = floor($diff/60);
        $diff -= $mins_diff*60;
        $secs_diff = $diff;

		$output = '';
		if ($days_diff) { $output .= $days_diff.' days '; }
		if ($hrs_diff) { $output .= $hrs_diff.' hours '; }
		if ($mins_diff) { $output .= $mins_diff.' minutes '; }
		$output .= $secs_diff.' seconds ';
        return $output;
    }

	/*---------------------------------------------------------
	  _showPrevNextLinks($numRows)
	  Outputs next and previous links for lists of stats
	 The 
	  ---------------------------------------------------------*/
    function _showPrevNextLinks($numRows) {
        $page_uri = 'moduleinterface.php?module=VisitorStats&';
        if ((FALSE == isset($_GET['offset']) || 0 == $_GET['offset']) && $numRows > 100) {
            $output = '<a href="'.$page_uri.'offset=100">&lt;&lt; Previous</a>';
        } else {
            if (FALSE != isset($_GET['offset'])) {
                $prev_offset = $_GET['offset'] + 100;
                //echo $numRows.'<br />';
                //echo $prev_offset;
                if ($numRows > $prev_offset) {
                    $output  = '<div class="back">';
                    $output .= '<a href="'.$page_uri.'offset='.$prev_offset.'">&lt;&lt; Previous</a>';
                    $output .= '</div>';
                } else {
                    $output = '';
                }

                $next_events = $_GET['offset'] - 100;
                $output .= '<div class="forward">';
                $output .= '<a href="'.$page_uri.'offset='.$next_events.'">Next &gt;&gt;</a>';
                $output .= '</div>';
            } else {
                $output = '';
            }
        }
        return $output;
    }

}

?>
