<?php
ini_set('include_path', 
	dirname(__FILE__) . '/class'
	. PATH_SEPARATOR . ini_get('include_path')
);
require_once('IPFilter.class.php');
class IPLock extends CMSModule {
	function GetName() {
		return 'IPLock';
	}
	
	function GetFriendlyName() {
		return $this->Lang ( 'friendlyname' );
	}
	function GetVersion() {
		return '0.4.1';
	}
	function MinimumCMSVersion() {
		return '1.6';
	}
	function GetAuthor() {
		return 'Benoit Vermont';
	}
	function GetAuthorEmail() {
		return 'redwarp@gmail.com';
	}
	function GetDependencies() {
		return array('CMSMailer' => '2.0');
	}
	
	function IsPluginModule() {
		return false;
	}
	
	function HasAdmin() {
		return true;
	}
	function GetHelp() {
		return $this->Lang ( 'help' );
	}
	
	function GetAdminDescription() {
		return $this->Lang ( 'moddescription' );
	}
	
	function InstallPostMessage() {
		return $this->Lang ( 'postinstall' );
	}
	
	function UninstallPreMessage() {
		return html_entity_decode($this->Lang ( 'preuninstall' ),ENT_NOQUOTES, 'UTF-8');
	}
	function UninstallPostMessage() {
		return $this->Lang ( 'postuninstall' );
	}
	function GetAdminSection() {
		return 'siteadmin';
	}
	function VisibleToAdminUser() {
		return $this->CheckPermission ( 'IPLock Admin' );
	}
	function HandleEvents() {
		return true;
	}
	function DefaultLanguage(){
		return 'en_US';
	}
	
	function GetNotificationOutput( $priority = 2 ){
		if ($this->GetPreference('notification') == 'display' && $this->GetPreference('new_banned_ip') == 'not_verified' && $this->CheckPermission('IPLock Admin')){
			$ret = new stdClass;
			$ret->priority = 3;
			$ret->html = $this->lang('notification_message', $this->CreateLink($id, 'defaultadmin', $returnid, $this->lang('friendlyname'), array('active_tab' => 'denied_ip')));
			return $ret;
		}
		else {
			return '';
		}
	}
	
	function GetEventDescription($eventname){
		if ($eventname == 'UserBanned'){
			return $this->lang('userbanned_event_desc');
		}
	}
	
	function GetEventHelp($eventname){
		if ($eventname == 'UserBanned'){
			$help = '<p>'.$this->lang('userbanned_event_desc').'</p>';
			$help.= '<h4>'.$this->lang('userbanned_event_help_paramh').'</h4><ul>';
			$help.= '<li>'.$this->lang('userbanned_event_help_param1').'</li>';
			$help.= '<li>'.$this->lang('userbanned_event_help_param2').'</li>';
			return $help;
		}
	}
	
	function _GetDbName(){
		return cms_db_prefix().'module_iplock';
	}
	function _GetWatchDbName(){
		return $this->_GetDbName() . '_watch';
	}
	function _IPFilterInit(){
		IPFilter::init($this);
	}
	
	//TODO
	///This should be pulled out at a smarty templete
	function _IPTable($id, array $ipArray, array $parameters = null){
		global $id;
		$rowcount = count($ipArray);
		$thead = $this->lang('ip_comment');
		$liste = <<<TBS
<table class='pagetable'>
	<thead>
		<tr>
			<th width='20%'>IP</th>
			<th width='100%'>$thead</th>
			<th></th>
			<th></th>
		</tr>
	</thead>
	<tbody>
TBS;
		if( $rowcount == 0 ){
			$liste .= "<tr class='row1'><td colspan='4'>".$this->Lang('emptylist')."</tr>";
		}
		else {
			$i = 0;
			foreach( $ipArray as $ip_id => $ip_value){
				$ip_comment = htmlspecialchars(IPFilter::getIPComment($ip_id));
				// Construction des paramètres à donner à chaque lien.
				foreach ( $parameters as $paramName => $paramValue ) {
					$params [$paramName] = $paramValue;
				}
				$params['ip_id'] = $ip_id;
				$liste .= "<tr class='row".($i%2+1)."'><td>$ip_value</td><td>$ip_comment</td><td>".
				$this->CreateLink ( $id, 'edit_ip_comment', $returnid, '<img src="../modules/' . $this->GetName () . '/images/edit.gif" class="systemicon" alt="' . $this->Lang ( 'edit' ) . '" title="' . $this->Lang ( 'edit' ) . '" />', $params).
				"</td>";
				if ($ip_value == '127.0.0.1') {
					$liste .= '<td></td>';
				} else {
					$liste .= "<td>" . $this->CreateLink ( $id, 'remove_ip', $returnid, '<img src="../modules/' . $this->GetName () . '/images/delete.gif" class="systemicon" alt="' . $this->Lang ( 'delete' ) . '" title="' . $this->Lang ( 'delete' ) . '" />', $params, $this->Lang ( 'deleteconfirm' ) ) . '</td></tr>';
				}
				$i++;
			}
		}
		$liste .= <<<TBE
	</tbody>
</table>
TBE;
		return $liste;
	}
	
	function _IPField($id, $action){
		global $params;
		//$ipfield = $this->CreateFormStart($id, $action, $returnid). // $returnid is undefined should be passing in
		$ipfield = $this->CreateFormStart($id, $action).'<p>'.
		$this->CreateInputText($id, 'field0','',5).'.'.
		$this->CreateInputText($id, 'field1','',5).'.'.
		$this->CreateInputText($id, 'field2','',5).'.'.
		$this->CreateInputText($id, 'field3','',5).
		$this->CreateInputSubmit($id, 'submit', $this->Lang('add')).
		'</p>'.$this->CreateFormEnd();
		if(isset($params[$action.'_error'])){
			$ipfield .= $this->ShowErrors($params[$action.'_error']);
		}
		if ($action == 'allow_ip'){
			$ipfield .= $this->CreateFormStart($id, $action).'<p>'.
			$this->lang('add_current_ip', $_SERVER['REMOTE_ADDR']).' '.
			$this->CreateInputHidden($id,'ip',$_SERVER['REMOTE_ADDR']).
			$this->CreateInputSubmit($id, 'submit', $this->lang('add')).
			'</p>'.$this->CreateFormEnd();
		}
		return $ipfield;
	}
	
	function _AlertEmail( $ip ){
		if($this->GetPreference('email') == 'send'){
			/* @var $cmsmailer CMSMailer */
			global $config;
			$emaillist = $this->GetPreference('admin_email');
			if($emaillist != ''){
				$emaillist = explode(', ', $emaillist);
				$cmsmailer = $this->GetModuleInstance('CMSMailer');
				foreach($emaillist as $email){
					$cmsmailer->AddAddress($email);
				}
				$this->smarty->assign('iconlocation', $config['root_url'].'/modules/IPLock/images/icon.gif');
				$this->smarty->assign('alert_email_title', $this->lang('alert_email_title'));
				$this->smarty->assign('alert_email_info', $this->lang('alert_email_info'));
				$this->smarty->assign('alert_email_body', $this->lang('alert_email_body', $ip));
				
				$cmsmailer->SetBody($this->ProcessTemplate('alert_email.tpl'));
				$cmsmailer->IsHTML(true);
				$cmsmailer->SetSubject($this->lang('alert_email_title'));
				$cmsmailer->Send();
			}
		}
	}
}

?>