<?php

class IPLock extends CMSModule {
	function GetName() {
		return 'IPLock';
	}
	
	function GetFriendlyName() {
		return $this->Lang ( 'friendlyname' );
	}
	function GetVersion() {
		return '0.3.5';
	}
	function MinimumCMSVersion() {
		return '1.6';
	}
	function GetAuthor() {
		return 'Redwarp';
	}
	function GetAuthorEmail() {
		return 'redwarp@gmail.com';
	}
	
	function IsPluginModule() {
		return false;
	}
	
	function HasAdmin() {
		return true;
	}
	function GetHelp() {
		return $this->Lang ( 'help' );
	}
	
	function GetAdminDescription() {
		return $this->Lang ( 'moddescription' );
	}
	
	function InstallPostMessage() {
		return $this->Lang ( 'postinstall' );
	}
	
	function UninstallPreMessage() {
		return $this->Lang ( 'preuninstall' );
	}
	function UninstallPostMessage() {
		return $this->Lang ( 'postuninstall' );
	}
	function GetAdminSection() {
		return 'siteadmin';
	}
	function VisibleToAdminUser() {
		return $this->CheckPermission ( 'IPLock Admin' );
	}
	function HandleEvents() {
		return true;
	}
	function DefaultLanguage(){
		return 'fr_FR';
	}
	function _GetDbName(){
		return cms_db_prefix().'module_iplock';
	}
	function _GetWatchDbName(){
		return $this->_GetDbName() . '_watch';
	}
	function _IPFilterInit(){
		require_once('class/IPFilter.class.php');
		IPFilter::init($this);
	}
	
	function DoEvent($originator, $eventname, $params) {
		// On verifie que l'event reçu est bien LoginPost, originaire du Coeur
		if ($originator == 'Core' && $eventname == 'LoginPost') {
			
			$this->_IPFilterInit ();
			$ip = $_SERVER ["REMOTE_ADDR"];
			/* Pur paranoïa : on redirige également l'utilisateur sur logout
			 * au cas ou il aurait fourni des mauvais identifiants. */
			global $password, $oneuser;
			if (($oneuser->id == '' || $password == "")) {			
				IPFilter::watchIP($ip, $this->GetPreference('max_conn_min'));
				redirect ( 'logout.php' );
			} else {
				IPFilter::watchIPFlush($ip);
			}
			
			$IPLock_mode = $this->GetPreference ( 'IPLock_mode' );
			
			if ($IPLock_mode == 'allow') {
				$allowedIP = !IPFilter::isDeniedIP ( $ip );
			} else {
				
				// L'ip est elle dans la liste des IPs autorisées ?
				$allowedIP = IPFilter::isAllowedIP ( $ip );
				// Et surtout, n'est elle pas bannie ?
				$allowedIP = $allowedIP && ! IPFilter::isDeniedIP ( $ip );
			}			
			// A ce stade là, l'utilisateur est considéré comme logué.
			// Mais si son IP est incorrecte, on le redirige vers la page logout.php, ce qui le dégage.
			if (! $allowedIP) {
				$this->Audit ( 42, $this->GetName (), $this->Lang ( 'wrongip', $ip ) );
				redirect ( 'logout.php' );
			}
		}
	}
	
	function _IPTable($id, array $ipArray, array $parameters = null){
		global $id;
		$rowcount = count($ipArray);
		$liste = <<<TBS
<table class='pagetable'>
	<thead>
		<tr>
			<th width='100%'>IP</th>
			<th></th>
		</tr>
	</thead>
	<tbody>
TBS;
		if( $rowcount == 0 ){
			$liste .= "<tr class='row1'><td>".$this->Lang('emptylist')."</td><td></td></tr>";
		}
		else {
			$i = 0;
			foreach( $ipArray as $ip_id => $ip_value){
				// Construction des paramètres à donner à chaque lien.
				foreach ( $parameters as $paramName => $paramValue ) {
					$params [$paramName] = $paramValue;
				}
				$params['ip_id'] = $ip_id;
				$liste .= "<tr class='row".($i%2+1)."'><td>$ip_value</td>";
				if ($ip_value == '127.0.0.1') {
					$liste .= '<td></td>';
				} else {
					$liste .= "<td>" . $this->CreateLink ( $id, 'remove_ip', $returnid, '<img src="../modules/' . $this->GetName () . '/images/delete.gif" class="systemicon" alt="' . $this->Lang ( 'delete' ) . '" title="' . $this->Lang ( 'delete' ) . '" />', $params, $this->Lang ( 'deleteconfirm' ) ) . '</td></tr>';
				}
				$i++;
			}
		}
		$liste .= <<<TBE
	</tbody>
</table>
TBE;
		return $liste;
	}
	
	function _IPField($id, $action){
		global $params;
		$ipfield = $this->CreateFormStart($id, $action, $returnid).
		$this->CreateInputText($id, 'field0','',5).'.'.
		$this->CreateInputText($id, 'field1','',5).'.'.
		$this->CreateInputText($id, 'field2','',5).'.'.
		$this->CreateInputText($id, 'field3','',5).
		$this->CreateInputSubmit($id, 'submit', $this->Lang('add')).
		$this->CreateFormEnd();
		if(isset($params[$action.'_error'])){
			$ipfield .= $this->ShowErrors($params[$action.'_error']);
		}
		return $ipfield;
	}
}

?>
