<?php 

if (!isset($gCms)) exit;
if(! $this->CheckPermission('IPLock Admin')) exit;

$this->_IPFilterInit();

if(isset($params['active_tab'])){
	$active_tab = $params['active_tab'];
}
else{
	$active_tab = '';
}
echo $this->StartTabHeaders();
echo $this->SetTabHeader('prefs', $this->Lang('prefs'), ($active_tab == 'prefs' ? true : false));
echo $this->SetTabHeader('allowed_ip', $this->Lang('allowed_ip'), ($active_tab == 'allowed_ip' ? true : false));
echo $this->SetTabHeader('denied_ip', $this->Lang('denied_ip'), ($active_tab == 'denied_ip' ? true : false));
echo $this->EndTabHeaders();
echo $this->StartTabContent();


echo $this->StartTab('prefs', $params);
?>
<fieldset><legend>Paramètres généraux</legend>
<?php
echo $this->CreateFormStart($id, 'set_prefs', $returnid);
?>
<div class='pageoverflow'>
<p class='pagetext'>Réglage du mode de fonctionnement par défault de IPLock :</p>
<p class='pageinput'>
En mode "Autoriser à tous", toutes les IPs sont autorisées par défault à se connecter à l'interface admin.<br />
En mode "Interdire à tous", la seule IP autorisée par défault à se connecter à l'interface admin est 127.0.0.1.
</p>
<p class='pageinput'>
<?php
echo $this->CreateInputRadioGroup($id, 'iplock_mode', array('Autoriser à tous<br />' => 'allow', 'Interdire à tous' => 'deny'), $this->GetPreference('IPLock_mode'));
?>
</p>
</div>
<div class='pageoverflow'>
<p class='pagetext'>Nombre de tentative de connection max par minutes (minimum 0) :</p>
<p class='pageinput'>
C'est le nombre de fois où un utilisateur, mal intentionné ou non, a le droit de se planter de login et mot de passe en moins d'une minute lorsqu'il essaye d'accéder à l'interface admin.<br />
Si l'utilisateur se trompe un nombre de fois supérieur, son IP sera bannie.
</p>
<p class='pageinput'>
<?php
echo $this->CreateInputText($id, 'max_conn_min', $this->GetPreference('max_conn_min'));
?>
</p>
</div>
<div class='pageoverflow'>
<p class='pagetext'>&nbsp;</p>
<p class='pageinput'>
<?
echo $this->CreateInputSubmit($id, 'submit', $this->Lang('save'));
echo $this->CreateFormEnd();
?>
</p>
</div>
</fieldset>
<?php

echo $this->EndTab();
echo $this->StartTab('allowed_ip',$params);
?>
<p>Cette liste est utilisée au cas où IPLock fonctionne en mode "Interdire à tous"</p>
<fieldset><legend>Liste des IPs autorisées expressement</legend>
<?php
echo $this->_IPTable($id, IPFilter::getAllowedIPList(), array('active_tab' => 'allowed_ip'));
?>
</fieldset>
<fieldset><legend>Ajouter une nouvelle IP (ou plage) aux exceptions</legend>
<p>
<?php
echo $this->_IPField($id, 'allow_ip');
?>
	</p>
</fieldset>
<fieldset><legend>Syntaxe</legend>
<p>Une IP se décompose en quatre nombre variant de 0 à 255. Pour chacun
de ces nombres, on peut spécifier :</p>
<ul>
	<li style='list-style-type: disc;'>Une valeur fixe</li>
	<li style='list-style-type: disc;'>Une plage d'IP, en tapant par exemple 12-245. Si le nombre
	correspondant de l'IP de la personne cherchant à se connecter est
	compris entre 12 et 245, il sera valide.</li>
	<li style='list-style-type: disc;'>Tout nombre accepté, en tapant '*'</li>
</ul>
</fieldset>
<?php
echo $this->EndTab();
echo $this->StartTab('denied_ip', $params);
?>
<p>Cette liste est utilisée quelque soit le mode. Une IP interdite sera toujours interdite.</p>
<fieldset><legend>Liste des IPs interdites expressement</legend>
<?php
echo $this->_IPTable($id, IPFilter::getDeniedIPList(), array('active_tab' => 'denied_ip'));
?>
</fieldset>
<fieldset><legend>Ajouter une nouvelle IP (ou plage) aux exceptions</legend>
<p>
<?
echo $this->_IPField($id, 'deny_ip');
?>
</p>
</fieldset>
<fieldset><legend>Syntaxe</legend>
<p>Une IP se décompose en quatre nombre variant de 0 à 255. Pour chacun
de ces nombres, on peut spécifier :</p>
<ul>
	<li style='list-style-type: disc;'>Une valeur fixe</li>
	<li style='list-style-type: disc;'>Une plage d'IP, en tapant par exemple 12-245. Si le nombre
	correspondant de l'IP de la personne cherchant à se connecter est
	compris entre 12 et 245, il sera valide.</li>
	<li style='list-style-type: disc;'>Tout nombre accepté, en tapant '*'</li>
</ul>
</fieldset>
<?
echo $this->EndTab();
echo $this->EndTabContent();

?>