<?php

   /*
   
      RCRUD Class
      by Robert Brown
      brownrl@gmail.com
      
      version: .04 2006-07-20
      
      Useage:
      
      require_once( 'rcrud.inc.php' );
      $co = new rcrud( $adodblite_db_connection , 'table_name' );
      $co->go();
   
   
   */


   class rcrud
   {

      #this var is the table that this object will crud on   
      var $table;
      
      #this var will holds fields and config info
      var $fields = array();
      
      #this var holds the adodblite db connection
      var $db;
      
      #this var holds the key field
      var $key;
      
      #this var holds the color for the errors in a form, ie, red , #FF0000
      var $errorcolor = "#FF0000";
      
      #this variable holds the text to be displayed above gets set in the constructor
      var $header;
      
      #this variable holds which field that we should sort by in the listing
      #gets set to the key in the constructor
      var $def_sort;
   
   
   
      function rcrud( $db , $tablename )
      {
         $this->db = $db;
         $this->table = $tablename;
         
         $q = "DESCRIBE ".$this->table;
         $qr = $db->Execute( $q ) or die( "The database connection or table supplied to rcrud is invalid, please check code and try again." );
         
         if( $qr->RecordCount() < 1 )
         {
            die( "The table name supplied to rcrud is invalid" );
         }
         else
         {
            $this->header = $this->field2label( $this->table );
            $i = 0;
            while ($row = $qr->FetchRow() ) 
            {

                 $this->fields[$row['Field']] = array();
                 $this->fields[$row['Field']]['order'] = $i++;                
                 $this->fields[$row['Field']]['label'] = $this->field2label( $row['Field'] );
                 $this->fields[$row['Field']]['visible_in_list'] = true;
                 $this->fields[$row['Field']]['visible_in_add'] = true;
                 $this->fields[$row['Field']]['visible_in_edit'] = true;
                 $this->fields[$row['Field']]['field_width'] = 30;
                 $this->fields[$row['Field']]['field_height'] = 10;                 
                 $this->fields[$row['Field']]['field_type'] = "text";
                 $this->fields[$row['Field']]['field_error'] = "Error: Invalid Form Data";
                 $this->fields[$row['Field']]['group'] = "";
               
                 if( $row['Key'] == "PRI" )
                 {
                    $this->fields[$row['Field']]['isKey'] = true;
                    $this->key = $row['Field'];
                    $this->fields[$row['Field']]['field_type'] = "display";
                    $this->fields[$row['Field']]['visible_in_add'] = false;
                    $this->def_sort = $row['Field'];
                 }
                 
                 if( $row['Type'] == "text" )
                 {
                    $this->fields[$row['Field']]['field_type'] = "textarea";
                 }
                 
                 if( $row['Type'] == "datetime" )
                 {
                 
                    $this->fields[$row['Field']]['field_type'] = "datetime";
                 
                 }
                 
                 if( $row['Type'] == "date" )
                 {
                    $this->fields[$row['Field']]['field_type'] = "date";
                 }
                 
                 if( ereg( "ipstamp" , $row['Field']  ) )
                 {
                    $this->fields[$row['Field']]['field_type'] = "ipstamp";
                 }

                 
                 $this->fields[$row['Field']]['label'] = $this->field2label( $row['Field'] );
            }#end while
            # Group Constructor
            # A group allow to regroup fields in the show display.
            # by default none group is created
            //$this->groups[0] = array();
            //$this->groups[0]['label'] = "";
                       
         }#end if
      }#end constructor
      
      #constructgroup
      function constructgroup()
      {
		 foreach( $this->fields as $k => $v )
                  {
					  // tests si le group exist déjà
					  if ($this->groups[$v[group]] != null) {
						$this->groups[$v[group]][$k] = $this->fields[$k];
				      } else {
						$this->groups[$v[group]] = array();
						//$this->groups[$v[group]][$k] = array();
				        $this->groups[$v[group]][$k] = $this->fields[$k];
				      }
				      //echo $k."<br>\n";
				  } 
		 //var_dump($this->groups);
		 //var_dump($this->fields);
	  }
      
      #this function converts field_name to Field Name
      function field2label( $field )
      {
         return ucwords( ereg_replace( "_" , " " , $field ) );
      }
      

      #this is the main function that will do every thing or atleast call the other functions      
      function go()
      {
            #make that the rcrud stuff happening in $_GET is for this instance and not for another
            if( isset( $_GET['rcrud_table'] ) && $_GET['rcrud_table'] != $this->table )
            {
               return false;
            }
           
           
            if( ! isset( $_GET['rcrud_action'] ) )
            {
               $rcrud_action = "show"; //default is to show what is in the db table.
            }
            else
            {
               $rcrud_action = $_GET['rcrud_action'];
            }
            
            echo "<h3>".$this->header."</h3>\n";
            
            switch( $rcrud_action )
            {
               case "show":
                  $this->show();
                  break;
               case "delete":
                  $this->delete( $_GET['rcrud_id'] );
                  break;
               case "add":
                  $this->add();
                  break;
               case "edit":
                  $this->edit();
                  break;
                  
            
            }#end switch
      
      }#end go function
      

      #this function allows a record to be added **MAJOR**
      function add()
      {
	$errors = '';
	$sql = '';
         #has the form been submitted
         if( isset( $_POST['rcrud_sub'] ) )
         {
 
               #compile any datetimes into one field again.
               $this->compile_datetimes();
            
               #form had no errors
               if( ! $errors = $this->form_errors() )
               {
                                    
                  #do an insert
                  
                  #first build the SET portion
                  foreach( $this->fields as $k => $v )
                  {
                
                     if( isset( $_POST[$k] ) )
                     {
                        $sql = $sql . $k . " = " . $this->db->qstr( $_POST[$k] ) . ", ";
                     }
                  
                  }
                  
                  #second take off the last ', '
                  $sql = ereg_replace( ", $" , "" , $sql );
                  $sql = "INSERT INTO ".$this->table." SET ".$sql;
                  $qr = $this->db->Execute( $sql ) or die( "RCRUD: Create New SQL Problem: ".$this->db->ErrorMsg() );
                  
                  echo "<p>Your item has been created.</p>";
                  $this->make_return_link();
                  
                  return true;
                  
               }

         }
         
         $this->make_form_bygrp( "visible_in_add" , "Create New" , $errors );
         $this->make_return_link();
         
      
      }#end add function      
      

      #this function allows a record to be edited **MAJOR**
      function edit()
      {
	$errors = '';
	$sql = "";
         #has the form been submitted
         if( isset( $_POST['rcrud_sub'] ) )
         {
               #compile any datetimes into one field again.
               $this->compile_datetimes();
               
               #form had no errors
               if( ! $errors = $this->form_errors() )
               {
                  #do an update
                  
                  #first build the SET portion
                  foreach( $this->fields as $k => $v )
                  {
		 
                     if( isset( $_POST[$k] ) )
                     {
                        $sql = $sql . $k . " = " . $this->db->qstr( $_POST[$k] ) . ", ";
                     }
                  
                  }
                  
                  #second take off the last ', '
                  $sql = ereg_replace( ", $" , "" , $sql );
                  $sql = "UPDATE ".$this->table." SET ".$sql." WHERE ".$this->key." = ".$this->db->qstr( $_GET['rcrud_id'] )." LIMIT 1";
                  $qr = $this->db->Execute( $sql ) or die( "RCRUD Edit SQL Problem: ".$this->db->ErrorMsg() );
                  
                  echo "<p>Your item has been updated.</p>";
                  $this->make_return_link();
                  
                  return true;
                  
               }

         }
         else
         {
         
            #fill $_POST with the values one time, on first visit.
            $q = "SELECT * FROM ".$this->table." WHERE ".$this->key." = ".$this->db->qstr( $_GET['rcrud_id'] );
            $qr = $this->db->Execute( $q ) or die( "RCRUD Edit Values Fill: ".$this->db->ErrorMsg() );
            $row = $qr->FetchRow();
            $_POST = $row;
         }
      
         #make the form
         $this->make_form_bygrp( "visible_in_edit", "Save" , $errors );
         $this->make_return_link();
         
      }      



      #this makes the form for add and edit
      #show the ones that have the visibility
      #place sublabel on the submit button
      #show these errors where needed
      function make_form( $visibility, $sublabel, $errors )
      {
            #this form posts to itself so no action specified
            echo "<form method=\"POST\">\n";
            // ici place le parcours des groupes
            // une table pour chaque groupe
            echo "<table class=\"pagetable\" width=\"100%\">\n";
            
                  
            foreach( $this->fields as $k => $v )
            {
            
        
               if( $v[$visibility] )
               {
                  if( isset( $errors[$k] ) )
                  {
                     echo "<tr><td colspan=\"2\">";
                     echo "<span style=\"color: ".$this->errorcolor.";\">";
                     echo $v['field_error'];
                     echo "</span></td></tr>\n";
                  }
                  
                  
                  echo "<tr>\n";
   
                  echo " <td>".$v['label']."</td>\n";
   
                  echo " <td>\n";

		  if(!isset($_POST[$k])) {
		    $_POST[$k] = '';
		  }

                  switch( $v['field_type'] )
                  {
                     case "text":
                        echo "    <input type=\"text\" name=\"".$k."\" value=\"". $_POST[$k] . "\" size=\"".$v['field_width']."\">\n";
                        break;
                     case "textarea":
                        echo "    <textarea name=\"".$k."\" ROWS=".$v['field_height']." COLS=".$v['field_width'].">";
                        echo $_POST[$k];
                        echo "</textarea>\n";
                        break;
                     case "display":
                        echo $_POST[$k];
                        break;
                     case "ipstamp":
                        echo "<input type=\"hidden\" name=\"".$k."\" value=\"".$_SERVER["REMOTE_ADDR"]."\">\n";
                        echo $_SERVER['REMOTE_ADDR'];
                        break;
                     case "checkbox":
                        echo "    <input type=\"hidden\" name=\"".$k."\" value=\"0\" >\n";
                        echo "    <input type=\"checkbox\" name=\"".$k."\" value=\"1\"";
                        if( $_POST[$k] == "1" )
                        {
                           echo " CHECKED ";
                        }
                        echo ">\n";
                        break;
                     case "checkbox_on":
                        echo "    <input type=\"hidden\" name=\"".$k."\" value=\"0\" >\n";
                        echo "    <input type=\"checkbox\" name=\"".$k."\" value=\"1\"";
                        if( $_POST[$k] == "1" )
                        {
                           echo " CHECKED ";
                        }
			if( $_POST[$k] == '' ) {
			  //should only affect add
			  echo " CHECKED ";
			}
                        echo ">\n";
                        break;
                     case "date":
                        $this->make_date( $k );
                        break;
                     case "datetime":
                        $this->make_datetime( $k );
                        break;
                  }
                  
                  if( ereg( "^select" , $v['field_type'] ) )
                  {
                     $parts = split( "\|" , $v['field_type'] );
                     
                     switch( $parts[1] )
                     {
                        case "range":
                           $this->make_range_selector( $parts[2] , $parts[3] , $k );
                           break;
                        case "table":
                           $this->make_table_selector( $parts[2] , $parts[3] , $parts[4] , $k );
                           break;
                     }
                  }
                  
                  if( ereg( "^radio" , $v['field_type'] ) )
                  {
                     $this->make_radios( $k );
                  }
                                       
                  echo " </td>\n";               
                  echo "</tr>\n";               
               }
               
            
            }#end for each
            
            echo "<tr><td colspan=\"2\"><input type=\"submit\" name=\"rcrud_sub\" value=\"".$sublabel."\"/></td></tr>\n";
            
            echo "</table>\n";
            echo "</form>\n";
         
      
      
      
      }#end form function       
      
      
      #this makes the form for add and edit
      #show the ones that have the visibility
      #place sublabel on the submit button
      #show these errors where needed
      function make_form_bygrp( $visibility, $sublabel, $errors )
      {
            // on regroupe les fields par groups
		    $this->constructgroup();
            #this form posts to itself so no action specified
            echo "<form method=\"POST\">\n";
            // ici place le parcours des groupes
            // une table pour chaque groupe
            foreach( $this->groups as $gl => $gv )
            {
              echo "<fieldset><legend>".$gl."</legend>\n";       
              echo "<table class=\"pagetable\" width=\"100%\">\n";
            
                  
              foreach( $gv as $k => $v )
              {
            
        
               if( $v[$visibility] )
               {
                  if( isset( $errors[$k] ) )
                  {
                     echo "<tr><td colspan=\"2\">";
                     echo "<span style=\"color: ".$this->errorcolor.";\">";
                     echo $v['field_error'];
                     echo "</span></td></tr>\n";
                  }
                  
                  
                  echo "<tr>\n";
   
                  echo " <td>".$v['label']."</td>\n";
   
                  echo " <td>\n";

		  if(!isset($_POST[$k])) {
		    $_POST[$k] = '';
		  }

                  switch( $v['field_type'] )
                  {
                     case "text":
                        echo "    <input type=\"text\" name=\"".$k."\" value=\"". $_POST[$k] . "\" size=\"".$v['field_width']."\">\n";
                        break;
                     case "textarea":
                        echo "    <textarea name=\"".$k."\" ROWS=".$v['field_height']." COLS=".$v['field_width'].">";
                        echo $_POST[$k];
                        echo "</textarea>\n";
                        break;
                     case "display":
                        echo $_POST[$k];
                        break;
                     case "ipstamp":
                        echo "<input type=\"hidden\" name=\"".$k."\" value=\"".$_SERVER["REMOTE_ADDR"]."\">\n";
                        echo $_SERVER['REMOTE_ADDR'];
                        break;
                     case "checkbox":
                        echo "    <input type=\"hidden\" name=\"".$k."\" value=\"0\" >\n";
                        echo "    <input type=\"checkbox\" name=\"".$k."\" value=\"1\"";
                        if( $_POST[$k] == "1" )
                        {
                           echo " CHECKED ";
                        }
                        echo ">\n";
                        break;
                     case "checkbox_on":
                        echo "    <input type=\"hidden\" name=\"".$k."\" value=\"0\" >\n";
                        echo "    <input type=\"checkbox\" name=\"".$k."\" value=\"1\"";
                        if( $_POST[$k] == "1" )
                        {
                           echo " CHECKED ";
                        }
			if( $_POST[$k] == '' ) {
			  //should only affect add
			  echo " CHECKED ";
			}
                        echo ">\n";
                        break;
                     case "date":
                        $this->make_date( $k );
                        break;
                     case "datetime":
                        $this->make_datetime( $k );
                        break;
                  }
                  
                  if( ereg( "^select" , $v['field_type'] ) )
                  {
                     $parts = split( "\|" , $v['field_type'] );
                     
                     switch( $parts[1] )
                     {
                        case "range":
                           $this->make_range_selector( $parts[2] , $parts[3] , $k );
                           break;
                        case "table":
                           $this->make_table_selector( $parts[2] , $parts[3] , $parts[4] , $k );
                           break;
                     }
                  }
                  
                  if( ereg( "^radio" , $v['field_type'] ) )
                  {
                     $this->make_radios( $k );
                  }
                                       
                  echo " </td>\n";               
                  echo "</tr>\n";               
               }
               
            
            }#end for each
                       
            echo "</table>\n";
		}
		echo "</fieldset>\n";
		echo "<table><tr><td colspan=\"2\"><input type=\"submit\" name=\"rcrud_sub\" value=\"".$sublabel."\"/></td></tr></table>\n";
        echo "</form>\n";
         
      
      
      
      }#end make_form_bygrp funct
      
      
      
      
      
      
      #this functions deletes a record
      function delete( $id )
      {
         $q = "DELETE FROM ".$this->table." WHERE ".$this->key." = ".$this->db->qstr( $id )." LIMIT 1";
         $qr = $this->db->Execute( $q ) or die( "RCRUD DELETE SQL: ".$this->db->ErrorMsg() );
         echo "That record has been deleted.</p>";
         $this->make_return_link();
         
      }
      
      
      
      #this function shows the data in a table if you need something fancy edit all you want I wont stop you
      function show()
      {
	$updown = '';

         if( isset( $_GET['rcrud_updown'] ) && ( $_GET['rcrud_updown'] == "ASC" || $_GET['rcrud_updown'] == "DESC" ) )
         {
             $updown = $_GET['rcrud_updown'];
         }
         else
         {
            $updown = "ASC";
            $_GET['rcrud_updown'] = "ASC";
         }
         
         if( ! isset( $_GET['rcrud_sortby'] ) || ! isset( $this->fields[$_GET['rcrud_sortby']] ) )
         {
            $sortby = $this->def_sort;
            $_GET['rcrud_sortby'] = $sortby;
         }
         else
         {
            $sortby = $_GET['rcrud_sortby'];
         }

         
         echo '<table cellspacing="2" cellpadding="2" class="pagetable" width="100%">';
         echo "<thead>\n";
         echo '<tr>';
         echo "\n";
               
         #show the table headers
         foreach( $this->fields as $k => $v )
         {
            if( $this->fields[$k]['visible_in_list'] )
            {
               echo "   <th>";
               echo $v['label'];

               echo "&nbsp;";
               
               echo "<a href=\"".$this->makeurl( "show" , -1 )."&amp;rcrud_sortby=".$k."&amp;rcrud_updown=ASC\">&and;</a>";
               if( $k == $_GET['rcrud_sortby'] && $_GET['rcrud_updown'] == "ASC" )
               {
                  echo ".";
               }
               else
               {
                  echo "&nbsp;";
               }
    
               echo "<a href=\"".$this->makeurl( "show" , -1 )."&amp;rcrud_sortby=".$k."&amp;rcrud_updown=DESC\">&or;</a>";
               if( $k == $_GET['rcrud_sortby'] && $_GET['rcrud_updown'] == "DESC" )
               {
                  echo ".";
               }
               echo "</th>\n";
            }
         }

         echo "<th width=\"1%\">&nbsp;</th>\n";
         echo "<th width=\"1%\">&nbsp;</th>\n";

         echo '</tr>';
         echo "\n";
         echo "</thead>\n";
         
         #now the data   
         $q = "SELECT * FROM ".$this->table." ORDER BY ".$sortby." ".$updown;
         $qr = $this->db->Execute( $q ) or die( "RCRUD SHOW SQL: ".$this->db->ErrorMsg() );
         
         $i = 0;
         while( $row = $qr->FetchRow() )
         {
            echo "<tr class=\"row".(($i % 2)+1)."\" ";
            echo "onmouseover=\"this.className='row".(($i % 2)+1)."hover';\" onmouseout=\"this.className='row".(($i % 2)+1)."';\">\n";
            $i++;
           
              foreach( $row as $k => $v )
              {
                 if( $this->fields[$k]['visible_in_list'] )
                 {
                    echo "   <td>";
                    if( ereg( "^select\|table" , $this->fields[$k]['field_type'] ) )
                    {
                       $parts = split( "\|" , $this->fields[$k]['field_type'] );
                       echo "(".$v.") ".$this->get_foreign_label( $parts[2] , $parts[3] , $v , $parts[4] );
                    }
                    else
                    {
                       echo $v;
                    }
                    echo "</td>\n";
                 }
              }
            
            #edit and delete columns
            echo "<td><a href=\"".$this->makeurl( "edit" , $row[$this->key] )."\">edit</a>&nbsp;</td>";
            echo "<td>&nbsp;<a href=\"".$this->makeurl( "delete" , $row[$this->key] )."\">delete</a></td>";

            echo "</tr>\n";
         }
         
         
         echo "</table>\n";
                  
         echo "<p><a href=\"".$this->makeurl( "add" , 0 )."\">Create New</a></p>\n";
      
      }#end show function
      
      
      #this function returns the exact url that we were called with strips out previous rcrud and applies new
      #hopefully this allows us to use rcrud in other programs and libraries
      function makeurl( $action , $id )
      {
	$t='';
         foreach( $_GET as $k => $v )
         {
            if( ! ereg( "^rcrud", $k ) )
            {
               $t = $t . $k . "=" .$v. "&amp;";
            }
         }
         
	 //check that module=  is carried through
	 if (!isset($_GET['module'])) 
	   {
	     $m = isset($_POST['mact']) ? explode(',',$_POST['mact']) : "";
	     $m = "module=". $m[0];
	     $t = $_SERVER["PHP_SELF"] . "?" . $t . $m ."&amp;rcrud_action=".$action."&amp;rcrud_id=".$id;
	   }
	 else
	   {
	     $t = $_SERVER["PHP_SELF"] . "?" . $t ."rcrud_action=".$action."&amp;rcrud_id=".$id;
	   }

         if( $action == "edit" || $action == "delete" || $action == "add" )
         {
            $t = $t . "&amp;rcrud_table=".$this->table;
         }
         
         return $t;
         
      }
      
      #set all the fields visibilty to $b
      #ex, set all fields to false, then enable the ones you need
      function setVisibleInListAll( $b )
      {
         foreach( $this->fields as $k => $v )
         {
            $this->fields[$k]['visible_in_list'] = $b;
         }
      }

      #set all the fields visibilty to $b
      #ex, set all fields to false, then enable the ones you need
      function setVisibleInAddAll( $b )
      {
         foreach( $this->fields as $k => $v )
         {
            $this->fields[$k]['visible_in_add'] = $b;
         }
      }      

      #set all the fields visibilty to $b
      #ex, set all fields to false, then enable the ones you need
      function setVisibleInEditAll( $b )
      {
         foreach( $this->fields as $k => $v )
         {
            $this->fields[$k]['visible_in_edit'] = $b;
         }
      }

      
      #print ourselves out so we can what is being set and/or not...
      function debug()
      {
         echo "<pre>\n";
         print_r($this);
         echo "</pre>\n";
      }
     
     
      
      #returns the errors if there were some otherwise no, then return false.
      function form_errors()
      {
         #process the regex validations
            foreach( $_POST as $k => $v )
            {
               if( isset( $this->fields[$k]['field_regex'] ) )
               {
                  if( ! ereg( $this->fields[$k]['field_regex'] , $v ) )
                  {
                     $errors[$k] = $this->fields[$k]['field_error'];
                  }
               }
            }
            
            if( isset( $errors )  )
            {
               return $errors;
            }
            else
            {
               return false;
            }
      }#end form errors
   

      #this function makes a radio button based on the field type
      function make_radios( $field )
      {
         $parts = split( "\|" , $this->fields[$field]['field_type'] );
         
         #pop the first element off the array 
         $parts = array_reverse( $parts );
         array_pop( $parts );
         $parts = array_reverse( $parts );
	 
	 $selected = '';

	 if (isset( $_POST[$field] ) && $_POST[$field] != '') {
	   $selected = $_POST[$field];
	 } else {
	   $selected = $parts[0];
	 }
         
         foreach( $parts as $k => $v )
         {
            echo $v . " <input type=\"radio\" name=\"".$field."\" value=\"".$v."\"/";
            if( $selected === $v )
            {
               echo " checked=\"checked\" ";
            }
            echo ">\n";
         }
      }
   
   
      #this function make a selector with an int range
      function make_range_selector( $min , $max , $form_field )
      {
      
         echo "<select name=\"".$form_field."\">\n";
         $i = $min;
         while( $i - 1 < $max )
         {
            echo "  <option value=\"".$i."\"";
            if( $_POST[$form_field] == $i )
            {
               echo " SELECTED ";
            }
            echo ">".$i."</option>\n";
            $i++;
         }
         echo "</select>\n";
      
      }#end func
 
 
 
 
      #this function make a selector with an int range
      function make_table_selector( $table , $value , $label , $form_field )
      {
      
         echo "<select name=\"".$form_field."\">\n";

         $q = "SELECT ".$value.", ".$label." FROM ".$table." ORDER BY ".$label." ASC";
         $qr = $this->db->Execute( $q ) or die( "RCRUD MAKE TABLE SELECT SQL: ".$this->db->ErrorMsg() );
       
         
         while( $row = $qr->FetchRow() )
         {
            echo "  <option value=\"".$row[$value]."\"";
            if( isset($_POST[$form_field]) && $_POST[$form_field] == $row[$value] )
            {
               echo " SELECTED ";
            }
            echo ">".$row[$label]."</option>\n";
            
         }
         echo "</select>\n";
      
      }#end func
      
      
      #this functions gets the text value of a foreign key
      function get_foreign_label( $table , $value_field , $value , $label )  
      {
      
         $q = "SELECT ".$label." FROM ".$table." WHERE ".$value_field." = ".$this->db->qstr( $value );
         $qr = $this->db->Execute( $q );
         $row = $qr->FetchRow();
         if( $qr->RecordCount() == 0 )
         {
            return "Missing Label";
         }
         else
         {
            return $row[$label];
         }
         
      }
      
      
      #this functions make a datetime html field
      function make_datetime( $field )
      {
      
         if( ! isset( $_POST[$field] ) || $_POST[$field] == "0000-00-00 00:00:00" )
         {
            $_POST[$field] = date( "Y-m-d H:i:s" );
         }
         
         $_POST[$field.'-year'] = date( "Y" , strtotime( $_POST[$field] ) );
         $_POST[$field.'-month'] = date( "m" , strtotime( $_POST[$field] ) );
         $_POST[$field.'-day'] = date( "d" , strtotime( $_POST[$field] ) );
         $_POST[$field.'-hour'] = date( "H" , strtotime( $_POST[$field] ) );
         $_POST[$field.'-minute'] = date( "i" , strtotime( $_POST[$field] ) );
         $_POST[$field.'-second'] = date( "s" , strtotime( $_POST[$field] ) );
         
         
         
         echo "YYYY-MM-DD ";
         $this->make_range_selector( date( "Y" ) - 100 , date( "Y" ) + 10 , $field."-year" );
         $this->make_range_selector( 1 , 12 , $field."-month" );
         $this->make_range_selector( 1 , 31 , $field."-day" );
         echo " &nbsp; HH:MM:SS ";
         $this->make_range_selector( 0 , 23 , $field."-hour" );
         $this->make_range_selector( 0 , 59 , $field."-minute" );
         $this->make_range_selector( 0 , 59 , $field."-second" );
      
      }
      
      #this function just makes the date no h,m,s
      function make_date( $field )
      {
         if( ! isset( $_POST[$field] ) || $_POST[$field] == "0000-00-00" )
         {
            $_POST[$field] = date( "Y-m-d" );
         }
         
         $_POST[$field.'-year'] = date( "Y" , strtotime( $_POST[$field] ) );
         $_POST[$field.'-month'] = date( "m" , strtotime( $_POST[$field] ) );
         $_POST[$field.'-day'] = date( "d" , strtotime( $_POST[$field] ) );
         
         
         echo "YYYY-MM-DD ";
         $this->make_range_selector( date( "Y" ) - 100 , date( "Y" ) + 10 , $field."-year" );
         $this->make_range_selector( 1 , 12 , $field."-month" );
         $this->make_range_selector( 1 , 31 , $field."-day" );

      
      }
      
      #this compiles back the datetime field from html post
      function compile_datetime( $field )
      {
      
         $_POST[$field] = $_POST[$field.'-year']."-".$_POST[$field.'-month']."-".$_POST[$field.'-day']." ".
                                    $_POST[$field.'-hour'].":".$_POST[$field.'-minute'].":".$_POST[$field.'-second'];
      
      }
      
      #this function compiles just a date into one field again
      function compile_date( $field )
      {
      
         $_POST[$field] = $_POST[$field.'-year']."-".$_POST[$field.'-month']."-".$_POST[$field.'-day'];
                                    
      }
      
      #this coverts all the datetimes from post into the original field
      function compile_datetimes()
      {
      
         foreach( $this->fields as $k => $v )
         {
            if( $v['field_type'] == "datetime" )
            {
               $this->compile_datetime( $k );
            }
            
            if( $v['field_type'] == "date" )
            {
               $this->compile_date( $k );
            }
            
         }
         
      }
      
     #this function makes a return to list link so with any rcrud stuff
     function make_return_link()
     {
       $t = '';
        foreach( $_GET as $k => $v )
        {
           if( ! ereg( "^rcrud", $k ) )
           {
              $t = $t . $k . "=" .$v. "&";
           }
        }
         
         $t = ereg_replace( "\&$" , "" , $t );
            
         $t = $_SERVER["PHP_SELF"] . "?" . $t;
         echo "<p><a href=\"". $t . "\">return to list</a></p>\n";
         
     }
   
   }#endclass


?>
