<?php
$lang['help_param_gpxfile'] = 'The full path of the local file in a format GPX';
$lang['missing_param'] = 'One or more required parameters are missing';
$lang['help_param_map'] = 'The map definition that holds the parameters and settings for the map';
$lang['help_param_title'] = 'The title of the popup ballon';
$lang['help_param_text'] = 'Text for the inside of the popup';
$lang['friendlyname'] = 'Simple GPX Map';
$lang['moddescription'] = 'A quick and easy way to generate a google or GeoPortail map from a GPX File';
$lang['postinstall'] = 'Please provide GoogleMaps api key ou GeoPOrtail api key! Using GPXMaps requires "Use GPXMaps" rights';
$lang['postuninstall'] = 'Bye bye';
$lang['really_uninstall'] = 'Really uninstall? All data will be lost';
$lang['uninstalled'] = 'Module Uninstalled.';
$lang['installed'] = 'Module version %s installed.';
$lang['prefsupdated'] = 'Module preferences updated.';
$lang['accessdenied'] = 'Access Denied. Please check your permissions.';
$lang['error'] = 'Error!';
$lang['upgraded'] = 'Module upgraded to version %s.';
$lang['title_mod_prefs'] = 'Module Preferences';
$lang['title_mod_admin'] = 'Module Admin Panel';
$lang['title_admin_panel'] = 'GoogleMaps or GeoPortail Module';
$lang['settings'] = 'Settings';
$lang['maps'] = 'Maps';
$lang['your_maps'] = 'Maps';
$lang['map_id'] = 'Map ID';
$lang['settings_saved'] = 'Settings saved';
$lang['Googleapikey'] = 'GoogleMaps apikey';
$lang['GeoPortailapikey'] = 'Geoportail apikey';




$lang['nokey'] = 'GoogleMaps or GeoPortail apikey missing in configuration';
$lang['nomap'] = 'No map provided';
$lang['query_address'] = 'Adress lookup';
$lang['address_lookup'] = 'Search location for address';
$lang['Submit'] = 'Submit';
$lang['location_for'] = 'Location for';
$lang['is'] = 'is';
$lang['general_settings'] = 'General Settings';
$lang['changelog'] = '
<ul>
<li>Version 0.1. Decembre 2009. Initial Release.</li>
<li>Version 0.2. Avril 2010. integration GeoPortail 1.0 final version.</li>
<li>Version 0.2. Avril 2010. custom marker for GoogleMaps.</li>
</ul>

<h3>Thanks go to </h3>
<p>Tatu Wikman for the skeleton that I used to build this module from.</p>
<p>calguy1000 for the SimpleGoogleMap that i used to build this module from.</p>
<p>Robert Brown for RCRUD Class used in admin extensively</p>
<p>and</p>
<p>Okuda for the javascript module to define API GoogleMaps (http://notions.okuda.ca/geotagging/projects-im-working-on/gpx-viewer/)</p>
';
$lang['help'] = '
<h3>What Does This Do?</h3>
<p>This module allows integrating in your site with the GoogleMaps and GeoPortail engines, your GPS track points. Quickly and easily you can build a map with any GPX file.</p>
<h3>How Do I Use It</h3>
<p>(1) First you must insert your GoogleMaps api key (please register in http://www.google.com/apis/maps/signup.html) into the admin section, and setup preferences.</p>
<p>(2) Next you must insert your GeoPortail api key (please register in https://api.ign.fr/geoportail/registration.do) into the admin section, and setup preferences.
You must sign a contract for at least the following layers : IGN MAPS  (WMSC:GEOGRAPHICALGRIDSYSTEMS.MAPS) et PHOTO MAPS (WMSC:ORTHOIMAGERY.ORTHOPHOTOS)</p>
<p>(3) The maps engines are showed in tabs. To customize these tabs you must integrate in your CSS files the following lines: </p>
<p><pre>
/* ------------ Tabs GPX Maps ------------- */
ul#tabnav {
    font: bold 11px verdana, arial, sans-serif;
    list-style-type: none;
    padding-bottom: 28px;
    border-bottom: 1px solid #666666;
    margin: 0;
}
ul#tabnav li {
    float: left;
    height: 21px;
    background-color: #F0F0F0;;
    margin: 2px 2px 0px 2px;
    border: 1px solid #666666;
    list-style-type: none;
}
ul#tabnav li.active {
    border-bottom: 1px solid #F0F0F0;
    background-color: #fff;
    color : #301E12;
    list-style-type: none;
}
#tabnav a {
    float: left;
    display: block;
    color : #666666;
    text-decoration: none;
    padding: 4px;
}
#tabnav li:hover, #tabnav a:hover {
    background: #fff;
}
/* ------------ End Tabs GPX Maps ------------- */

</pre></p>
<p>(4) Next you need to define one or more \'maps\' in the admin interface. Note that this just defines how the map will look and it\'s behavior, not the location of the map.</p>
<p>(5) Then to generate the map in your content page with , write the line :</p>
<p><pre>{SimpleGPXMap map=\'mymap\' gpxfile=\'./uploads/yourgpxfile.gpx\'}</pre></p>
<h3>Advanced usage</h3>
<p><b>Commun options</b></p>
<p><b>Name</b> : this field defines the name of your map.<br>
<b>Description</b> : the description of your map<br>
<b>Width</b> : The width of your maps in your content page. The width must be set in pixel. Don’t set the unit.<br>
<b>Height</b> : The height of your maps in your content page. The height must be set in pixel. Don’t set the unit.<br>
<b>Trace Color</b> : The color must be given in hexadecimal (by example set the value ‘#0000FF’). This option is optional. By default the color is the default color from the maps engine.<br>
<b>Trace width</b> : The trace width must be given in pixel.<br>
<b>The engine maps printed by default</b> : You have the choice between the values : ‘GOOGLE’ or ‘GeoPortail’. This field allows defining the maps engine shown by default in your content page. Warning this option is mandatory.</p>
<br>
<p><b>GeoPortails options</b></p>
<p><b>IGN map opacity</b> : this option defined the level of opacity of the IGN Maps. The values authorized go from 0 to 10. With the value ‘0’, the map is hidden.</br>
<b>Photo map opacity</b> : this option defined the level of opacity of the satellite photo maps. The values authorized go from 0 to 10. With the value ‘0’, the map is hidden.</br>
<b>Expand layer control</b> : The layer control is expand if this option is checked</br>
<b>Expand tool control</b> : The Zoom control is expand if this option is checked.
</p>
<br>
<p><b>Googlemaps options</b></p>
<p>
<b>Display type</b> : Define the Google map which will be shown by default. You have the choice between the following maps : ‘G_NORMAL_MAP’  ‘G_SATELLITE_MAP’  ‘G_HYBRID_MAP’  ‘G_PHYSICAL_MAP’. By the layer control, you can change this choice in your content page.<br>
<b>Type of zoom control</b> : You can choose the type of zoom control : ‘Small’ or ‘Large’<br>
<b>Type layer control</b> : You can choose the type of layer control : ‘Vertical’ or ‘Horizontal’<br>
<b>Show scale control</b> : to define, if you want the scale control.<br>
<b>Mouse zoom enable</b> : to navigate with the mouse in the zoom level.</p>

<p>
<b>Photo panoramia</b> : Checked this option to show the photo panoramia map<br>
<b>Wikipedia links</b> : Checked this option to show the Wikipedia links
</p>
<p>
<b>Start Icon marker</b> : this module allow to define the icon of the first point of the track. If no icon is defined, the Google default marker will be used.<br>
<b>End Icon marker</b> : this module allow to define the icon of the last point of the track. If no icon is defined, the Google default marker will be used.<br>
<b>Default icon marker</b> : this module allow to define the icon of the default track points. If no icon is defined, the Google default marker will be used.
</p>
<p><br>
For all icons marker we must defined the following fields :<br> 
<b>Icon</b> : donnez le chemin complet de l\'image (jpg, png) du marqueur.<br>
<b>shadow</b> : donnez le chemin complet de l\'image (jpg, png) de l\'ombre du marqueur <br>
<b>icon width</b> : the width of the icon, given in pixel<br>
<b>icon height</b> : the height of the icon, given in pixel
</p>
<p>
<b>icon shadow size width</b> : the width of the shadow icon; given in pixel<br>
<b>icon shadow size height</b> : the height of the shadow icon; given in pixel<br>
<br>
<b>icon anchor offset x</b> : the offset between the localization and the icon marker; given in pixel<br>
<b>icon anchor offset y</b> : the offset between the localization and the icon marker; given in pixel<br>
<br>
<b>info Window Anchor offset x</b> : the offset between the info windows  and the icon marker; given in pixel<br>
<b>info Window Anchor offset y</b> : the offset between the info windows  and the icon marker; given in pixel<br>
</p>
<p>
Par exemple vous pouvez utiliser les valeurs suivantes : 
</p>
<p><pre>
start icon			modules/SimpleGPXMap/images/start_en.png
start shadow icon		modules/SimpleGPXMap/images/startshadow_en.png
width start icon		85
height start icon		34
width shadow start icon	 	85
height shadow start icon	34
Offset x of start icon	 	10
Offset y of start icon	 	30
Offset x of the message  	5
Offset y of the message	 	1

end icon			modules/SimpleGPXMap/images/end_en.png
end shadow icon			modules/SimpleGPXMap/images/endshadow_en.png
width end icon			97
height end icon			34
width of shadow end icon	97
height shadow end icon	 	34
Offset x of end icon	 	75
Offset y of end icon	 	30
Offset x of the message  	65
Offset y of the message  	1
</pre></p>
<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<p>As per the GPL, this software is provided as-is. Please read the text
of the license for the full disclaimer.</p>

<h3>Security</h3>
<p>User must have "Use GPXMaps" permissions set to edit maps</p>
';

//param help
$lang['help_param_map'] = 'Set which map to show';


//table fields
$lang['t_name'] = 'Name';
$lang['t_belongs_to'] = 'Belongs to map';
$lang['t_description'] = 'Description';
$lang['t_type'] = 'Display type';
$lang['t_cartebydefault'] = 'Display type';
$lang['t_width'] = 'Width';
$lang['t_height'] = 'Height';
$lang['t_tracecolor'] = 'Trace Color';
$lang['t_tracewidth'] = 'Trace width';
$lang['t_firmselected'] = 'The engine maps printed by default';
$lang['t_onlyonfirm'] = 'Print only the firm selected by default';

$lang['t_smallcontrol'] = 'Type of zoom control ';
$lang['t_horizontalcontrol'] = 'Type layer control';
$lang['t_echellecontrol'] = 'Show scale control';
$lang['t_zoomenable'] = 'Mouse zoom enable';

$lang['t_opacityign'] = 'IGN map opacity';
$lang['t_opacityphoto'] = 'Photo map opacity';
$lang['t_expandlayerscontrol'] = 'Expand layer control';
$lang['t_expandtoolcontrol'] = 'Expand tool control';

$lang['t_showphotopanoramia'] = 'Show the photos Panoramia';
$lang['t_showwikipedia'] = 'Show Wikipedia links';

$lang['t_starticonimage'] = 'full Path of the start icon';
$lang['t_starticonshadow'] = 'full Path of the shadow start icon';
$lang['t_starticoniswidth'] = 'width start icon';
$lang['t_starticonisheigh'] = 'height start icon';
$lang['t_starticonsswidth'] = 'width shadow start icon';
$lang['t_starticonssheigh'] = 'height shadow start icon';
$lang['t_starticonialeft'] = 'Offset x  of start icon';
$lang['t_starticoniatop'] = 'Offset y of start icon';
$lang['t_starticoniwaleft'] = 'Offset x  of the message of the of start icon';
$lang['t_starticoniwatop'] = 'Offset y of the message of the start icon';

$lang['t_endiconimage'] = 'full Path of the end icon';
$lang['t_endiconshadow'] = 'full Path of the shadow end icon';
$lang['t_endiconiswidth'] = 'width end icon';
$lang['t_endiconisheigh'] = 'height end icon';
$lang['t_endiconsswidth'] = 'width of shadow end icon';
$lang['t_endiconssheigh'] = 'height shadow end icon';
$lang['t_endiconialeft'] = 'Offset x  of end icon';
$lang['t_endiconiatop'] = 'Offset y of end icon';
$lang['t_endiconiwaleft'] = 'Offset x  of the message of the of end icon';
$lang['t_endiconiwatop'] = 'Offset y of the message of the end icon';

$lang['t_defaulticonimage'] = 'full Path of the default icon';
$lang['t_defaulticonshadow'] = 'full Path of the shadow default icon';
$lang['t_defaulticoniswidth'] = 'width default icon';
$lang['t_defaulticonisheigh'] = 'height default icon';
$lang['t_defaulticonsswidth'] = 'width shadow default icon';
$lang['t_defaulticonssheigh'] = 'height shadow default icon';
$lang['t_defaulticonialeft'] = 'Offset x of default icon';
$lang['t_defaulticoniatop'] = 'Offset y of default icon';
$lang['t_defaulticoniwaleft'] = 'Offset x of the message of the of default icon';
$lang['t_defaulticoniwatop'] = 'Offset y of the message of the default icon';

$lang['t_optionscommon'] = 'Common options';
$lang['t_optionsgooglemaps'] = 'GoogleMaps options';
$lang['t_optionsgeoportail'] = 'Geoportail options';
?>
