<?php

/*---------------------------------------------------------
   DisplayModuleOutput($id, $params, $returnid, $message)
   NOT PART OF THE MODULE API
   This is an example of a simple method to display
   something where a page or template has a tag calling
   this module.
   
   Note that it uses a template, and is thus very powerful,
   even if it's simple.
  ---------------------------------------------------------*/

if (!isset($gCms)) exit;

		// Verification des paramètres
		#Avoid float problem in locale
		$currentLocale = setlocale(LC_ALL, 0);
		setlocale(LC_ALL, 'en_US');

		$map = '';
		if(!isset($params['map']))
		{
			$this->smarty->assign('error',$this->Lang('missing_param'));
			$this->smarty->assign('title',$this->Lang('error'));
			echo $this->ProcessTemplate('error.tpl');
			return;
		}
		$map = $params['map'];


		$gpxfile = '';
		if(!isset($params['gpxfile']))
		{
			$this->smarty->assign('error',$this->Lang('missing_param'));
			$this->smarty->assign('title',$this->Lang('error'));
			echo $this->ProcessTemplate('error.tpl');
			return;
		} else  {
			$gpxfile = $params['gpxfile'];
			// on ne verifie pas que le fichier GPX existe sur le site
		}

		$title = '';
		if( isset($params['title']) )
		{
			$title = $params['title'];
		}

		$text = '';
		if( isset($params['text']) )
		{
			$text = $params['text'];
		}

		// on verifie qu'il y a au moins un apikey
		if(($this->GetPreference('sgpxmap_Googleapikey') == ''))
		{
		$this->smarty->assign('error', $this->Lang('nokey'));
		$this->smarty->assign('title', $this->Lang('error'));
		echo $this->ProcessTemplate('error.tpl');
		return;
		}
		
		
		// recherche du Map pour trouver et afficher la firmMaps par defaut (Google ou GeoPortail)
		$db=&$this->GetDb();
		$query = "SELECT * FROM ". cms_db_prefix() ."module_SimpleGPXMap_maps WHERE name LIKE '$map' LIMIT 1";
		$map_data = array();
		$dbresult =& $db->Execute($query);
		if($dbresult) {
		$map_data = $dbresult->FetchRow();
		}

		if(!isset($map_data['map_id'])) {
		$this->smarty->assign('error', $this->Lang('nomap'));
		$this->smarty->assign('title', $this->Lang('error'));
		echo $this->ProcessTemplate('error.tpl');
		return;
		}
		
		
		//recuperation de la firm par defaut
		$Firm = isset($map_data['firmselected'])?$map_data['firmselected']:'GOOGLE';
		$parametreforce = $_GET['sgpxmap_forcefirm'];
		if (($parametreforce == 'GOOGLE') || ($parametreforce == 'GeoPortail')) $Firm = $parametreforce;
		switch ($Firm) {
			case 'GeoPortail':
			  echo $this->ConstructDivMapsGeoPortail($params);
			  break;
			default:
			  echo $this->ConstructDivMapsGoogle($params); // Google par défaut
			  break;
		}		
?>
