<?php
#-------------------------------------------------------------------------
# Module: SimpleGPXMap - Module for GoogleMaps GeoPortail
# Version: 0.1, MrFMO
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------


class SimpleGPXMap extends CMSModule
{
	//var $_googleapi_version = "2.4";

	function GetName()
	{
		return 'SimpleGPXMap';
	}

	function GetFriendlyName()
	{
		return $this->Lang('friendlyname');
	}

	function GetVersion()
	{
		return '0.2';
	}

	function GetHelp()
	{
		return $this->Lang('help');
	}

	function GetAuthor()
	{
		return 'MrFMO';
	}

	function GetAuthorEmail()
	{
		return 'fabrice.monge@free.fr';
	}

	function GetChangeLog()
	{
		return $this->Lang('changelog');
	}

	function IsPluginModule()
	{
		return true;
	}

	function HasAdmin()
	{
		return true;
	}

  	function GetAdminSection()
	{
		return 'extensions';
	}

	function GetAdminDescription()
	{
		return $this->Lang('moddescription');
	}

	function VisibleToAdminUser()
	{
	  return $this->CheckPermission('Use SimpleGPXMap');
	}

	function GetDependencies()
	{
		//return array( 'AjaxMadeSimple' => '0.1.6' );
		return array();
	}


	function MinimumCMSVersion()
	{
		return "1.2.6";
	}
	
	function SetParameters()
	{
	  $this->RestrictUnknownParams();
	  $this->RegisterModulePlugin();

	  $this->CreateParameter('gpxfile', '', $this->Lang('help_param_gpxfile'));
	  $this->SetParameterType('gpxfile',CLEAN_STRING);
	  $this->CreateParameter('map','test', $this->lang('help_param_map'), false);
	  $this->CreateParameter('title','', $this->lang('help_param_title'));
	  $this->CreateParameter('text','', $this->lang('help_param_text'));
	  $this->SetParameterType('map',CLEAN_STRING);
	  $this->SetParameterType('title',CLEAN_STRING);
	  $this->SetParameterType('text',CLEAN_STRING);
	}

	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}

	function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}

	function UninstallPreMessage()
	{
		return $this->Lang('really_uninstall');
	}
	
	function DisplayErrorPage($id, &$params, $returnid, $message='')
	{
	  $this->smarty->assign('title_error', $this->Lang('error'));
	  if ($message != '')
	    {
	      $this->smarty->assign_by_ref('message', $message);
	    }
	  
	  // Display the populated template
	  echo $this->ProcessTemplate('error.tpl');
	}

    function GetUrl() {
      $urlbrut = $_SERVER['REQUEST_URI'];
      // suppression des paramètres forçant Google
      $urlpurge = str_replace('&sgpxmap_forcefirm=GOOGLE','',$urlbrut);
      // suppression du paramètre forçant GeoPortail
      $urlpurge = str_replace('&sgpxmap_forcefirm=GeoPortail','',$urlpurge);
      // suppression de l'ancrage
      $urlpurge = str_replace('#sgpxmapancre','',$urlpurge);
     return $urlpurge;
	}



	function ConstructDivMapsGoogle($params) {
		#Avoid float problem in locale
		$currentLocale = setlocale(LC_ALL, 0);
		setlocale(LC_ALL, 'en_US');

		$map = '';
		if(!isset($params['map']))
		{
			$this->smarty->assign('error',$this->Lang('missing_param'));
			$this->smarty->assign('title',$this->Lang('error'));
			echo $this->ProcessTemplate('error.tpl');
			return;
		}
		$map = $params['map'];

		$gpxfile = '';
		if(!isset($params['gpxfile']))
		{
			$this->smarty->assign('error',$this->Lang('missing_param'));
			$this->smarty->assign('title',$this->Lang('error'));
			echo $this->ProcessTemplate('error.tpl');
			return;
		} else  {
			$gpxfile = $params['gpxfile'];
			// on ne verifie pas que le fichier GPX existe sur le site
		}

		$title = '';
		if( isset($params['title']) )
		{
			$title = $params['title'];
		}

		$text = '';
		if( isset($params['text']) )
		{
			$text = $params['text'];
		}

		// on verifie qu'il y a au moins un apikey
		if(($this->GetPreference('sgpxmap_Googleapikey') == ''))
		{
		$this->smarty->assign('error', $this->Lang('nokey'));
		$this->smarty->assign('title', $this->Lang('error'));
		echo $this->ProcessTemplate('error.tpl');
		return;
		}
		
		$db=&$this->GetDb();
		$query = "SELECT * FROM ". cms_db_prefix() ."module_SimpleGPXMap_maps WHERE name LIKE '$map' LIMIT 1";
		$map_data = array();
		$dbresult =& $db->Execute($query);
		if($dbresult) {
		$map_data = $dbresult->FetchRow();
		}

		if(!isset($map_data['map_id'])) {
		$this->smarty->assign('error', $this->Lang('nomap'));
		$this->smarty->assign('title', $this->Lang('error'));
		echo $this->ProcessTemplate('error.tpl');
		return;
		}

		$hmap = isset($map_data['height'])?$map_data['height']:'500';
		$wmap = isset($map_data['width'])?$map_data['width']:'600';
		$tracecolor = ($map_data['tracecolor'] != '')?$map_data['tracecolor']:'#0000ff';
		$traceWidth = ($map_data['tracewidth'] != '')?$map_data['tracewidth']:'5';
		$carteByDefault = isset($map_data['cartebydefault'])?$map_data['cartebydefault']:'G_NORMAL_MAP';
		
		$starticonimage = isset($map_data['starticonimage'])?$map_data['starticonimage']:'';
	    $starticonshadow = isset($map_data['starticonshadow'])?$map_data['starticonshadow']:'';
    	$starticoniswidth = isset($map_data['starticoniswidth'])?$map_data['starticoniswidth']:'0';
    	$starticonisheigh = isset($map_data['starticonisheigh'])?$map_data['starticonisheigh']:'0';
    	$starticonsswidth = isset($map_data['starticonsswidth'])?$map_data['starticonsswidth']:'0';
	    $starticonssheigh = isset($map_data['starticonssheigh'])?$map_data['starticonssheigh']:'0';
	    $starticonialeft = isset($map_data['starticonialeft'])?$map_data['starticonialeft']:'0';
	    $starticoniatop = isset($map_data['starticoniatop'])?$map_data['starticoniatop']:'0';
	    $starticoniwaleft = isset($map_data['starticoniwaleft'])?$map_data['starticoniwaleft']:'0';
	    $starticoniwatop = isset($map_data['starticoniwatop'])?$map_data['starticoniwatop']:'0';

		$endiconimage = isset($map_data['endiconimage'])?$map_data['endiconimage']:'';
	    $endiconshadow = isset($map_data['endiconshadow'])?$map_data['endiconshadow']:'';
    	$endiconiswidth = isset($map_data['endiconiswidth'])?$map_data['endiconiswidth']:'0';
    	$endiconisheigh = isset($map_data['endiconisheigh'])?$map_data['endiconisheigh']:'0';
    	$endiconsswidth = isset($map_data['endiconsswidth'])?$map_data['endiconsswidth']:'0';
	    $endiconssheigh = isset($map_data['endiconssheigh'])?$map_data['endiconssheigh']:'0';
	    $endiconialeft = isset($map_data['endiconialeft'])?$map_data['endiconialeft']:'0';
	    $endiconiatop = isset($map_data['endiconiatop'])?$map_data['endiconiatop']:'0';
	    $endiconiwaleft = isset($map_data['endiconiwaleft'])?$map_data['endiconiwaleft']:'0';
	    $endiconiwatop = isset($map_data['endiconiwatop'])?$map_data['endiconiwatop']:'0';
	    
	    $defaulticonimage = isset($map_data['defaulticonimage'])?$map_data['defaulticonimage']:'';
	    $defaulticonshadow = isset($map_data['defaulticonshadow'])?$map_data['defaulticonshadow']:'';
    	$defaulticoniswidth = isset($map_data['defaulticoniswidth'])?$map_data['defaulticoniswidth']:'0';
    	$defaulticonisheigh = isset($map_data['defaulticonisheigh'])?$map_data['defaulticonisheigh']:'0';
    	$defaulticonsswidth = isset($map_data['defaulticonsswidth'])?$map_data['defaulticonsswidth']:'0';
	    $defaulticonssheigh = isset($map_data['defaulticonssheigh'])?$map_data['defaulticonssheigh']:'0';
	    $defaulticonialeft = isset($map_data['defaulticonialeft'])?$map_data['defaulticonialeft']:'0';
	    $defaulticoniatop = isset($map_data['defaulticoniatop'])?$map_data['defaulticoniatop']:'0';
	    $defaulticoniwaleft = isset($map_data['defaulticoniwaleft'])?$map_data['defaulticoniwaleft']:'0';
	    $defaulticoniwatop = isset($map_data['defaulticoniwatop'])?$map_data['defaulticoniwatop']:'0';		
		
		$Firm = isset($map_data['firmselected'])?$map_data['firmselected']:'GOOGLE'; 

		$FirmApi = $this->GetPreference('sgpxmap_Googleapikey',1);
		$FirmHeader = '<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key='.$FirmApi.'" type="text/javascript"></script><script src="modules/SimpleGPXMap/lib/loadgpx/loadgpx.4.js" type="text/javascript"></script>';
        $FirmTabs = '<ul id="tabnav"><li class="active"><a href="'.$_SERVER['REQUEST_URI'].'#sgpxmapancre">Google</a></li><li ><a href="'.$this->GetUrl().'&sgpxmap_forcefirm=GeoPortail#sgpxmapancre">GeoPortail</a></li></ul>';

 		$FirmMap ='<div id="goomap" style="height:'.$hmap.'px;width:'.$wmap.'px;">'.$title.'&nbsp;'.$text.'</div>';
		$FirmMapJS = '<script type="text/javascript">// <![CDATA[
	var MyMap;
	function LoadGPXFileIntoGoogleMap(map, filename)
	{
		// Remove any existing overlays from the map.
		map.clearOverlays();
		var request = GXmlHttp.create();
		request.open("GET", filename, true);
		request.onreadystatechange = function()
		{
			if (request.readyState == 4)
			{
			parser = new GPXParser(request.responseXML, map);
			parser.SetTrackColour("'.$tracecolor.'");	// Set the track line colour
			parser.SetTrackWidth('.$traceWidth.');		// Set the track line width
			// definined the icons for the trackpoint marker
			';
		if (($starticonimage != '') && ($starticonshadow != '')) {$FirmMapJS .= 'parser.SetStartIcon("'.$starticonimage.'",
			                    "'.$starticonshadow.'",
			                    '.$starticoniswidth.','.$starticonisheigh.',
			                    '.$starticonsswidth.','.$starticonssheigh.',
			                    '.$starticonialeft.','.$starticoniatop.',
			                    '.$starticoniwaleft.','.$starticoniwatop.');
			 ';}
		if (($endiconimage != '') && ($endiconshadow != '')) {$FirmMapJS .= 'parser.SetEndIcon("'.$endiconimage.'",
			                    "'.$endiconshadow.'",
			                    '.$endiconiswidth.','.$endiconisheigh.',
			                    '.$endiconsswidth.','.$endiconssheigh.',
			                    '.$endiconialeft.','.$endiconiatop.',
			                    '.$endiconiwaleft.','.$endiconiwatop.');
			 ';}			 
		if (($defaulticonimage != '') && ($defaulticonshadow != '')) {$FirmMapJS .= 'parser.SetDefaultIcon("'.$defaulticonimage.'",
			                    "'.$defaulticonshadow.'",
			                    '.$defaulticoniswidth.','.$defaulticonisheigh.',
			                    '.$defaulticonsswidth.','.$defaulticonssheigh.',
			                    '.$defaulticonialeft.','.$defaulticoniatop.',
			                    '.$defaulticoniwaleft.','.$defaulticoniwatop.');
			 ';}			 
			$FirmMapJS .= 'parser.SetMinTrackPointDelta(0.001);	// Set the minimum distance between track points
			parser.CenterAndZoom(request.responseXML, '.$carteByDefault.'); // Center and Zoom the map over all the points.
			parser.AddTrackpointsToMap();	// Add the trackpoints
			parser.AddWaypointsToMap();	// Add the waypoints
			}
		}
		request.send(null);
	}

	function onLoad()
	{
	 if (GBrowserIsCompatible()) {
	   MyMap = new GMap2(document.getElementById("goomap"));
	   ';
	   if ($map_data['smallcontrol'] == 'Small') {$FirmMapJS .= 'MyMap.addControl(new GSmallMapControl()); // control en petit;
	   ';} else {$FirmMapJS .= 'MyMap.addControl(new GLargeMapControl());
	   ';}
	   if ($map_data['horizontalcontrol'] == 'Horizontal') {$FirmMapJS .= 'MyMap.addControl(new GMapTypeControl()); // menu à l horizontal
	   ';} else {$FirmMapJS .= 'MyMap.addControl(new GMenuMapTypeControl()); // menu vertical
	   ';}
	   if ($map_data['echellecontrol'] == '1') {$FirmMapJS .= 'MyMap.addControl(new GScaleControl()); // pour ajouter l echelle
	   ';}
	   $FirmMapJS .= 'MyMap.addMapType(G_PHYSICAL_MAP); // pour ajouter le relief
	   ';
	   if ($map_data['zoomenable'] == '1') {$FirmMapJS .= 'MyMap.enableScrollWheelZoom(); // pour permettre le zoom avec la molette
	   ';}
	   if ($map_data['showphotopanoramia'] == '1') {$FirmMapJS .= 'MyMap.addOverlay(new GLayer("com.panoramio.all")); // pour ajouter les photos de panoramio
	   ';}
	   if ($map_data['showwikipedia'] == '1') {$FirmMapJS .= 'MyMap.addOverlay(new GLayer("org.wikipedia.en")); // pour charger Wikipedia 
	   ';}
	   $FirmMapJS .= ' // Add the self created control
                    LoadGPXFileIntoGoogleMap(MyMap, "'.$gpxfile.'");
     }
	}
// 
window.onload = onLoad();
window.onunload = GUnload();
// ]]></script>';

//$FirmMapJS = "<h2>GOOGLE</h2>";	
		// assign Smarty variables;
		$this->smarty->assign('firm_map_header',$FirmHeader);
		$this->smarty->assign('firm_tabs',$FirmTabs);
		$this->smarty->assign('firm_map',$FirmMap);
		$this->smarty->assign('firm_js',$FirmMapJS);


		// Display the populated template
		//echo $this->ProcessTemplate('map.tpl');  
		adodb_connect();
		#Set locale again
		setlocale(LC_ALL, $currentLocale);
		
		// Display the populated template
		return $this->ProcessTemplate('map.tpl');  
		
	}
	
	
	
	
	
	
	function ConstructDivMapsGeoPortail($params) {
		#Avoid float problem in locale
		$currentLocale = setlocale(LC_ALL, 0);
		setlocale(LC_ALL, 'en_US');

		$map = '';
		if(!isset($params['map']))
		{
			$this->smarty->assign('error',$this->Lang('missing_param'));
			$this->smarty->assign('title',$this->Lang('error'));
			echo $this->ProcessTemplate('error.tpl');
			return;
		}
		$map = $params['map'];


		$gpxfile = '';
		if(!isset($params['gpxfile']))
		{
			$this->smarty->assign('error',$this->Lang('missing_param'));
			$this->smarty->assign('title',$this->Lang('error'));
			echo $this->ProcessTemplate('error.tpl');
			return;
		} else  {
			$gpxfile = $params['gpxfile'];
			// on ne verifie pas que le fichier GPX existe sur le site
		}

		$title = '';
		if( isset($params['title']) )
		{
			$title = $params['title'];
		}

		$text = '';
		if( isset($params['text']) )
		{
			$text = $params['text'];
		}

		// on verifie qu'il y a au moins un apikey
		if(($this->GetPreference('sgpxmap_GeoPortailapikey') == ''))
		{
		$this->smarty->assign('error', $this->Lang('nokey'));
		$this->smarty->assign('title', $this->Lang('error'));
		echo $this->ProcessTemplate('error.tpl');
		return;
		}
		
		$db=&$this->GetDb();
		$query = "SELECT * FROM ". cms_db_prefix() ."module_SimpleGPXMap_maps WHERE name LIKE '$map' LIMIT 1";
		$map_data = array();
		$dbresult =& $db->Execute($query);
		if($dbresult) {
		$map_data = $dbresult->FetchRow();
		}

		if(!isset($map_data['map_id'])) {
		$this->smarty->assign('error', $this->Lang('nomap'));
		$this->smarty->assign('title', $this->Lang('error'));
		echo $this->ProcessTemplate('error.tpl');
		return;
		}
		$hmap = isset($map_data['height'])?$map_data['height']:'500';
		$wmap = isset($map_data['width'])?$map_data['width']:'600';
		$tracecolor = ($map_data['tracecolor'] != '')?$map_data['tracecolor']:'#0000ff';
		$traceWidth = ($map_data['tracewidth'] != '')?$map_data['tracewidth']:'5';
		$opacityign = ($map_data['opacityign'] != '')?$map_data['opacityign']/10:'0.7';
		$opacityphoto = ($map_data['opacityphoto'] != '')?$map_data['opacityphoto']/10:'0.5';
		$expandlayerscontrol = ($map_data['expandlayerscontrol'] == 1)?'true':'false';
		$expandtoolcontrol = ($map_data['expandtoolcontrol'] == 0)?'false':'true';
		
		$FirmApi = $this->GetPreference('sgpxmap_GeoPortailapikey',1);
		$FirmHeader = '<script src="http://api.ign.fr/geoportail/api?v=1.0&amp;key='.$FirmApi.'&amp;instance=VISU" type="text/javascript"></script>';
        $FirmTabs = '<ul id="tabnav"><li><a href="'.$this->GetUrl().'&sgpxmap_forcefirm=GOOGLE#sgpxmapancre">Google</a></li><li  class="active" ><a href="'.$_SERVER['REQUEST_URI'].'#sgpxmapancre">GeoPortail</a></li></ul>';
        $FirmMap ='<!-- IE8 compatibility mode -->
<!--[if IE 8]>
 <meta http-equiv="X-UA-Compatible" content="IE=7"/>
<![endif]-->
<div id="GeoportalVisuDiv" style="height:'.$hmap.'px;width:'.$wmap.'px;"></div>';

		$FirmMapJS ='<script type="text/javascript">// <![CDATA[
    function initGeoportalMap() {
      // On implémente la carte
      geoportalLoadVISU("GeoportalVisuDiv", "normal", "FXX");
   
      // On charge les couches de données définies dans le contrat
      if (VISU) {
	    if(VISU.getMap().allowedGeoportalLayers){
         for (var i= 0; i<VISU.getMap().allowedGeoportalLayers.length; i++) {
           var overloaded_options= null;
           if (VISU.getMap().allowedGeoportalLayers[i].match(/^GEOGRAPHICALGRIDSYSTEMS.MAPS/)) {// maps IGN
               overloaded_options= {opacity:'.$opacityign.'};
           } else if (VISU.getMap().allowedGeoportalLayers[i].match(/^ORTHOIMAGERY.ORTHOPHOTOS/)) {// orthophotos
               overloaded_options= {opacity:'.$opacityphoto.'};
           }
          VISU.addGeoportalLayer(VISU.getMap().allowedGeoportalLayers[i],overloaded_options);
         }
		VISU.openLayersPanel('.$expandlayerscontrol.'); // pour fermer la barre de couche
        VISU.openToolsPanel('.$expandtoolcontrol.'); // pour fermer la barre de zoom
		
		var style1 = new OpenLayers.StyleMap({
        "default": new OpenLayers.Style({
            strokeColor:\''.$tracecolor.'\',
            strokeWidth:'.$traceWidth.'
        })
        });
    // on charge la trace
    lcircuit =  VISU.getMap().addLayer( "GPX", "Circuit","'.$gpxfile.'",
						{
							minZoomLevel:0,
							maxZoomLevel:20,';
	 if ($title !='') {$FirmMapJS .=' name:'.$title.',';};
     if ($text !='') {$FirmMapJS .=' attribution:'.$text.',';};
	 $FirmMapJS .=' visibility : true,
							styleMap: style1,
							extractWaypoints:true,extractTracks:true,extractRoutes:true, extractAttributes:true
						});
     lcircuit.events.register(\'loadend\',lcircuit, function(e){zoomToFitTraceGPX();})
        }
     }
	}
	
function zoomToFitTraceGPX() {
	   bounds = lcircuit.features[0].geometry.getBounds();
               VISU.getMap().zoomToExtent(bounds,false);
}
// ]]></script>';

		// assign Smarty variables;
		$this->smarty->assign('firm_map_header',$FirmHeader);
		$this->smarty->assign('firm_tabs',$FirmTabs);
		$this->smarty->assign('firm_map',$FirmMap);
		$this->smarty->assign('firm_js',$FirmMapJS);


		 
		adodb_connect();
		#Set locale again
		setlocale(LC_ALL, $currentLocale);
		
		// Display the populated template
		return $this->ProcessTemplate('map.tpl');  
		
	}
}

?>
