<?php
if (!isset($gCms)) exit;

if (! $this->CheckAccess())
	{
	return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
	}

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for Snippets "defaultadmin" admin action
   
   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/

 
$template_list = $this->ListTemplates();
    	
$rowclass = 'row1';
	
$templates = array();
	
foreach ($template_list as $template)
{
	$onerow = new stdClass();	
	$onerow->name = $template;	
	$onerow->deletelink = $this->CreateLink($id, 'deleteSnippet', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete_snippet'),'','','systemicon'), array('name'=>$template), $this->Lang('areyousure'));
	$onerow->editlink = $this->CreateLink($id, 'manageSnippet', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit_snippet'),'','','systemicon'), array('name'=>$template));
	$onerow->export = $this->CreateLink($id, 'exportSnippet', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/export.gif', $this->Lang('export_snippet'),'','','systemicon'), array('name'=>$template, 'disable_theme' => 'true'));
	$onerow->edit = $this->CreateLink($id, 'manageSnippet', $returnid,$template, array('name'=>$template));
	$onerow->rowclass = $rowclass;
	$templates[] = $onerow;
	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}
	
$this->smarty->assign('snippets', $templates);

$this->smarty->assign('title_snippets', $this->Lang('snippets'));
$this->smarty->assign('title_tag', $this->Lang('tag'));
	
	
$this->smarty->assign('addSnippetLink',$this->CreateLink($id,
				'manageSnippet', '', $this->Lang('add_snippet'),
				array()));
				
$this->smarty->assign('addSnippetIcon',$this->CreateLink($id,
				'manageSnippet', '',
				$gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('add_snippet'),'',
					'','systemicon'), array()));
	
// Import section

$this->smarty->assign('legend_xml_import', $this->Lang('import_xml'));
$this->smarty->assign('form_start', $this->CreateFormStart($id, 'importSnippet', $returnid, 'post','multipart/form-data'));
$this->smarty->assign('form_end',$this->CreateFormEnd());

$this->smarty->assign('submitxml', $this->CreateInputSubmit($id, 'submit', $this->Lang('import')));

$this->smarty->assign('input_xml_to_upload',$this->CreateInputFile($id, 'xmlfile'));
$this->smarty->assign('title_xml_to_upload',$this->Lang('title_xml_to_upload'));

$this->smarty->assign('title_xml_name',$this->Lang('title_xml_name'));
$this->smarty->assign('input_xml_name',$this->CreateInputText($id,'name','',25));
$this->smarty->assign('info_leaveempty',$this->Lang('help_leaveempty'));
$this->smarty->assign('import_icon', 	$gCms->variables['admintheme']->DisplayImage('icons/system/import.gif', $this->Lang('import_snippet'),'',
		'','systemicon'));


echo $this->ProcessTemplate('adminpanel.tpl');
?>