<?PHP
/*-------------------LN--
 * The liteNuke System  |
 *----------------------|
 *  www.gingerware.org  |
 ************************/

/*
 Usage:
 1. Set the GLOBAL var to one of:
 format (default) : do full formatting of all output
 raw : do no formatting whatsoever, dumping all data raw to the browser
 dull : remove all spaces preceding data in every line
 ugly : force all code into 1 long line rendering it practically unreadable
 2. make sure necho_start() is called before any html-code is written
 3. make sure necho_end() is called after last html-code is written
 4. you can use the supplied necho_* functions to write, but do not have to

 have fun
 */

if (!isset($GLOBALS["necho_htmlstate"]))
$GLOBALS["necho_htmlstate"]="format";
$GLOBALS["necho_indentwidth"]=2;
$GLOBALS["necho_forcelowertags"]=false;
$GLOBALS["necho_debugmode"]=false;
$GLOBALS["necho_debuglevel"]="brief";
$GLOBALS["necho_errors"]=0;
$GLOBALS["necho_version"]="nEcho 0.3.2 [".$GLOBALS["necho_htmlstate"]."] - a Nice HTML echo function";

$GLOBALS["necho_indentlevel"]=0;
$GLOBALS["necho_timer"]=0;

//History at the bottom!

if (!function_exists("necho_israw")) {
  function necho_israw() {
    return ($GLOBALS["necho_htmlstate"]=="raw");
  }
}//function_exists

if (!function_exists("_necho_clean")) {
  function _necho_clean($s) { //Clean off anything preceding a string=leftindent everything

    $result=str_replace("\t"," ",$s);

    $result=str_replace("\r"," ",$result);
     
   	$result=str_replace("\n"," ",$result);
   	while (strpos($result,'  ') !== false) $result = str_replace('  ',' ',$result);
    return $result;
  }
}//function_exists

if (!function_exists("necho_clean")) {
  function necho_clean($s/*,$leftindent=false*/) { //Clean off anything preceding a string=leftindent everything
    //Must handle textareas correctly!!!
    //skal dele $s op i bidder, hvis der er text-areas, og ikke behandler delene inde i...
    //$pos=str
    $result=_necho_clean($s);

    return $result;
  }
}//function_exists

if (!function_exists("necho_findscripts")) {
  function necho_findscripts($_s,$offset=0) {
    //  echo "offset:".$offset."<br>";
    if ($offset>strlen($_s)) return false;
    $p=strpos($_s,"<script",$offset);
    if ($p===false) $p=strpos($_s,"<SCRIPT",$offset);
    if ($p===false) $p=strpos($_s,"<pre",$offset);
    if ($p===false) $p=strpos($_s,"<PRE",$offset);
    return $p;
  }
}//function_exists

if (!function_exists("necho_findendscripts")) {
  function necho_findendscripts($_s,$offset=0) {
    if ($offset>strlen($_s)) return false;
    $p=strpos($_s,"</script>",$offset);
    if ($p===false) $p=strpos($_s,"</SCRIPT>",$offset); else $p+=9;
    if ($p===false) $p=strpos($_s,"</pre>",$offset); else $p+=9;
    if ($p===false) $p=strpos($_s,"</PRE>",$offset); else $p+=6;
    if ($p) $p+=6;
    //	echo "OUT:$p";
    return $p;
  }
}


if (!function_exists("necho_uglyfy")) {
  function necho_uglyfy($_s) { //Clean off EVERYTHING, = 1 very long string, except <script>'s and <pre>'s
    if (necho_findscripts($_s)===false)  return necho_clean($_s);
    $s=$_s;
    $result="";
    $inside=false;
    //	$lastp=0;
    $p=necho_findscripts($s);
    while ($p!=false) {
      //	  $result.="*";
      if ($inside) {
        $result.=substr($s,0,$p);
        $s=substr($s,$p,100000);
        $p=necho_findscripts($s);
        $inside=false;
      } else {
        $result.=necho_clean(substr($s,0,$p));
        $s=substr($s,$p,100000);
        $p=necho_findendscripts($s);
        $inside=true;
      }
    }
    if ($s!="") {
      if ($inside) {
        $result.=$s;
      } else {
        $result.=necho_clean($s);
      }
    }

    return $result;
  }
}//function_exists



if (!function_exists("necho_mkindent")) {
  function necho_mkindent($ind,$return=true) {     
    if ($return) $result="\n"; else $result="";
    for ($i=0; $i<$ind; $i++) {
      $result.=substr("                 ",0, $GLOBALS["necho_indentwidth"]);
    }
    static $level=0;
    if ($ind==$level+1) {
      $GLOBALS["necho_indentlevel"]++;
      $level++;
    } else {
      if ($ind==$level-1) {
        $GLOBALS["necho_indentlevel"]--;
        $level--;
      }
    }
    return $result;
  }
}//function_exists

if (!function_exists("necho_addtag")) {
  function necho_addtag($tag) {
    $result=trim($tag);
    if ($GLOBALS["necho_forcelowertags"]) {
      $result=strtolower($result);
      
    }
    return $result;
  }
}//function_exists

if (!function_exists("necho_format")) {
  function necho_format($s) {
    $starttime=microtime(true);
    static $indentarray=array();
    static $indentmessage="";
    static $ind=0;
    $result="";
    $p=0;

    //Tags which should be preceded by a newline and an increase of indention
    $indents=array("<TD","<TR","<TH","<TABLE","<DIV","<SPAN","<A","<P","<BODY","<HTML","<HEAD","<CENTER","<TITLE","<SELECT","<OPTION","<FORM","<LI","<OL","<UL","<DFN","<THEAD","<TBODY","<H1","<H2","<H3","<H4","<LABEL","<STYLE");

    //Tags which should be followed by a newline and a decrease of indention
    $antindents=array("</TD","</TR","</TH","</TABLE","</DIV","</SPAN","</A","</P","</BODY","</HTML","</HEAD","</CENTER","</TITLE","</SELECT","</OPTION","</FORM","</LI","</OL","</UL","</DFN","</THEAD","</TBODY","</H1","</H2","</H3","</H4","</LABEL","</STYLE");

    //Stand alone tags which should be indented but not expecting a close tag
    $standalone=array("<IMG","<HR","<BR","<LINK","<META","<INPUT","<BASE");
    $lefts=array("<!--","<!DOCTYPE","<?XML"); //TAGS which should always be completely leftaligned
    $rawstarts=array("<TEXTAREA","<PRE"); //Tags whose content should be output raw
    $rawends=array("</TEXTAREA","</PRE");	//End raw output tags
    $scriptstarts=array("<SCRIPT","<NOSCRIPT"); //Tags whose content should be output raw, but where start and end tags can be indented
    $scriptends=array("</SCRIPT","</NOSCRIPT");	//End raw output tags, but where start and end tags can be indented

    //Well, this following small state-machine does all the parsing
    $state="outside";
    $tag="";
    $returnsent=false;
    $needreturn=false;
    $rawoutput=false;
    $insidestandalone=false;
    $alreadyindented=false;
    $inside_q_single=false;
    $inside_q_double=false;
    while ($p<strlen($s)) {
      switch ($state) {
        case "outside" : { // OK, we're outside any tags
          if ($s[$p]=="<") { //Starting a tag?
            $state="searching"; //Well, let's change state
            $tag="<"; //The tag-var is updated            
          } else {
            if (!$rawoutput) { //outputting raw?
              if (!$returnsent) { //Not starting a tag
                if ($s[$p]!=" ") { //If anything else but spaces, lets indent as is appropraite
                  $result.=(necho_mkindent($ind,/*$needreturn*/true));
                  $returnsent=true;
                  $needreturn=false;
                  $alreadyindented=true;
                }
              }
              if (strpos("\n\t\r",$s[$p])===false) $result.=$s[$p]; //And add the char if it's not a newline
            } else {
              $result.=$s[$p]; //And add the char
            }
          }
          break;
        }
        case "searching" : {
          if ($s[$p]==">") { //End of tag??
            $tag.=">"; //Not found, does not know what to do...
            $result.=necho_addtag($tag); //Simply add it...
            $state="outside"; //And change state
            $returnsent=true;  //No return sent, but as we found no tag it shouldn't probably
          } else if ($s[$p]=="<") {//hmmm
            $tag.="<"; //Well, nothing to do but to add the thing...
          } else {
            $tag.=$s[$p]; //Add to the tag "in progress"
            $peek="";
            if ($p<strlen($s)) {
              $peek=$s[$p+1];
            }
            //if ($s[$p]==" ") continue; //Tag not complete yet
            $found=false; //not found yet!
            $utag=strtoupper($tag); //Prepare an uppercase tag version
            for ($i=0; $i<count($indents);$i++) { //Search the indent array
              if ($utag==$indents[$i] && ($peek==" " || $peek==">" || $peek=="/")) {
                $result.=(necho_mkindent($ind,true).necho_addtag($tag));
                //!$returnsent
                if ($GLOBALS["necho_debugmode"]) {
                  array_push($indentarray,$utag);
                  if ($GLOBALS["necho_debuglevel"]=="verbose") {
                    $indentmessage=" <!-- added to stack ".substr($utag,1)." -->";
                  }
                }
                $state="inside"; $found=true; //found! Now we're inside a known tag!
                $ind++;	//Increase indentation
                break;
              }
            }
            if (!$found) { //search the Anti-Indentarray
              for ($i=0; $i<count($antindents);$i++) {
                if ($utag==$antindents[$i]) {
                  $ind--; //Decrease indentation
                  if ($GLOBALS["necho_debugmode"]) {
                    $expected=array_pop($indentarray);
                    $expected=$expected[0]."/".substr($expected,1);
                    if ($utag==$expected) {
                      if ($GLOBALS["necho_debuglevel"]=="verbose") {
                        $indentmessage=" <!-- removed to stack ".substr($utag,1)." -->";
                      }
                    } else {
                      $indentmessage=" <!-- error: removed from stack ".substr($utag,1).", expected ".substr($expected,1)." -->";
                      $GLOBALS["necho_errors"]++;
                    }
                  }
                  $result.=(necho_mkindent($ind).necho_addtag($tag)); //Just put it there
                  $state="inside"; $found=true; //found! Now we're inside a known tag!
                  $needreturn=true;
                  break;
                }
              }
            }
            if (!$found) { //search the left-aligned array
              for ($i=0; $i<count($lefts);$i++) {
                if ($utag==$lefts[$i]) {
                  $result.=(necho_mkindent(0).necho_addtag($tag)); //Just put it there
                  $state="inside"; $found=true; //We're inside a known tag!
                  //$endreturn=true;
                  break;
                }
              }
            }
            if (!$found) {
              for ($i=0; $i<count($standalone);$i++) { //Search the stand-alone-tag array
                if ($utag==$standalone[$i]) {
                  $result.=(necho_mkindent($ind).necho_addtag($tag)); //Put it there properly indented
                  $state="inside"; $found=true;		//We're inside a known tag!
                  $insidestandalone=true;
                  break;
                }
              }
            }
            if (!$found) {
              for ($i=0; $i<count($rawstarts);$i++) { //Search the rawstarters-tag array
                if ($utag==$rawstarts[$i]) {
                  $result.=necho_addtag($tag); //Add the tag without indentations
                  $state="inside"; $found=true;		//We're inside a known tag!
                  $rawoutput=true;  //Raw output
                }
              }
            }
            if (!$found) {
              for ($i=0; $i<count($rawends);$i++) { //Search the rawstarters-tag array
                if ($utag==$rawends[$i]) {
                  $result.=necho_addtag($tag);//Add the tag without indentations
                  $state="inside"; $found=true;		//We're inside a known tag!
                  $rawoutput=false;
                }
              }
            }
            if (!$found) {
              for ($i=0; $i<count($scriptstarts);$i++) { //Search the scriptstarters-tag array
                if ($utag==$scriptstarts[$i]) {
                  $result.=(necho_mkindent($ind).necho_addtag($tag)); //Put it there properly indented
                  $state="inside"; $found=true;		//We're inside a known tag!
                  $rawoutput=true;
                }
              }
            }
            if (!$found) {
              for ($i=0; $i<count($scriptends);$i++) { //Search the rawstarters-tag array
                if ($utag==$scriptends[$i]) {
                  $result.=(necho_mkindent($ind).necho_addtag($tag)); //Put it there properly indented
                  $state="inside"; $found=true;		//We're inside a known tag!
                  $rawoutput=false;
                }
              }
            }
          }
          break;
        }
        case "inside" : {
          if ($s[$p]==">") { //End of tag found!
            if (($inside_q_single==true) || ($inside_q_double==true))  {
              $result.=">"; //Add to output, still inside a tag
            } else {
              $result.=">"; //Add it to output
              $returnsent=false; //No return sent
              $state="outside"; //And change state
              if ($GLOBALS["necho_debugmode"]) {
                if ($indentmessage!="") {
                  $result.=$indentmessage;
                  $indentmessage="";
                } else {
                  if ($insidestandalone) {
                    if (substr($result,-2,1)!="/") {
                      $result.=" <!-- error: Did you remember to add / to standalone tag? -->";
                      $GLOBALS["necho_errors"]++;
                    }
                  }
                }
              }
              
              $insidestandalone=false;
            }
          } else if ($s[$p]=="<") {//hmmm, html-error?
            $result.="<"; //Well, just add the thing...

          }
          else if ($s[$p]=="\"") {
            if ($inside_q_double==true) {
              $inside_q_double=false;  //OK, end of parameter
            } else {
              $inside_q_double=true;  //OK, this must be a parameter
            }
            $result.=$s[$p]; //Add to output, still inside a tag
          } else if ($s[$p]=="\'") {
            if ($inside_q_single==true) {
              $inside_q_single=false;  //OK, end of parameter
            } else {
              $inside_q_single=true;  //OK, this must be a parameter
            }
            $result.=$s[$p]; //Add to output, still inside a tag
          } else {
            $result.=$s[$p]; //Add to output, still inside a tag
          }
          break;
        }
      }
      $p++;  //Increase pointer in string
    }
    $GLOBALS["necho_timer"]+=(microtime(true)-$starttime);
    return $result;
  }
} //ion_exists

if (!function_exists("necho_start")) {
  function necho_start() {
    ob_start("gz_handler"); //GLobal output buffer, GZ'ed
    if (!necho_israw()) {
      ob_start(); //internal necho-buffer
      necho("<!-- NECHO OUTPUT START ".$GLOBALS["necho_version"]." -->\n");
    }
  }
} //function_exists


if (!function_exists("necho")) {
  function necho($s1,$flush=false,$recurse=true) {
    //  echo $s1."\n"; return;
    if (necho_israw()) {echo $s1."\n"; return;}; //if not enabled simply output
    static $_s;
    if ($recurse) {
      $_buffer=ob_get_contents(); //"save" any content not send through necho
      ob_end_clean(); ob_start(); //Clear the internal necho-buffer
      //ob_clean(); //PHP version 4.2.0+
      necho($_buffer,false,false); //And format/show this content

    }
    $s1=trim($s1);
    if ($s1!="") $_s.=($s1."\n");
    if ((strlen($_s)>1024) || $flush) {
      switch ($GLOBALS["necho_htmlstate"]) {
        case "ugly" : $_s=necho_uglyfy($_s); break;
        case "dull" : $_s=necho_clean($_s); break;
        case "format" : $_s=necho_uglyfy($_s); $_s=necho_format($_s); break;
        default : ;  //raw has been taken care of above...
      }

      echo $_s;
      ob_end_flush(); ob_start();
      $_s="";
    }

  }
} //function_exists

if (!function_exists("necho_raw")) {
  function necho_raw($s1) {
    if (!necho_israw()) {
      necho_flush(); //Empty output buffer, formatting it as it should
      ob_end_clean(); //Stop inner buffer
      echo $s1."\n"; //Output raw
      ob_start();
    } else {
      necho($s1);
    }

    //	necho_flush();  //Flush again
  }
} //function_exists

if (!function_exists("necho_nbsp")) {
  function necho_nbsp($s1) {
    necho(str_replace(" ","&nbsp;",$s1)); //exchange spaces to entities, and echo
  }
} //function_exists

if (!function_exists("nbsp")) {
  function nbsp($s1) {
    return str_replace(" ","&nbsp;",$s1);	//exchange spaces to entities, and return it
  }
} //function_exists


if (!function_exists("necho_end")) {
  function necho_end() {
    if (!necho_israw()) {
      necho("<!-- NECHO OUTPUT END [end indent level is ".$GLOBALS["necho_indentlevel"]." should be 0] Generation time: ".date("H:i:s d/m/y")."-->");
      necho("",true,true); //Flush all
      ob_end_flush(); //the internal necho_buffer
    }
    ob_end_flush();
  }

} //function_exists

//Hmmm, don't know if this works, but it is meant to show some progress in the
//client browser
if (!function_exists("necho_flush")) {
  function necho_flush() {
    if (!necho_israw()) { //if necho_buffering enabled flush it
      necho("",true,true); //Flush all
      ob_end_flush(); //the internal necho_buffer
    }
    ob_end_flush(); //flush the obliogatory gz-buffer

    ob_start("gz_handler"); //GLobal output buffer, GZ'ed
    if (!necho_israw()) {
      ob_start(); //internal necho-buffer
    }
  }
} //function_exists


/*
 HISTORY
 0.3.2 - Added <style> to indentations
 0.3.1 - Added option to force lowercase tags.
 0.3.0 - Fixed LINK to not indent, added BASE to standalonelist.
 0.2.1 -
 0.2.0 - correctly handle tags inside tag-parametres, f.ex. embedded javascript outputting tags
 0.1.9 - Fixed som issues where there appeared a line feed instead of a space...
 0.1.6 - Worked on <script> processing
 0.1.5 - added <script> to nonformatted output
 0.1.4 - fixed <textarea> and <pre> output once again
 0.1.3 - Fixed a bug causing occassoinal trouble with early sent data, which caused header/cookies to fail
 0.1.2 - Fixed a bug causing some extra spaces to be added to <textarea> - content
 0.1.1 - Some issues fixed... A couple of details to go, but generally it works great!
 0.1.0 - Well, I actually got the formatting to work, which was the main reason
 I started this project, so I guess version 0.1.0 is in order...
 Not, exactly perfect, though ;-)
 0.0.3 - Hmmm, I forgot
 0.0.2 - added necho_flush and fixed some bugs
 0.0.1 - first release with liteNuke

 */

?>
